/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.extension.CycleError;
import org.eventb.core.ast.extension.IGrammar;
import org.eventb.core.ast.extension.IOperator;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.lexer.Token;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.ILedParser;
import org.eventb.internal.core.parser.INudParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.IPropertyParserInfo;
import org.eventb.internal.core.parser.MainParsers;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.parser.TokenSet;
import org.eventb.internal.core.parser.TokenSetRedist;
import org.eventb.internal.core.parser.operators.BracketCompactor;
import org.eventb.internal.core.parser.operators.Brackets;
import org.eventb.internal.core.parser.operators.ExternalViewUtils;
import org.eventb.internal.core.parser.operators.LexKindParserDB;
import org.eventb.internal.core.parser.operators.OpRegistryCompactor;
import org.eventb.internal.core.parser.operators.OperatorRegistry;
import org.eventb.internal.core.parser.operators.OperatorRegistryCompact;
import org.eventb.internal.core.parser.operators.OperatorRelationship;
import org.eventb.internal.core.parser.operators.PropertyParserDB;

public abstract class AbstractGrammar {
    private static final String OFTYPE_ID = "Oftype";
    protected TokenSet tokens = new TokenSet();
    private final LexKindParserDB subParsers = new LexKindParserDB();
    private OperatorRegistry initOpRegistry = new OperatorRegistry();
    private OperatorRegistryCompact opRegistry = null;
    private List<IOperatorInfo<? extends Formula<?>>> deferredOperators = new ArrayList();
    private final PropertyParserDB propParsers = new PropertyParserDB();
    private Map<Integer, Integer> initCloseOpenKinds = new HashMap<Integer, Integer>();
    private Brackets brackets = null;
    private final int[] defaultTokenKinds = new int[DefaultToken.values().length];

    public IGrammar asExternalView() {
        ExternalViewUtils.Instantiator<Integer, IOperator> instantiator = new ExternalViewUtils.Instantiator<Integer, IOperator>();
        Map<Integer, String> kindIds = this.opRegistry.getKindIds();
        for (Map.Entry<Integer, String> kindId : kindIds.entrySet()) {
            Integer kind = kindId.getKey();
            String id = kindId.getValue();
            String syntaxSymbol = this.tokens.getImage(kind);
            ExternalViewUtils.ExternalOperator operator = new ExternalViewUtils.ExternalOperator(id, syntaxSymbol);
            instantiator.setInst(kind, operator);
        }
        return this.opRegistry.asExternalView(instantiator);
    }

    public boolean isOperator(int kind) {
        return kind == this.getKind(DefaultToken.NEG_LIT) || this.opRegistry.hasGroup(kind) && !this.tokens.isReserved(kind);
    }

    protected boolean isInitOperator(int kind) {
        return this.initOpRegistry.hasGroup(kind) && !this.tokens.isReserved(kind);
    }

    public TokenSet getTokens() {
        return this.tokens;
    }

    public final void init() {
        try {
            this.initDefaultKinds();
            this.initOpRegistry.addOperator(this.getKind(DefaultToken.EOF), DefaultToken.EOF.getImage(), StandardGroup.GROUP_0.getId(), false);
            this.initOpRegistry.addOperator(this.getKind(DefaultToken.NOOP), DefaultToken.NOOP.getImage(), StandardGroup.GROUP_0.getId(), false);
            this.initOpRegistry.addOperator(this.getKind(DefaultToken.OPEN), DefaultToken.OPEN.getImage(), StandardGroup.GROUP_0.getId(), false);
            this.initOpRegistry.addOperator(this.getKind(DefaultToken.NEG_LIT), DefaultToken.NEG_LIT.getImage(), StandardGroup.ARITHMETIC.getId(), false);
            this.addOperator(DefaultToken.OFTYPE, OFTYPE_ID, StandardGroup.TYPED.getId(), SubParsers.OFTYPE_PARSER, true);
            this.addOpenClose(DefaultToken.LPAR.getImage(), DefaultToken.RPAR.getImage());
            this.addOpenClose(DefaultToken.LBRACE.getImage(), DefaultToken.RBRACE.getImage());
            this.addOpenClose(DefaultToken.LBRACKET.getImage(), DefaultToken.RBRACKET.getImage());
            IntegerLiteral.init(this);
            Identifier.init(this);
            this.subParsers.addNud(this.getKind(DefaultToken.LPAR), MainParsers.CLOSED_SUGAR);
            this.addOperators();
            this.addOperatorRelationships();
            this.compact();
            this.updateDefaultKinds();
            for (IOperatorInfo<? extends Formula<?>> iOperatorInfo : this.deferredOperators) {
                this.populateSubParsers(iOperatorInfo);
            }
            this.deferredOperators = null;
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    private void initDefaultKinds() {
        DefaultToken[] defTokens = DefaultToken.values();
        for (int i = 0; i < defTokens.length; ++i) {
            DefaultToken token = defTokens[i];
            this.defaultTokenKinds[i] = token.isReserved() ? this.tokens.reserved(token.getImage()) : this.tokens.getOrAdd(token.getImage());
        }
    }

    private void updateDefaultKinds() {
        DefaultToken[] defTokens = DefaultToken.values();
        for (int i = 0; i < defTokens.length; ++i) {
            DefaultToken token = defTokens[i];
            this.defaultTokenKinds[i] = token.isReserved() ? this.tokens.getReserved(token.getImage()) : this.tokens.getKind(token.getImage());
        }
    }

    private void compact() {
        OpRegistryCompactor regCompactor = new OpRegistryCompactor(this.initOpRegistry);
        ExternalViewUtils.Instantiator<Integer, Integer> opKindInst = new ExternalViewUtils.Instantiator<Integer, Integer>();
        this.opRegistry = regCompactor.compact(opKindInst);
        this.initOpRegistry = null;
        TokenSetRedist tokenCompactor = new TokenSetRedist();
        this.tokens = tokenCompactor.redistribute(this.tokens, opKindInst);
        this.subParsers.redistribute(opKindInst);
        BracketCompactor brkCompactor = new BracketCompactor(this.initCloseOpenKinds);
        this.brackets = brkCompactor.compact(opKindInst);
        this.initCloseOpenKinds = null;
    }

    private void populateSubParsers(IOperatorInfo<? extends Formula<?>> operInfo) throws GenParser.OverrideException {
        int kind = this.tokens.getKind(operInfo.getImage());
        IParserPrinter<? extends Formula<?>> parser = operInfo.makeParser(kind);
        if (parser instanceof INudParser) {
            this.subParsers.addNud(kind, (INudParser)parser);
        } else {
            this.subParsers.addLed(kind, (ILedParser)parser);
        }
    }

    protected abstract void addOperators();

    protected abstract void addOperatorRelationships();

    public void addCompatibility(String leftOpId, String rightOpId) {
        this.initOpRegistry.addCompatibility(leftOpId, rightOpId);
    }

    public void addAssociativity(String opId) {
        this.initOpRegistry.addAssociativity(opId);
    }

    public void addPriority(String lowOpId, String highOpId) throws CycleError {
        this.initOpRegistry.addPriority(lowOpId, highOpId);
    }

    public void addGroupPriority(String lowGroupId, String highGroupId) throws CycleError {
        this.initOpRegistry.addGroupPriority(lowGroupId, highGroupId);
    }

    public List<INudParser<? extends Formula<?>>> getNudParsers(Token token) {
        return this.subParsers.getNudParsers(token);
    }

    public ILedParser<? extends Formula<?>> getLedParser(Token token) {
        return this.subParsers.getLedParser(token);
    }

    public IOperatorInfo<? extends Formula<?>> getParser(IOperatorProperties operProps, String image, int tag, String opId, String groupId) {
        return this.propParsers.getParser(operProps, image, tag, opId, groupId);
    }

    public void addParser(IPropertyParserInfo<? extends Formula<?>> parserInfo) throws GenParser.OverrideException {
        this.propParsers.add(parserInfo);
    }

    public void addOperator(IOperatorInfo<? extends Formula<?>> operInfo) throws GenParser.OverrideException {
        int kind = this.tokens.getOrAdd(operInfo.getImage());
        this.initOpRegistry.addOperator(kind, operInfo.getId(), operInfo.getGroupId(), operInfo.isSpaced());
        this.deferredOperators.add(operInfo);
    }

    public void addOperator(DefaultToken token, String operatorId, String groupId, IParserPrinter<? extends Formula<?>> subParser, boolean isSpaced) throws GenParser.OverrideException {
        int kind = this.getKind(token);
        this.initOpRegistry.addOperator(kind, operatorId, groupId, isSpaced);
        if (subParser instanceof INudParser) {
            this.subParsers.addNud(kind, (INudParser)subParser);
        } else {
            this.subParsers.addLed(kind, (ILedParser)subParser);
        }
    }

    protected void addOpenClose(String open, String close) {
        int openKind = this.tokens.getOrAdd(open);
        int closeKind = this.tokens.getOrAdd(close);
        this.initCloseOpenKinds.put(closeKind, openKind);
    }

    public boolean isOpen(int kind) {
        return this.brackets.isOpen(kind);
    }

    public boolean isClose(int kind) {
        return this.brackets.isClose(kind);
    }

    public void addReservedSubParser(DefaultToken token, INudParser<? extends Formula<?>> subParser) {
        assert (token.isReserved());
        int reservedKind = this.getKind(token);
        this.subParsers.addNud(reservedKind, subParser);
    }

    protected void addGroupPrioritySequence(StandardGroup ... groups) throws CycleError {
        for (int i = 0; i < groups.length - 1; ++i) {
            this.initOpRegistry.addGroupPriority(groups[i].getId(), groups[i + 1].getId());
        }
    }

    public OperatorRelationship getOperatorRelationship(int leftKind, int rightKind) {
        return this.opRegistry.getOperatorRelationship(leftKind, rightKind);
    }

    public String getImage(int kind) {
        return this.tokens.getImage(kind);
    }

    public int getKind(String image) {
        int kind = this.tokens.getKind(image);
        if (kind == -1) {
            throw new IllegalArgumentException("No such token: " + image);
        }
        return kind;
    }

    public int getKind(DefaultToken token) {
        return this.defaultTokenKinds[token.ordinal()];
    }

    public boolean needsParentheses(boolean isRightChild, int childKind, int parentKind) {
        if (parentKind == this.getKind(DefaultToken.EOF)) {
            return false;
        }
        if (!this.isOperator(parentKind) || !this.isOperator(childKind)) {
            return false;
        }
        if (childKind == parentKind && this.opRegistry.isAssociative(parentKind)) {
            return true;
        }
        OperatorRelationship relParentChild = this.getOperatorRelationship(parentKind, childKind);
        if (relParentChild == OperatorRelationship.LEFT_PRIORITY) {
            return true;
        }
        if (relParentChild == OperatorRelationship.RIGHT_PRIORITY) {
            return false;
        }
        if (isRightChild && relParentChild == OperatorRelationship.COMPATIBLE) {
            return true;
        }
        return isRightChild || this.getOperatorRelationship(childKind, parentKind) != OperatorRelationship.COMPATIBLE;
    }

    public boolean isSpaced(int kind) {
        return this.opRegistry.isSpaced(kind);
    }

    public boolean isDeclared(String operatorId) {
        return this.opRegistry.isDeclared(operatorId);
    }

    public static enum DefaultToken {
        EOF("End of Formula", true),
        NOOP("No Operator", true),
        OPEN("Open", true),
        IDENT("an identifier", true),
        INT_LIT("an integer literal", true),
        NEG_LIT("a negative integer literal", true),
        PRED_VAR("Predicate Variable", true),
        LPAR("(", false),
        RPAR(")", false),
        COMMA(",", false),
        LBRACKET("[", false),
        RBRACKET("]", false),
        LBRACE("{", false),
        RBRACE("}", false),
        MAPS_TO("\u21a6", false),
        MID("\u2223", false),
        DOT("\u00b7", false),
        OFTYPE("\u2982", false);

        private final String image;
        private final boolean isReserved;

        private DefaultToken(String image, boolean isReserved) {
            this.image = image;
            this.isReserved = isReserved;
        }

        public String getImage() {
            return this.image;
        }

        public boolean isReserved() {
            return this.isReserved;
        }
    }
}

