/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.ITypeDistribution;
import org.eventb.internal.core.ast.extension.OperatorProperties;

public class ExtensionKind
implements IExtensionKind {
    private final IOperatorProperties operProps;

    public ExtensionKind(IOperatorProperties.Notation notation, IOperatorProperties.FormulaType formulaType, ITypeDistribution childTypes, boolean isAssociative) {
        this.operProps = OperatorProperties.makeOperProps(notation, formulaType, childTypes, isAssociative);
    }

    @Override
    public IOperatorProperties getProperties() {
        return this.operProps;
    }

    @Override
    public boolean checkPreconditions(Expression[] childExprs, Predicate[] childPreds) {
        ITypeDistribution childTypes = this.operProps.getChildTypes();
        return childTypes.getExprArity().check(childExprs.length) && childTypes.getPredArity().check(childPreds.length);
    }

    @Override
    public boolean checkTypePreconditions(Type[] typeParameters) {
        ITypeDistribution childTypes = this.operProps.getChildTypes();
        return childTypes.getExprArity().check(typeParameters.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operProps == null ? 0 : this.operProps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionKind)) {
            return false;
        }
        ExtensionKind other = (ExtensionKind)obj;
        return !(this.operProps == null ? other.operProps != null : !this.operProps.equals(other.operProps));
    }
}

