/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.ArrayList;
import java.util.List;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IConstructorBuilder;
import org.eventb.internal.core.ast.datatype.ConstructorExtension;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.DatatypeArgument;
import org.eventb.internal.core.ast.datatype.DatatypeBuilder;
import org.eventb.internal.core.ast.datatype.ExtensionHarvester;

public final class ConstructorBuilder
implements IConstructorBuilder {
    private final DatatypeBuilder dtBuilder;
    private final String name;
    private final List<DatatypeArgument> arguments;

    ConstructorBuilder(DatatypeBuilder dtBuilder, String name) {
        this.dtBuilder = dtBuilder;
        this.name = name;
        this.arguments = new ArrayList<DatatypeArgument>();
    }

    @Override
    public void addArgument(String argName, Type argType) {
        this.dtBuilder.checkNotFinalized();
        this.arguments.add(new DatatypeArgument(this.dtBuilder, argName, argType));
    }

    @Override
    public void addArgument(Type argType) {
        this.addArgument(null, argType);
    }

    @Override
    public boolean isBasic() {
        for (DatatypeArgument arg : this.arguments) {
            if (arg.isBasic()) continue;
            return false;
        }
        return true;
    }

    public ConstructorExtension makeExtension(Datatype origin) {
        return new ConstructorExtension(origin, this.name, this.arguments);
    }

    public void harvest(ExtensionHarvester harvester) {
        for (DatatypeArgument arg : this.arguments) {
            arg.harvest(harvester);
        }
    }
}

