/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.GivenTypeHelper;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class FreeIdentifier
extends Identifier {
    private static String primeSuffix = "'";
    private final String name;

    protected FreeIdentifier(String name, SourceLocation location, Type type, FormulaFactory ff) {
        super(1, ff, location, name.hashCode());
        FormulaChecks.ensureValidIdentifierName(name, ff);
        this.name = name;
        this.ensureSameFactory(type);
        this.setPredicateVariableCache(new Formula[0]);
        this.synthesizeType(type);
        FormulaChecks.ensureHasType(this, type);
    }

    @Override
    protected void synthesizeType(Type proposedType) {
        Identifier[] givenTypeIdents;
        this.freeIdents = new FreeIdentifier[]{this};
        this.boundIdents = NO_BOUND_IDENT;
        if (proposedType == null) {
            return;
        }
        if (!GivenTypeHelper.isGivenSet(this.name, proposedType)) {
            for (Identifier givenTypeIdent : givenTypeIdents = GivenTypeHelper.getGivenTypeIdentifiers(proposedType)) {
                if (!this.name.equals(((FreeIdentifier)givenTypeIdent).getName())) continue;
                return;
            }
        } else {
            givenTypeIdents = null;
        }
        this.setFinalType(proposedType, proposedType);
        if (givenTypeIdents != null) {
            IdentListMerger merger = IdentListMerger.makeMerger((Identifier[])this.freeIdents, (Identifier[])givenTypeIdents);
            this.freeIdents = merger.getFreeMergedArray();
            assert (!merger.containsError());
        }
    }

    public String getName() {
        return this.name;
    }

    public FreeIdentifier withPrime() {
        assert (!this.isPrimed());
        FreeIdentifier primedIdentifier = this.getFactory().makeFreeIdentifier(this.name + primeSuffix, this.getSourceLocation(), this.getType());
        return primedIdentifier;
    }

    public BoundIdentDecl asDecl() {
        BoundIdentDecl decl = this.getFactory().makeBoundIdentDecl(this.name, this.getSourceLocation(), this.getType());
        return decl;
    }

    public BoundIdentDecl asPrimedDecl() {
        assert (!this.isPrimed());
        BoundIdentDecl primedDecl = this.getFactory().makeBoundIdentDecl(this.name + primeSuffix, this.getSourceLocation(), this.getType());
        return primedDecl;
    }

    public FreeIdentifier withoutPrime() {
        assert (this.isPrimed());
        FreeIdentifier unprimedIdentifier = this.getFactory().makeFreeIdentifier(this.name.substring(0, this.name.length() - primeSuffix.length()), this.getSourceLocation(), this.getType());
        return unprimedIdentifier;
    }

    public boolean isPrimed() {
        return this.name.endsWith(primeSuffix);
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String typeName = this.getType() != null ? " [type: " + this.getType().toString() + "]" : "";
        return tabs + this.getClass().getSimpleName() + " [name: " + this.name + "]" + typeName + "\n";
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        FreeIdentifier other = (FreeIdentifier)expr;
        return this.name.equals(other.name);
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        if (result.hasBoundIdentDecl(this.name)) {
            result.addProblem(new ASTProblem(this.getSourceLocation(), ProblemKind.FreeIdentifierHasBoundOccurences, 1, this.name));
            BoundIdentDecl temp = result.getExistingBoundIdentDecl(this.name);
            result.addProblem(new ASTProblem(temp.getSourceLocation(), ProblemKind.BoundIdentifierHasFreeOccurences, 1, this.name));
        } else if (!result.hasFreeIdent(this.name)) {
            result.addFreeIdent(this);
        }
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        this.setTemporaryType(result.getIdentType(this), result);
        result.analyzeExpression(this);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        freeIdentSet.add(this);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        names.add(this.name);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        return visitor.visitFREE_IDENT(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitFreeIdentifier(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        return rewriter.rewrite(this);
    }

    @Override
    public boolean isATypeExpression() {
        PowerSetType powerSetType;
        Type baseType;
        Type myType = this.getType();
        if (myType instanceof PowerSetType && (baseType = (powerSetType = (PowerSetType)myType).getBaseType()) instanceof GivenType) {
            GivenType givenType = (GivenType)baseType;
            return givenType.getName().equals(this.name);
        }
        return false;
    }

    @Override
    public Type toType() {
        if (!this.isATypeExpression()) {
            return super.toType();
        }
        return this.getFactory().makeGivenType(this);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }
}

