/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.BecomesEqualTo;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.DefaultRewriter;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.IDatatypeTranslation;
import org.eventb.core.ast.IExtensionTranslation;
import org.eventb.core.ast.IFormulaFilter;
import org.eventb.core.ast.IFormulaInspector;
import org.eventb.core.ast.IFormulaRewriter;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.IResult;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.ISpecialization;
import org.eventb.core.ast.ITypeCheckResult;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.PredicateVariable;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.ToStringFullParenMediator;
import org.eventb.core.ast.ToStringMediator;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.AbstractTranslation;
import org.eventb.internal.core.ast.BindingSubstitution;
import org.eventb.internal.core.ast.BoundIdentifierShifter;
import org.eventb.internal.core.ast.FilteringInspector;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaTranslatabilityChecker;
import org.eventb.internal.core.ast.FormulaTranslator;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.SameTypeRewriter;
import org.eventb.internal.core.ast.SimpleSubstitution;
import org.eventb.internal.core.ast.Specialization;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.ast.wd.WDComputer;
import org.eventb.internal.core.ast.wd.WDImprover;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public abstract class Formula<T extends Formula<T>> {
    private final int tag;
    private final FormulaFactory fac;
    private final SourceLocation location;
    private final int hashCode;
    private PredicateVariable[] predVars;
    protected FreeIdentifier[] freeIdents;
    protected BoundIdentifier[] boundIdents;
    protected boolean typeChecked;
    public static final int NO_TAG = 0;
    public static final int FREE_IDENT = 1;
    public static final int BOUND_IDENT_DECL = 2;
    public static final int BOUND_IDENT = 3;
    public static final int INTLIT = 4;
    public static final int SETEXT = 5;
    public static final int BECOMES_EQUAL_TO = 6;
    public static final int BECOMES_MEMBER_OF = 7;
    public static final int BECOMES_SUCH_THAT = 8;
    public static final int PREDICATE_VARIABLE = 9;
    public static final int FIRST_RELATIONAL_PREDICATE = 101;
    public static final int EQUAL = 101;
    public static final int NOTEQUAL = 102;
    public static final int LT = 103;
    public static final int LE = 104;
    public static final int GT = 105;
    public static final int GE = 106;
    public static final int IN = 107;
    public static final int NOTIN = 108;
    public static final int SUBSET = 109;
    public static final int NOTSUBSET = 110;
    public static final int SUBSETEQ = 111;
    public static final int NOTSUBSETEQ = 112;
    public static final int FIRST_BINARY_EXPRESSION = 201;
    public static final int MAPSTO = 201;
    public static final int REL = 202;
    public static final int TREL = 203;
    public static final int SREL = 204;
    public static final int STREL = 205;
    public static final int PFUN = 206;
    public static final int TFUN = 207;
    public static final int PINJ = 208;
    public static final int TINJ = 209;
    public static final int PSUR = 210;
    public static final int TSUR = 211;
    public static final int TBIJ = 212;
    public static final int SETMINUS = 213;
    public static final int CPROD = 214;
    public static final int DPROD = 215;
    public static final int PPROD = 216;
    public static final int DOMRES = 217;
    public static final int DOMSUB = 218;
    public static final int RANRES = 219;
    public static final int RANSUB = 220;
    public static final int UPTO = 221;
    public static final int MINUS = 222;
    public static final int DIV = 223;
    public static final int MOD = 224;
    public static final int EXPN = 225;
    public static final int FUNIMAGE = 226;
    public static final int RELIMAGE = 227;
    public static final int FIRST_BINARY_PREDICATE = 251;
    public static final int LIMP = 251;
    public static final int LEQV = 252;
    public static final int FIRST_ASSOCIATIVE_EXPRESSION = 301;
    public static final int BUNION = 301;
    public static final int BINTER = 302;
    public static final int BCOMP = 303;
    public static final int FCOMP = 304;
    public static final int OVR = 305;
    public static final int PLUS = 306;
    public static final int MUL = 307;
    public static final int FIRST_ASSOCIATIVE_PREDICATE = 351;
    public static final int LAND = 351;
    public static final int LOR = 352;
    public static final int FIRST_ATOMIC_EXPRESSION = 401;
    public static final int INTEGER = 401;
    public static final int NATURAL = 402;
    public static final int NATURAL1 = 403;
    public static final int BOOL = 404;
    public static final int TRUE = 405;
    public static final int FALSE = 406;
    public static final int EMPTYSET = 407;
    public static final int KPRED = 408;
    public static final int KSUCC = 409;
    public static final int KPRJ1_GEN = 410;
    public static final int KPRJ2_GEN = 411;
    public static final int KID_GEN = 412;
    public static final int KBOOL = 601;
    public static final int FIRST_LITERAL_PREDICATE = 610;
    public static final int BTRUE = 610;
    public static final int BFALSE = 611;
    public static final int FIRST_SIMPLE_PREDICATE = 620;
    public static final int KFINITE = 620;
    public static final int FIRST_UNARY_PREDICATE = 701;
    public static final int NOT = 701;
    public static final int FIRST_UNARY_EXPRESSION = 751;
    public static final int KCARD = 751;
    public static final int POW = 752;
    public static final int POW1 = 753;
    public static final int KUNION = 754;
    public static final int KINTER = 755;
    public static final int KDOM = 756;
    public static final int KRAN = 757;
    @Deprecated
    public static final int KPRJ1 = 758;
    @Deprecated
    public static final int KPRJ2 = 759;
    @Deprecated
    public static final int KID = 760;
    public static final int KMIN = 761;
    public static final int KMAX = 762;
    public static final int CONVERSE = 763;
    public static final int UNMINUS = 764;
    public static final int FIRST_QUANTIFIED_EXPRESSION = 801;
    public static final int QUNION = 801;
    public static final int QINTER = 802;
    public static final int CSET = 803;
    public static final int FIRST_QUANTIFIED_PREDICATE = 851;
    public static final int FORALL = 851;
    public static final int EXISTS = 852;
    public static final int FIRST_MULTIPLE_PREDICATE = 901;
    public static final int KPARTITION = 901;
    public static final int FIRST_EXTENSION_TAG = 1000;
    protected static final BoundIdentDecl[] NO_BOUND_IDENT_DECL = new BoundIdentDecl[0];
    protected static final FreeIdentifier[] NO_FREE_IDENT = new FreeIdentifier[0];
    protected static final BoundIdentifier[] NO_BOUND_IDENT = new BoundIdentifier[0];
    private static final PredicateVariable[] NO_PRED_VAR = new PredicateVariable[0];
    protected static final String[] NO_STRING = new String[0];

    protected Formula(int tag, FormulaFactory fac, SourceLocation location, int hashCode) {
        this.tag = tag;
        this.fac = fac;
        this.location = location;
        this.hashCode = Formula.combineHashCodes(hashCode, tag);
    }

    protected static int combineHashCodes(int hash1, int hash2) {
        return hash1 * 17 + hash2;
    }

    protected static int combineHashCodes(int hash1, int hash2, int hash3) {
        return Formula.combineHashCodes(Formula.combineHashCodes(hash1, hash2), hash3);
    }

    protected static int combineHashCodes(Object[] objects) {
        int result = 0;
        for (Object object : objects) {
            result = Formula.combineHashCodes(result, object.hashCode());
        }
        return result;
    }

    protected static int combineHashCodes(Object[] xs, Object[] ys) {
        return Formula.combineHashCodes(Formula.combineHashCodes(xs), Formula.combineHashCodes(ys));
    }

    protected static <T extends Formula<T>> int combineHashCodes(Collection<? extends T> formulas) {
        int result = 0;
        for (Formula formula : formulas) {
            result = Formula.combineHashCodes(result, formula.hashCode());
        }
        return result;
    }

    private static <S extends Formula<?>> ArrayList<FreeIdentifier[]> getFreeIdentifiers(S ... formulas) {
        ArrayList<FreeIdentifier[]> lists = new ArrayList<FreeIdentifier[]>(formulas.length);
        for (S formula : formulas) {
            FreeIdentifier[] freeIdents = ((Formula)formula).freeIdents;
            if (freeIdents.length == 0) continue;
            lists.add(freeIdents);
        }
        return lists;
    }

    protected static <S extends Formula<?>> IdentListMerger mergeFreeIdentifiers(S ... formulas) {
        ArrayList lists = Formula.getFreeIdentifiers(formulas);
        if (lists.size() == 0) {
            lists.add(NO_FREE_IDENT);
        }
        return IdentListMerger.makeMerger(lists);
    }

    private static <S extends Formula<?>> ArrayList<BoundIdentifier[]> getBoundIdentifiers(S[] formulas) {
        ArrayList<BoundIdentifier[]> lists = new ArrayList<BoundIdentifier[]>(formulas.length);
        for (S formula : formulas) {
            BoundIdentifier[] boundIdents = ((Formula)formula).boundIdents;
            if (boundIdents.length == 0) continue;
            lists.add(boundIdents);
        }
        return lists;
    }

    protected static <S extends Formula<?>> IdentListMerger mergeBoundIdentifiers(S[] formulas) {
        ArrayList lists = Formula.getBoundIdentifiers(formulas);
        if (lists.size() == 0) {
            lists.add(NO_BOUND_IDENT);
        }
        return IdentListMerger.makeMerger(lists);
    }

    protected void setPredicateVariableCache(Formula<?> ... children) {
        if (children.length == 0) {
            this.predVars = NO_PRED_VAR;
            return;
        }
        if (children.length == 1) {
            Formula<?> child = children[0];
            this.predVars = child.getTag() == 9 ? new PredicateVariable[]{(PredicateVariable)child} : child.predVars;
            return;
        }
        ArrayList<PredicateVariable> result = new ArrayList<PredicateVariable>();
        for (Formula<?> child : children) {
            for (PredicateVariable predVar : child.predVars) {
                if (result.contains(predVar)) continue;
                result.add(predVar);
            }
        }
        this.predVars = result.toArray(new PredicateVariable[result.size()]);
    }

    protected void ensureSameFactory(Type type) {
        if (type == null) {
            return;
        }
        FormulaFactory typeFactory = type.getFactory();
        if (this.fac != typeFactory) {
            throw new IllegalArgumentException("The type " + type + " has an incompatible factory: " + typeFactory + " instead of: " + this.fac);
        }
    }

    protected void ensureSameFactory(Formula<?>[] children) {
        for (Formula<?> child : children) {
            this.ensureSameFactory(child);
        }
    }

    protected void ensureSameFactory(Formula<?> left, Formula<?> right) {
        this.ensureSameFactory(left);
        this.ensureSameFactory(right);
    }

    protected void ensureSameFactory(Formula<?> child) {
        FormulaFactory childFactory = child.getFactory();
        if (this.fac != childFactory) {
            throw new IllegalArgumentException("The child " + child + " has an incompatible factory: " + childFactory + " instead of: " + this.fac);
        }
    }

    protected void ensureSameFactory(ITypeEnvironment typEnv) {
        FormulaFactory otherFactory = typEnv.getFormulaFactory();
        if (this.fac != otherFactory) {
            throw new IllegalArgumentException("The environment " + typEnv + " has an incompatible factory: " + otherFactory + " instead of: " + this.fac);
        }
    }

    public final int getTag() {
        return this.tag;
    }

    public final SourceLocation getSourceLocation() {
        return this.location;
    }

    public final String toStringFullyParenthesized() {
        StringBuilder builder = new StringBuilder();
        ToStringFullParenMediator strMed = new ToStringFullParenMediator(this, builder, NO_STRING, false);
        strMed.forward(this);
        return builder.toString();
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        ToStringMediator strMed = new ToStringMediator(this, builder, NO_STRING, false, false);
        strMed.forward(this);
        return builder.toString();
    }

    public final String toStringWithTypes() {
        StringBuilder builder = new StringBuilder();
        ToStringMediator strMed = new ToStringMediator(this, builder, NO_STRING, true, false);
        strMed.forward(this);
        return builder.toString();
    }

    protected abstract void toString(IToStringMediator var1);

    protected abstract int getKind(KindMediator var1);

    public final FormulaFactory getFactory() {
        return this.fac;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Formula other = (Formula)obj;
        if (this.tag != other.tag) {
            return false;
        }
        if (this.hashCode != other.hashCode) {
            return false;
        }
        return this.equalsInternal(other);
    }

    public final T flatten() {
        DefaultRewriter rewriter = new DefaultRewriter(true);
        return this.rewrite(rewriter);
    }

    public final FreeIdentifier[] getFreeIdentifiers() {
        return (FreeIdentifier[])this.freeIdents.clone();
    }

    public final BoundIdentifier[] getBoundIdentifiers() {
        return (BoundIdentifier[])this.boundIdents.clone();
    }

    public final FreeIdentifier[] getSyntacticallyFreeIdentifiers() {
        LinkedHashSet<FreeIdentifier> freeIdentSet = new LinkedHashSet<FreeIdentifier>();
        this.collectFreeIdentifiers(freeIdentSet);
        FreeIdentifier[] model = new FreeIdentifier[freeIdentSet.size()];
        return freeIdentSet.toArray(model);
    }

    public PredicateVariable[] getPredicateVariables() {
        return (PredicateVariable[])this.predVars.clone();
    }

    public boolean hasPredicateVariable() {
        return this.predVars.length > 0;
    }

    protected abstract void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> var1);

    protected abstract void collectNamesAbove(Set<String> var1, String[] var2, int var3);

    public final String getSyntaxTree() {
        return this.getSyntaxTree(NO_STRING, "");
    }

    protected abstract String getSyntaxTree(String[] var1, String var2);

    public final IResult isLegible(Collection<FreeIdentifier> context) {
        LegibilityResult result = new LegibilityResult(context);
        this.isLegible(result);
        return result;
    }

    public final boolean isWellFormed() {
        return this.boundIdents.length == 0;
    }

    public final ITypeCheckResult typeCheck(ITypeEnvironment environment) {
        if (!this.isWellFormed()) {
            throw new IllegalStateException("Cannot typecheck ill-formed formula: " + this);
        }
        this.ensureSameFactory(environment);
        TypeCheckResult result = new TypeCheckResult(environment.makeSnapshot());
        this.typeCheck(result, NO_BOUND_IDENT_DECL);
        result.solveTypeVariables();
        this.solveType(result.getUnifier());
        assert (!result.isSuccess() || this.typeChecked);
        return result;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final T bindAllFreeIdents(List<BoundIdentDecl> boundIdentDecls) {
        assert (boundIdentDecls.size() == 0);
        LinkedHashSet<FreeIdentifier> list = new LinkedHashSet<FreeIdentifier>();
        this.collectFreeIdentifiers(list);
        for (FreeIdentifier ident : list) {
            boundIdentDecls.add(ident.asDecl());
        }
        return this.bindTheseIdents(list);
    }

    public final T bindTheseIdents(Collection<FreeIdentifier> identsToBind) {
        if (identsToBind.size() == 0) {
            return this.getTypedThis();
        }
        BindingSubstitution subst = new BindingSubstitution(identsToBind, this.fac);
        return this.rewrite(subst);
    }

    protected abstract T getTypedThis();

    public final T applyAssignment(BecomesEqualTo assignment) {
        HashMap<FreeIdentifier, Expression> map = new HashMap<FreeIdentifier, Expression>();
        Formula.addAssignmentToMap(map, assignment);
        return this.substituteFreeIdents(map);
    }

    public final T applyAssignments(Iterable<BecomesEqualTo> assignments) {
        HashMap<FreeIdentifier, Expression> map = new HashMap<FreeIdentifier, Expression>();
        for (BecomesEqualTo assignment : assignments) {
            Formula.addAssignmentToMap(map, assignment);
        }
        return this.substituteFreeIdents(map);
    }

    private static void addAssignmentToMap(Map<FreeIdentifier, Expression> map, BecomesEqualTo assignment) {
        FreeIdentifier[] idents = assignment.getAssignedIdentifiers();
        Expression[] exprs = assignment.getExpressions();
        int length = idents.length;
        for (int i = 0; i < length; ++i) {
            FreeIdentifier ident = idents[i];
            assert (!map.containsKey(ident));
            map.put(ident, exprs[i]);
        }
    }

    public T rewrite(IFormulaRewriter rewriter) {
        return this.rewrite(new SameTypeRewriter(this.fac, rewriter));
    }

    protected abstract T rewrite(ITypeCheckingRewriter var1);

    public T substituteFreeIdents(Map<FreeIdentifier, Expression> map) {
        SimpleSubstitution subst = new SimpleSubstitution(map, this.fac);
        return this.rewrite(subst);
    }

    protected abstract boolean equalsInternal(Formula<?> var1);

    protected abstract void typeCheck(TypeCheckResult var1, BoundIdentDecl[] var2);

    protected abstract void isLegible(LegibilityResult var1);

    public final Predicate getWDPredicate() {
        this.ensureTypeChecked();
        WDComputer wdComputer = new WDComputer(this.fac);
        Predicate wdLemma = wdComputer.getWDLemma(this);
        WDImprover wdImprover = new WDImprover(this.fac);
        return wdImprover.improve(wdLemma);
    }

    public abstract boolean isWDStrict();

    protected abstract void solveType(TypeUnifier var1);

    public abstract boolean accept(IVisitor var1);

    public abstract void accept(ISimpleVisitor var1);

    public final boolean isTypeChecked() {
        return this.typeChecked;
    }

    public T shiftBoundIdentifiers(int offset) {
        if (offset == 0) {
            return this.getTypedThis();
        }
        BoundIdentifierShifter subst = new BoundIdentifierShifter(offset, this.fac);
        return this.rewrite(subst);
    }

    public final Set<GivenType> getGivenTypes() {
        HashSet<GivenType> result = new HashSet<GivenType>();
        for (FreeIdentifier ident : this.getFreeIdentifiers()) {
            if (!ident.isATypeExpression()) continue;
            result.add((GivenType)ident.getType().getBaseType());
        }
        return result;
    }

    public final Formula<?> getSubFormula(IPosition position) {
        Formula<?> formula = this;
        for (int index : ((Position)position).indexes) {
            if (index >= formula.getChildCount()) {
                return null;
            }
            formula = formula.getChild(index);
        }
        return formula;
    }

    public boolean isWDStrict(IPosition position) {
        Formula<?> formula = this;
        for (int index : ((Position)position).indexes) {
            if (!formula.isWDStrict()) {
                return false;
            }
            if (index >= formula.getChildCount()) {
                return false;
            }
            formula = formula.getChild(index);
        }
        return true;
    }

    public abstract Formula<?> getChild(int var1);

    public abstract int getChildCount();

    protected final void checkChildIndex(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            throw Formula.invalidIndex(index);
        }
    }

    protected static IllegalArgumentException invalidIndex(int index) {
        return new IllegalArgumentException("Invalid child index " + index);
    }

    public final List<IPosition> getPositions(IFormulaFilter filter) {
        return this.inspect(new FilteringInspector(filter));
    }

    public final <F> List<F> inspect(IFormulaInspector<F> inspector) {
        if (this instanceof Assignment) {
            throw new IllegalArgumentException("Inspection not available for assignments.");
        }
        FindingAccumulator<F> acc = new FindingAccumulator<F>(inspector);
        this.inspect(acc);
        return acc.getFindings();
    }

    protected abstract <F> void inspect(FindingAccumulator<F> var1);

    public final IPosition getPosition(SourceLocation sloc) {
        return this.getPosition(sloc, new IntStack());
    }

    protected final IPosition getPosition(SourceLocation sloc, IntStack indexes) {
        if (this.contains(sloc)) {
            return this.getDescendantPos(sloc, indexes);
        }
        return null;
    }

    protected abstract IPosition getDescendantPos(SourceLocation var1, IntStack var2);

    public final boolean contains(SourceLocation sloc) {
        return this.location != null && this.location.contains(sloc);
    }

    public final T rewriteSubFormula(IPosition position, Formula<?> newFormula) {
        this.ensureTypeChecked();
        if (position == null) {
            throw new NullPointerException("Null position");
        }
        if (!newFormula.isTypeChecked()) {
            throw new IllegalArgumentException("New sub-formula is not type-checked.");
        }
        if (newFormula.getFactory() != this.fac) {
            throw new IllegalArgumentException("New sub-formula has a different factory.");
        }
        SingleRewriter rewriter = new SingleRewriter(position, newFormula);
        Object result = rewriter.rewrite(this);
        assert (((Formula)result).isTypeChecked());
        return result;
    }

    protected abstract T rewriteChild(int var1, SingleRewriter var2);

    protected abstract T getCheckedReplacement(SingleRewriter var1);

    protected final void ensureTypeChecked() {
        if (!this.isTypeChecked()) {
            throw new IllegalStateException("Formula should be type-checked");
        }
    }

    public T specialize(ISpecialization specialization) {
        this.ensureTypeChecked();
        Specialization spec = (Specialization)specialization;
        return this.rewrite(spec);
    }

    public T translateDatatype(IDatatypeTranslation translation) {
        this.ensureTypeChecked();
        AbstractTranslation real = (AbstractTranslation)((Object)translation);
        real.ensurePreconditions(this);
        return this.rewrite(real.getFormulaRewriter());
    }

    public T translateExtensions(IExtensionTranslation translation) {
        this.ensureTypeChecked();
        AbstractTranslation real = (AbstractTranslation)((Object)translation);
        real.ensurePreconditions(this);
        return this.rewrite(real.getFormulaRewriter());
    }

    public boolean isTranslatable(FormulaFactory factory) {
        return FormulaTranslatabilityChecker.isTranslatable(this, factory, this.freeIdents);
    }

    public T translate(FormulaFactory factory) {
        return this.rewrite(new FormulaTranslator(factory));
    }
}

