/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.ITypeCheckResult;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.QuantifiedHelper;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.GivenTypeHelper;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public abstract class Expression
extends Formula<Expression> {
    private Type type = null;

    protected Expression(int tag, FormulaFactory ff, SourceLocation location, int hashCode) {
        super(tag, ff, location, hashCode);
    }

    protected abstract void synthesizeType(Type var1);

    protected final boolean mergeGivenTypes(Type aType) {
        Identifier[] newIdents = GivenTypeHelper.getGivenTypeIdentifiers(aType);
        if (newIdents.length == 0) {
            return true;
        }
        IdentListMerger merger = IdentListMerger.makeMerger((Identifier[])this.freeIdents, (Identifier[])newIdents);
        this.freeIdents = merger.getFreeMergedArray();
        return !merger.containsError();
    }

    protected final void setFinalType(Type synType, Type proposedType) {
        assert (synType != null);
        assert (synType.isSolved());
        if (proposedType != null && proposedType.equals(synType)) {
            synType = proposedType;
        }
        this.type = synType;
        this.typeChecked = true;
    }

    public final Type getType() {
        return this.type;
    }

    @Override
    protected final Expression getTypedThis() {
        return this;
    }

    protected final String getTypeName() {
        return this.type != null ? " [type: " + this.type + "]" : "";
    }

    @Override
    protected final boolean equalsInternal(Formula<?> formula) {
        Expression other = (Expression)formula;
        return QuantifiedHelper.sameType(this.type, other.type) && this.equalsInternalExpr(other);
    }

    abstract boolean equalsInternalExpr(Expression var1);

    protected final void setTemporaryType(Type type, TypeCheckResult result) {
        if (this.type == null) {
            this.type = type;
        } else {
            result.unify(this.type, type, this);
        }
    }

    public boolean isATypeExpression() {
        return false;
    }

    public Type toType() {
        throw new IllegalStateException("Expression does not denote a type: " + this.toString());
    }

    public final ITypeCheckResult typeCheck(ITypeEnvironment environment, Type expectedType) {
        if (!this.isWellFormed()) {
            throw new IllegalStateException("Cannot typecheck ill-formed expression: " + this);
        }
        this.ensureSameFactory(environment);
        this.ensureSameFactory(expectedType);
        TypeCheckResult result = new TypeCheckResult(environment.makeSnapshot());
        boolean wasTypeChecked = this.isTypeChecked();
        this.typeCheck(result, NO_BOUND_IDENT_DECL);
        result.unify(this.getType(), expectedType, this);
        result.analyzeType(expectedType, this);
        result.solveTypeVariables();
        if (!wasTypeChecked) {
            this.solveType(result.getUnifier());
        }
        assert (!result.isSuccess() || this.typeChecked && this.getType().equals(expectedType));
        return result;
    }

    @Override
    protected final void solveType(TypeUnifier unifier) {
        if (this.isTypeChecked() || this.type == null) {
            return;
        }
        Type inferredType = unifier.solve(this.type);
        this.type = null;
        this.solveChildrenTypes(unifier);
        if (inferredType != null && inferredType.isSolved()) {
            this.synthesizeType(inferredType);
        } else {
            this.synthesizeType(null);
        }
    }

    protected abstract void solveChildrenTypes(TypeUnifier var1);

    @Override
    protected final Expression getCheckedReplacement(SingleRewriter rewriter) {
        return rewriter.getExpression(this);
    }
}

