/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.domainobjects;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum SymmetryReductionOption {
    off(0, "No Symmetry Reduction"),
    nauty(1, "Nauty"),
    flood(2, "Permutation Flooding"),
    hash(3, "Symmetry Marker (Hash)");

    private final String description;
    private final int pos;
    private static final Map<Integer, SymmetryReductionOption> lookup;

    private SymmetryReductionOption(int pos, String description) {
        this.pos = pos;
        this.description = description;
    }

    public final boolean isDefault() {
        return this == off;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getPos() {
        return this.pos;
    }

    public static final SymmetryReductionOption get(int code) {
        return lookup.get(code);
    }

    static {
        lookup = new HashMap<Integer, SymmetryReductionOption>();
        for (SymmetryReductionOption s : EnumSet.allOf(SymmetryReductionOption.class)) {
            lookup.put(s.getPos(), s);
        }
    }
}

