/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.xml.SymbolContext;
import tla2sany.xml.XMLExportingException;
import util.FileUtil;
import util.SimpleFilenameToStream;
import util.ToolIO;

public class XMLExporter {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String TLA_SCHEMA = "http://tla.msr-inria.inria.fr/tlaps/sany.xsd";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public static final void main(String[] args) throws XMLExportingException {
        int i;
        if (args.length < 1) {
            throw new IllegalArgumentException("at least one .tla file must be given");
        }
        LinkedList<String> pathsLs = new LinkedList<String>();
        boolean offline_mode = false;
        int lastarg = -1;
        for (int i2 = 0; i2 < args.length - 1; ++i2) {
            if ("-o".equals(args[i2])) {
                offline_mode = true;
                lastarg = i2;
                continue;
            }
            if (!"-I".equals(args[i2])) continue;
            if (++i2 > args.length - 2) {
                throw new IllegalArgumentException("the -I flag must be followed by a directory and at least one .tla file");
            }
            pathsLs.addLast(args[i2]);
            lastarg = i2;
        }
        ++lastarg;
        String[] paths = new String[pathsLs.size()];
        for (int i3 = 0; i3 < paths.length; ++i3) {
            paths[i3] = (String)pathsLs.get(i3);
        }
        String[] tlas = new String[args.length - lastarg];
        for (int i4 = 0; i4 < args.length - lastarg; ++i4) {
            tlas[i4] = args[lastarg++];
        }
        SimpleFilenameToStream fts = new SimpleFilenameToStream(paths);
        PrintStream out = System.out;
        System.setOut(new PrintStream(new ByteArrayOutputStream()));
        SpecObj[] specs = new SpecObj[tlas.length];
        for (i = 0; i < tlas.length; ++i) {
            specs[i] = new SpecObj(tlas[i], fts);
        }
        for (i = 0; i < tlas.length; ++i) {
            ToolIO.out.println("\n****** SANY2 " + SANY.version + "\n");
            if (FileUtil.createNamedInputStream(tlas[i], specs[i].getResolver()) != null) {
                try {
                    SANY.frontEndMain(specs[i], tlas[i], System.err);
                    if (specs[i].getExternalModuleTable() == null) {
                        throw new XMLExportingException("spec " + specs[i].getName() + " is malformed - does not have an external module table", null);
                    }
                    if (specs[i].getExternalModuleTable().getRootModule() != null) continue;
                    throw new XMLExportingException("spec " + specs[i].getName() + " is malformed - does not have a root module", null);
                }
                catch (FrontEndException fe) {
                    fe.printStackTrace();
                    ToolIO.out.println(fe);
                    return;
                }
            }
            ToolIO.out.println("Cannot find the specified file " + tlas[i] + ".");
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("modules");
            doc.appendChild(rootElement);
            SymbolContext context = new SymbolContext();
            for (int i5 = 0; i5 < specs.length; ++i5) {
                Element e = specs[i5].getExternalModuleTable().getRootModule().exportDefinition(doc, context);
                rootElement.appendChild(e);
            }
            rootElement.insertBefore(context.getContextElement(doc), rootElement.getFirstChild());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            if (!offline_mode) {
                try {
                    SchemaFactory factory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
                    Schema schema = factory.newSchema(new URL(TLA_SCHEMA));
                    Validator validator = schema.newValidator();
                    validator.validate(source);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            throw new XMLExportingException("failed to write XML", pce);
        }
        catch (TransformerException tfe) {
            throw new XMLExportingException("failed to write XML", tfe);
        }
        catch (SAXException se) {
            throw new XMLExportingException("failed to validate XML", se);
        }
    }
}

