/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.be4.classicalb.core.preparser.lexer;

import java.io.*;
import java.util.*;
import de.be4.classicalb.core.preparser.node.*;
import de.hhu.stups.sablecc.patch.*;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.NORMAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;
    private final Queue<IToken> nextList = new LinkedBlockingQueue<IToken>();

	private IToken tok;

    public Queue<IToken> getNextList() {
        return nextList;
    }

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
              nextList.add(token);
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return (Token) nextList.peek();
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = (Token) nextList.poll();
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NO_DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 4: state = State.NO_DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 14:
                        {
                              Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 15:
                        {
                              Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 16:
                        {
                              Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 17:
                        {
                              Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 18:
                        {
                              Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 19:
                        {
                              Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 20:
                        {
                              Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 21:
                        {
                              Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITION_FILE; break;
                                case 3: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 22:
                        {
                              Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.DEFINITION_FILE; break;
                            }
                            return token;
                        }
                    case 23:
                        {
                              Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 24:
                        {
                              Token token = new24(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  String text,   int line,   int pos) { return new TComment(text, line, pos); }
    Token new1(  String text,   int line,   int pos) { return new TCommentEnd(text, line, pos); }
    Token new2(  String text,   int line,   int pos) { return new TCommentContent(text, line, pos); }
    Token new3(  String text,   int line,   int pos) { return new TLineComment(text, line, pos); }
    Token new4(  int line,   int pos) { return new TDefinitions(line, pos); }
    Token new5(  String text,   int line,   int pos) { return new TOtherClauseBegin(text, line, pos); }
    Token new6(  String text,   int line,   int pos) { return new TEndMachine(text, line, pos); }
    Token new7(  int line,   int pos) { return new TKwDefinitions(line, pos); }
    Token new8(  String text,   int line,   int pos) { return new TKwPrefix(text, line, pos); }
    Token new9(  String text,   int line,   int pos) { return new TNoDefSomething(text, line, pos); }
    Token new10(  String text,   int line,   int pos) { return new TIdentifierLiteral(text, line, pos); }
    Token new11(  int line,   int pos) { return new TLeftPar(line, pos); }
    Token new12(  int line,   int pos) { return new TRightPar(line, pos); }
    Token new13(  String text,   int line,   int pos) { return new TSlash(text, line, pos); }
    Token new14(  int line,   int pos) { return new TComma(line, pos); }
    Token new15(  int line,   int pos) { return new TBeginDefBody(line, pos); }
    Token new16(  String text,   int line,   int pos) { return new TRhsBody(text, line, pos); }
    Token new17(  String text,   int line,   int pos) { return new TBeginNesting(text, line, pos); }
    Token new18(  String text,   int line,   int pos) { return new TEndNesting(text, line, pos); }
    Token new19(  String text,   int line,   int pos) { return new TRhsIdentifier(text, line, pos); }
    Token new20(  String text,   int line,   int pos) { return new TSemicolon(text, line, pos); }
    Token new21(  String text,   int line,   int pos) { return new TDoubleQuotation(text, line, pos); }
    Token new22(  String text,   int line,   int pos) { return new TFilename(text, line, pos); }
    Token new23(  String text,   int line,   int pos) { return new TSomething(text, line, pos); }
    Token new24(  String text,   int line,   int pos) { return new TWhiteSpace(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // NORMAL
            {{0, 32, 1}, {33, 33, 2}, {34, 34, 3}, {35, 35, 4}, {36, 46, 2}, {47, 47, 5}, {48, 64, 2}, {65, 65, 6}, {66, 66, 2}, {67, 67, 7}, {68, 68, 8}, {69, 69, 9}, {70, 72, 2}, {73, 73, 10}, {74, 75, 2}, {76, 76, 11}, {77, 77, 12}, {78, 78, 2}, {79, 79, 13}, {80, 80, 14}, {81, 81, 2}, {82, 82, 15}, {83, 83, 16}, {84, 84, 2}, {85, 85, 17}, {86, 86, 18}, {87, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 19}, {127, 160, 19}, {8206, 8207, 19}, {8232, 8233, 19}, },
            {},
            {{0, 33, 20}, {34, 34, 21}, {35, 65535, 20}, },
            {{65, 65, 22}, {67, 67, 23}, {68, 68, 24}, {69, 69, 25}, {73, 73, 26}, {76, 76, 27}, {79, 79, 28}, {80, 80, 29}, {82, 82, 30}, {83, 83, 31}, {85, 85, 32}, {86, 86, 33}, },
            {{42, 42, 34}, {47, 47, 35}, },
            {{66, 66, 36}, {83, 83, 37}, },
            {{79, 79, 38}, },
            {{69, 69, 39}, },
            {{78, 78, 40}, {86, 86, 41}, {88, 88, 42}, },
            {{77, 77, 43}, {78, 78, 44}, },
            {{79, 79, 45}, },
            {{65, 65, 46}, {79, 79, 47}, },
            {{80, 80, 48}, },
            {{82, 82, 49}, },
            {{69, 69, 50}, },
            {{69, 69, 51}, {89, 89, 52}, },
            {{83, 83, 53}, },
            {{65, 65, 54}, },
            {{0, 8233, -3}, },
            {{0, 65535, -5}, },
            {},
            {{66, 66, 55}, {83, 83, 56}, },
            {{79, 79, 57}, },
            {{69, 69, 58}, },
            {{86, 86, 59}, {88, 88, 60}, },
            {{77, 77, 61}, {78, 78, 62}, },
            {{79, 79, 63}, },
            {{80, 80, 64}, },
            {{82, 82, 65}, },
            {{69, 69, 66}, },
            {{69, 69, 67}, {85, 85, 68}, },
            {{83, 83, 69}, },
            {{65, 65, 70}, },
            {},
            {{0, 9, 71}, {10, 10, 72}, {11, 12, 71}, {13, 13, 72}, {14, 65535, 71}, },
            {{83, 83, 73}, },
            {{83, 83, 74}, },
            {{78, 78, 75}, },
            {{70, 70, 76}, },
            {{68, 68, 77}, },
            {{69, 69, 78}, },
            {{84, 84, 79}, },
            {{80, 80, 80}, },
            {{67, 67, 81}, {73, 73, 82}, {86, 86, 83}, },
            {{67, 67, 84}, },
            {{67, 67, 85}, },
            {{68, 68, 86}, },
            {{69, 69, 87}, },
            {{79, 79, 88}, },
            {{70, 70, 89}, },
            {{69, 69, 90}, {84, 84, 91}, },
            {{83, 83, 92}, },
            {{69, 69, 93}, },
            {{76, 76, 94}, {82, 82, 95}, },
            {{83, 83, 96}, },
            {{83, 83, 97}, },
            {{78, 78, 98}, },
            {{70, 70, 99}, },
            {{69, 69, 100}, },
            {{80, 80, 101}, },
            {{80, 80, 102}, },
            {{67, 67, 103}, {73, 73, 104}, {86, 86, 105}, },
            {{67, 67, 106}, },
            {{69, 69, 107}, },
            {{69, 69, 108}, {79, 79, 109}, },
            {{70, 70, 110}, },
            {{69, 69, 111}, {84, 84, 112}, },
            {{66, 66, 113}, },
            {{69, 69, 114}, },
            {{76, 76, 115}, {82, 82, 116}, },
            {{0, 65535, -37}, },
            {},
            {{84, 84, 117}, },
            {{69, 69, 118}, },
            {{67, 67, 119}, {83, 83, 120}, },
            {{73, 73, 121}, },
            {},
            {{78, 78, 122}, },
            {{69, 69, 123}, },
            {{76, 76, 124}, {79, 79, 125}, },
            {{76, 76, 126}, },
            {{84, 84, 127}, },
            {{65, 65, 128}, },
            {{65, 65, 129}, },
            {{72, 72, 130}, },
            {{69, 69, 131}, },
            {{82, 82, 132}, },
            {{77, 77, 133}, {80, 80, 134}, },
            {{73, 73, 135}, },
            {{83, 83, 136}, },
            {{83, 83, 137}, },
            {{84, 84, 138}, },
            {{83, 83, 139}, },
            {{85, 85, 140}, },
            {{73, 73, 141}, },
            {{84, 84, 142}, },
            {{69, 69, 143}, },
            {{67, 67, 144}, {83, 83, 145}, },
            {{73, 73, 146}, },
            {{78, 78, 147}, },
            {{82, 82, 148}, },
            {{76, 76, 149}, {79, 79, 150}, },
            {{76, 76, 151}, },
            {{84, 84, 152}, },
            {{65, 65, 153}, },
            {{65, 65, 154}, },
            {{82, 82, 155}, },
            {{68, 68, 156}, },
            {{77, 77, 157}, {80, 80, 158}, },
            {{73, 73, 159}, },
            {{83, 83, 160}, },
            {{83, 83, 161}, },
            {{83, 83, 162}, },
            {{83, 83, 163}, },
            {{85, 85, 164}, },
            {{73, 73, 165}, },
            {{82, 82, 166}, },
            {{82, 82, 167}, },
            {{82, 82, 168}, },
            {{84, 84, 169}, },
            {{78, 78, 170}, },
            {{84, 84, 171}, },
            {{78, 78, 172}, },
            {{69, 69, 173}, },
            {{82, 82, 174}, },
            {{85, 85, 175}, },
            {{73, 73, 176}, },
            {{82, 82, 177}, },
            {{76, 76, 178}, },
            {{73, 73, 179}, },
            {{76, 76, 180}, },
            {{65, 65, 181}, },
            {{79, 79, 182}, },
            {{69, 69, 183}, },
            {{78, 78, 184}, },
            {},
            {},
            {{69, 69, 185}, },
            {},
            {{69, 69, 186}, },
            {{65, 65, 187}, },
            {{82, 82, 188}, },
            {{82, 82, 189}, },
            {{82, 82, 190}, },
            {{84, 84, 191}, },
            {{78, 78, 192}, },
            {{84, 84, 193}, },
            {{69, 69, 194}, },
            {{69, 69, 195}, },
            {{82, 82, 196}, },
            {{85, 85, 197}, },
            {{73, 73, 198}, },
            {{82, 82, 199}, },
            {{76, 76, 200}, },
            {{65, 65, 201}, },
            {{73, 73, 202}, },
            {{79, 79, 203}, },
            {{69, 69, 204}, },
            {{78, 78, 205}, },
            {},
            {},
            {{84, 84, 206}, },
            {},
            {{69, 69, 207}, },
            {{65, 65, 208}, },
            {{65, 65, 209}, },
            {{84, 84, 210}, },
            {{69, 69, 211}, },
            {{65, 65, 212}, {82, 82, 213}, },
            {{73, 73, 214}, },
            {{83, 83, 215}, },
            {{68, 68, 216}, },
            {{77, 77, 217}, },
            {{84, 84, 218}, },
            {{68, 68, 219}, },
            {{65, 65, 220}, },
            {{73, 73, 221}, },
            {{95, 95, 222}, },
            {{78, 78, 223}, },
            {},
            {{84, 84, 224}, },
            {{84, 84, 225}, },
            {{82, 82, 226}, },
            {{69, 69, 227}, },
            {{77, 77, 228}, },
            {{83, 83, 229}, },
            {{66, 66, 230}, },
            {{65, 65, 231}, },
            {{84, 84, 232}, },
            {{69, 69, 233}, },
            {{65, 65, 234}, {82, 82, 235}, },
            {{73, 73, 236}, },
            {{83, 83, 237}, },
            {{83, 83, 238}, },
            {{77, 77, 239}, },
            {{84, 84, 240}, },
            {{68, 68, 241}, },
            {{65, 65, 242}, },
            {{73, 73, 243}, },
            {{95, 95, 244}, },
            {{84, 84, 245}, },
            {{67, 67, 246}, },
            {{84, 84, 247}, },
            {{82, 82, 248}, },
            {{69, 69, 249}, },
            {{73, 73, 250}, },
            {{83, 83, 251}, },
            {{66, 66, 252}, },
            {{67, 67, 253}, },
            {{73, 73, 254}, },
            {{84, 84, 255}, },
            {{78, 78, 256}, },
            {{65, 65, 257}, },
            {{84, 84, 258}, },
            {},
            {{83, 83, 259}, },
            {{69, 69, 260}, },
            {{83, 83, 261}, },
            {{69, 69, 262}, },
            {{76, 76, 263}, },
            {{65, 65, 264}, },
            {{79, 79, 265}, },
            {{69, 69, 266}, },
            {{73, 73, 267}, },
            {{69, 69, 268}, },
            {{84, 84, 269}, },
            {{77, 77, 270}, {83, 83, 271}, },
            {},
            {},
            {{76, 76, 272}, },
            {{67, 67, 273}, },
            {{73, 73, 274}, },
            {{84, 84, 275}, },
            {{78, 78, 276}, },
            {{65, 65, 277}, },
            {{84, 84, 278}, },
            {},
            {{83, 83, 279}, },
            {{69, 69, 280}, },
            {{83, 83, 281}, },
            {{69, 69, 282}, },
            {{76, 76, 283}, },
            {{65, 65, 284}, },
            {{79, 79, 285}, },
            {{73, 73, 286}, },
            {{65, 65, 287}, },
            {{69, 69, 288}, },
            {{84, 84, 289}, },
            {{83, 83, 290}, },
            {{84, 84, 291}, },
            {},
            {{76, 76, 292}, },
            {{84, 84, 293}, },
            {{79, 79, 294}, },
            {{69, 69, 295}, },
            {{84, 84, 296}, },
            {{73, 73, 297}, },
            {{73, 73, 298}, },
            {},
            {{78, 78, 299}, },
            {},
            {{83, 83, 300}, },
            {{73, 73, 301}, },
            {{78, 78, 302}, },
            {{80, 80, 303}, },
            {},
            {{79, 79, 304}, },
            {{83, 83, 305}, },
            {{73, 73, 306}, },
            {{69, 69, 307}, },
            {},
            {{69, 69, 308}, },
            {{84, 84, 309}, },
            {{79, 79, 310}, },
            {{69, 69, 311}, },
            {{84, 84, 312}, },
            {{73, 73, 313}, },
            {{73, 73, 314}, },
            {{73, 73, 315}, },
            {{78, 78, 316}, },
            {},
            {{83, 83, 317}, },
            {{73, 73, 318}, },
            {{78, 78, 319}, },
            {{80, 80, 320}, },
            {{79, 79, 321}, },
            {{84, 84, 322}, },
            {{83, 83, 323}, },
            {{73, 73, 324}, },
            {},
            {{85, 85, 325}, },
            {{69, 69, 326}, },
            {{95, 95, 327}, },
            {{78, 78, 328}, },
            {{95, 95, 329}, },
            {{83, 83, 330}, },
            {{78, 78, 331}, },
            {{79, 79, 332}, },
            {{84, 84, 333}, },
            {},
            {{83, 83, 334}, {90, 90, 335}, },
            {{84, 84, 336}, },
            {{69, 69, 337}, },
            {{78, 78, 338}, },
            {},
            {{69, 69, 339}, },
            {{78, 78, 340}, },
            {{83, 83, 341}, },
            {{95, 95, 342}, },
            {{78, 78, 343}, },
            {{95, 95, 344}, },
            {{83, 83, 345}, },
            {{78, 78, 346}, },
            {{79, 79, 347}, },
            {{79, 79, 348}, },
            {{84, 84, 349}, },
            {},
            {{83, 83, 350}, {90, 90, 351}, },
            {{84, 84, 352}, },
            {{69, 69, 353}, },
            {{78, 78, 354}, },
            {{69, 69, 355}, },
            {},
            {{69, 69, 356}, },
            {{84, 84, 357}, },
            {{83, 83, 358}, },
            {{67, 67, 359}, {86, 86, 360}, },
            {{83, 83, 361}, },
            {{67, 67, 362}, {86, 86, 363}, },
            {},
            {{84, 84, 364}, },
            {{78, 78, 365}, },
            {{65, 65, 366}, },
            {{65, 65, 367}, },
            {{65, 65, 368}, },
            {},
            {{82, 82, 369}, },
            {{83, 83, 370}, },
            {{83, 83, 371}, },
            {{84, 84, 372}, },
            {},
            {{67, 67, 373}, {86, 86, 374}, },
            {{83, 83, 375}, },
            {{67, 67, 376}, {86, 86, 377}, },
            {},
            {{84, 84, 378}, },
            {{78, 78, 379}, },
            {{78, 78, 380}, },
            {{65, 65, 381}, },
            {{65, 65, 382}, },
            {{65, 65, 383}, },
            {},
            {{82, 82, 384}, },
            {{83, 83, 385}, },
            {},
            {{83, 83, 386}, },
            {{73, 73, 387}, },
            {},
            {{79, 79, 388}, },
            {{65, 65, 389}, },
            {},
            {{79, 79, 390}, },
            {{65, 65, 391}, },
            {{83, 83, 392}, },
            {{83, 83, 393}, },
            {{84, 84, 394}, },
            {{84, 84, 395}, },
            {{84, 84, 396}, },
            {{65, 65, 397}, },
            {},
            {},
            {},
            {{79, 79, 398}, },
            {{65, 65, 399}, },
            {},
            {{79, 79, 400}, },
            {{65, 65, 401}, },
            {{83, 83, 402}, },
            {{83, 83, 403}, },
            {},
            {{84, 84, 404}, },
            {{84, 84, 405}, },
            {{84, 84, 406}, },
            {{65, 65, 407}, },
            {},
            {},
            {{79, 79, 408}, },
            {{78, 78, 409}, },
            {{82, 82, 410}, },
            {{78, 78, 411}, },
            {{82, 82, 412}, },
            {},
            {},
            {{73, 73, 413}, },
            {{73, 73, 414}, },
            {{73, 73, 415}, },
            {{84, 84, 416}, },
            {{78, 78, 417}, },
            {{82, 82, 418}, },
            {{78, 78, 419}, },
            {{82, 82, 420}, },
            {},
            {},
            {{73, 73, 421}, },
            {{73, 73, 422}, },
            {{73, 73, 423}, },
            {{84, 84, 424}, },
            {{78, 78, 425}, },
            {{83, 83, 426}, },
            {{73, 73, 427}, },
            {{83, 83, 428}, },
            {{73, 73, 429}, },
            {{79, 79, 430}, },
            {{79, 79, 431}, },
            {{79, 79, 432}, },
            {{73, 73, 433}, },
            {{83, 83, 434}, },
            {{73, 73, 435}, },
            {{83, 83, 436}, },
            {{73, 73, 437}, },
            {{79, 79, 438}, },
            {{79, 79, 439}, },
            {{79, 79, 440}, },
            {{73, 73, 441}, },
            {},
            {{84, 84, 442}, },
            {{65, 65, 443}, },
            {{84, 84, 444}, },
            {{65, 65, 445}, },
            {{78, 78, 446}, },
            {{78, 78, 447}, },
            {{78, 78, 448}, },
            {{79, 79, 449}, },
            {{84, 84, 450}, },
            {{65, 65, 451}, },
            {{84, 84, 452}, },
            {{65, 65, 453}, },
            {{78, 78, 454}, },
            {{78, 78, 455}, },
            {{78, 78, 456}, },
            {{79, 79, 457}, },
            {{65, 65, 458}, },
            {{66, 66, 459}, },
            {{65, 65, 460}, },
            {{66, 66, 461}, },
            {},
            {},
            {},
            {{78, 78, 462}, },
            {{65, 65, 463}, },
            {{66, 66, 464}, },
            {{65, 65, 465}, },
            {{66, 66, 466}, },
            {},
            {},
            {},
            {{78, 78, 467}, },
            {{78, 78, 468}, },
            {{76, 76, 469}, },
            {{78, 78, 470}, },
            {{76, 76, 471}, },
            {{83, 83, 472}, },
            {{78, 78, 473}, },
            {{76, 76, 474}, },
            {{78, 78, 475}, },
            {{76, 76, 476}, },
            {{83, 83, 477}, },
            {{84, 84, 478}, },
            {{69, 69, 479}, },
            {{84, 84, 480}, },
            {{69, 69, 481}, },
            {},
            {{84, 84, 482}, },
            {{69, 69, 483}, },
            {{84, 84, 484}, },
            {{69, 69, 485}, },
            {},
            {{83, 83, 486}, },
            {{83, 83, 487}, },
            {{83, 83, 488}, },
            {{83, 83, 489}, },
            {{83, 83, 490}, },
            {{83, 83, 491}, },
            {{83, 83, 492}, },
            {{83, 83, 493}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
        }
        { // DEFINITIONS
            {{0, 32, 1}, {34, 34, 2}, {40, 40, 3}, {41, 41, 4}, {44, 44, 5}, {47, 47, 6}, {59, 59, 7}, {61, 61, 8}, {65, 65, 9}, {66, 66, 10}, {67, 67, 11}, {68, 68, 10}, {69, 69, 12}, {70, 72, 10}, {73, 73, 13}, {74, 75, 10}, {76, 76, 14}, {77, 77, 15}, {78, 78, 10}, {79, 79, 16}, {80, 80, 17}, {81, 81, 10}, {82, 82, 18}, {83, 83, 19}, {84, 84, 10}, {85, 85, 20}, {86, 86, 21}, {87, 90, 10}, {97, 122, 22}, {127, 160, 1}, {8206, 8207, 1}, {8232, 8233, 1}, },
            {{0, 32, 1}, {127, 8233, -2}, },
            {},
            {},
            {},
            {},
            {{42, 42, 23}, {47, 47, 24}, },
            {},
            {{61, 61, 25}, },
            {{48, 57, 26}, {65, 65, 27}, {66, 66, 28}, {67, 82, 27}, {83, 83, 29}, {84, 90, 27}, {95, 95, 30}, {97, 122, 31}, },
            {{48, 57, 26}, {65, 90, 27}, {95, 122, -11}, },
            {{48, 57, 26}, {65, 78, 27}, {79, 79, 32}, {80, 90, 27}, {95, 122, -11}, },
            {{48, 57, 26}, {65, 77, 27}, {78, 78, 33}, {79, 85, 27}, {86, 86, 34}, {87, 87, 27}, {88, 88, 35}, {89, 90, 27}, {95, 122, -11}, },
            {{48, 57, 26}, {65, 76, 27}, {77, 77, 36}, {78, 78, 37}, {79, 90, 27}, {95, 122, -11}, },
            {{48, 78, -13}, {79, 79, 38}, {80, 122, -13}, },
            {{48, 57, 26}, {65, 65, 39}, {66, 78, 27}, {79, 79, 40}, {80, 122, -13}, },
            {{48, 57, 26}, {65, 79, 27}, {80, 80, 41}, {81, 90, 27}, {95, 122, -11}, },
            {{48, 57, 26}, {65, 81, 27}, {82, 82, 42}, {83, 90, 27}, {95, 122, -11}, },
            {{48, 57, 26}, {65, 68, 27}, {69, 69, 43}, {70, 90, 27}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 44}, {70, 88, 27}, {89, 89, 45}, {90, 90, 27}, {95, 122, -11}, },
            {{48, 57, 26}, {65, 82, 27}, {83, 83, 46}, {84, 122, -11}, },
            {{48, 57, 26}, {65, 65, 47}, {66, 90, 27}, {95, 122, -11}, },
            {{48, 122, -12}, },
            {},
            {{0, 9, 48}, {10, 10, 49}, {11, 12, 48}, {13, 13, 49}, {14, 65535, 48}, },
            {},
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 50}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 51}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 52}, {79, 122, -15}, },
            {{48, 57, 26}, {65, 67, 27}, {68, 68, 53}, {69, 90, 27}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 54}, {70, 122, -20}, },
            {{48, 57, 26}, {65, 83, 27}, {84, 84, 55}, {85, 90, 27}, {95, 122, -11}, },
            {{48, 79, -18}, {80, 80, 56}, {81, 122, -18}, },
            {{48, 57, 26}, {65, 66, 27}, {67, 67, 57}, {68, 72, 27}, {73, 73, 58}, {74, 85, 27}, {86, 86, 59}, {87, 90, 27}, {95, 122, -11}, },
            {{48, 66, -39}, {67, 67, 60}, {68, 90, 27}, {95, 122, -11}, },
            {{48, 66, -39}, {67, 67, 61}, {68, 122, -40}, },
            {{48, 67, -35}, {68, 68, 62}, {69, 122, -35}, },
            {{48, 68, -20}, {69, 69, 63}, {70, 122, -20}, },
            {{48, 78, -13}, {79, 79, 64}, {80, 122, -13}, },
            {{48, 57, 26}, {65, 69, 27}, {70, 70, 65}, {71, 90, 27}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 66}, {70, 83, 27}, {84, 84, 67}, {85, 122, -37}, },
            {{48, 82, -22}, {83, 83, 68}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 69}, {70, 122, -20}, },
            {{48, 57, 26}, {65, 75, 27}, {76, 76, 70}, {77, 81, 27}, {82, 82, 71}, {83, 122, -19}, },
            {{0, 65535, -26}, },
            {},
            {{48, 83, -37}, {84, 84, 72}, {85, 122, -37}, },
            {{48, 68, -20}, {69, 69, 73}, {70, 122, -20}, },
            {{48, 66, -39}, {67, 67, 74}, {68, 82, 27}, {83, 83, 75}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 76}, {79, 122, -15}, },
            {{48, 68, -20}, {69, 69, 77}, {70, 122, -20}, },
            {{48, 75, -49}, {76, 76, 78}, {77, 78, 27}, {79, 79, 79}, {80, 122, -13}, },
            {{48, 75, -49}, {76, 76, 80}, {77, 90, 27}, {95, 122, -11}, },
            {{48, 83, -37}, {84, 84, 81}, {85, 122, -37}, },
            {{48, 57, 26}, {65, 65, 82}, {66, 122, -23}, },
            {{48, 57, 26}, {65, 65, 83}, {66, 122, -23}, },
            {{48, 57, 26}, {65, 71, 27}, {72, 72, 84}, {73, 90, 27}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 85}, {70, 122, -20}, },
            {{48, 81, -19}, {82, 82, 86}, {83, 122, -19}, },
            {{48, 76, -15}, {77, 77, 87}, {78, 79, 27}, {80, 80, 88}, {81, 122, -18}, },
            {{48, 57, 26}, {65, 72, 27}, {73, 73, 89}, {74, 90, 27}, {95, 122, -11}, },
            {{48, 82, -22}, {83, 83, 90}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 91}, {84, 122, -11}, },
            {{48, 83, -37}, {84, 84, 92}, {85, 122, -37}, },
            {{48, 82, -22}, {83, 83, 93}, {84, 122, -11}, },
            {{48, 57, 26}, {65, 84, 27}, {85, 85, 94}, {86, 90, 27}, {95, 122, -11}, },
            {{48, 72, -67}, {73, 73, 95}, {74, 122, -67}, },
            {{48, 81, -19}, {82, 82, 96}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 97}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 98}, {83, 122, -19}, },
            {{48, 83, -37}, {84, 84, 99}, {85, 122, -37}, },
            {{48, 83, -37}, {84, 84, 100}, {85, 122, -37}, },
            {{48, 77, -14}, {78, 78, 101}, {79, 122, -15}, },
            {{48, 68, -20}, {69, 69, 102}, {70, 122, -20}, },
            {{48, 81, -19}, {82, 82, 103}, {83, 122, -19}, },
            {{48, 84, -72}, {85, 85, 104}, {86, 122, -72}, },
            {{48, 72, -67}, {73, 73, 105}, {74, 122, -67}, },
            {{48, 81, -19}, {82, 82, 106}, {83, 122, -19}, },
            {{48, 75, -49}, {76, 76, 107}, {77, 122, -59}, },
            {{48, 72, -67}, {73, 73, 108}, {74, 122, -67}, },
            {{48, 75, -49}, {76, 76, 109}, {77, 122, -59}, },
            {{48, 57, 26}, {65, 65, 110}, {66, 122, -23}, },
            {{48, 78, -13}, {79, 79, 111}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 112}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 113}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 114}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 115}, {70, 122, -20}, },
            {{48, 57, 26}, {65, 65, 116}, {66, 122, -23}, },
            {{48, 57, 26}, {65, 65, 117}, {66, 122, -23}, },
            {{48, 83, -37}, {84, 84, 118}, {85, 122, -37}, },
            {{48, 68, -20}, {69, 69, 119}, {70, 122, -20}, },
            {{48, 57, 26}, {65, 65, 120}, {66, 81, 27}, {82, 82, 121}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 122}, {84, 122, -11}, },
            {{48, 67, -35}, {68, 68, 123}, {69, 122, -35}, },
            {{48, 76, -15}, {77, 77, 124}, {78, 90, 27}, {95, 122, -11}, },
            {{48, 83, -37}, {84, 84, 125}, {85, 122, -37}, },
            {{48, 67, -35}, {68, 68, 126}, {69, 122, -35}, },
            {{48, 57, 26}, {65, 65, 127}, {66, 122, -23}, },
            {{48, 72, -67}, {73, 73, 128}, {74, 122, -67}, },
            {{48, 90, -12}, {95, 95, 129}, {97, 122, 31}, },
            {{48, 77, -14}, {78, 78, 130}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 83, -37}, {84, 84, 131}, {85, 122, -37}, },
            {{48, 83, -37}, {84, 84, 132}, {85, 122, -37}, },
            {{48, 81, -19}, {82, 82, 133}, {83, 122, -19}, },
            {{48, 68, -20}, {69, 69, 134}, {70, 122, -20}, },
            {{48, 76, -15}, {77, 77, 135}, {78, 122, -104}, },
            {{48, 82, -22}, {83, 83, 136}, {84, 122, -11}, },
            {{48, 65, -11}, {66, 66, 137}, {67, 90, 27}, {95, 122, -11}, },
            {{48, 66, -39}, {67, 67, 138}, {68, 122, -40}, },
            {{48, 72, -67}, {73, 73, 139}, {74, 122, -67}, },
            {{48, 83, -37}, {84, 84, 140}, {85, 122, -37}, },
            {{48, 77, -14}, {78, 78, 141}, {79, 122, -15}, },
            {{48, 57, 26}, {65, 65, 142}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 143}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 144}, {70, 122, -20}, },
            {{48, 82, -22}, {83, 83, 145}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 146}, {70, 122, -20}, },
            {{48, 75, -49}, {76, 76, 147}, {77, 122, -59}, },
            {{48, 57, 26}, {65, 65, 148}, {66, 122, -23}, },
            {{48, 78, -13}, {79, 79, 149}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 150}, {70, 122, -20}, },
            {{48, 72, -67}, {73, 73, 151}, {74, 122, -67}, },
            {{48, 68, -20}, {69, 69, 152}, {70, 122, -20}, },
            {{48, 83, -37}, {84, 84, 153}, {85, 122, -37}, },
            {{48, 76, -15}, {77, 77, 154}, {78, 82, 27}, {83, 83, 155}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 75, -49}, {76, 76, 156}, {77, 122, -59}, },
            {{48, 83, -37}, {84, 84, 157}, {85, 122, -37}, },
            {{48, 78, -13}, {79, 79, 158}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 159}, {70, 122, -20}, },
            {{48, 83, -37}, {84, 84, 160}, {85, 122, -37}, },
            {{48, 72, -67}, {73, 73, 161}, {74, 122, -67}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 162}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 163}, {84, 122, -11}, },
            {{48, 72, -67}, {73, 73, 164}, {74, 122, -67}, },
            {{48, 77, -14}, {78, 78, 165}, {79, 122, -15}, },
            {{48, 79, -18}, {80, 80, 166}, {81, 122, -18}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 167}, {80, 122, -13}, },
            {{48, 82, -22}, {83, 83, 168}, {84, 122, -11}, },
            {{48, 72, -67}, {73, 73, 169}, {74, 122, -67}, },
            {{48, 68, -20}, {69, 69, 170}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 171}, {70, 122, -20}, },
            {{48, 90, -12}, {95, 95, 172}, {97, 122, 31}, },
            {{48, 77, -14}, {78, 78, 173}, {79, 122, -15}, },
            {{48, 90, -12}, {95, 95, 174}, {97, 122, 31}, },
            {{48, 82, -22}, {83, 83, 175}, {84, 122, -11}, },
            {{48, 77, -14}, {78, 78, 176}, {79, 122, -15}, },
            {{48, 83, -37}, {84, 84, 177}, {85, 122, -37}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 178}, {84, 89, 27}, {90, 90, 179}, {95, 122, -11}, },
            {{48, 83, -37}, {84, 84, 180}, {85, 122, -37}, },
            {{48, 68, -20}, {69, 69, 181}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 182}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 183}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 184}, {79, 122, -15}, },
            {{48, 82, -22}, {83, 83, 185}, {84, 122, -11}, },
            {{48, 66, -39}, {67, 67, 186}, {68, 85, 27}, {86, 86, 187}, {87, 122, -39}, },
            {{48, 82, -22}, {83, 83, 188}, {84, 122, -11}, },
            {{48, 66, -39}, {67, 67, 189}, {68, 85, 27}, {86, 86, 190}, {87, 122, -39}, },
            {{48, 122, -12}, },
            {{48, 83, -37}, {84, 84, 191}, {85, 122, -37}, },
            {{48, 57, 26}, {65, 65, 192}, {66, 122, -23}, },
            {{48, 57, 26}, {65, 65, 193}, {66, 122, -23}, },
            {{48, 57, 26}, {65, 65, 194}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 81, -19}, {82, 82, 195}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 196}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 197}, {84, 122, -11}, },
            {{48, 83, -37}, {84, 84, 198}, {85, 122, -37}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 199}, {80, 122, -13}, },
            {{48, 57, 26}, {65, 65, 200}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 201}, {80, 122, -13}, },
            {{48, 57, 26}, {65, 65, 202}, {66, 122, -23}, },
            {{48, 82, -22}, {83, 83, 203}, {84, 122, -11}, },
            {{48, 83, -37}, {84, 84, 204}, {85, 122, -37}, },
            {{48, 83, -37}, {84, 84, 205}, {85, 122, -37}, },
            {{48, 83, -37}, {84, 84, 206}, {85, 122, -37}, },
            {{48, 57, 26}, {65, 65, 207}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 208}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 209}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 210}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 211}, {83, 122, -19}, },
            {{48, 122, -12}, },
            {{48, 72, -67}, {73, 73, 212}, {74, 122, -67}, },
            {{48, 72, -67}, {73, 73, 213}, {74, 122, -67}, },
            {{48, 72, -67}, {73, 73, 214}, {74, 122, -67}, },
            {{48, 83, -37}, {84, 84, 215}, {85, 122, -37}, },
            {{48, 82, -22}, {83, 83, 216}, {84, 122, -11}, },
            {{48, 72, -67}, {73, 73, 217}, {74, 122, -67}, },
            {{48, 82, -22}, {83, 83, 218}, {84, 122, -11}, },
            {{48, 72, -67}, {73, 73, 219}, {74, 122, -67}, },
            {{48, 78, -13}, {79, 79, 220}, {80, 122, -13}, },
            {{48, 78, -13}, {79, 79, 221}, {80, 122, -13}, },
            {{48, 78, -13}, {79, 79, 222}, {80, 122, -13}, },
            {{48, 72, -67}, {73, 73, 223}, {74, 122, -67}, },
            {{48, 83, -37}, {84, 84, 224}, {85, 122, -37}, },
            {{48, 57, 26}, {65, 65, 225}, {66, 122, -23}, },
            {{48, 83, -37}, {84, 84, 226}, {85, 122, -37}, },
            {{48, 57, 26}, {65, 65, 227}, {66, 122, -23}, },
            {{48, 77, -14}, {78, 78, 228}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 229}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 230}, {79, 122, -15}, },
            {{48, 78, -13}, {79, 79, 231}, {80, 122, -13}, },
            {{48, 57, 26}, {65, 65, 232}, {66, 122, -23}, },
            {{48, 65, -11}, {66, 66, 233}, {67, 122, -118}, },
            {{48, 57, 26}, {65, 65, 234}, {66, 122, -23}, },
            {{48, 65, -11}, {66, 66, 235}, {67, 122, -118}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 236}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 237}, {79, 122, -15}, },
            {{48, 75, -49}, {76, 76, 238}, {77, 122, -59}, },
            {{48, 77, -14}, {78, 78, 239}, {79, 122, -15}, },
            {{48, 75, -49}, {76, 76, 240}, {77, 122, -59}, },
            {{48, 82, -22}, {83, 83, 241}, {84, 122, -11}, },
            {{48, 83, -37}, {84, 84, 242}, {85, 122, -37}, },
            {{48, 68, -20}, {69, 69, 243}, {70, 122, -20}, },
            {{48, 83, -37}, {84, 84, 244}, {85, 122, -37}, },
            {{48, 68, -20}, {69, 69, 245}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 246}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 247}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 248}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 249}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
        }
        { // DEFINITIONS_RHS
            {{0, 32, 1}, {33, 33, 2}, {34, 34, 3}, {35, 39, 2}, {40, 40, 4}, {41, 41, 5}, {42, 46, 2}, {47, 47, 6}, {48, 58, 2}, {59, 59, 7}, {60, 64, 2}, {65, 65, 8}, {66, 66, 9}, {67, 67, 10}, {68, 68, 11}, {69, 69, 12}, {70, 72, 11}, {73, 73, 13}, {74, 75, 11}, {76, 76, 14}, {77, 77, 15}, {78, 78, 11}, {79, 79, 16}, {80, 80, 17}, {81, 81, 11}, {82, 82, 18}, {83, 83, 19}, {84, 84, 11}, {85, 85, 20}, {86, 86, 21}, {87, 87, 22}, {88, 90, 11}, {91, 96, 2}, {97, 122, 23}, {123, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 1}, {127, 160, 1}, {8206, 8207, 1}, {8232, 8233, 1}, },
            {},
            {{0, 33, 24}, {34, 34, 25}, {35, 65535, 24}, },
            {},
            {},
            {{42, 42, 26}, {47, 47, 27}, },
            {},
            {{48, 57, 28}, {65, 65, 29}, {66, 66, 30}, {67, 77, 29}, {78, 78, 31}, {79, 82, 29}, {83, 83, 32}, {84, 90, 29}, {95, 95, 33}, {97, 122, 34}, },
            {{48, 57, 28}, {65, 68, 29}, {69, 69, 35}, {70, 90, 29}, {95, 122, -10}, },
            {{48, 57, 28}, {65, 65, 36}, {66, 71, 29}, {72, 72, 37}, {73, 78, 29}, {79, 79, 38}, {80, 90, 29}, {95, 122, -10}, },
            {{48, 57, 28}, {65, 90, 29}, {95, 122, -10}, },
            {{48, 57, 28}, {65, 77, 29}, {78, 78, 39}, {79, 85, 29}, {86, 86, 40}, {87, 87, 29}, {88, 88, 41}, {89, 90, 29}, {95, 122, -10}, },
            {{48, 57, 28}, {65, 69, 29}, {70, 70, 42}, {71, 76, 29}, {77, 77, 43}, {78, 78, 44}, {79, 90, 29}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 45}, {70, 78, 29}, {79, 79, 46}, {80, 122, -12}, },
            {{48, 57, 28}, {65, 65, 47}, {66, 78, 29}, {79, 79, 48}, {80, 122, -12}, },
            {{48, 57, 28}, {65, 79, 29}, {80, 80, 49}, {81, 90, 29}, {95, 122, -10}, },
            {{48, 57, 28}, {65, 81, 29}, {82, 82, 50}, {83, 90, 29}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 51}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 52}, {70, 88, 29}, {89, 89, 53}, {90, 90, 29}, {95, 122, -10}, },
            {{48, 57, 28}, {65, 82, 29}, {83, 83, 54}, {84, 122, -10}, },
            {{48, 57, 28}, {65, 65, 55}, {66, 90, 29}, {95, 122, -10}, },
            {{48, 57, 28}, {65, 71, 29}, {72, 72, 56}, {73, 90, 29}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{0, 65535, -5}, },
            {},
            {},
            {{0, 9, 57}, {10, 10, 58}, {11, 12, 57}, {13, 13, 58}, {14, 65535, 57}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 59}, {84, 122, -10}, },
            {{48, 57, 28}, {65, 88, 29}, {89, 89, 60}, {90, 122, -21}, },
            {{48, 82, -22}, {83, 83, 61}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 57, 28}, {65, 70, 29}, {71, 71, 62}, {72, 90, 29}, {95, 122, -10}, },
            {{48, 82, -22}, {83, 83, 63}, {84, 122, -10}, },
            {{48, 57, 28}, {65, 78, 29}, {79, 79, 64}, {80, 122, -12}, },
            {{48, 77, -14}, {78, 78, 65}, {79, 122, -15}, },
            {{48, 57, 28}, {65, 67, 29}, {68, 68, 66}, {69, 90, 29}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 67}, {70, 122, -11}, },
            {{48, 57, 28}, {65, 83, 29}, {84, 84, 68}, {85, 90, 29}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 79, -18}, {80, 80, 69}, {81, 122, -18}, },
            {{48, 57, 28}, {65, 66, 29}, {67, 67, 70}, {68, 72, 29}, {73, 73, 71}, {74, 85, 29}, {86, 86, 72}, {87, 90, 29}, {95, 122, -10}, },
            {{48, 83, -43}, {84, 84, 73}, {85, 122, -43}, },
            {{48, 66, -46}, {67, 67, 74}, {68, 90, 29}, {95, 122, -10}, },
            {{48, 66, -46}, {67, 67, 75}, {68, 122, -48}, },
            {{48, 67, -41}, {68, 68, 76}, {69, 122, -41}, },
            {{48, 68, -11}, {69, 69, 77}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 78}, {70, 78, 29}, {79, 79, 79}, {80, 122, -12}, },
            {{48, 69, -15}, {70, 70, 80}, {71, 90, 29}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 81}, {70, 75, 29}, {76, 76, 82}, {77, 83, 29}, {84, 84, 83}, {85, 122, -43}, },
            {{48, 82, -22}, {83, 83, 84}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 85}, {70, 122, -11}, },
            {{48, 57, 28}, {65, 75, 29}, {76, 76, 86}, {77, 81, 29}, {82, 82, 87}, {83, 122, -19}, },
            {{48, 57, 28}, {65, 72, 29}, {73, 73, 88}, {74, 90, 29}, {95, 122, -10}, },
            {{0, 65535, -29}, },
            {},
            {{48, 83, -43}, {84, 84, 89}, {85, 122, -43}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 90}, {70, 122, -11}, },
            {{48, 72, -58}, {73, 73, 91}, {74, 122, -58}, },
            {{48, 68, -11}, {69, 69, 92}, {70, 122, -11}, },
            {{48, 72, -58}, {73, 73, 93}, {74, 122, -58}, },
            {{48, 66, -46}, {67, 67, 94}, {68, 82, 29}, {83, 83, 95}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 96}, {79, 122, -15}, },
            {{48, 68, -11}, {69, 69, 97}, {70, 122, -11}, },
            {{48, 75, -57}, {76, 76, 98}, {77, 78, 29}, {79, 79, 99}, {80, 122, -12}, },
            {{48, 75, -57}, {76, 76, 100}, {77, 90, 29}, {95, 122, -10}, },
            {{48, 83, -43}, {84, 84, 101}, {85, 122, -43}, },
            {{48, 57, 28}, {65, 65, 102}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 57, 28}, {65, 65, 103}, {66, 122, -23}, },
            {{48, 71, -24}, {72, 72, 104}, {73, 122, -24}, },
            {{48, 68, -11}, {69, 69, 105}, {70, 122, -11}, },
            {{48, 81, -19}, {82, 82, 106}, {83, 122, -19}, },
            {{48, 122, -13}, },
            {{48, 57, 28}, {65, 76, 29}, {77, 77, 107}, {78, 79, 29}, {80, 80, 108}, {81, 122, -18}, },
            {{48, 72, -58}, {73, 73, 109}, {74, 122, -58}, },
            {{48, 82, -22}, {83, 83, 110}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 111}, {70, 122, -11}, },
            {{48, 82, -22}, {83, 83, 112}, {84, 122, -10}, },
            {{48, 83, -43}, {84, 84, 113}, {85, 122, -43}, },
            {{48, 82, -22}, {83, 83, 114}, {84, 122, -10}, },
            {{48, 57, 28}, {65, 84, 29}, {85, 85, 115}, {86, 90, 29}, {95, 122, -10}, },
            {{48, 72, -58}, {73, 73, 116}, {74, 122, -58}, },
            {{48, 75, -57}, {76, 76, 117}, {77, 122, -72}, },
            {{48, 81, -19}, {82, 82, 118}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 119}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 120}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 66, -46}, {67, 67, 121}, {68, 122, -48}, },
            {{48, 81, -19}, {82, 82, 122}, {83, 122, -19}, },
            {{48, 83, -43}, {84, 84, 123}, {85, 122, -43}, },
            {{48, 83, -43}, {84, 84, 124}, {85, 122, -43}, },
            {{48, 77, -14}, {78, 78, 125}, {79, 122, -15}, },
            {{48, 68, -11}, {69, 69, 126}, {70, 122, -11}, },
            {{48, 81, -19}, {82, 82, 127}, {83, 122, -19}, },
            {{48, 84, -88}, {85, 85, 128}, {86, 122, -88}, },
            {{48, 72, -58}, {73, 73, 129}, {74, 122, -58}, },
            {{48, 81, -19}, {82, 82, 130}, {83, 122, -19}, },
            {{48, 75, -57}, {76, 76, 131}, {77, 122, -72}, },
            {{48, 72, -58}, {73, 73, 132}, {74, 122, -58}, },
            {{48, 75, -57}, {76, 76, 133}, {77, 122, -72}, },
            {{48, 57, 28}, {65, 65, 134}, {66, 122, -23}, },
            {{48, 78, -39}, {79, 79, 135}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 136}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 137}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 66, -46}, {67, 67, 138}, {68, 122, -48}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 139}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 140}, {70, 122, -11}, },
            {{48, 57, 28}, {65, 65, 141}, {66, 122, -23}, },
            {{48, 68, -11}, {69, 69, 142}, {70, 122, -11}, },
            {{48, 57, 28}, {65, 65, 143}, {66, 122, -23}, },
            {{48, 83, -43}, {84, 84, 144}, {85, 122, -43}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 145}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 146}, {70, 122, -11}, },
            {{48, 57, 28}, {65, 65, 147}, {66, 81, 29}, {82, 82, 148}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 149}, {84, 122, -10}, },
            {{48, 67, -41}, {68, 68, 150}, {69, 122, -41}, },
            {{48, 76, -81}, {77, 77, 151}, {78, 90, 29}, {95, 122, -10}, },
            {{48, 83, -43}, {84, 84, 152}, {85, 122, -43}, },
            {{48, 67, -41}, {68, 68, 153}, {69, 122, -41}, },
            {{48, 57, 28}, {65, 65, 154}, {66, 122, -23}, },
            {{48, 72, -58}, {73, 73, 155}, {74, 122, -58}, },
            {{48, 90, -13}, {95, 95, 156}, {97, 122, 34}, },
            {{48, 77, -14}, {78, 78, 157}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 83, -43}, {84, 84, 158}, {85, 122, -43}, },
            {{48, 83, -43}, {84, 84, 159}, {85, 122, -43}, },
            {{48, 81, -19}, {82, 82, 160}, {83, 122, -19}, },
            {{48, 68, -11}, {69, 69, 161}, {70, 122, -11}, },
            {{48, 83, -43}, {84, 84, 162}, {85, 122, -43}, },
            {{48, 76, -81}, {77, 77, 163}, {78, 122, -128}, },
            {{48, 82, -22}, {83, 83, 164}, {84, 122, -10}, },
            {{48, 65, -10}, {66, 66, 165}, {67, 90, 29}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 66, -46}, {67, 67, 166}, {68, 122, -48}, },
            {{48, 72, -58}, {73, 73, 167}, {74, 122, -58}, },
            {{48, 122, -13}, },
            {{48, 83, -43}, {84, 84, 168}, {85, 122, -43}, },
            {{48, 77, -14}, {78, 78, 169}, {79, 122, -15}, },
            {{48, 57, 28}, {65, 65, 170}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 171}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 172}, {70, 122, -11}, },
            {{48, 82, -22}, {83, 83, 173}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 174}, {70, 122, -11}, },
            {{48, 75, -57}, {76, 76, 175}, {77, 122, -72}, },
            {{48, 57, 28}, {65, 65, 176}, {66, 122, -23}, },
            {{48, 78, -39}, {79, 79, 177}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 178}, {70, 122, -11}, },
            {{48, 72, -58}, {73, 73, 179}, {74, 122, -58}, },
            {{48, 68, -11}, {69, 69, 180}, {70, 122, -11}, },
            {{48, 83, -43}, {84, 84, 181}, {85, 122, -43}, },
            {{48, 76, -81}, {77, 77, 182}, {78, 82, 29}, {83, 83, 183}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 75, -57}, {76, 76, 184}, {77, 122, -72}, },
            {{48, 83, -43}, {84, 84, 185}, {85, 122, -43}, },
            {{48, 78, -39}, {79, 79, 186}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 187}, {70, 122, -11}, },
            {{48, 83, -43}, {84, 84, 188}, {85, 122, -43}, },
            {{48, 72, -58}, {73, 73, 189}, {74, 122, -58}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 190}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 191}, {84, 122, -10}, },
            {{48, 72, -58}, {73, 73, 192}, {74, 122, -58}, },
            {{48, 77, -14}, {78, 78, 193}, {79, 122, -15}, },
            {{48, 79, -18}, {80, 80, 194}, {81, 122, -18}, },
            {{48, 122, -13}, },
            {{48, 78, -39}, {79, 79, 195}, {80, 122, -12}, },
            {{48, 82, -22}, {83, 83, 196}, {84, 122, -10}, },
            {{48, 72, -58}, {73, 73, 197}, {74, 122, -58}, },
            {{48, 68, -11}, {69, 69, 198}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 199}, {70, 122, -11}, },
            {{48, 90, -13}, {95, 95, 200}, {97, 122, 34}, },
            {{48, 77, -14}, {78, 78, 201}, {79, 122, -15}, },
            {{48, 90, -13}, {95, 95, 202}, {97, 122, 34}, },
            {{48, 82, -22}, {83, 83, 203}, {84, 122, -10}, },
            {{48, 77, -14}, {78, 78, 204}, {79, 122, -15}, },
            {{48, 83, -43}, {84, 84, 205}, {85, 122, -43}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 206}, {84, 89, 29}, {90, 90, 207}, {95, 122, -10}, },
            {{48, 83, -43}, {84, 84, 208}, {85, 122, -43}, },
            {{48, 68, -11}, {69, 69, 209}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 210}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 211}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 212}, {79, 122, -15}, },
            {{48, 82, -22}, {83, 83, 213}, {84, 122, -10}, },
            {{48, 66, -46}, {67, 67, 214}, {68, 85, 29}, {86, 86, 215}, {87, 122, -46}, },
            {{48, 82, -22}, {83, 83, 216}, {84, 122, -10}, },
            {{48, 66, -46}, {67, 67, 217}, {68, 85, 29}, {86, 86, 218}, {87, 122, -46}, },
            {{48, 122, -13}, },
            {{48, 83, -43}, {84, 84, 219}, {85, 122, -43}, },
            {{48, 57, 28}, {65, 65, 220}, {66, 122, -23}, },
            {{48, 57, 28}, {65, 65, 221}, {66, 122, -23}, },
            {{48, 57, 28}, {65, 65, 222}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 81, -19}, {82, 82, 223}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 224}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 225}, {84, 122, -10}, },
            {{48, 83, -43}, {84, 84, 226}, {85, 122, -43}, },
            {{48, 122, -13}, },
            {{48, 78, -39}, {79, 79, 227}, {80, 122, -12}, },
            {{48, 57, 28}, {65, 65, 228}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 78, -39}, {79, 79, 229}, {80, 122, -12}, },
            {{48, 57, 28}, {65, 65, 230}, {66, 122, -23}, },
            {{48, 82, -22}, {83, 83, 231}, {84, 122, -10}, },
            {{48, 83, -43}, {84, 84, 232}, {85, 122, -43}, },
            {{48, 83, -43}, {84, 84, 233}, {85, 122, -43}, },
            {{48, 83, -43}, {84, 84, 234}, {85, 122, -43}, },
            {{48, 57, 28}, {65, 65, 235}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 236}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 237}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 238}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 239}, {83, 122, -19}, },
            {{48, 122, -13}, },
            {{48, 72, -58}, {73, 73, 240}, {74, 122, -58}, },
            {{48, 72, -58}, {73, 73, 241}, {74, 122, -58}, },
            {{48, 72, -58}, {73, 73, 242}, {74, 122, -58}, },
            {{48, 83, -43}, {84, 84, 243}, {85, 122, -43}, },
            {{48, 82, -22}, {83, 83, 244}, {84, 122, -10}, },
            {{48, 72, -58}, {73, 73, 245}, {74, 122, -58}, },
            {{48, 82, -22}, {83, 83, 246}, {84, 122, -10}, },
            {{48, 72, -58}, {73, 73, 247}, {74, 122, -58}, },
            {{48, 78, -39}, {79, 79, 248}, {80, 122, -12}, },
            {{48, 78, -39}, {79, 79, 249}, {80, 122, -12}, },
            {{48, 78, -39}, {79, 79, 250}, {80, 122, -12}, },
            {{48, 72, -58}, {73, 73, 251}, {74, 122, -58}, },
            {{48, 83, -43}, {84, 84, 252}, {85, 122, -43}, },
            {{48, 57, 28}, {65, 65, 253}, {66, 122, -23}, },
            {{48, 83, -43}, {84, 84, 254}, {85, 122, -43}, },
            {{48, 57, 28}, {65, 65, 255}, {66, 122, -23}, },
            {{48, 77, -14}, {78, 78, 256}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 257}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 258}, {79, 122, -15}, },
            {{48, 78, -39}, {79, 79, 259}, {80, 122, -12}, },
            {{48, 57, 28}, {65, 65, 260}, {66, 122, -23}, },
            {{48, 65, -10}, {66, 66, 261}, {67, 122, -143}, },
            {{48, 57, 28}, {65, 65, 262}, {66, 122, -23}, },
            {{48, 65, -10}, {66, 66, 263}, {67, 122, -143}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 264}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 265}, {79, 122, -15}, },
            {{48, 75, -57}, {76, 76, 266}, {77, 122, -72}, },
            {{48, 77, -14}, {78, 78, 267}, {79, 122, -15}, },
            {{48, 75, -57}, {76, 76, 268}, {77, 122, -72}, },
            {{48, 82, -22}, {83, 83, 269}, {84, 122, -10}, },
            {{48, 83, -43}, {84, 84, 270}, {85, 122, -43}, },
            {{48, 68, -11}, {69, 69, 271}, {70, 122, -11}, },
            {{48, 83, -43}, {84, 84, 272}, {85, 122, -43}, },
            {{48, 68, -11}, {69, 69, 273}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 274}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 275}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 276}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 277}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
        }
        { // DEFINITION_FILE
            {{0, 32, 1}, {33, 33, 2}, {34, 34, 3}, {35, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 33, -2}, {35, 65535, -2}, },
            {{0, 33, 2}, {35, 65535, 2}, },
            {},
        }
        { // NO_DEFINITIONS
            {{0, 32, 1}, {33, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 65535, -2}, },
            {{0, 65535, 2}, },
        }
        { // COMMENT
            {{0, 32, 1}, {33, 41, 2}, {42, 42, 3}, {43, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 4}, {127, 160, 4}, {8206, 8207, 4}, {8232, 8233, 4}, },
            {},
            {{47, 47, 5}, },
            {{0, 8233, -3}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // NORMAL
        {-1, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, -1, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, 8, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, 5, -1, 5, -1, -1, -1, -1, 5, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, 5, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, 8, -1, -1, 8, -1, -1, 8, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, 5, -1, -1, 8, -1, -1, -1, -1, 8, -1, -1, -1, -1, 8, 8, -1, -1, -1, -1, -1, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, 8, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, 5, -1, -1, -1, -1, -1, 8, 8, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, 5, 5, 8, 8, 8, 8, },
        // DEFINITIONS
        {-1, 24, 21, 11, 12, 14, 13, 20, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 0, -1, 15, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -1, 3, 10, 10, 10, 6, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 5, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 5, 10, 10, 10, 10, 10, 10, 5, 10, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 5, 5, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 5, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 5, 5, 5, },
        // DEFINITIONS_RHS
        {-1, 24, 16, 16, 11, 12, 13, 20, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, -1, 16, 0, -1, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 17, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, -1, 3, 19, 17, 19, 19, 19, 19, 19, 18, 19, 19, 19, 19, 19, 19, 17, 19, 19, 19, 19, 17, 19, 19, 19, 19, 19, 19, 19, 19, 17, 19, 19, 19, 19, 17, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 5, 19, 5, 19, 5, 19, 19, 19, 19, 19, 17, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 5, 19, 19, 19, 19, 19, 19, 19, 19, 17, 19, 17, 17, 19, 19, 19, 5, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 17, 5, 5, 19, 19, 19, 19, 19, 19, 5, 19, 5, 19, 19, 19, 19, 5, 19, 19, 19, 19, 5, 19, 19, 19, 19, 19, 19, 19, 5, 19, 19, 19, 19, 5, 19, 19, 19, 19, 19, 19, 5, 19, 19, 19, 19, 5, 19, 19, 19, 19, 5, 19, 19, 5, 19, 19, 19, 19, 19, 19, 19, 5, 5, 5, 19, 19, 19, 19, 5, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 5, 5, 5, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 5, 19, 19, 19, 19, 5, 5, 5, 5, },
        // DEFINITION_FILE
        {22, 22, 22, 21, },
        // NO_DEFINITIONS
        {9, 9, 9, },
        // COMMENT
        {-1, 2, 2, 2, 24, 1, },

    };*/

    public static class State
    {
        public final static State NORMAL = new State(0);
        public final static State DEFINITIONS = new State(1);
        public final static State DEFINITIONS_RHS = new State(2);
        public final static State DEFINITION_FILE = new State(3);
        public final static State NO_DEFINITIONS = new State(4);
        public final static State COMMENT = new State(5);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
