/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web;

import de.prob.web.ISession;
import de.prob.web.ReloadRequiredException;
import de.prob.web.Responses;
import de.prob.web.WebUtils;
import de.prob.web.data.Message;
import de.prob.web.data.SessionResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSession
implements ISession {
    private final UUID id;
    protected final Responses responses;
    protected boolean incrementalUpdate = true;
    private final Logger logger = LoggerFactory.getLogger(AbstractSession.class);

    public AbstractSession() {
        this(UUID.randomUUID());
    }

    public AbstractSession(UUID id) {
        this.id = id;
        this.responses = new Responses();
    }

    @Override
    public Callable<SessionResult> command(final Map<String, String[]> parameterMap) {
        String cmd = this.get(parameterMap, "cmd");
        final AbstractSession delegate = this;
        Class<?> clazz = this.getClass();
        try {
            final Method method = clazz.getMethod(cmd, Map.class);
            return new Callable<SessionResult>(){

                @Override
                public SessionResult call() throws Exception {
                    Object result = method.invoke((Object)delegate, parameterMap);
                    if (result instanceof Object[]) {
                        return new SessionResult(delegate, (Object[])result);
                    }
                    return new SessionResult(delegate, result);
                }
            };
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return new Callable<SessionResult>(){

            @Override
            public SessionResult call() throws Exception {
                return new SessionResult(delegate, "");
            }
        };
    }

    @Override
    public abstract String html(String var1, Map<String, String[]> var2);

    @Override
    public UUID getSessionUUID() {
        return this.id;
    }

    public String get(Map<String, String[]> parameterMap, String key) {
        String[] strings = parameterMap.get(key);
        if (strings.length != 1) {
            throw new IllegalArgumentException("get Method is only applicable to simple key-Value pairs");
        }
        return strings[0];
    }

    @Override
    public void submit(Object ... result) {
        Message message = new Message(this.responses.size() + 1, result);
        this.responses.add(message);
    }

    protected void send(String json, AsyncContext context) {
        ServletResponse response = context.getResponse();
        try {
            PrintWriter writer = response.getWriter();
            writer.print(json);
            writer.flush();
            writer.close();
            context.complete();
        }
        catch (IOException e) {
            this.logger.error("Could not get the writer for connection.", (Throwable)e);
        }
        catch (UncheckedIOException e) {
            this.logger.trace("Exception occured while sending data. This happens if timeouts occured. Ignoring and continuing.");
        }
        catch (IllegalStateException e) {
            this.logger.trace("Exception occured while completing asynchronous call. This happens if timeouts occured. Ignoring and continuing.");
        }
    }

    @Override
    public void sendPendingUpdates(String client, int lastinfo, AsyncContext context) {
        if (lastinfo == -1) {
            this.reload(client, lastinfo, context);
        } else if (lastinfo < this.responses.size()) {
            this.resend(client, lastinfo, context);
        } else {
            this.send("", context);
        }
    }

    protected void resend(String client, int lastinfo, AsyncContext context) {
        if (this.responses.isEmpty()) {
            return;
        }
        Message m = null;
        int lastMessageId = -1;
        Message lastMessage = null;
        try {
            lastMessage = this.responses.get(this.responses.size() - 1);
            lastMessageId = lastMessage.id;
        }
        catch (ReloadRequiredException e) {
            this.reload(client, lastinfo, context);
            return;
        }
        if (this.incrementalUpdate || lastinfo > 0) {
            ArrayList<Object> cp = new ArrayList<Object>();
            try {
                for (int i = Math.max(lastinfo, 0); i < this.responses.size(); ++i) {
                    Message message = this.responses.get(i);
                    Object[] content = message.content;
                    for (int j = 0; j < content.length; ++j) {
                        cp.add(content[j]);
                    }
                }
            }
            catch (ReloadRequiredException e) {
                this.reload(client, lastinfo, context);
                return;
            }
            Object[] everything = cp.toArray();
            m = new Message(lastMessageId, everything);
        } else {
            m = lastMessage;
        }
        String json = WebUtils.toJson(m);
        this.send(json, context);
    }

    @Override
    public int getResponseCount() {
        return this.responses.size();
    }

    public void sendInitMessage(AsyncContext context) {
        Message message = new Message(0, WebUtils.wrap("cmd", "extern.skip"));
        this.send(WebUtils.toJson(message), context);
    }

    @Override
    public abstract void reload(String var1, int var2, AsyncContext var3);

    public String simpleRender(String clientid, String template) {
        Map<String, String> scope = WebUtils.wrap("clientid", clientid);
        return WebUtils.render(template, scope);
    }
}

