/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.AFn;
import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.IHashEq;
import com.github.krukow.clj_lang.IMapEntry;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.Util;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APersistentMap<K, V>
extends AFn
implements IPersistentMap<K, V>,
Map<K, V>,
Iterable<Map.Entry<K, V>>,
Serializable,
IHashEq {
    int _hash = -1;
    int _hasheq = -1;

    public String toString() {
        return RT.printString(this);
    }

    @Override
    public IPersistentCollection cons(IMapEntry<K, V> o) {
        return this.assoc(o.getKey(), o.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.size()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equals(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equiv(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.size()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equiv(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                Map.Entry e = (Map.Entry)s.first();
                hash += (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
            }
            this._hash = hash;
        }
        return this._hash;
    }

    @Override
    public int hasheq() {
        if (this._hasheq == -1) {
            int hash = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                Map.Entry e = (Map.Entry)s.first();
                hash += Util.hasheq(e.getKey()) ^ Util.hasheq(e.getValue());
            }
            this._hasheq = hash;
        }
        return this._hasheq;
    }

    @Override
    public Object invoke(Object arg1) {
        return this.valAt(arg1);
    }

    @Override
    public Object invoke(Object arg1, Object notFound) {
        return this.valAt(arg1, notFound);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return APersistentMap.this.iterator();
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }

            @Override
            public int hashCode() {
                return APersistentMap.this.hashCode();
            }

            @Override
            public boolean contains(Object o) {
                Map.Entry e;
                IMapEntry found;
                return o instanceof Map.Entry && (found = APersistentMap.this.entryAt((e = (Map.Entry)o).getKey())) != null && Util.equals(found.getValue(), e.getValue());
            }
        };
    }

    @Override
    public V get(Object key) {
        return this.valAt(key);
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry e = (Map.Entry)mi.next();
                        return e.getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }

            @Override
            public boolean contains(Object o) {
                return APersistentMap.this.containsKey(o);
            }
        };
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Map.Entry)mi.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }
        };
    }

    public static class ValSeq
    extends ASeq {
        ISeq seq;

        public static ValSeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new ValSeq(seq);
        }

        private ValSeq(ISeq seq) {
            this.seq = seq;
        }

        private ValSeq(IPersistentMap meta, ISeq seq) {
            super(meta);
            this.seq = seq;
        }

        public Object first() {
            return ((Map.Entry)this.seq.first()).getValue();
        }

        public ISeq next() {
            return ValSeq.create(this.seq.next());
        }

        public ValSeq withMeta(IPersistentMap meta) {
            return new ValSeq(meta, this.seq);
        }
    }

    public static class KeySeq
    extends ASeq {
        ISeq seq;

        public static KeySeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new KeySeq(seq);
        }

        private KeySeq(ISeq seq) {
            this.seq = seq;
        }

        private KeySeq(IPersistentMap meta, ISeq seq) {
            super(meta);
            this.seq = seq;
        }

        public Object first() {
            return ((Map.Entry)this.seq.first()).getKey();
        }

        public ISeq next() {
            return KeySeq.create(this.seq.next());
        }

        public KeySeq withMeta(IPersistentMap meta) {
            return new KeySeq(meta, this.seq);
        }
    }
}

