/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;

public final class MemIntQueue {
    private static final int InitialSize = 4096;
    private static final int GrowthFactor = 2;
    private int len = 0;
    private int[] elems = new int[4096];
    private int start = 0;
    private String diskdir;
    private String filename;

    public MemIntQueue(String metadir, String filename) {
        this.diskdir = metadir;
        this.filename = filename;
    }

    public final int length() {
        return this.len;
    }

    public final boolean hasElements() {
        return this.len > 0;
    }

    public final void enqueueInt(int elem) {
        if (this.len == this.elems.length) {
            int newLen = Math.max(1, this.len * 2);
            int[] newElems = new int[newLen];
            int copyLen = this.elems.length - this.start;
            System.arraycopy(this.elems, this.start, newElems, 0, copyLen);
            System.arraycopy(this.elems, 0, newElems, copyLen, this.start);
            this.elems = newElems;
            this.start = 0;
        }
        int last = (this.start + this.len) % this.elems.length;
        this.elems[last] = elem;
        ++this.len;
    }

    public final void enqueueLong(long elem) {
        this.enqueueInt((int)(elem >>> 32));
        this.enqueueInt((int)(elem & 0xFFFFFFFFL));
    }

    public final int dequeueInt() {
        if (this.len < 1) {
            throw new NoSuchElementException();
        }
        int res = this.elems[this.start];
        --this.len;
        this.start = (this.start + 1) % this.elems.length;
        return res;
    }

    public final long dequeueLong() {
        long high = this.dequeueInt();
        long low = this.dequeueInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final void beginChkpt() throws IOException {
        String tmpName = this.diskdir + FileUtil.separator + this.filename + ".tmp";
        BufferedDataOutputStream bos = new BufferedDataOutputStream(tmpName);
        bos.writeInt(this.len);
        int index = this.start;
        for (int i = 0; i < this.len; ++i) {
            bos.writeInt(this.elems[index++]);
            if (index != this.elems.length) continue;
            index = 0;
        }
        bos.close();
    }

    public final void commitChkpt() throws IOException {
        String oldName = this.diskdir + FileUtil.separator + this.filename + ".chkpt";
        File oldChkpt = new File(oldName);
        String newName = this.diskdir + FileUtil.separator + this.filename + ".tmp";
        File newChkpt = new File(newName);
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemStateQueue.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    public final void recover() throws IOException {
        String chkptName = this.diskdir + FileUtil.separator + this.filename + ".chkpt";
        BufferedDataInputStream bis = new BufferedDataInputStream(chkptName);
        this.len = bis.readInt();
        for (int i = 0; i < this.len; ++i) {
            this.elems[i] = bis.readInt();
        }
        bis.close();
    }

    public static class DetailedFormatter {
        public static String fpAndtidx(MemIntQueue aQueue) {
            StringBuffer buf = new StringBuffer(aQueue.len / 3);
            for (int i = 0; i < aQueue.len; i += 3) {
                long fp = (long)aQueue.elems[i] << 32 | (long)aQueue.elems[i + 1] & 0xFFFFFFFFL;
                buf.append("fp: " + fp);
                buf.append(" tidx: " + aQueue.elems[i + 2]);
                buf.append("\n");
            }
            return buf.toString();
        }

        public static String fpAndtidxAndptr(MemIntQueue aQueue) {
            StringBuffer buf = new StringBuffer(aQueue.len / 5);
            for (int i = 0; i < aQueue.len; i += 5) {
                long fp = (long)aQueue.elems[i] << 32 | (long)aQueue.elems[i + 1] & 0xFFFFFFFFL;
                buf.append("fp: " + fp);
                buf.append(" tidx: " + aQueue.elems[i + 2]);
                long ptr = (long)aQueue.elems[i + 3] << 32 | (long)aQueue.elems[i + 4] & 0xFFFFFFFFL;
                buf.append(" ptr: " + ptr);
                buf.append("\n");
            }
            return buf.toString();
        }
    }
}

