/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.lexer;

import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.SourceLocation;
import org.eventb.internal.core.lexer.ILexer;
import org.eventb.internal.core.lexer.LexStream;
import org.eventb.internal.core.lexer.LexicalClass;
import org.eventb.internal.core.lexer.Token;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.ParseResult;

public class GenLexer
implements ILexer {
    public static final int LAMBDA = 955;
    public static final int META = 36;
    public static final int PRIME = 39;
    public final ParseResult result;
    private final LexStream stream;
    private final AbstractGrammar grammar;
    private final LexemReader reader;

    public static boolean isIdent(String str) {
        return LexicalClass.IDENTIFIER.contains(str);
    }

    public static boolean isSymbol(String str) {
        return LexicalClass.SYMBOL.contains(str);
    }

    public GenLexer(String toLex, ParseResult result, AbstractGrammar grammar) {
        this.result = result;
        this.stream = new LexStream(toLex);
        this.grammar = grammar;
        this.reader = new LexemReader(grammar);
    }

    @Override
    public LexState save() {
        return new LexState(this.stream.getTokenStart(), this.stream.getCurPos());
    }

    @Override
    public void restore(LexState lexState) {
        this.stream.setTokenStart(lexState.tokenStart);
        this.stream.setCurPos(lexState.curPos);
    }

    @Override
    public Token nextToken() {
        if (this.stream.isEOF()) {
            return this.makeEOF();
        }
        LexicalClass lexClass = this.reader.read(this.stream);
        if (lexClass == null) {
            this.addProblem(this.stream.getLexem());
            return this.nextToken();
        }
        if (lexClass == LexicalClass.WHITESPACE) {
            return this.nextToken();
        }
        String lexem = this.stream.getLexem();
        int kind = lexClass.getKind(lexem, this.grammar);
        if (kind == -1) {
            this.addProblem(lexem);
            return this.makeEOF();
        }
        if (kind == this.grammar.getKind(AbstractGrammar.DefaultToken.IDENT) && GenLexer.isPrime(this.stream)) {
            this.stream.goForward();
            lexem = this.stream.getLexem();
        }
        return new Token(kind, lexem, this.stream.getTokenStart());
    }

    @Override
    public Token makeEOF() {
        return new Token(this.grammar.getKind(AbstractGrammar.DefaultToken.EOF), "", this.stream.getCurPos());
    }

    private void addProblem(String tokenImage) {
        int pos = this.stream.getCurPos() - 1;
        this.result.addProblem(new ASTProblem(new SourceLocation(pos, pos), ProblemKind.LexerError, 0, tokenImage));
    }

    private static boolean isPrime(LexStream stream) {
        return !stream.isEOF() && stream.curCodePoint() == 39;
    }

    @Override
    public int eofKind() {
        return this.grammar.getKind(AbstractGrammar.DefaultToken.EOF);
    }

    @Override
    public ParseResult getResult() {
        return this.result;
    }

    public static class LexemReader {
        private final AbstractGrammar grammar;

        public LexemReader(AbstractGrammar grammar) {
            this.grammar = grammar;
        }

        public LexicalClass read(LexStream stream) {
            stream.startNext();
            int codePoint = stream.codePointAt(stream.getTokenStart());
            LexicalClass lexClass = LexemReader.recognize(codePoint);
            boolean success = lexClass.read(stream, this.grammar);
            if (!success) {
                return null;
            }
            return lexClass;
        }

        private static LexicalClass recognize(int codePoint) {
            LexicalClass lexClass = LexicalClass.getLexicalClass(codePoint);
            if (lexClass == null) {
                throw new IllegalStateException("LEXER: code point with no lexical class: " + codePoint);
            }
            return lexClass;
        }
    }

    public static class LexState {
        public final int tokenStart;
        public final int curPos;

        public LexState(int tokenStart, int curPos) {
            this.curPos = curPos;
            this.tokenStart = tokenStart;
        }
    }
}

