/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast.extension;

import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.extension.ExtensionFactory;
import org.eventb.core.ast.extension.IArity;
import org.eventb.core.ast.extension.ITypeDistribution;

public interface IOperatorProperties {
    public static final IArity NULLARY = ExtensionFactory.makeFixedArity(0);
    public static final IArity UNARY = ExtensionFactory.makeFixedArity(1);
    public static final IArity BINARY = ExtensionFactory.makeFixedArity(2);
    public static final IArity MULTARY_2 = ExtensionFactory.makeArity(2, Integer.MAX_VALUE);

    public Notation getNotation();

    public FormulaType getFormulaType();

    public ITypeDistribution getChildTypes();

    public boolean isAssociative();

    public static enum FormulaType {
        EXPRESSION{

            @Override
            public boolean check(Formula<?> formula) {
                return formula instanceof Expression;
            }
        }
        ,
        PREDICATE{

            @Override
            public boolean check(Formula<?> formula) {
                return formula instanceof Predicate;
            }
        };


        public abstract boolean check(Formula<?> var1);
    }

    public static enum Notation {
        PREFIX,
        INFIX,
        POSTFIX;

    }
}

