/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.be4.classicalb.core.parser.node.AAnticipatedEventstatus;
import de.be4.classicalb.core.parser.node.AConvergentEventstatus;
import de.be4.classicalb.core.parser.node.AEvent;
import de.be4.classicalb.core.parser.node.AEventBModelParseUnit;
import de.be4.classicalb.core.parser.node.AEventsModelClause;
import de.be4.classicalb.core.parser.node.AInvariantModelClause;
import de.be4.classicalb.core.parser.node.AOrdinaryEventstatus;
import de.be4.classicalb.core.parser.node.ARefinesModelClause;
import de.be4.classicalb.core.parser.node.ASeesModelClause;
import de.be4.classicalb.core.parser.node.ATheoremsModelClause;
import de.be4.classicalb.core.parser.node.AVariablesModelClause;
import de.be4.classicalb.core.parser.node.AVariantModelClause;
import de.be4.classicalb.core.parser.node.AWitness;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PEventstatus;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PModelClause;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.Context;
import de.prob.model.eventb.Event;
import de.prob.model.eventb.EventBAction;
import de.prob.model.eventb.EventBGuard;
import de.prob.model.eventb.EventBInvariant;
import de.prob.model.eventb.EventBMachine;
import de.prob.model.eventb.EventBVariable;
import de.prob.model.eventb.EventParameter;
import de.prob.model.eventb.Witness;
import de.prob.model.representation.ModelElementList;
import de.prob.util.Tuple2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventBMachineTranslator {
    private final EventBMachine machine;
    private final Map<Node, Tuple2<String, String>> nodeInfos = new HashMap<Node, Tuple2<String, String>>();

    public EventBMachineTranslator(EventBMachine machine) {
        this.machine = machine;
    }

    public Map<Node, Tuple2<String, String>> getNodeInfos() {
        return this.nodeInfos;
    }

    public Node translateMachine() {
        AEventBModelParseUnit ast = new AEventBModelParseUnit();
        ast.setName(new TIdentifierLiteral(this.machine.getName()));
        ArrayList<Object> clauses = new ArrayList<Object>();
        clauses.add(this.processContexts());
        ARefinesModelClause refines = this.processRefines();
        if (refines != null) {
            clauses.add(refines);
        }
        clauses.add(this.processVariables());
        clauses.addAll(this.processInvariantsAndTheorems());
        AVariantModelClause variant = this.processVariant();
        if (variant != null) {
            clauses.add(variant);
        }
        clauses.add(this.processEvents());
        ast.setModelClauses(clauses);
        return ast;
    }

    private ASeesModelClause processContexts() {
        ModelElementList<Context> sees = this.machine.getSees();
        ArrayList<TIdentifierLiteral> contextNames = new ArrayList<TIdentifierLiteral>();
        for (Context context : sees) {
            contextNames.add(new TIdentifierLiteral(context.getName()));
        }
        return new ASeesModelClause(contextNames);
    }

    private ARefinesModelClause processRefines() {
        ModelElementList<EventBMachine> refines = this.machine.getRefines();
        if (!refines.isEmpty()) {
            return new ARefinesModelClause(new TIdentifierLiteral(((EventBMachine)refines.get(0)).getName()));
        }
        return null;
    }

    private AVariablesModelClause processVariables() {
        ArrayList<PExpression> identifiers = new ArrayList<PExpression>();
        for (EventBVariable eventBVariable : this.machine.getVariables()) {
            identifiers.add((PExpression)((EventB)eventBVariable.getExpression()).getAst());
        }
        return new AVariablesModelClause(identifiers);
    }

    private List<PModelClause> processInvariantsAndTheorems() {
        ArrayList<PModelClause> invsAndTheorems = new ArrayList<PModelClause>();
        ArrayList<PPredicate> invs = new ArrayList<PPredicate>();
        ArrayList<PPredicate> thms = new ArrayList<PPredicate>();
        ModelElementList<EventBInvariant> allInvs = this.machine.getInvariants();
        for (EventBInvariant ebInv : allInvs) {
            PPredicate ppred = (PPredicate)((EventB)ebInv.getPredicate()).getAst();
            this.nodeInfos.put((Node)ppred, new Tuple2<String, String>(this.machine.getName(), ebInv.getName()));
            if (ebInv.isTheorem()) {
                thms.add(ppred);
                continue;
            }
            invs.add(ppred);
        }
        invsAndTheorems.add((PModelClause)new AInvariantModelClause(invs));
        invsAndTheorems.add((PModelClause)new ATheoremsModelClause(thms));
        return invsAndTheorems;
    }

    private AVariantModelClause processVariant() {
        if (this.machine.getVariant() != null) {
            EventB expression = (EventB)this.machine.getVariant().getExpression();
            return new AVariantModelClause((PExpression)expression.getAst());
        }
        return null;
    }

    private AEventsModelClause processEvents() {
        ArrayList<AEvent> events = new ArrayList<AEvent>();
        for (Event e : this.machine.getEvents()) {
            AEvent event = new AEvent();
            event.setEventName(new TIdentifierLiteral(e.getName()));
            event.setStatus(this.extractEventStatus(e));
            this.nodeInfos.put((Node)event, new Tuple2<String, String>(this.machine.getName(), e.getName()));
            ArrayList<TIdentifierLiteral> refined = new ArrayList<TIdentifierLiteral>();
            for (Event ref : e.getRefines()) {
                refined.add(new TIdentifierLiteral(ref.getName()));
            }
            event.setRefines(refined);
            ArrayList<PExpression> params = new ArrayList<PExpression>();
            for (EventParameter eventParameter : e.getParameters()) {
                PExpression pExpression = (PExpression)eventParameter.getExpression().getAst();
                this.nodeInfos.put((Node)pExpression, new Tuple2<String, String>(this.machine.getName(), eventParameter.getName()));
                params.add(pExpression);
            }
            event.setVariables(params);
            ArrayList<PPredicate> guards = new ArrayList<PPredicate>();
            ArrayList<PPredicate> thms = new ArrayList<PPredicate>();
            for (EventBGuard eventBGuard : e.getGuards()) {
                PPredicate ppred = (PPredicate)((EventB)eventBGuard.getPredicate()).getAst();
                this.nodeInfos.put((Node)ppred, new Tuple2<String, String>(this.machine.getName(), eventBGuard.getName()));
                if (eventBGuard.isTheorem()) {
                    thms.add(ppred);
                    continue;
                }
                guards.add(ppred);
            }
            event.setGuards(guards);
            event.setTheorems(thms);
            ArrayList<AWitness> witnesses = new ArrayList<AWitness>();
            for (Witness witness : e.getWitnesses()) {
                PPredicate ppred = (PPredicate)witness.getPredicate().getAst();
                this.nodeInfos.put((Node)ppred, new Tuple2<String, String>(this.machine.getName(), witness.getName()));
                witnesses.add(new AWitness(new TIdentifierLiteral(witness.getName()), ppred));
            }
            event.setWitness(witnesses);
            ArrayList<PSubstitution> actions = new ArrayList<PSubstitution>();
            for (EventBAction eventBAction : e.getActions()) {
                PSubstitution psub = (PSubstitution)((EventB)eventBAction.getCode()).getAst();
                this.nodeInfos.put((Node)psub, new Tuple2<String, String>(this.machine.getName(), eventBAction.getName()));
                actions.add(psub);
            }
            event.setAssignments(actions);
            events.add(event);
        }
        return new AEventsModelClause(events);
    }

    private PEventstatus extractEventStatus(Event e) {
        AOrdinaryEventstatus result = null;
        switch (e.getType()) {
            case ORDINARY: {
                result = new AOrdinaryEventstatus();
                break;
            }
            case ANTICIPATED: {
                result = new AAnticipatedEventstatus();
                break;
            }
            case CONVERGENT: {
                result = new AConvergentEventstatus();
                break;
            }
        }
        return result;
    }
}

