/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.theory;

import de.prob.model.representation.AbstractElement;
import de.prob.util.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.datatype.IConstructorBuilder;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.datatype.IDatatypeBuilder;
import org.eventb.core.ast.extension.IFormulaExtension;

public class DataType
extends AbstractElement {
    final String identifierString;
    private final Map<String, List<Tuple2<String, String>>> constructors;
    private final List<String> typeArguments;

    public DataType(String identifier, Map<String, List<Tuple2<String, String>>> constructors, List<String> types) {
        this.identifierString = identifier;
        this.constructors = constructors;
        this.typeArguments = types;
    }

    public String getTypeIdentifier() {
        return this.identifierString;
    }

    public String toString() {
        return this.identifierString;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DataType) {
            return this.identifierString.equals(((DataType)obj).toString());
        }
        return false;
    }

    public int hashCode() {
        return this.identifierString.hashCode();
    }

    public Map<String, List<Tuple2<String, String>>> getConstructors() {
        return this.constructors;
    }

    public Set<IFormulaExtension> getFormulaExtensions(FormulaFactory ff) {
        ArrayList<GivenType> types = new ArrayList<GivenType>();
        for (String type : this.typeArguments) {
            IParseResult parseType = ff.parseType(type);
            if (!(parseType.getParsedType() instanceof GivenType)) continue;
            types.add((GivenType)parseType.getParsedType());
        }
        assert (types.size() == this.typeArguments.size());
        IDatatypeBuilder builder = ff.makeDatatypeBuilder(this.identifierString, types.toArray(new GivenType[this.typeArguments.size()]));
        for (Map.Entry<String, List<Tuple2<String, String>>> entry : this.constructors.entrySet()) {
            IConstructorBuilder consBuilder = builder.addConstructor(entry.getKey());
            for (Tuple2<String, String> destructor : entry.getValue()) {
                IParseResult parseType = ff.parseType(destructor.getSecond());
                consBuilder.addArgument(destructor.getFirst(), parseType.getParsedType());
            }
        }
        IDatatype datatype = builder.finalizeDatatype();
        Set extensions = datatype.getExtensions();
        return extensions;
    }

    public List<String> getTypeArguments() {
        return this.typeArguments;
    }
}

