/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.algorithm;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Switch;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import java.util.HashSet;
import java.util.Set;

public class IdentifierExtractor
extends DepthFirstAdapter {
    private final Set<String> identifiers = new HashSet<String>();

    public Set<String> getIdentifiers() {
        return this.identifiers;
    }

    public void inAIdentifierExpression(AIdentifierExpression node) {
        this.identifiers.add(((TIdentifierLiteral)node.getIdentifier().getFirst()).getText());
    }

    public static Set<String> union(Node ... assignments) {
        HashSet<String> union = new HashSet<String>();
        for (Node assignment : assignments) {
            IdentifierExtractor v = new IdentifierExtractor();
            assignment.apply((Switch)v);
            union.addAll(v.getIdentifiers());
        }
        return union;
    }

    public static Set<String> intersection(Node assignment1, Node assignment2) {
        IdentifierExtractor v1 = new IdentifierExtractor();
        IdentifierExtractor v2 = new IdentifierExtractor();
        assignment1.apply((Switch)v1);
        assignment2.apply((Switch)v2);
        HashSet<String> intersection = new HashSet<String>();
        Set<String> union = IdentifierExtractor.union(assignment1, assignment2);
        for (String id : union) {
            if (!v1.getIdentifiers().contains(id) || !v2.getIdentifiers().contains(id)) continue;
            intersection.add(id);
        }
        return intersection;
    }

    public static boolean disjoint(Node assignment1, Node assignment2) {
        return IdentifierExtractor.intersection(assignment1, assignment2).isEmpty();
    }
}

