/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.domainobjects;

import de.prob.parser.BindingGenerator;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.unicode.UnicodeTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class ExpandedFormula {
    private String name;
    private Object value;
    private String id;
    private boolean hasError = false;
    private List<ExpandedFormula> children;
    private final Map<String, Object> fields = new HashMap<String, Object>();

    public ExpandedFormula(CompoundPrologTerm cpt) {
        this.init(cpt);
    }

    public void init(CompoundPrologTerm cpt) {
        this.name = cpt.getArgument(1).getFunctor();
        this.fields.put("name", this.escapeUnicode(this.name));
        PrologTerm v = cpt.getArgument(2);
        this.value = this.getValue(v);
        this.fields.put("value", this.value instanceof String ? this.escapeUnicode((String)this.value) : this.value);
        this.fields.put("hasError", this.hasError);
        this.id = cpt.getArgument(3).getFunctor();
        this.fields.put("id", this.id);
        ListPrologTerm list = BindingGenerator.getList((PrologTerm)cpt.getArgument(4));
        if (!list.isEmpty()) {
            this.children = new ArrayList<ExpandedFormula>();
            ArrayList<Map<String, Object>> childrenFields = new ArrayList<Map<String, Object>>();
            for (PrologTerm prologTerm : list) {
                ExpandedFormula expandedFormula = new ExpandedFormula(BindingGenerator.getCompoundTerm((PrologTerm)prologTerm, (int)4));
                this.children.add(expandedFormula);
                childrenFields.add(expandedFormula.getFields());
            }
            this.fields.put("children", childrenFields);
        }
    }

    private String escapeUnicode(String data) {
        return StringEscapeUtils.escapeJava((String)data);
    }

    private Object getValue(PrologTerm v) {
        if (v.getFunctor().equals("p")) {
            CompoundPrologTerm cpt = BindingGenerator.getCompoundTerm((PrologTerm)v, (int)1);
            if (cpt.getArgument(1).getFunctor().equals("true")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (v.getFunctor().equals("v")) {
            CompoundPrologTerm cpt = BindingGenerator.getCompoundTerm((PrologTerm)v, (int)1);
            return UnicodeTranslator.toUnicode((String)cpt.getArgument(1).getFunctor());
        }
        if (v.getFunctor().equals("e")) {
            CompoundPrologTerm cpt = BindingGenerator.getCompoundTerm((PrologTerm)v, (int)1);
            this.hasError = true;
            return cpt.getArgument(1).getFunctor();
        }
        v.getFunctor();
        return null;
    }

    public String getLabel() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public List<ExpandedFormula> getChildren() {
        return this.children;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.fields.toString();
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void toggle() {
        if (this.fields.containsKey("children")) {
            Object _children = this.fields.get("children");
            this.fields.put("_children", _children);
            this.fields.remove("children");
        } else {
            Object children = this.fields.get("_children");
            this.fields.put("children", children);
            this.fields.remove("_children");
        }
    }

    public void collapseNodes(Set<String> collapsedNodes) {
        if (collapsedNodes.contains(this.id)) {
            this.toggle();
            collapsedNodes.remove(this.id);
        }
        if (this.children == null) {
            return;
        }
        if (collapsedNodes.isEmpty()) {
            return;
        }
        for (ExpandedFormula expandedFormula : this.children) {
            expandedFormula.collapseNodes(collapsedNodes);
        }
    }
}

