/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.AbstractEvalResult;
import de.prob.animator.domainobjects.ComputationNotCompletedResult;
import de.prob.animator.domainobjects.EvalResult;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbcSolveCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "cbc_solve";
    private static final int BINDINGS = 1;
    private static final int VAR_NAME = 1;
    private static final int PROLOG_REP = 2;
    private static final int PRETTY_PRINT = 3;
    Logger logger = LoggerFactory.getLogger(CbcSolveCommand.class);
    private static final String EVALUATE_TERM_VARIABLE = "Val";
    private static final String IDENTIFIER_LIST = "IdList";
    private final IEvalElement evalElement;
    private AbstractEvalResult result;
    private final List<String> freeVariables = new ArrayList<String>();

    public CbcSolveCommand(IEvalElement evalElement) {
        this.evalElement = evalElement;
    }

    public AbstractEvalResult getValue() {
        return this.result;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm idList = (PrologTerm)bindings.get((Object)IDENTIFIER_LIST);
        if (idList instanceof ListPrologTerm) {
            for (PrologTerm id : (ListPrologTerm)idList) {
                this.freeVariables.add(id.getFunctor());
            }
        }
        PrologTerm prologTerm = (PrologTerm)bindings.get((Object)EVALUATE_TERM_VARIABLE);
        assert (prologTerm instanceof CompoundPrologTerm);
        String functor = prologTerm.getFunctor();
        if ("time_out".equals(functor)) {
            this.result = new ComputationNotCompletedResult(this.evalElement.getCode(), "time out");
        }
        if ("contradiction_found".equals(functor)) {
            this.result = new ComputationNotCompletedResult(this.evalElement.getCode(), "contradiction found");
        }
        if ("solution".equals(functor)) {
            ListPrologTerm solutionBindings = BindingGenerator.getList((PrologTerm)prologTerm.getArgument(1));
            if (solutionBindings.isEmpty()) {
                this.result = EvalResult.TRUE;
                return;
            }
            HashMap<String, String> solutions = new HashMap<String, String>();
            for (PrologTerm b : solutionBindings) {
                CompoundPrologTerm t = (CompoundPrologTerm)b;
                solutions.put(t.getArgument(1).getFunctor(), t.getArgument(3).getFunctor());
            }
            this.result = new EvalResult("TRUE", solutions);
        }
        if ("no_solution_found".equals(functor)) {
            this.result = new ComputationNotCompletedResult(this.evalElement.getCode(), "no solution found (but one might exist)");
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pout) {
        pout.openTerm(PROLOG_COMMAND_NAME);
        pout.openList();
        this.evalElement.printProlog(pout);
        pout.closeList();
        pout.printVariable(IDENTIFIER_LIST);
        pout.printVariable(EVALUATE_TERM_VARIABLE);
        pout.closeTerm();
    }

    public List<String> getFreeVariables() {
        return this.freeVariables;
    }
}

