/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.be4.classicalb.core.preparser.parser;

import de.be4.classicalb.core.preparser.lexer.*;
import de.be4.classicalb.core.preparser.node.*;
import de.be4.classicalb.core.preparser.analysis.*;
import java.util.*;
import de.hhu.stups.sablecc.patch.*;


import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings({"rawtypes","unchecked","unused"})
public class Parser implements IParser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;
    
    private ArrayList firstPopped = null;
    private ArrayList lastPopped = null;
    private ITokenListContainer lex;

    public Parser(  Lexer lexer)
    {
        this.lexer = lexer;
        this.lex = lexer; 
    }
    
     
    private Map<PositionedNode, SourcecodeRange> mapping = new HashMap<PositionedNode, SourcecodeRange>();    
    public Map<PositionedNode, SourcecodeRange> getMapping() { 	return this.mapping; }

   private void checkResult(Object elementToCheck) {
       checkResult(elementToCheck, false);
   }

	 
	private void checkResult(Object elementToCheck, boolean slurp) {
		// nodes with no tokens or sub nodes at all may exist
		if (this.firstPopped == null) {
			return;
		}

		if (elementToCheck instanceof LinkedList) {
			/*
			 * special case: this is a list of nodes, for example an identifier
			 * list, so we don't want to check the list but the last element
			 * added to it
			 */
			final LinkedList nodeList = (LinkedList) elementToCheck;

			if (nodeList.size() > 0) {
				elementToCheck = nodeList.get(nodeList.size() - 1);
			} else {
				// no positions for empty lists...
				return;
			}
		}

		if (!(elementToCheck instanceof PositionedNode)) {
			throw new Error(
					"Unexpected elementToCheck (not instanceof PositionedNode): "
							+ elementToCheck.getClass().getSimpleName() + "/"
							+ elementToCheck);
		}

		if (!this.getMapping().containsKey(elementToCheck) || slurp ) {
			final PositionedNode node = (PositionedNode) elementToCheck;

			// dealing with a one-token element
			if (this.lastPopped == null) {
				this.lastPopped = this.firstPopped;
			}

			final int begin = findBeginPos(this.lastPopped, node);
			int end = findEndPos(this.firstPopped);
			if (end == -1) end = begin;
			final SourcecodeRange range = new SourcecodeRange(begin, end);

			this.getMapping().put(node, range);

			node.setStartPos(createBeginPos(begin));
			node.setEndPos(createEndPos(end));
		}
	}
	
	 
	private int findBeginPos(final ArrayList list,
			PositionedNode n) {
		Object first = list.get(0);
		if (!(first instanceof PositionedNode) && !(first instanceof IToken)) {
			List list2 = (List) first;

			if (list2.size() > 0) {
				first = list2.get(0);
			} else {
				/*
				 * Sometimes (haven't found out why) we get empty list here. In
				 * the only observed cases we were looking for the source range
				 * of the whole parse unit. Then the index is 0.
				 */
				return 0;
			}
		}

		if (first instanceof IToken) {
			return findIndex((IToken) first);
		}

		final PositionedNode node = (PositionedNode) first;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null){
			System.err.println(n.getClass().getSimpleName() + " / " + node.getClass().getSimpleName() + ": " + node);
		}
		return item.getBeginIndex();
	}

	 
	private int findEndPos(final ArrayList list) {
		Object last = list.get(list.size() - 1);
		if (!(last instanceof PositionedNode) && !(last instanceof IToken)) {
			final List list2 = (List) last;
			last = list2.get(list2.size() - 1);
		}

		if (last instanceof IToken) {
			return findIndex((IToken) last);
		}

		final PositionedNode node = (PositionedNode) last;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null)
			return -1;
		return item.getEndIndex();
	}

	private int findIndex(final IToken token) {
		final List<IToken> list = this.lex.getTokenList();

		for (int i = list.size() - 1; i >= 0; i--) {
			if (list.get(i) == token) {
				return i;
			}
		}

		return -1;
	}

	private SourcePosition createBeginPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos());
	}

	private SourcePosition createEndPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos()
				+ token.getText().length());
	}
	     
    private void push(int numstate, ArrayList listNode) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
    	ArrayList list = ((State) this.stack.previous()).nodes; 
		if (this.firstPopped == null) {
			this.firstPopped = list;
		} else {
			this.lastPopped = list;
		}
        return list;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

     
    public Start parse() throws ParserException, LexerException, IOException
    {
    	this.getMapping().clear();
    
        push(0, null);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce ADefsClauseParseUnit */
		    {
			ArrayList list = new0();
			push(goTo(0), list);
		    }
		    break;
                    case 1: /* reduce AKwDefinitionsParseUnit */
		    {
			ArrayList list = new1();
			push(goTo(0), list);
		    }
		    break;
                    case 2: /* reduce ASomethingParseUnit */
		    {
			ArrayList list = new2();
			push(goTo(0), list);
		    }
		    break;
                    case 3: /* reduce ANothingParseUnit */
		    {
			ArrayList list = new3();
			push(goTo(0), list);
		    }
		    break;
                    case 4: /* reduce AAdefclause1DefClause */
		    {
			ArrayList list = new4();
			push(goTo(1), list);
		    }
		    break;
                    case 5: /* reduce AAdefclause2DefClause */
		    {
			ArrayList list = new5();
			push(goTo(1), list);
		    }
		    break;
                    case 6: /* reduce ASingleDefinitionList */
		    {
			ArrayList list = new6();
			push(goTo(2), list);
		    }
		    break;
                    case 7: /* reduce AMultiDefinitionList */
		    {
			ArrayList list = new7();
			push(goTo(2), list);
		    }
		    break;
                    case 8: /* reduce AAdefinition1Definition */
		    {
			ArrayList list = new8();
			push(goTo(3), list);
		    }
		    break;
                    case 9: /* reduce AAdefinition2Definition */
		    {
			ArrayList list = new9();
			push(goTo(3), list);
		    }
		    break;
                    case 10: /* reduce AFileDefinition */
		    {
			ArrayList list = new10();
			push(goTo(3), list);
		    }
		    break;
                    case 11: /* reduce ADefParameters */
		    {
			ArrayList list = new11();
			push(goTo(4), list);
		    }
		    break;
                    case 12: /* reduce ASingleIdentifierList */
		    {
			ArrayList list = new12();
			push(goTo(5), list);
		    }
		    break;
                    case 13: /* reduce AMultiIdentifierList */
		    {
			ArrayList list = new13();
			push(goTo(5), list);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PParseUnit node1 = (PParseUnit) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " ,
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



     
    ArrayList new0() /* reduce ADefsClauseParseUnit */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PParseUnit pparseunitNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList1.get(0);
	if(listNode2 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode2);
  	  //listNode3 = listNode2;
	}
        }

        pparseunitNode1 = new ADefsParseUnit(listNode3);
        }
	nodeList.add(pparseunitNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new1() /* reduce AKwDefinitionsParseUnit */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PParseUnit pparseunitNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList2.get(0);
	if(listNode2 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode2);
  	  //listNode3 = listNode2;
	}
        }

        pparseunitNode1 = new ADefsParseUnit(listNode3);
        }
	nodeList.add(pparseunitNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new2() /* reduce ASomethingParseUnit */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PParseUnit pparseunitNode1;
        {
            // Block

        pparseunitNode1 = new ANoDefsParseUnit();
        }
	nodeList.add(pparseunitNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new3() /* reduce ANothingParseUnit */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

        PParseUnit pparseunitNode1;
        {
            // Block

        pparseunitNode1 = new ANoDefsParseUnit();
        }
	nodeList.add(pparseunitNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new4() /* reduce AAdefclause1DefClause */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        listNode1 = (LinkedList)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode2.addAll(listNode1);
  	  //listNode2 = listNode1;
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new5() /* reduce AAdefclause2DefClause */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        listNode1 = (LinkedList)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode2.addAll(listNode1);
  	  //listNode2 = listNode1;
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new6() /* reduce ASingleDefinitionList */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PDefinition pdefinitionNode1;
        pdefinitionNode1 = (PDefinition)nodeArrayList1.get(0);
	if(pdefinitionNode1 != null)
	{
	  listNode2.add(pdefinitionNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new7() /* reduce AMultiDefinitionList */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PDefinition pdefinitionNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pdefinitionNode2 = (PDefinition)nodeArrayList3.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(pdefinitionNode2 != null)
	{
	  listNode3.add(pdefinitionNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new8() /* reduce AAdefinition1Definition */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PDefinition pdefinitionNode1;
        {
            // Block
        TIdentifierLiteral tidentifierliteralNode2;
        LinkedList listNode3 = new LinkedList();
        TRhsBody trhsbodyNode4;
        tidentifierliteralNode2 = (TIdentifierLiteral)nodeArrayList1.get(0);
        {
            // Block
        }
        trhsbodyNode4 = (TRhsBody)nodeArrayList3.get(0);

        pdefinitionNode1 = new ADefinition(tidentifierliteralNode2, listNode3, trhsbodyNode4);
        }
	nodeList.add(pdefinitionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new9() /* reduce AAdefinition2Definition */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PDefinition pdefinitionNode1;
        {
            // Block
        TIdentifierLiteral tidentifierliteralNode2;
        LinkedList listNode4 = new LinkedList();
        TRhsBody trhsbodyNode5;
        tidentifierliteralNode2 = (TIdentifierLiteral)nodeArrayList1.get(0);
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        listNode3 = (LinkedList)nodeArrayList2.get(0);
	if(listNode3 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode4.addAll(listNode3);
  	  //listNode4 = listNode3;
	}
        }
        trhsbodyNode5 = (TRhsBody)nodeArrayList4.get(0);

        pdefinitionNode1 = new ADefinition(tidentifierliteralNode2, listNode4, trhsbodyNode5);
        }
	nodeList.add(pdefinitionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new10() /* reduce AFileDefinition */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PDefinition pdefinitionNode1;
        {
            // Block
        TFilename tfilenameNode2;
        tfilenameNode2 = (TFilename)nodeArrayList2.get(0);

        pdefinitionNode1 = new AFileDefinition(tfilenameNode2);
        }
	nodeList.add(pdefinitionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new11() /* reduce ADefParameters */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        listNode1 = (LinkedList)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode2.addAll(listNode1);
  	  //listNode2 = listNode1;
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new12() /* reduce ASingleIdentifierList */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        TIdentifierLiteral tidentifierliteralNode1;
        tidentifierliteralNode1 = (TIdentifierLiteral)nodeArrayList1.get(0);
	if(tidentifierliteralNode1 != null)
	{
	  listNode2.add(tidentifierliteralNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new13() /* reduce AMultiIdentifierList */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        TIdentifierLiteral tidentifierliteralNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        tidentifierliteralNode2 = (TIdentifierLiteral)nodeArrayList3.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(tidentifierliteralNode2 != null)
	{
	  listNode3.add(tidentifierliteralNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


    private static int[][][] actionTable;
/*      {
			{{-1, REDUCE, 3}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, },
			{{-1, ERROR, 1}, {4, SHIFT, 6}, {15, SHIFT, 7}, },
			{{-1, ERROR, 2}, {0, SHIFT, 1}, },
			{{-1, ERROR, 3}, {3, SHIFT, 11}, },
			{{-1, ERROR, 4}, {17, ACCEPT, -1}, },
			{{-1, REDUCE, 0}, },
			{{-1, ERROR, 6}, {5, SHIFT, 12}, {9, SHIFT, 13}, },
			{{-1, ERROR, 7}, {16, SHIFT, 15}, },
			{{-1, REDUCE, 4}, {14, SHIFT, 16}, },
			{{-1, REDUCE, 6}, },
			{{-1, REDUCE, 1}, },
			{{-1, REDUCE, 2}, },
			{{-1, ERROR, 12}, {4, SHIFT, 17}, },
			{{-1, ERROR, 13}, {10, SHIFT, 19}, },
			{{-1, ERROR, 14}, {9, SHIFT, 20}, },
			{{-1, ERROR, 15}, {15, SHIFT, 21}, },
			{{-1, REDUCE, 5}, {4, SHIFT, 6}, {15, SHIFT, 7}, },
			{{-1, REDUCE, 12}, },
			{{-1, ERROR, 18}, {6, SHIFT, 23}, {8, SHIFT, 24}, },
			{{-1, REDUCE, 8}, },
			{{-1, ERROR, 20}, {10, SHIFT, 25}, },
			{{-1, REDUCE, 10}, },
			{{-1, REDUCE, 7}, },
			{{-1, REDUCE, 11}, },
			{{-1, ERROR, 24}, {4, SHIFT, 26}, },
			{{-1, REDUCE, 9}, },
			{{-1, REDUCE, 13}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 4}, },
			{{-1, 5}, {2, 10}, },
			{{-1, 8}, },
			{{-1, 9}, {16, 22}, },
			{{-1, 14}, },
			{{-1, 18}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: 'DEFINITIONS', '#DEFINITIONS', kw prefix, EOF",
			"expecting: identifier literal, double quotation",
			"expecting: 'DEFINITIONS'",
			"expecting: no def something",
			"expecting: EOF",
			"expecting: '(', '=='",
			"expecting: filename",
			"expecting: semicolon, EOF",
			"expecting: identifier literal",
			"expecting: rhs body",
			"expecting: '=='",
			"expecting: double quotation",
			"expecting: identifier literal, double quotation, EOF",
			"expecting: ')', ','",
        };*/
    private static int[] errors;
/*      {
			0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 4, 4, 8, 9, 10, 11, 12, 13, 13, 7, 9, 7, 7, 10, 8, 7, 13, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
