/* This file was generated by SableCC (http://www.sablecc.org/). */

package promela.parser;

import promela.lexer.*;
import promela.node.*;
import promela.analysis.*;
import java.util.*;
import de.hhu.stups.sablecc.patch.*;


import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings({"rawtypes","unchecked","unused"})
public class Parser implements IParser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;
    
    private ArrayList firstPopped = null;
    private ArrayList lastPopped = null;
    private ITokenListContainer lex;

    public Parser(  Lexer lexer)
    {
        this.lexer = lexer;
        this.lex = lexer; 
    }
    
     
    private Map<PositionedNode, SourcecodeRange> mapping = new HashMap<PositionedNode, SourcecodeRange>();    
    public Map<PositionedNode, SourcecodeRange> getMapping() { 	return this.mapping; }

   private void checkResult(Object elementToCheck) {
       checkResult(elementToCheck, false);
   }

	 
	private void checkResult(Object elementToCheck, boolean slurp) {
		// nodes with no tokens or sub nodes at all may exist
		if (this.firstPopped == null) {
			return;
		}

		if (elementToCheck instanceof LinkedList) {
			/*
			 * special case: this is a list of nodes, for example an identifier
			 * list, so we don't want to check the list but the last element
			 * added to it
			 */
			final LinkedList nodeList = (LinkedList) elementToCheck;

			if (nodeList.size() > 0) {
				elementToCheck = nodeList.get(nodeList.size() - 1);
			} else {
				// no positions for empty lists...
				return;
			}
		}

		if (!(elementToCheck instanceof PositionedNode)) {
			throw new Error(
					"Unexpected elementToCheck (not instanceof PositionedNode): "
							+ elementToCheck.getClass().getSimpleName() + "/"
							+ elementToCheck);
		}

		if (!this.getMapping().containsKey(elementToCheck) || slurp ) {
			final PositionedNode node = (PositionedNode) elementToCheck;

			// dealing with a one-token element
			if (this.lastPopped == null) {
				this.lastPopped = this.firstPopped;
			}

			final int begin = findBeginPos(this.lastPopped, node);
			int end = findEndPos(this.firstPopped);
			if (end == -1) end = begin;
			final SourcecodeRange range = new SourcecodeRange(begin, end);

			this.getMapping().put(node, range);

			node.setStartPos(createBeginPos(begin));
			node.setEndPos(createEndPos(end));
		}
	}
	
	 
	private int findBeginPos(final ArrayList list,
			PositionedNode n) {
		Object first = list.get(0);
		if (!(first instanceof PositionedNode) && !(first instanceof IToken)) {
			List list2 = (List) first;

			if (list2.size() > 0) {
				first = list2.get(0);
			} else {
				/*
				 * Sometimes (haven't found out why) we get empty list here. In
				 * the only observed cases we were looking for the source range
				 * of the whole parse unit. Then the index is 0.
				 */
				return 0;
			}
		}

		if (first instanceof IToken) {
			return findIndex((IToken) first);
		}

		final PositionedNode node = (PositionedNode) first;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null){
			System.err.println(n.getClass().getSimpleName() + " / " + node.getClass().getSimpleName() + ": " + node);
		}
		return item.getBeginIndex();
	}

	 
	private int findEndPos(final ArrayList list) {
		Object last = list.get(list.size() - 1);
		if (!(last instanceof PositionedNode) && !(last instanceof IToken)) {
			final List list2 = (List) last;
			last = list2.get(list2.size() - 1);
		}

		if (last instanceof IToken) {
			return findIndex((IToken) last);
		}

		final PositionedNode node = (PositionedNode) last;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null)
			return -1;
		return item.getEndIndex();
	}

	private int findIndex(final IToken token) {
		final List<IToken> list = this.lex.getTokenList();

		for (int i = list.size() - 1; i >= 0; i--) {
			if (list.get(i) == token) {
				return i;
			}
		}

		return -1;
	}

	private SourcePosition createBeginPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos());
	}

	private SourcePosition createEndPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos()
				+ token.getText().length());
	}
	    protected void filter() throws ParserException, LexerException, IOException
    {
        // Empty body
    }

    private void push(int numstate, ArrayList listNode, boolean hidden) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!hidden)
        {
            filter();
        }

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
    	ArrayList list = ((State) this.stack.previous()).nodes; 
		if (this.firstPopped == null) {
			this.firstPopped = list;
		} else {
			this.lastPopped = list;
		}
        return list;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

     
    public Start parse() throws ParserException, LexerException, IOException
    {
    	this.getMapping().clear();
    
        push(0, null, true);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list, false);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce ASpec */
		    {
			ArrayList list = new0();
			push(goTo(0), list, false);
		    }
		    break;
                    case 1: /* reduce ACppCommentModule */
		    {
			ArrayList list = new1();
			push(goTo(1), list, false);
		    }
		    break;
                    case 2: /* reduce AAnarresCppCommentModule */
		    {
			ArrayList list = new2();
			push(goTo(1), list, false);
		    }
		    break;
                    case 3: /* reduce AAutypemodule1Module */
		    {
			ArrayList list = new3();
			push(goTo(1), list, false);
		    }
		    break;
                    case 4: /* reduce AAutypemodule2Module */
		    {
			ArrayList list = new4();
			push(goTo(1), list, false);
		    }
		    break;
                    case 5: /* reduce AAmtypemodule1Module */
		    {
			ArrayList list = new5();
			push(goTo(1), list, false);
		    }
		    break;
                    case 6: /* reduce AAmtypemodule2Module */
		    {
			ArrayList list = new6();
			push(goTo(1), list, false);
		    }
		    break;
                    case 7: /* reduce AAvarschansmodule1Module */
		    {
			ArrayList list = new7();
			push(goTo(1), list, false);
		    }
		    break;
                    case 8: /* reduce AAvarschansmodule2Module */
		    {
			ArrayList list = new8();
			push(goTo(1), list, false);
		    }
		    break;
                    case 9: /* reduce AInlineModule */
		    {
			ArrayList list = new9();
			push(goTo(1), list, false);
		    }
		    break;
                    case 10: /* reduce AProctypeModule */
		    {
			ArrayList list = new10();
			push(goTo(1), list, false);
		    }
		    break;
                    case 11: /* reduce AInitModule */
		    {
			ArrayList list = new11();
			push(goTo(1), list, false);
		    }
		    break;
                    case 12: /* reduce ANeverModule */
		    {
			ArrayList list = new12();
			push(goTo(1), list, false);
		    }
		    break;
                    case 13: /* reduce ATraceModule */
		    {
			ArrayList list = new13();
			push(goTo(1), list, false);
		    }
		    break;
                    case 14: /* reduce ALongCppComment */
		    {
			ArrayList list = new14();
			push(goTo(2), list, false);
		    }
		    break;
                    case 15: /* reduce AShortCppComment */
		    {
			ArrayList list = new15();
			push(goTo(2), list, false);
		    }
		    break;
                    case 16: /* reduce AAnarresCppComment */
		    {
			ArrayList list = new16();
			push(goTo(3), list, false);
		    }
		    break;
                    case 17: /* reduce AAinline1Inline */
		    {
			ArrayList list = new17();
			push(goTo(4), list, false);
		    }
		    break;
                    case 18: /* reduce AAinline2Inline */
		    {
			ArrayList list = new18();
			push(goTo(4), list, false);
		    }
		    break;
                    case 19: /* reduce AAproctype1Proctype */
		    {
			ArrayList list = new19();
			push(goTo(5), list, false);
		    }
		    break;
                    case 20: /* reduce AAproctype2Proctype */
		    {
			ArrayList list = new20();
			push(goTo(5), list, false);
		    }
		    break;
                    case 21: /* reduce AAproctype3Proctype */
		    {
			ArrayList list = new21();
			push(goTo(5), list, false);
		    }
		    break;
                    case 22: /* reduce AAproctype4Proctype */
		    {
			ArrayList list = new22();
			push(goTo(5), list, false);
		    }
		    break;
                    case 23: /* reduce AAproctype5Proctype */
		    {
			ArrayList list = new23();
			push(goTo(5), list, false);
		    }
		    break;
                    case 24: /* reduce AAproctype6Proctype */
		    {
			ArrayList list = new24();
			push(goTo(5), list, false);
		    }
		    break;
                    case 25: /* reduce AAproctype7Proctype */
		    {
			ArrayList list = new25();
			push(goTo(5), list, false);
		    }
		    break;
                    case 26: /* reduce AAproctype8Proctype */
		    {
			ArrayList list = new26();
			push(goTo(5), list, false);
		    }
		    break;
                    case 27: /* reduce AAproctype9Proctype */
		    {
			ArrayList list = new27();
			push(goTo(5), list, false);
		    }
		    break;
                    case 28: /* reduce AAproctype10Proctype */
		    {
			ArrayList list = new28();
			push(goTo(5), list, false);
		    }
		    break;
                    case 29: /* reduce AAproctype11Proctype */
		    {
			ArrayList list = new29();
			push(goTo(5), list, false);
		    }
		    break;
                    case 30: /* reduce AAproctype12Proctype */
		    {
			ArrayList list = new30();
			push(goTo(5), list, false);
		    }
		    break;
                    case 31: /* reduce AAproctype13Proctype */
		    {
			ArrayList list = new31();
			push(goTo(5), list, false);
		    }
		    break;
                    case 32: /* reduce AAproctype14Proctype */
		    {
			ArrayList list = new32();
			push(goTo(5), list, false);
		    }
		    break;
                    case 33: /* reduce AAproctype15Proctype */
		    {
			ArrayList list = new33();
			push(goTo(5), list, false);
		    }
		    break;
                    case 34: /* reduce AAproctype16Proctype */
		    {
			ArrayList list = new34();
			push(goTo(5), list, false);
		    }
		    break;
                    case 35: /* reduce AAinit1Init */
		    {
			ArrayList list = new35();
			push(goTo(6), list, false);
		    }
		    break;
                    case 36: /* reduce AAinit2Init */
		    {
			ArrayList list = new36();
			push(goTo(6), list, false);
		    }
		    break;
                    case 37: /* reduce ANever */
		    {
			ArrayList list = new37();
			push(goTo(7), list, false);
		    }
		    break;
                    case 38: /* reduce ATraceTrace */
		    {
			ArrayList list = new38();
			push(goTo(8), list, false);
		    }
		    break;
                    case 39: /* reduce ANotraceTrace */
		    {
			ArrayList list = new39();
			push(goTo(8), list, false);
		    }
		    break;
                    case 40: /* reduce AUtype */
		    {
			ArrayList list = new40();
			push(goTo(9), list, false);
		    }
		    break;
                    case 41: /* reduce AAudecl1Udecl */
		    {
			ArrayList list = new41();
			push(goTo(10), list, false);
		    }
		    break;
                    case 42: /* reduce AAudecl2Udecl */
		    {
			ArrayList list = new42();
			push(goTo(10), list, false);
		    }
		    break;
                    case 43: /* reduce AAmtype1Mtype */
		    {
			ArrayList list = new43();
			push(goTo(11), list, false);
		    }
		    break;
                    case 44: /* reduce AAmtype2Mtype */
		    {
			ArrayList list = new44();
			push(goTo(11), list, false);
		    }
		    break;
                    case 45: /* reduce AOneNameLst */
		    {
			ArrayList list = new45();
			push(goTo(12), list, false);
		    }
		    break;
                    case 46: /* reduce AManyNameLst */
		    {
			ArrayList list = new46();
			push(goTo(12), list, false);
		    }
		    break;
                    case 47: /* reduce AOneDeclLst */
		    {
			ArrayList list = new47();
			push(goTo(13), list, false);
		    }
		    break;
                    case 48: /* reduce AManyDeclLst */
		    {
			ArrayList list = new48();
			push(goTo(13), list, false);
		    }
		    break;
                    case 49: /* reduce AAonedecl1OneDecl */
		    {
			ArrayList list = new49();
			push(goTo(14), list, false);
		    }
		    break;
                    case 50: /* reduce AAonedecl2OneDecl */
		    {
			ArrayList list = new50();
			push(goTo(14), list, false);
		    }
		    break;
                    case 51: /* reduce AOneIvarLst */
		    {
			ArrayList list = new51();
			push(goTo(15), list, false);
		    }
		    break;
                    case 52: /* reduce AManyIvarLst */
		    {
			ArrayList list = new52();
			push(goTo(15), list, false);
		    }
		    break;
                    case 53: /* reduce ABitTypename */
		    {
			ArrayList list = new53();
			push(goTo(16), list, false);
		    }
		    break;
                    case 54: /* reduce ABoolTypename */
		    {
			ArrayList list = new54();
			push(goTo(16), list, false);
		    }
		    break;
                    case 55: /* reduce AByteTypename */
		    {
			ArrayList list = new55();
			push(goTo(16), list, false);
		    }
		    break;
                    case 56: /* reduce APidTypename */
		    {
			ArrayList list = new56();
			push(goTo(16), list, false);
		    }
		    break;
                    case 57: /* reduce AShortTypename */
		    {
			ArrayList list = new57();
			push(goTo(16), list, false);
		    }
		    break;
                    case 58: /* reduce AIntTypename */
		    {
			ArrayList list = new58();
			push(goTo(16), list, false);
		    }
		    break;
                    case 59: /* reduce AMtypeTypename */
		    {
			ArrayList list = new59();
			push(goTo(16), list, false);
		    }
		    break;
                    case 60: /* reduce AChanTypename */
		    {
			ArrayList list = new60();
			push(goTo(16), list, false);
		    }
		    break;
                    case 61: /* reduce AUnameTypename */
		    {
			ArrayList list = new61();
			push(goTo(16), list, false);
		    }
		    break;
                    case 62: /* reduce AUnsignedTypename */
		    {
			ArrayList list = new62();
			push(goTo(16), list, false);
		    }
		    break;
                    case 63: /* reduce AOneTypenamelst */
		    {
			ArrayList list = new63();
			push(goTo(17), list, false);
		    }
		    break;
                    case 64: /* reduce AManyTypenamelst */
		    {
			ArrayList list = new64();
			push(goTo(17), list, false);
		    }
		    break;
                    case 65: /* reduce AOneActive */
		    {
			ArrayList list = new65();
			push(goTo(18), list, false);
		    }
		    break;
                    case 66: /* reduce AManyActive */
		    {
			ArrayList list = new66();
			push(goTo(18), list, false);
		    }
		    break;
                    case 67: /* reduce APriority */
		    {
			ArrayList list = new67();
			push(goTo(19), list, false);
		    }
		    break;
                    case 68: /* reduce AEnabler */
		    {
			ArrayList list = new68();
			push(goTo(20), list, false);
		    }
		    break;
                    case 69: /* reduce AHiddenVisible */
		    {
			ArrayList list = new69();
			push(goTo(21), list, false);
		    }
		    break;
                    case 70: /* reduce AShowVisible */
		    {
			ArrayList list = new70();
			push(goTo(21), list, false);
		    }
		    break;
                    case 71: /* reduce ANullSequence */
		    {
			ArrayList list = new71();
			push(goTo(22), list, false);
		    }
		    break;
                    case 72: /* reduce AOneSequence */
		    {
			ArrayList list = new72();
			push(goTo(22), list, false);
		    }
		    break;
                    case 73: /* reduce AManySequence */
		    {
			ArrayList list = new73();
			push(goTo(22), list, false);
		    }
		    break;
                    case 74: /* reduce AAatomicsequence1Sequence */
		    {
			ArrayList list = new74();
			push(goTo(22), list, false);
		    }
		    break;
                    case 75: /* reduce AAatomicsequence2Sequence */
		    {
			ArrayList list = new75();
			push(goTo(22), list, false);
		    }
		    break;
                    case 76: /* reduce AAdstepsequence1Sequence */
		    {
			ArrayList list = new76();
			push(goTo(22), list, false);
		    }
		    break;
                    case 77: /* reduce AAdstepsequence2Sequence */
		    {
			ArrayList list = new77();
			push(goTo(22), list, false);
		    }
		    break;
                    case 78: /* reduce AAbracessequence1Sequence */
		    {
			ArrayList list = new78();
			push(goTo(22), list, false);
		    }
		    break;
                    case 79: /* reduce AAbracessequence2Sequence */
		    {
			ArrayList list = new79();
			push(goTo(22), list, false);
		    }
		    break;
                    case 80: /* reduce ALabelSequence */
		    {
			ArrayList list = new80();
			push(goTo(22), list, false);
		    }
		    break;
                    case 81: /* reduce AAelsesequence1Sequence */
		    {
			ArrayList list = new81();
			push(goTo(22), list, false);
		    }
		    break;
                    case 82: /* reduce AAelsesequence2Sequence */
		    {
			ArrayList list = new82();
			push(goTo(22), list, false);
		    }
		    break;
                    case 83: /* reduce ADeclarationStep */
		    {
			ArrayList list = new83();
			push(goTo(23), list, false);
		    }
		    break;
                    case 84: /* reduce AStmntStep */
		    {
			ArrayList list = new84();
			push(goTo(23), list, false);
		    }
		    break;
                    case 85: /* reduce AUnlessStep */
		    {
			ArrayList list = new85();
			push(goTo(23), list, false);
		    }
		    break;
                    case 86: /* reduce AExreceiveStep */
		    {
			ArrayList list = new86();
			push(goTo(23), list, false);
		    }
		    break;
                    case 87: /* reduce AExsendStep */
		    {
			ArrayList list = new87();
			push(goTo(23), list, false);
		    }
		    break;
                    case 88: /* reduce AOneVarreflst */
		    {
			ArrayList list = new88();
			push(goTo(24), list, false);
		    }
		    break;
                    case 89: /* reduce AManyVarreflst */
		    {
			ArrayList list = new89();
			push(goTo(24), list, false);
		    }
		    break;
                    case 90: /* reduce AAsingleivar1Ivar */
		    {
			ArrayList list = new90();
			push(goTo(25), list, false);
		    }
		    break;
                    case 91: /* reduce AAsingleivar2Ivar */
		    {
			ArrayList list = new91();
			push(goTo(25), list, false);
		    }
		    break;
                    case 92: /* reduce AAsingleivar3Ivar */
		    {
			ArrayList list = new92();
			push(goTo(25), list, false);
		    }
		    break;
                    case 93: /* reduce AAsingleivar4Ivar */
		    {
			ArrayList list = new93();
			push(goTo(25), list, false);
		    }
		    break;
                    case 94: /* reduce AAarrayivar1Ivar */
		    {
			ArrayList list = new94();
			push(goTo(25), list, false);
		    }
		    break;
                    case 95: /* reduce AAarrayivar2Ivar */
		    {
			ArrayList list = new95();
			push(goTo(25), list, false);
		    }
		    break;
                    case 96: /* reduce AVariableIvarassignment */
		    {
			ArrayList list = new96();
			push(goTo(26), list, false);
		    }
		    break;
                    case 97: /* reduce AChannelIvarassignment */
		    {
			ArrayList list = new97();
			push(goTo(26), list, false);
		    }
		    break;
                    case 98: /* reduce AWidth */
		    {
			ArrayList list = new98();
			push(goTo(27), list, false);
		    }
		    break;
                    case 99: /* reduce AAsinglevarref1Varref */
		    {
			ArrayList list = new99();
			push(goTo(28), list, false);
		    }
		    break;
                    case 100: /* reduce AAsinglevarref2Varref */
		    {
			ArrayList list = new100();
			push(goTo(28), list, false);
		    }
		    break;
                    case 101: /* reduce AArecordvarref1Varref */
		    {
			ArrayList list = new101();
			push(goTo(28), list, false);
		    }
		    break;
                    case 102: /* reduce AArecordvarref2Varref */
		    {
			ArrayList list = new102();
			push(goTo(28), list, false);
		    }
		    break;
                    case 103: /* reduce AAstringvarref1Varref */
		    {
			ArrayList list = new103();
			push(goTo(28), list, false);
		    }
		    break;
                    case 104: /* reduce AAstringvarref2Varref */
		    {
			ArrayList list = new104();
			push(goTo(28), list, false);
		    }
		    break;
                    case 105: /* reduce AArrayref */
		    {
			ArrayList list = new105();
			push(goTo(29), list, false);
		    }
		    break;
                    case 106: /* reduce ARecordref */
		    {
			ArrayList list = new106();
			push(goTo(30), list, false);
		    }
		    break;
                    case 107: /* reduce AFifoSend */
		    {
			ArrayList list = new107();
			push(goTo(31), list, false);
		    }
		    break;
                    case 108: /* reduce ASortedSend */
		    {
			ArrayList list = new108();
			push(goTo(31), list, false);
		    }
		    break;
                    case 109: /* reduce AFifoReceive */
		    {
			ArrayList list = new109();
			push(goTo(32), list, false);
		    }
		    break;
                    case 110: /* reduce ARandomReceive */
		    {
			ArrayList list = new110();
			push(goTo(32), list, false);
		    }
		    break;
                    case 111: /* reduce AFifopollReceive */
		    {
			ArrayList list = new111();
			push(goTo(32), list, false);
		    }
		    break;
                    case 112: /* reduce ARandompollReceive */
		    {
			ArrayList list = new112();
			push(goTo(32), list, false);
		    }
		    break;
                    case 113: /* reduce AFifoRecvPoll */
		    {
			ArrayList list = new113();
			push(goTo(33), list, false);
		    }
		    break;
                    case 114: /* reduce ARandomRecvPoll */
		    {
			ArrayList list = new114();
			push(goTo(33), list, false);
		    }
		    break;
                    case 115: /* reduce AListSendArgs */
		    {
			ArrayList list = new115();
			push(goTo(34), list, false);
		    }
		    break;
                    case 116: /* reduce AHeadedlistSendArgs */
		    {
			ArrayList list = new116();
			push(goTo(34), list, false);
		    }
		    break;
                    case 117: /* reduce AOneArgLst */
		    {
			ArrayList list = new117();
			push(goTo(35), list, false);
		    }
		    break;
                    case 118: /* reduce AManyArgLst */
		    {
			ArrayList list = new118();
			push(goTo(35), list, false);
		    }
		    break;
                    case 119: /* reduce AOneRecvArgs */
		    {
			ArrayList list = new119();
			push(goTo(36), list, false);
		    }
		    break;
                    case 120: /* reduce AManyRecvArgs */
		    {
			ArrayList list = new120();
			push(goTo(36), list, false);
		    }
		    break;
                    case 121: /* reduce AManyheaded1RecvArgs */
		    {
			ArrayList list = new121();
			push(goTo(36), list, false);
		    }
		    break;
                    case 122: /* reduce AManyheaded2RecvArgs */
		    {
			ArrayList list = new122();
			push(goTo(36), list, false);
		    }
		    break;
                    case 123: /* reduce AVarRecvArg */
		    {
			ArrayList list = new123();
			push(goTo(37), list, false);
		    }
		    break;
                    case 124: /* reduce AEvalRecvArg */
		    {
			ArrayList list = new124();
			push(goTo(37), list, false);
		    }
		    break;
                    case 125: /* reduce AConstRecvArg */
		    {
			ArrayList list = new125();
			push(goTo(37), list, false);
		    }
		    break;
                    case 126: /* reduce AUnderscoreRecvArg */
		    {
			ArrayList list = new126();
			push(goTo(37), list, false);
		    }
		    break;
                    case 127: /* reduce AAssignmentAssignment */
		    {
			ArrayList list = new127();
			push(goTo(38), list, false);
		    }
		    break;
                    case 128: /* reduce AIncrementAssignment */
		    {
			ArrayList list = new128();
			push(goTo(38), list, false);
		    }
		    break;
                    case 129: /* reduce ADecrementAssignment */
		    {
			ArrayList list = new129();
			push(goTo(38), list, false);
		    }
		    break;
                    case 130: /* reduce AAruninlinestmnt1Stmnt */
		    {
			ArrayList list = new130();
			push(goTo(39), list, false);
		    }
		    break;
                    case 131: /* reduce AAruninlinestmnt2Stmnt */
		    {
			ArrayList list = new131();
			push(goTo(39), list, false);
		    }
		    break;
                    case 132: /* reduce AIfStmnt */
		    {
			ArrayList list = new132();
			push(goTo(39), list, false);
		    }
		    break;
                    case 133: /* reduce ADoStmnt */
		    {
			ArrayList list = new133();
			push(goTo(39), list, false);
		    }
		    break;
                    case 134: /* reduce ASendStmnt */
		    {
			ArrayList list = new134();
			push(goTo(39), list, false);
		    }
		    break;
                    case 135: /* reduce AReceiveStmnt */
		    {
			ArrayList list = new135();
			push(goTo(39), list, false);
		    }
		    break;
                    case 136: /* reduce AAssignStmnt */
		    {
			ArrayList list = new136();
			push(goTo(39), list, false);
		    }
		    break;
                    case 137: /* reduce ABreakStmnt */
		    {
			ArrayList list = new137();
			push(goTo(39), list, false);
		    }
		    break;
                    case 138: /* reduce AGotoStmnt */
		    {
			ArrayList list = new138();
			push(goTo(39), list, false);
		    }
		    break;
                    case 139: /* reduce APrintmStmnt */
		    {
			ArrayList list = new139();
			push(goTo(39), list, false);
		    }
		    break;
                    case 140: /* reduce APrintfStmnt */
		    {
			ArrayList list = new140();
			push(goTo(39), list, false);
		    }
		    break;
                    case 141: /* reduce APrintwithargsStmnt */
		    {
			ArrayList list = new141();
			push(goTo(39), list, false);
		    }
		    break;
                    case 142: /* reduce AAssertStmnt */
		    {
			ArrayList list = new142();
			push(goTo(39), list, false);
		    }
		    break;
                    case 143: /* reduce AExpressionStmnt */
		    {
			ArrayList list = new143();
			push(goTo(39), list, false);
		    }
		    break;
                    case 144: /* reduce AAoptions1Options */
		    {
			ArrayList list = new144();
			push(goTo(40), list, false);
		    }
		    break;
                    case 145: /* reduce AAoptions2Options */
		    {
			ArrayList list = new145();
			push(goTo(40), list, false);
		    }
		    break;
                    case 146: /* reduce AParentheseFactor */
		    {
			ArrayList list = new146();
			push(goTo(41), list, false);
		    }
		    break;
                    case 147: /* reduce ALengthFactor */
		    {
			ArrayList list = new147();
			push(goTo(41), list, false);
		    }
		    break;
                    case 148: /* reduce ARecvPollFactor */
		    {
			ArrayList list = new148();
			push(goTo(41), list, false);
		    }
		    break;
                    case 149: /* reduce AVarrefFactor */
		    {
			ArrayList list = new149();
			push(goTo(41), list, false);
		    }
		    break;
                    case 150: /* reduce AConstFactor */
		    {
			ArrayList list = new150();
			push(goTo(41), list, false);
		    }
		    break;
                    case 151: /* reduce ATimeoutFactor */
		    {
			ArrayList list = new151();
			push(goTo(41), list, false);
		    }
		    break;
                    case 152: /* reduce ANonprogressFactor */
		    {
			ArrayList list = new152();
			push(goTo(41), list, false);
		    }
		    break;
                    case 153: /* reduce AEnabledFactor */
		    {
			ArrayList list = new153();
			push(goTo(41), list, false);
		    }
		    break;
                    case 154: /* reduce APcValueFactor */
		    {
			ArrayList list = new154();
			push(goTo(41), list, false);
		    }
		    break;
                    case 155: /* reduce ARemoterefFactor */
		    {
			ArrayList list = new155();
			push(goTo(41), list, false);
		    }
		    break;
                    case 156: /* reduce AArunfactor1Factor */
		    {
			ArrayList list = new156();
			push(goTo(41), list, false);
		    }
		    break;
                    case 157: /* reduce AArunfactor2Factor */
		    {
			ArrayList list = new157();
			push(goTo(41), list, false);
		    }
		    break;
                    case 158: /* reduce AArunfactor3Factor */
		    {
			ArrayList list = new158();
			push(goTo(41), list, false);
		    }
		    break;
                    case 159: /* reduce AArunfactor4Factor */
		    {
			ArrayList list = new159();
			push(goTo(41), list, false);
		    }
		    break;
                    case 160: /* reduce AChanopFactor */
		    {
			ArrayList list = new160();
			push(goTo(41), list, false);
		    }
		    break;
                    case 161: /* reduce AConditionalFactor */
		    {
			ArrayList list = new161();
			push(goTo(41), list, false);
		    }
		    break;
                    case 162: /* reduce ASimpleUnExpr */
		    {
			ArrayList list = new162();
			push(goTo(42), list, false);
		    }
		    break;
                    case 163: /* reduce ANotUnExpr */
		    {
			ArrayList list = new163();
			push(goTo(42), list, false);
		    }
		    break;
                    case 164: /* reduce AComplementUnExpr */
		    {
			ArrayList list = new164();
			push(goTo(42), list, false);
		    }
		    break;
                    case 165: /* reduce ASimpleMultExpr */
		    {
			ArrayList list = new165();
			push(goTo(43), list, false);
		    }
		    break;
                    case 166: /* reduce ACompoundMultExpr */
		    {
			ArrayList list = new166();
			push(goTo(43), list, false);
		    }
		    break;
                    case 167: /* reduce ASimpleAddExpr */
		    {
			ArrayList list = new167();
			push(goTo(44), list, false);
		    }
		    break;
                    case 168: /* reduce ACompoundplusAddExpr */
		    {
			ArrayList list = new168();
			push(goTo(44), list, false);
		    }
		    break;
                    case 169: /* reduce ACompoundminusAddExpr */
		    {
			ArrayList list = new169();
			push(goTo(44), list, false);
		    }
		    break;
                    case 170: /* reduce ASimpleShiftExpr */
		    {
			ArrayList list = new170();
			push(goTo(45), list, false);
		    }
		    break;
                    case 171: /* reduce ACompoundShiftExpr */
		    {
			ArrayList list = new171();
			push(goTo(45), list, false);
		    }
		    break;
                    case 172: /* reduce ASimpleRelExpr */
		    {
			ArrayList list = new172();
			push(goTo(46), list, false);
		    }
		    break;
                    case 173: /* reduce ACompoundrelopRelExpr */
		    {
			ArrayList list = new173();
			push(goTo(46), list, false);
		    }
		    break;
                    case 174: /* reduce ACompoundgtRelExpr */
		    {
			ArrayList list = new174();
			push(goTo(46), list, false);
		    }
		    break;
                    case 175: /* reduce ACompoundltRelExpr */
		    {
			ArrayList list = new175();
			push(goTo(46), list, false);
		    }
		    break;
                    case 176: /* reduce ASimpleEqExpr */
		    {
			ArrayList list = new176();
			push(goTo(47), list, false);
		    }
		    break;
                    case 177: /* reduce ACompoundEqExpr */
		    {
			ArrayList list = new177();
			push(goTo(47), list, false);
		    }
		    break;
                    case 178: /* reduce ASimpleBitandExpr */
		    {
			ArrayList list = new178();
			push(goTo(48), list, false);
		    }
		    break;
                    case 179: /* reduce ACompoundBitandExpr */
		    {
			ArrayList list = new179();
			push(goTo(48), list, false);
		    }
		    break;
                    case 180: /* reduce ASimpleBitxorExpr */
		    {
			ArrayList list = new180();
			push(goTo(49), list, false);
		    }
		    break;
                    case 181: /* reduce ACompoundBitxorExpr */
		    {
			ArrayList list = new181();
			push(goTo(49), list, false);
		    }
		    break;
                    case 182: /* reduce ASimpleBitorExpr */
		    {
			ArrayList list = new182();
			push(goTo(50), list, false);
		    }
		    break;
                    case 183: /* reduce ACompoundBitorExpr */
		    {
			ArrayList list = new183();
			push(goTo(50), list, false);
		    }
		    break;
                    case 184: /* reduce ASimpleAndExpr */
		    {
			ArrayList list = new184();
			push(goTo(51), list, false);
		    }
		    break;
                    case 185: /* reduce ACompoundAndExpr */
		    {
			ArrayList list = new185();
			push(goTo(51), list, false);
		    }
		    break;
                    case 186: /* reduce ASimpleOrExpr */
		    {
			ArrayList list = new186();
			push(goTo(52), list, false);
		    }
		    break;
                    case 187: /* reduce ACompoundOrExpr */
		    {
			ArrayList list = new187();
			push(goTo(52), list, false);
		    }
		    break;
                    case 188: /* reduce ASimpleExpr */
		    {
			ArrayList list = new188();
			push(goTo(53), list, false);
		    }
		    break;
                    case 189: /* reduce ATrueConst */
		    {
			ArrayList list = new189();
			push(goTo(54), list, false);
		    }
		    break;
                    case 190: /* reduce AFalseConst */
		    {
			ArrayList list = new190();
			push(goTo(54), list, false);
		    }
		    break;
                    case 191: /* reduce ASkipConst */
		    {
			ArrayList list = new191();
			push(goTo(54), list, false);
		    }
		    break;
                    case 192: /* reduce AAnumberconst1Const */
		    {
			ArrayList list = new192();
			push(goTo(54), list, false);
		    }
		    break;
                    case 193: /* reduce AAnumberconst2Const */
		    {
			ArrayList list = new193();
			push(goTo(54), list, false);
		    }
		    break;
                    case 194: /* reduce APidConst */
		    {
			ArrayList list = new194();
			push(goTo(54), list, false);
		    }
		    break;
                    case 195: /* reduce ANrPrConst */
		    {
			ArrayList list = new195();
			push(goTo(54), list, false);
		    }
		    break;
                    case 196: /* reduce ASemicolonSeparator */
		    {
			ArrayList list = new196();
			push(goTo(55), list, false);
		    }
		    break;
                    case 197: /* reduce ARightarrowSeparator */
		    {
			ArrayList list = new197();
			push(goTo(55), list, false);
		    }
		    break;
                    case 198: /* reduce ATerminal$Module */
		    {
			ArrayList list = new198();
			push(goTo(56), list, true);
		    }
		    break;
                    case 199: /* reduce ANonTerminal$Module */
		    {
			ArrayList list = new199();
			push(goTo(56), list, true);
		    }
		    break;
                    case 200: /* reduce ATerminal$Udecl */
		    {
			ArrayList list = new200();
			push(goTo(57), list, true);
		    }
		    break;
                    case 201: /* reduce ANonTerminal$Udecl */
		    {
			ArrayList list = new201();
			push(goTo(57), list, true);
		    }
		    break;
                    case 202: /* reduce ATerminal$Semicolon */
		    {
			ArrayList list = new202();
			push(goTo(58), list, true);
		    }
		    break;
                    case 203: /* reduce ANonTerminal$Semicolon */
		    {
			ArrayList list = new203();
			push(goTo(58), list, true);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PSpec node1 = (PSpec) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " ,
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



     
    ArrayList new0() /* reduce ASpec */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PSpec pspecNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList1.get(0);
	if(listNode2 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode2);
  	  //listNode3 = listNode2;
	}
        }

        pspecNode1 = new ASpec(listNode3);
        }
	nodeList.add(pspecNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new1() /* reduce ACppCommentModule */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PCppComment pcppcommentNode2;
        pcppcommentNode2 = (PCppComment)nodeArrayList1.get(0);

        pmoduleNode1 = new ACppCommentModule(pcppcommentNode2);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new2() /* reduce AAnarresCppCommentModule */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PAnarresCppComment panarrescppcommentNode2;
        panarrescppcommentNode2 = (PAnarresCppComment)nodeArrayList1.get(0);

        pmoduleNode1 = new AAnarresCppCommentModule(panarrescppcommentNode2);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new3() /* reduce AAutypemodule1Module */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PUtype putypeNode2;
          Object nullNode3 = null;
        putypeNode2 = (PUtype)nodeArrayList1.get(0);

        pmoduleNode1 = new AUtypeModule(putypeNode2, null);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new4() /* reduce AAutypemodule2Module */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PUtype putypeNode2;
        PSeparator pseparatorNode3;
        putypeNode2 = (PUtype)nodeArrayList1.get(0);
        pseparatorNode3 = (PSeparator)nodeArrayList2.get(0);

        pmoduleNode1 = new AUtypeModule(putypeNode2, pseparatorNode3);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new5() /* reduce AAmtypemodule1Module */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PMtype pmtypeNode2;
          Object nullNode3 = null;
        pmtypeNode2 = (PMtype)nodeArrayList1.get(0);

        pmoduleNode1 = new AMtypeModule(pmtypeNode2, null);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new6() /* reduce AAmtypemodule2Module */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PMtype pmtypeNode2;
        PSeparator pseparatorNode3;
        pmtypeNode2 = (PMtype)nodeArrayList1.get(0);
        pseparatorNode3 = (PSeparator)nodeArrayList2.get(0);

        pmoduleNode1 = new AMtypeModule(pmtypeNode2, pseparatorNode3);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new7() /* reduce AAvarschansmodule1Module */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        POneDecl ponedeclNode2;
          Object nullNode3 = null;
        ponedeclNode2 = (POneDecl)nodeArrayList1.get(0);

        pmoduleNode1 = new AVarschansModule(ponedeclNode2, null);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new8() /* reduce AAvarschansmodule2Module */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        POneDecl ponedeclNode2;
        PSeparator pseparatorNode3;
        ponedeclNode2 = (POneDecl)nodeArrayList1.get(0);
        pseparatorNode3 = (PSeparator)nodeArrayList2.get(0);

        pmoduleNode1 = new AVarschansModule(ponedeclNode2, pseparatorNode3);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new9() /* reduce AInlineModule */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PInline pinlineNode2;
        pinlineNode2 = (PInline)nodeArrayList1.get(0);

        pmoduleNode1 = new AInlineModule(pinlineNode2);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new10() /* reduce AProctypeModule */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PProctype pproctypeNode2;
        pproctypeNode2 = (PProctype)nodeArrayList1.get(0);

        pmoduleNode1 = new AProctypeModule(pproctypeNode2);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new11() /* reduce AInitModule */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PInit pinitNode2;
        pinitNode2 = (PInit)nodeArrayList1.get(0);

        pmoduleNode1 = new AInitModule(pinitNode2);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new12() /* reduce ANeverModule */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PNever pneverNode2;
        pneverNode2 = (PNever)nodeArrayList1.get(0);

        pmoduleNode1 = new ANeverModule(pneverNode2);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new13() /* reduce ATraceModule */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PModule pmoduleNode1;
        {
            // Block
        PTrace ptraceNode2;
        ptraceNode2 = (PTrace)nodeArrayList1.get(0);

        pmoduleNode1 = new ATraceModule(ptraceNode2);
        }
	nodeList.add(pmoduleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new14() /* reduce ALongCppComment */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCppComment pcppcommentNode1;
        {
            // Block
        TNumberSign tnumbersignNode2;
        TNumber tnumberNode3;
        TString tstringNode4;
        TNumber tnumberNode5;
        tnumbersignNode2 = (TNumberSign)nodeArrayList1.get(0);
        tnumberNode3 = (TNumber)nodeArrayList2.get(0);
        tstringNode4 = (TString)nodeArrayList3.get(0);
        tnumberNode5 = (TNumber)nodeArrayList4.get(0);

        pcppcommentNode1 = new ALongCppComment(tnumbersignNode2, tnumberNode3, tstringNode4, tnumberNode5);
        }
	nodeList.add(pcppcommentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new15() /* reduce AShortCppComment */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCppComment pcppcommentNode1;
        {
            // Block
        TNumberSign tnumbersignNode2;
        TNumber tnumberNode3;
        TString tstringNode4;
        tnumbersignNode2 = (TNumberSign)nodeArrayList1.get(0);
        tnumberNode3 = (TNumber)nodeArrayList2.get(0);
        tstringNode4 = (TString)nodeArrayList3.get(0);

        pcppcommentNode1 = new AShortCppComment(tnumbersignNode2, tnumberNode3, tstringNode4);
        }
	nodeList.add(pcppcommentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new16() /* reduce AAnarresCppComment */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PAnarresCppComment panarrescppcommentNode1;
        {
            // Block
        TNumberSign tnumbersignNode2;
        TLine tlineNode3;
        TNumber tnumberNode4;
        TString tstringNode5;
        TNumber tnumberNode6;
        tnumbersignNode2 = (TNumberSign)nodeArrayList1.get(0);
        tlineNode3 = (TLine)nodeArrayList2.get(0);
        tnumberNode4 = (TNumber)nodeArrayList3.get(0);
        tstringNode5 = (TString)nodeArrayList4.get(0);
        tnumberNode6 = (TNumber)nodeArrayList5.get(0);

        panarrescppcommentNode1 = new AAnarresCppComment(tnumbersignNode2, tlineNode3, tnumberNode4, tstringNode5, tnumberNode6);
        }
	nodeList.add(panarrescppcommentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new17() /* reduce AAinline1Inline */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInline pinlineNode1;
        {
            // Block
        TInlinetok tinlinetokNode2;
        TName tnameNode3;
        TLParenthese tlparentheseNode4;
          Object nullNode5 = null;
        TRParenthese trparentheseNode6;
        TLBrace tlbraceNode7;
        PSequence psequenceNode8;
        TRBrace trbraceNode9;
        tinlinetokNode2 = (TInlinetok)nodeArrayList1.get(0);
        tnameNode3 = (TName)nodeArrayList2.get(0);
        tlparentheseNode4 = (TLParenthese)nodeArrayList3.get(0);
        trparentheseNode6 = (TRParenthese)nodeArrayList4.get(0);
        tlbraceNode7 = (TLBrace)nodeArrayList5.get(0);
        psequenceNode8 = (PSequence)nodeArrayList6.get(0);
        trbraceNode9 = (TRBrace)nodeArrayList7.get(0);

        pinlineNode1 = new AInline(tinlinetokNode2, tnameNode3, tlparentheseNode4, null, trparentheseNode6, tlbraceNode7, psequenceNode8, trbraceNode9);
        }
	nodeList.add(pinlineNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new18() /* reduce AAinline2Inline */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInline pinlineNode1;
        {
            // Block
        TInlinetok tinlinetokNode2;
        TName tnameNode3;
        TLParenthese tlparentheseNode4;
        PArgLst parglstNode5;
        TRParenthese trparentheseNode6;
        TLBrace tlbraceNode7;
        PSequence psequenceNode8;
        TRBrace trbraceNode9;
        tinlinetokNode2 = (TInlinetok)nodeArrayList1.get(0);
        tnameNode3 = (TName)nodeArrayList2.get(0);
        tlparentheseNode4 = (TLParenthese)nodeArrayList3.get(0);
        parglstNode5 = (PArgLst)nodeArrayList4.get(0);
        trparentheseNode6 = (TRParenthese)nodeArrayList5.get(0);
        tlbraceNode7 = (TLBrace)nodeArrayList6.get(0);
        psequenceNode8 = (PSequence)nodeArrayList7.get(0);
        trbraceNode9 = (TRBrace)nodeArrayList8.get(0);

        pinlineNode1 = new AInline(tinlinetokNode2, tnameNode3, tlparentheseNode4, parglstNode5, trparentheseNode6, tlbraceNode7, psequenceNode8, trbraceNode9);
        }
	nodeList.add(pinlineNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new19() /* reduce AAproctype1Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
          Object nullNode2 = null;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
          Object nullNode6 = null;
        TRParenthese trparentheseNode7;
          Object nullNode8 = null;
          Object nullNode9 = null;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        tproctypetokNode3 = (TProctypetok)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList3.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList4.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList5.get(0);
        psequenceNode11 = (PSequence)nodeArrayList6.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList7.get(0);

        pproctypeNode1 = new AProctype(null, tproctypetokNode3, tnameNode4, tlparentheseNode5, null, trparentheseNode7, null, null, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new20() /* reduce AAproctype2Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
        PActive pactiveNode2;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
          Object nullNode6 = null;
        TRParenthese trparentheseNode7;
          Object nullNode8 = null;
          Object nullNode9 = null;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        pactiveNode2 = (PActive)nodeArrayList1.get(0);
        tproctypetokNode3 = (TProctypetok)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList4.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList5.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList6.get(0);
        psequenceNode11 = (PSequence)nodeArrayList7.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList8.get(0);

        pproctypeNode1 = new AProctype(pactiveNode2, tproctypetokNode3, tnameNode4, tlparentheseNode5, null, trparentheseNode7, null, null, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new21() /* reduce AAproctype3Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
          Object nullNode2 = null;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
        PDeclLst pdecllstNode6;
        TRParenthese trparentheseNode7;
          Object nullNode8 = null;
          Object nullNode9 = null;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        tproctypetokNode3 = (TProctypetok)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList3.get(0);
        pdecllstNode6 = (PDeclLst)nodeArrayList4.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList5.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList6.get(0);
        psequenceNode11 = (PSequence)nodeArrayList7.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList8.get(0);

        pproctypeNode1 = new AProctype(null, tproctypetokNode3, tnameNode4, tlparentheseNode5, pdecllstNode6, trparentheseNode7, null, null, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new22() /* reduce AAproctype4Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
        PActive pactiveNode2;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
        PDeclLst pdecllstNode6;
        TRParenthese trparentheseNode7;
          Object nullNode8 = null;
          Object nullNode9 = null;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        pactiveNode2 = (PActive)nodeArrayList1.get(0);
        tproctypetokNode3 = (TProctypetok)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList4.get(0);
        pdecllstNode6 = (PDeclLst)nodeArrayList5.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList6.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList7.get(0);
        psequenceNode11 = (PSequence)nodeArrayList8.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList9.get(0);

        pproctypeNode1 = new AProctype(pactiveNode2, tproctypetokNode3, tnameNode4, tlparentheseNode5, pdecllstNode6, trparentheseNode7, null, null, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new23() /* reduce AAproctype5Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
          Object nullNode2 = null;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
          Object nullNode6 = null;
        TRParenthese trparentheseNode7;
        PPriority ppriorityNode8;
          Object nullNode9 = null;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        tproctypetokNode3 = (TProctypetok)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList3.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList4.get(0);
        ppriorityNode8 = (PPriority)nodeArrayList5.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList6.get(0);
        psequenceNode11 = (PSequence)nodeArrayList7.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList8.get(0);

        pproctypeNode1 = new AProctype(null, tproctypetokNode3, tnameNode4, tlparentheseNode5, null, trparentheseNode7, ppriorityNode8, null, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new24() /* reduce AAproctype6Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
        PActive pactiveNode2;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
          Object nullNode6 = null;
        TRParenthese trparentheseNode7;
        PPriority ppriorityNode8;
          Object nullNode9 = null;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        pactiveNode2 = (PActive)nodeArrayList1.get(0);
        tproctypetokNode3 = (TProctypetok)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList4.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList5.get(0);
        ppriorityNode8 = (PPriority)nodeArrayList6.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList7.get(0);
        psequenceNode11 = (PSequence)nodeArrayList8.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList9.get(0);

        pproctypeNode1 = new AProctype(pactiveNode2, tproctypetokNode3, tnameNode4, tlparentheseNode5, null, trparentheseNode7, ppriorityNode8, null, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new25() /* reduce AAproctype7Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
          Object nullNode2 = null;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
        PDeclLst pdecllstNode6;
        TRParenthese trparentheseNode7;
        PPriority ppriorityNode8;
          Object nullNode9 = null;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        tproctypetokNode3 = (TProctypetok)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList3.get(0);
        pdecllstNode6 = (PDeclLst)nodeArrayList4.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList5.get(0);
        ppriorityNode8 = (PPriority)nodeArrayList6.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList7.get(0);
        psequenceNode11 = (PSequence)nodeArrayList8.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList9.get(0);

        pproctypeNode1 = new AProctype(null, tproctypetokNode3, tnameNode4, tlparentheseNode5, pdecllstNode6, trparentheseNode7, ppriorityNode8, null, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new26() /* reduce AAproctype8Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList10 = pop();
          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
        PActive pactiveNode2;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
        PDeclLst pdecllstNode6;
        TRParenthese trparentheseNode7;
        PPriority ppriorityNode8;
          Object nullNode9 = null;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        pactiveNode2 = (PActive)nodeArrayList1.get(0);
        tproctypetokNode3 = (TProctypetok)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList4.get(0);
        pdecllstNode6 = (PDeclLst)nodeArrayList5.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList6.get(0);
        ppriorityNode8 = (PPriority)nodeArrayList7.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList8.get(0);
        psequenceNode11 = (PSequence)nodeArrayList9.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList10.get(0);

        pproctypeNode1 = new AProctype(pactiveNode2, tproctypetokNode3, tnameNode4, tlparentheseNode5, pdecllstNode6, trparentheseNode7, ppriorityNode8, null, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new27() /* reduce AAproctype9Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
          Object nullNode2 = null;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
          Object nullNode6 = null;
        TRParenthese trparentheseNode7;
          Object nullNode8 = null;
        PEnabler penablerNode9;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        tproctypetokNode3 = (TProctypetok)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList3.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList4.get(0);
        penablerNode9 = (PEnabler)nodeArrayList5.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList6.get(0);
        psequenceNode11 = (PSequence)nodeArrayList7.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList8.get(0);

        pproctypeNode1 = new AProctype(null, tproctypetokNode3, tnameNode4, tlparentheseNode5, null, trparentheseNode7, null, penablerNode9, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new28() /* reduce AAproctype10Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
        PActive pactiveNode2;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
          Object nullNode6 = null;
        TRParenthese trparentheseNode7;
          Object nullNode8 = null;
        PEnabler penablerNode9;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        pactiveNode2 = (PActive)nodeArrayList1.get(0);
        tproctypetokNode3 = (TProctypetok)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList4.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList5.get(0);
        penablerNode9 = (PEnabler)nodeArrayList6.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList7.get(0);
        psequenceNode11 = (PSequence)nodeArrayList8.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList9.get(0);

        pproctypeNode1 = new AProctype(pactiveNode2, tproctypetokNode3, tnameNode4, tlparentheseNode5, null, trparentheseNode7, null, penablerNode9, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new29() /* reduce AAproctype11Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
          Object nullNode2 = null;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
        PDeclLst pdecllstNode6;
        TRParenthese trparentheseNode7;
          Object nullNode8 = null;
        PEnabler penablerNode9;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        tproctypetokNode3 = (TProctypetok)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList3.get(0);
        pdecllstNode6 = (PDeclLst)nodeArrayList4.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList5.get(0);
        penablerNode9 = (PEnabler)nodeArrayList6.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList7.get(0);
        psequenceNode11 = (PSequence)nodeArrayList8.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList9.get(0);

        pproctypeNode1 = new AProctype(null, tproctypetokNode3, tnameNode4, tlparentheseNode5, pdecllstNode6, trparentheseNode7, null, penablerNode9, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new30() /* reduce AAproctype12Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList10 = pop();
          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
        PActive pactiveNode2;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
        PDeclLst pdecllstNode6;
        TRParenthese trparentheseNode7;
          Object nullNode8 = null;
        PEnabler penablerNode9;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        pactiveNode2 = (PActive)nodeArrayList1.get(0);
        tproctypetokNode3 = (TProctypetok)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList4.get(0);
        pdecllstNode6 = (PDeclLst)nodeArrayList5.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList6.get(0);
        penablerNode9 = (PEnabler)nodeArrayList7.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList8.get(0);
        psequenceNode11 = (PSequence)nodeArrayList9.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList10.get(0);

        pproctypeNode1 = new AProctype(pactiveNode2, tproctypetokNode3, tnameNode4, tlparentheseNode5, pdecllstNode6, trparentheseNode7, null, penablerNode9, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new31() /* reduce AAproctype13Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
          Object nullNode2 = null;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
          Object nullNode6 = null;
        TRParenthese trparentheseNode7;
        PPriority ppriorityNode8;
        PEnabler penablerNode9;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        tproctypetokNode3 = (TProctypetok)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList3.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList4.get(0);
        ppriorityNode8 = (PPriority)nodeArrayList5.get(0);
        penablerNode9 = (PEnabler)nodeArrayList6.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList7.get(0);
        psequenceNode11 = (PSequence)nodeArrayList8.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList9.get(0);

        pproctypeNode1 = new AProctype(null, tproctypetokNode3, tnameNode4, tlparentheseNode5, null, trparentheseNode7, ppriorityNode8, penablerNode9, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new32() /* reduce AAproctype14Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList10 = pop();
          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
        PActive pactiveNode2;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
          Object nullNode6 = null;
        TRParenthese trparentheseNode7;
        PPriority ppriorityNode8;
        PEnabler penablerNode9;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        pactiveNode2 = (PActive)nodeArrayList1.get(0);
        tproctypetokNode3 = (TProctypetok)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList4.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList5.get(0);
        ppriorityNode8 = (PPriority)nodeArrayList6.get(0);
        penablerNode9 = (PEnabler)nodeArrayList7.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList8.get(0);
        psequenceNode11 = (PSequence)nodeArrayList9.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList10.get(0);

        pproctypeNode1 = new AProctype(pactiveNode2, tproctypetokNode3, tnameNode4, tlparentheseNode5, null, trparentheseNode7, ppriorityNode8, penablerNode9, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new33() /* reduce AAproctype15Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList10 = pop();
          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
          Object nullNode2 = null;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
        PDeclLst pdecllstNode6;
        TRParenthese trparentheseNode7;
        PPriority ppriorityNode8;
        PEnabler penablerNode9;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        tproctypetokNode3 = (TProctypetok)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList3.get(0);
        pdecllstNode6 = (PDeclLst)nodeArrayList4.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList5.get(0);
        ppriorityNode8 = (PPriority)nodeArrayList6.get(0);
        penablerNode9 = (PEnabler)nodeArrayList7.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList8.get(0);
        psequenceNode11 = (PSequence)nodeArrayList9.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList10.get(0);

        pproctypeNode1 = new AProctype(null, tproctypetokNode3, tnameNode4, tlparentheseNode5, pdecllstNode6, trparentheseNode7, ppriorityNode8, penablerNode9, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new34() /* reduce AAproctype16Proctype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList11 = pop();
          ArrayList nodeArrayList10 = pop();
          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProctype pproctypeNode1;
        {
            // Block
        PActive pactiveNode2;
        TProctypetok tproctypetokNode3;
        TName tnameNode4;
        TLParenthese tlparentheseNode5;
        PDeclLst pdecllstNode6;
        TRParenthese trparentheseNode7;
        PPriority ppriorityNode8;
        PEnabler penablerNode9;
        TLBrace tlbraceNode10;
        PSequence psequenceNode11;
        TRBrace trbraceNode12;
        pactiveNode2 = (PActive)nodeArrayList1.get(0);
        tproctypetokNode3 = (TProctypetok)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tlparentheseNode5 = (TLParenthese)nodeArrayList4.get(0);
        pdecllstNode6 = (PDeclLst)nodeArrayList5.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList6.get(0);
        ppriorityNode8 = (PPriority)nodeArrayList7.get(0);
        penablerNode9 = (PEnabler)nodeArrayList8.get(0);
        tlbraceNode10 = (TLBrace)nodeArrayList9.get(0);
        psequenceNode11 = (PSequence)nodeArrayList10.get(0);
        trbraceNode12 = (TRBrace)nodeArrayList11.get(0);

        pproctypeNode1 = new AProctype(pactiveNode2, tproctypetokNode3, tnameNode4, tlparentheseNode5, pdecllstNode6, trparentheseNode7, ppriorityNode8, penablerNode9, tlbraceNode10, psequenceNode11, trbraceNode12);
        }
	nodeList.add(pproctypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new35() /* reduce AAinit1Init */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInit pinitNode1;
        {
            // Block
        TInittok tinittokNode2;
          Object nullNode3 = null;
        TLBrace tlbraceNode4;
        PSequence psequenceNode5;
        TRBrace trbraceNode6;
        tinittokNode2 = (TInittok)nodeArrayList1.get(0);
        tlbraceNode4 = (TLBrace)nodeArrayList2.get(0);
        psequenceNode5 = (PSequence)nodeArrayList3.get(0);
        trbraceNode6 = (TRBrace)nodeArrayList4.get(0);

        pinitNode1 = new AInit(tinittokNode2, null, tlbraceNode4, psequenceNode5, trbraceNode6);
        }
	nodeList.add(pinitNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new36() /* reduce AAinit2Init */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInit pinitNode1;
        {
            // Block
        TInittok tinittokNode2;
        PPriority ppriorityNode3;
        TLBrace tlbraceNode4;
        PSequence psequenceNode5;
        TRBrace trbraceNode6;
        tinittokNode2 = (TInittok)nodeArrayList1.get(0);
        ppriorityNode3 = (PPriority)nodeArrayList2.get(0);
        tlbraceNode4 = (TLBrace)nodeArrayList3.get(0);
        psequenceNode5 = (PSequence)nodeArrayList4.get(0);
        trbraceNode6 = (TRBrace)nodeArrayList5.get(0);

        pinitNode1 = new AInit(tinittokNode2, ppriorityNode3, tlbraceNode4, psequenceNode5, trbraceNode6);
        }
	nodeList.add(pinitNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new37() /* reduce ANever */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PNever pneverNode1;
        {
            // Block
        TNevertok tnevertokNode2;
        TLBrace tlbraceNode3;
        PSequence psequenceNode4;
        TRBrace trbraceNode5;
        tnevertokNode2 = (TNevertok)nodeArrayList1.get(0);
        tlbraceNode3 = (TLBrace)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);
        trbraceNode5 = (TRBrace)nodeArrayList4.get(0);

        pneverNode1 = new ANever(tnevertokNode2, tlbraceNode3, psequenceNode4, trbraceNode5);
        }
	nodeList.add(pneverNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new38() /* reduce ATraceTrace */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PTrace ptraceNode1;
        {
            // Block
        TTracetok ttracetokNode2;
        TLBrace tlbraceNode3;
        PSequence psequenceNode4;
        TRBrace trbraceNode5;
        ttracetokNode2 = (TTracetok)nodeArrayList1.get(0);
        tlbraceNode3 = (TLBrace)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);
        trbraceNode5 = (TRBrace)nodeArrayList4.get(0);

        ptraceNode1 = new ATraceTrace(ttracetokNode2, tlbraceNode3, psequenceNode4, trbraceNode5);
        }
	nodeList.add(ptraceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new39() /* reduce ANotraceTrace */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PTrace ptraceNode1;
        {
            // Block
        TNotrace tnotraceNode2;
        TLBrace tlbraceNode3;
        PSequence psequenceNode4;
        TRBrace trbraceNode5;
        tnotraceNode2 = (TNotrace)nodeArrayList1.get(0);
        tlbraceNode3 = (TLBrace)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);
        trbraceNode5 = (TRBrace)nodeArrayList4.get(0);

        ptraceNode1 = new ANotraceTrace(tnotraceNode2, tlbraceNode3, psequenceNode4, trbraceNode5);
        }
	nodeList.add(ptraceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new40() /* reduce AUtype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PUtype putypeNode1;
        {
            // Block
        TTypedef ttypedefNode2;
        TName tnameNode3;
        TLBrace tlbraceNode4;
        LinkedList listNode6 = new LinkedList();
        TRBrace trbraceNode7;
        ttypedefNode2 = (TTypedef)nodeArrayList1.get(0);
        tnameNode3 = (TName)nodeArrayList2.get(0);
        tlbraceNode4 = (TLBrace)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode5 = new LinkedList();
        listNode5 = (LinkedList)nodeArrayList4.get(0);
	if(listNode5 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode6.addAll(listNode5);
  	  //listNode6 = listNode5;
	}
        }
        trbraceNode7 = (TRBrace)nodeArrayList5.get(0);

        putypeNode1 = new AUtype(ttypedefNode2, tnameNode3, tlbraceNode4, listNode6, trbraceNode7);
        }
	nodeList.add(putypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new41() /* reduce AAudecl1Udecl */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PUdecl pudeclNode1;
        {
            // Block
        POneDecl ponedeclNode2;
          Object nullNode3 = null;
        ponedeclNode2 = (POneDecl)nodeArrayList1.get(0);

        pudeclNode1 = new AUdecl(ponedeclNode2, null);
        }
	nodeList.add(pudeclNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new42() /* reduce AAudecl2Udecl */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PUdecl pudeclNode1;
        {
            // Block
        POneDecl ponedeclNode2;
        PSeparator pseparatorNode3;
        ponedeclNode2 = (POneDecl)nodeArrayList1.get(0);
        pseparatorNode3 = (PSeparator)nodeArrayList2.get(0);

        pudeclNode1 = new AUdecl(ponedeclNode2, pseparatorNode3);
        }
	nodeList.add(pudeclNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new43() /* reduce AAmtype1Mtype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PMtype pmtypeNode1;
        {
            // Block
        TMtypetok tmtypetokNode2;
          Object nullNode3 = null;
        TLBrace tlbraceNode4;
        PNameLst pnamelstNode5;
        TRBrace trbraceNode6;
        tmtypetokNode2 = (TMtypetok)nodeArrayList1.get(0);
        tlbraceNode4 = (TLBrace)nodeArrayList2.get(0);
        pnamelstNode5 = (PNameLst)nodeArrayList3.get(0);
        trbraceNode6 = (TRBrace)nodeArrayList4.get(0);

        pmtypeNode1 = new AMtype(tmtypetokNode2, null, tlbraceNode4, pnamelstNode5, trbraceNode6);
        }
	nodeList.add(pmtypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new44() /* reduce AAmtype2Mtype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PMtype pmtypeNode1;
        {
            // Block
        TMtypetok tmtypetokNode2;
        TAssign tassignNode3;
        TLBrace tlbraceNode4;
        PNameLst pnamelstNode5;
        TRBrace trbraceNode6;
        tmtypetokNode2 = (TMtypetok)nodeArrayList1.get(0);
        tassignNode3 = (TAssign)nodeArrayList2.get(0);
        tlbraceNode4 = (TLBrace)nodeArrayList3.get(0);
        pnamelstNode5 = (PNameLst)nodeArrayList4.get(0);
        trbraceNode6 = (TRBrace)nodeArrayList5.get(0);

        pmtypeNode1 = new AMtype(tmtypetokNode2, tassignNode3, tlbraceNode4, pnamelstNode5, trbraceNode6);
        }
	nodeList.add(pmtypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new45() /* reduce AOneNameLst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PNameLst pnamelstNode1;
        {
            // Block
        TName tnameNode2;
        tnameNode2 = (TName)nodeArrayList1.get(0);

        pnamelstNode1 = new AOneNameLst(tnameNode2);
        }
	nodeList.add(pnamelstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new46() /* reduce AManyNameLst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PNameLst pnamelstNode1;
        {
            // Block
        TName tnameNode2;
        TComma tcommaNode3;
        PNameLst pnamelstNode4;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        tcommaNode3 = (TComma)nodeArrayList2.get(0);
        pnamelstNode4 = (PNameLst)nodeArrayList3.get(0);

        pnamelstNode1 = new AManyNameLst(tnameNode2, tcommaNode3, pnamelstNode4);
        }
	nodeList.add(pnamelstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new47() /* reduce AOneDeclLst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PDeclLst pdecllstNode1;
        {
            // Block
        POneDecl ponedeclNode2;
        ponedeclNode2 = (POneDecl)nodeArrayList1.get(0);

        pdecllstNode1 = new AOneDeclLst(ponedeclNode2);
        }
	nodeList.add(pdecllstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new48() /* reduce AManyDeclLst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PDeclLst pdecllstNode1;
        {
            // Block
        POneDecl ponedeclNode2;
        PSeparator pseparatorNode3;
        PDeclLst pdecllstNode4;
        ponedeclNode2 = (POneDecl)nodeArrayList1.get(0);
        pseparatorNode3 = (PSeparator)nodeArrayList2.get(0);
        pdecllstNode4 = (PDeclLst)nodeArrayList3.get(0);

        pdecllstNode1 = new AManyDeclLst(ponedeclNode2, pseparatorNode3, pdecllstNode4);
        }
	nodeList.add(pdecllstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new49() /* reduce AAonedecl1OneDecl */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        POneDecl ponedeclNode1;
        {
            // Block
          Object nullNode2 = null;
        PTypename ptypenameNode3;
        PIvarLst pivarlstNode4;
        ptypenameNode3 = (PTypename)nodeArrayList1.get(0);
        pivarlstNode4 = (PIvarLst)nodeArrayList2.get(0);

        ponedeclNode1 = new AOneDecl(null, ptypenameNode3, pivarlstNode4);
        }
	nodeList.add(ponedeclNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new50() /* reduce AAonedecl2OneDecl */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        POneDecl ponedeclNode1;
        {
            // Block
        PVisible pvisibleNode2;
        PTypename ptypenameNode3;
        PIvarLst pivarlstNode4;
        pvisibleNode2 = (PVisible)nodeArrayList1.get(0);
        ptypenameNode3 = (PTypename)nodeArrayList2.get(0);
        pivarlstNode4 = (PIvarLst)nodeArrayList3.get(0);

        ponedeclNode1 = new AOneDecl(pvisibleNode2, ptypenameNode3, pivarlstNode4);
        }
	nodeList.add(ponedeclNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new51() /* reduce AOneIvarLst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PIvarLst pivarlstNode1;
        {
            // Block
        PIvar pivarNode2;
        pivarNode2 = (PIvar)nodeArrayList1.get(0);

        pivarlstNode1 = new AOneIvarLst(pivarNode2);
        }
	nodeList.add(pivarlstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new52() /* reduce AManyIvarLst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIvarLst pivarlstNode1;
        {
            // Block
        PIvar pivarNode2;
        TComma tcommaNode3;
        PIvarLst pivarlstNode4;
        pivarNode2 = (PIvar)nodeArrayList1.get(0);
        tcommaNode3 = (TComma)nodeArrayList2.get(0);
        pivarlstNode4 = (PIvarLst)nodeArrayList3.get(0);

        pivarlstNode1 = new AManyIvarLst(pivarNode2, tcommaNode3, pivarlstNode4);
        }
	nodeList.add(pivarlstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new53() /* reduce ABitTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TBit tbitNode2;
        tbitNode2 = (TBit)nodeArrayList1.get(0);

        ptypenameNode1 = new ABitTypename(tbitNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new54() /* reduce ABoolTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TBool tboolNode2;
        tboolNode2 = (TBool)nodeArrayList1.get(0);

        ptypenameNode1 = new ABoolTypename(tboolNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new55() /* reduce AByteTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TByte tbyteNode2;
        tbyteNode2 = (TByte)nodeArrayList1.get(0);

        ptypenameNode1 = new AByteTypename(tbyteNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new56() /* reduce APidTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TPid tpidNode2;
        tpidNode2 = (TPid)nodeArrayList1.get(0);

        ptypenameNode1 = new APidTypename(tpidNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new57() /* reduce AShortTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TShort tshortNode2;
        tshortNode2 = (TShort)nodeArrayList1.get(0);

        ptypenameNode1 = new AShortTypename(tshortNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new58() /* reduce AIntTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TInt tintNode2;
        tintNode2 = (TInt)nodeArrayList1.get(0);

        ptypenameNode1 = new AIntTypename(tintNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new59() /* reduce AMtypeTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TMtypetok tmtypetokNode2;
        tmtypetokNode2 = (TMtypetok)nodeArrayList1.get(0);

        ptypenameNode1 = new AMtypeTypename(tmtypetokNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new60() /* reduce AChanTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TChan tchanNode2;
        tchanNode2 = (TChan)nodeArrayList1.get(0);

        ptypenameNode1 = new AChanTypename(tchanNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new61() /* reduce AUnameTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TName tnameNode2;
        tnameNode2 = (TName)nodeArrayList1.get(0);

        ptypenameNode1 = new AUnameTypename(tnameNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new62() /* reduce AUnsignedTypename */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypename ptypenameNode1;
        {
            // Block
        TUnsigned tunsignedNode2;
        tunsignedNode2 = (TUnsigned)nodeArrayList1.get(0);

        ptypenameNode1 = new AUnsignedTypename(tunsignedNode2);
        }
	nodeList.add(ptypenameNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new63() /* reduce AOneTypenamelst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTypenamelst ptypenamelstNode1;
        {
            // Block
        PTypename ptypenameNode2;
        ptypenameNode2 = (PTypename)nodeArrayList1.get(0);

        ptypenamelstNode1 = new AOneTypenamelst(ptypenameNode2);
        }
	nodeList.add(ptypenamelstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new64() /* reduce AManyTypenamelst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PTypenamelst ptypenamelstNode1;
        {
            // Block
        PTypename ptypenameNode2;
        TComma tcommaNode3;
        PTypenamelst ptypenamelstNode4;
        ptypenameNode2 = (PTypename)nodeArrayList1.get(0);
        tcommaNode3 = (TComma)nodeArrayList2.get(0);
        ptypenamelstNode4 = (PTypenamelst)nodeArrayList3.get(0);

        ptypenamelstNode1 = new AManyTypenamelst(ptypenameNode2, tcommaNode3, ptypenamelstNode4);
        }
	nodeList.add(ptypenamelstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new65() /* reduce AOneActive */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PActive pactiveNode1;
        {
            // Block
        TActivetok tactivetokNode2;
        tactivetokNode2 = (TActivetok)nodeArrayList1.get(0);

        pactiveNode1 = new AOneActive(tactivetokNode2);
        }
	nodeList.add(pactiveNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new66() /* reduce AManyActive */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PActive pactiveNode1;
        {
            // Block
        TActivetok tactivetokNode2;
        TLBracket tlbracketNode3;
        PConst pconstNode4;
        TRBracket trbracketNode5;
        tactivetokNode2 = (TActivetok)nodeArrayList1.get(0);
        tlbracketNode3 = (TLBracket)nodeArrayList2.get(0);
        pconstNode4 = (PConst)nodeArrayList3.get(0);
        trbracketNode5 = (TRBracket)nodeArrayList4.get(0);

        pactiveNode1 = new AManyActive(tactivetokNode2, tlbracketNode3, pconstNode4, trbracketNode5);
        }
	nodeList.add(pactiveNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new67() /* reduce APriority */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PPriority ppriorityNode1;
        {
            // Block
        TPrioritytok tprioritytokNode2;
        PConst pconstNode3;
        tprioritytokNode2 = (TPrioritytok)nodeArrayList1.get(0);
        pconstNode3 = (PConst)nodeArrayList2.get(0);

        ppriorityNode1 = new APriority(tprioritytokNode2, pconstNode3);
        }
	nodeList.add(ppriorityNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new68() /* reduce AEnabler */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PEnabler penablerNode1;
        {
            // Block
        TProvided tprovidedNode2;
        TLParenthese tlparentheseNode3;
        PExpr pexprNode4;
        TRParenthese trparentheseNode5;
        tprovidedNode2 = (TProvided)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        pexprNode4 = (PExpr)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        penablerNode1 = new AEnabler(tprovidedNode2, tlparentheseNode3, pexprNode4, trparentheseNode5);
        }
	nodeList.add(penablerNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new69() /* reduce AHiddenVisible */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PVisible pvisibleNode1;
        {
            // Block
        THidden thiddenNode2;
        thiddenNode2 = (THidden)nodeArrayList1.get(0);

        pvisibleNode1 = new AHiddenVisible(thiddenNode2);
        }
	nodeList.add(pvisibleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new70() /* reduce AShowVisible */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PVisible pvisibleNode1;
        {
            // Block
        TShow tshowNode2;
        tshowNode2 = (TShow)nodeArrayList1.get(0);

        pvisibleNode1 = new AShowVisible(tshowNode2);
        }
	nodeList.add(pvisibleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new71() /* reduce ANullSequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

        PSequence psequenceNode1;
        {
            // Block

        psequenceNode1 = new ANullSequence();
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new72() /* reduce AOneSequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        PStep pstepNode2;
        pstepNode2 = (PStep)nodeArrayList1.get(0);

        psequenceNode1 = new AOneSequence(pstepNode2);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new73() /* reduce AManySequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        PStep pstepNode2;
        PSeparator pseparatorNode3;
        PSequence psequenceNode4;
        pstepNode2 = (PStep)nodeArrayList1.get(0);
        pseparatorNode3 = (PSeparator)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);

        psequenceNode1 = new AManySequence(pstepNode2, pseparatorNode3, psequenceNode4);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new74() /* reduce AAatomicsequence1Sequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TAtomic tatomicNode2;
        TLBrace tlbraceNode3;
        PSequence psequenceNode4;
        TRBrace trbraceNode5;
          Object nullNode6 = null;
        PSequence psequenceNode7;
        tatomicNode2 = (TAtomic)nodeArrayList1.get(0);
        tlbraceNode3 = (TLBrace)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);
        trbraceNode5 = (TRBrace)nodeArrayList4.get(0);
        psequenceNode7 = (PSequence)nodeArrayList5.get(0);

        psequenceNode1 = new AAtomicSequence(tatomicNode2, tlbraceNode3, psequenceNode4, trbraceNode5, null, psequenceNode7);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new75() /* reduce AAatomicsequence2Sequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TAtomic tatomicNode2;
        TLBrace tlbraceNode3;
        PSequence psequenceNode4;
        TRBrace trbraceNode5;
        PSeparator pseparatorNode6;
        PSequence psequenceNode7;
        tatomicNode2 = (TAtomic)nodeArrayList1.get(0);
        tlbraceNode3 = (TLBrace)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);
        trbraceNode5 = (TRBrace)nodeArrayList4.get(0);
        pseparatorNode6 = (PSeparator)nodeArrayList5.get(0);
        psequenceNode7 = (PSequence)nodeArrayList6.get(0);

        psequenceNode1 = new AAtomicSequence(tatomicNode2, tlbraceNode3, psequenceNode4, trbraceNode5, pseparatorNode6, psequenceNode7);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new76() /* reduce AAdstepsequence1Sequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TDStep tdstepNode2;
        TLBrace tlbraceNode3;
        PSequence psequenceNode4;
        TRBrace trbraceNode5;
          Object nullNode6 = null;
        PSequence psequenceNode7;
        tdstepNode2 = (TDStep)nodeArrayList1.get(0);
        tlbraceNode3 = (TLBrace)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);
        trbraceNode5 = (TRBrace)nodeArrayList4.get(0);
        psequenceNode7 = (PSequence)nodeArrayList5.get(0);

        psequenceNode1 = new ADstepSequence(tdstepNode2, tlbraceNode3, psequenceNode4, trbraceNode5, null, psequenceNode7);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new77() /* reduce AAdstepsequence2Sequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TDStep tdstepNode2;
        TLBrace tlbraceNode3;
        PSequence psequenceNode4;
        TRBrace trbraceNode5;
        PSeparator pseparatorNode6;
        PSequence psequenceNode7;
        tdstepNode2 = (TDStep)nodeArrayList1.get(0);
        tlbraceNode3 = (TLBrace)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);
        trbraceNode5 = (TRBrace)nodeArrayList4.get(0);
        pseparatorNode6 = (PSeparator)nodeArrayList5.get(0);
        psequenceNode7 = (PSequence)nodeArrayList6.get(0);

        psequenceNode1 = new ADstepSequence(tdstepNode2, tlbraceNode3, psequenceNode4, trbraceNode5, pseparatorNode6, psequenceNode7);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new78() /* reduce AAbracessequence1Sequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TLBrace tlbraceNode2;
        PSequence psequenceNode3;
        TRBrace trbraceNode4;
          Object nullNode5 = null;
        PSequence psequenceNode6;
        tlbraceNode2 = (TLBrace)nodeArrayList1.get(0);
        psequenceNode3 = (PSequence)nodeArrayList2.get(0);
        trbraceNode4 = (TRBrace)nodeArrayList3.get(0);
        psequenceNode6 = (PSequence)nodeArrayList4.get(0);

        psequenceNode1 = new ABracesSequence(tlbraceNode2, psequenceNode3, trbraceNode4, null, psequenceNode6);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new79() /* reduce AAbracessequence2Sequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TLBrace tlbraceNode2;
        PSequence psequenceNode3;
        TRBrace trbraceNode4;
        PSeparator pseparatorNode5;
        PSequence psequenceNode6;
        tlbraceNode2 = (TLBrace)nodeArrayList1.get(0);
        psequenceNode3 = (PSequence)nodeArrayList2.get(0);
        trbraceNode4 = (TRBrace)nodeArrayList3.get(0);
        pseparatorNode5 = (PSeparator)nodeArrayList4.get(0);
        psequenceNode6 = (PSequence)nodeArrayList5.get(0);

        psequenceNode1 = new ABracesSequence(tlbraceNode2, psequenceNode3, trbraceNode4, pseparatorNode5, psequenceNode6);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new80() /* reduce ALabelSequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TName tnameNode2;
        TColon tcolonNode3;
        PSequence psequenceNode4;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        tcolonNode3 = (TColon)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);

        psequenceNode1 = new ALabelSequence(tnameNode2, tcolonNode3, psequenceNode4);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new81() /* reduce AAelsesequence1Sequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TElse telseNode2;
          Object nullNode3 = null;
        PSequence psequenceNode4;
        telseNode2 = (TElse)nodeArrayList1.get(0);
        psequenceNode4 = (PSequence)nodeArrayList2.get(0);

        psequenceNode1 = new AElseSequence(telseNode2, null, psequenceNode4);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new82() /* reduce AAelsesequence2Sequence */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSequence psequenceNode1;
        {
            // Block
        TElse telseNode2;
        PSeparator pseparatorNode3;
        PSequence psequenceNode4;
        telseNode2 = (TElse)nodeArrayList1.get(0);
        pseparatorNode3 = (PSeparator)nodeArrayList2.get(0);
        psequenceNode4 = (PSequence)nodeArrayList3.get(0);

        psequenceNode1 = new AElseSequence(telseNode2, pseparatorNode3, psequenceNode4);
        }
	nodeList.add(psequenceNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new83() /* reduce ADeclarationStep */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PStep pstepNode1;
        {
            // Block
        POneDecl ponedeclNode2;
        ponedeclNode2 = (POneDecl)nodeArrayList1.get(0);

        pstepNode1 = new ADeclarationStep(ponedeclNode2);
        }
	nodeList.add(pstepNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new84() /* reduce AStmntStep */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PStep pstepNode1;
        {
            // Block
        PStmnt pstmntNode2;
        pstmntNode2 = (PStmnt)nodeArrayList1.get(0);

        pstepNode1 = new AStmntStep(pstmntNode2);
        }
	nodeList.add(pstepNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new85() /* reduce AUnlessStep */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStep pstepNode1;
        {
            // Block
        PStmnt pstmntNode2;
        TUnless tunlessNode3;
        PStmnt pstmntNode4;
        pstmntNode2 = (PStmnt)nodeArrayList1.get(0);
        tunlessNode3 = (TUnless)nodeArrayList2.get(0);
        pstmntNode4 = (PStmnt)nodeArrayList3.get(0);

        pstepNode1 = new AUnlessStep(pstmntNode2, tunlessNode3, pstmntNode4);
        }
	nodeList.add(pstepNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new86() /* reduce AExreceiveStep */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStep pstepNode1;
        {
            // Block
        TXr txrNode2;
        PVarreflst pvarreflstNode3;
        txrNode2 = (TXr)nodeArrayList1.get(0);
        pvarreflstNode3 = (PVarreflst)nodeArrayList2.get(0);

        pstepNode1 = new AExreceiveStep(txrNode2, pvarreflstNode3);
        }
	nodeList.add(pstepNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new87() /* reduce AExsendStep */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStep pstepNode1;
        {
            // Block
        TXs txsNode2;
        PVarreflst pvarreflstNode3;
        txsNode2 = (TXs)nodeArrayList1.get(0);
        pvarreflstNode3 = (PVarreflst)nodeArrayList2.get(0);

        pstepNode1 = new AExsendStep(txsNode2, pvarreflstNode3);
        }
	nodeList.add(pstepNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new88() /* reduce AOneVarreflst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PVarreflst pvarreflstNode1;
        {
            // Block
        PVarref pvarrefNode2;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);

        pvarreflstNode1 = new AOneVarreflst(pvarrefNode2);
        }
	nodeList.add(pvarreflstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new89() /* reduce AManyVarreflst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PVarreflst pvarreflstNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TComma tcommaNode3;
        PVarreflst pvarreflstNode4;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tcommaNode3 = (TComma)nodeArrayList2.get(0);
        pvarreflstNode4 = (PVarreflst)nodeArrayList3.get(0);

        pvarreflstNode1 = new AManyVarreflst(pvarrefNode2, tcommaNode3, pvarreflstNode4);
        }
	nodeList.add(pvarreflstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new90() /* reduce AAsingleivar1Ivar */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PIvar pivarNode1;
        {
            // Block
        TName tnameNode2;
          Object nullNode3 = null;
          Object nullNode4 = null;
        tnameNode2 = (TName)nodeArrayList1.get(0);

        pivarNode1 = new ASingleIvar(tnameNode2, null, null);
        }
	nodeList.add(pivarNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new91() /* reduce AAsingleivar2Ivar */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIvar pivarNode1;
        {
            // Block
        TName tnameNode2;
        PWidth pwidthNode3;
          Object nullNode4 = null;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        pwidthNode3 = (PWidth)nodeArrayList2.get(0);

        pivarNode1 = new ASingleIvar(tnameNode2, pwidthNode3, null);
        }
	nodeList.add(pivarNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new92() /* reduce AAsingleivar3Ivar */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIvar pivarNode1;
        {
            // Block
        TName tnameNode2;
          Object nullNode3 = null;
        PIvarassignment pivarassignmentNode4;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        pivarassignmentNode4 = (PIvarassignment)nodeArrayList2.get(0);

        pivarNode1 = new ASingleIvar(tnameNode2, null, pivarassignmentNode4);
        }
	nodeList.add(pivarNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new93() /* reduce AAsingleivar4Ivar */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIvar pivarNode1;
        {
            // Block
        TName tnameNode2;
        PWidth pwidthNode3;
        PIvarassignment pivarassignmentNode4;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        pwidthNode3 = (PWidth)nodeArrayList2.get(0);
        pivarassignmentNode4 = (PIvarassignment)nodeArrayList3.get(0);

        pivarNode1 = new ASingleIvar(tnameNode2, pwidthNode3, pivarassignmentNode4);
        }
	nodeList.add(pivarNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new94() /* reduce AAarrayivar1Ivar */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIvar pivarNode1;
        {
            // Block
        TName tnameNode2;
        TLBracket tlbracketNode3;
        PConst pconstNode4;
        TRBracket trbracketNode5;
          Object nullNode6 = null;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        tlbracketNode3 = (TLBracket)nodeArrayList2.get(0);
        pconstNode4 = (PConst)nodeArrayList3.get(0);
        trbracketNode5 = (TRBracket)nodeArrayList4.get(0);

        pivarNode1 = new AArrayIvar(tnameNode2, tlbracketNode3, pconstNode4, trbracketNode5, null);
        }
	nodeList.add(pivarNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new95() /* reduce AAarrayivar2Ivar */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIvar pivarNode1;
        {
            // Block
        TName tnameNode2;
        TLBracket tlbracketNode3;
        PConst pconstNode4;
        TRBracket trbracketNode5;
        PIvarassignment pivarassignmentNode6;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        tlbracketNode3 = (TLBracket)nodeArrayList2.get(0);
        pconstNode4 = (PConst)nodeArrayList3.get(0);
        trbracketNode5 = (TRBracket)nodeArrayList4.get(0);
        pivarassignmentNode6 = (PIvarassignment)nodeArrayList5.get(0);

        pivarNode1 = new AArrayIvar(tnameNode2, tlbracketNode3, pconstNode4, trbracketNode5, pivarassignmentNode6);
        }
	nodeList.add(pivarNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new96() /* reduce AVariableIvarassignment */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIvarassignment pivarassignmentNode1;
        {
            // Block
        TAssign tassignNode2;
        PExpr pexprNode3;
        tassignNode2 = (TAssign)nodeArrayList1.get(0);
        pexprNode3 = (PExpr)nodeArrayList2.get(0);

        pivarassignmentNode1 = new AVariableIvarassignment(tassignNode2, pexprNode3);
        }
	nodeList.add(pivarassignmentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new97() /* reduce AChannelIvarassignment */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIvarassignment pivarassignmentNode1;
        {
            // Block
        TAssign tassignNode2;
        TLBracket tlbracketNode3;
        PConst pconstNode4;
        TRBracket trbracketNode5;
        TOf tofNode6;
        TLBrace tlbraceNode7;
        PTypenamelst ptypenamelstNode8;
        TRBrace trbraceNode9;
        tassignNode2 = (TAssign)nodeArrayList1.get(0);
        tlbracketNode3 = (TLBracket)nodeArrayList2.get(0);
        pconstNode4 = (PConst)nodeArrayList3.get(0);
        trbracketNode5 = (TRBracket)nodeArrayList4.get(0);
        tofNode6 = (TOf)nodeArrayList5.get(0);
        tlbraceNode7 = (TLBrace)nodeArrayList6.get(0);
        ptypenamelstNode8 = (PTypenamelst)nodeArrayList7.get(0);
        trbraceNode9 = (TRBrace)nodeArrayList8.get(0);

        pivarassignmentNode1 = new AChannelIvarassignment(tassignNode2, tlbracketNode3, pconstNode4, trbracketNode5, tofNode6, tlbraceNode7, ptypenamelstNode8, trbraceNode9);
        }
	nodeList.add(pivarassignmentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new98() /* reduce AWidth */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PWidth pwidthNode1;
        {
            // Block
        TColon tcolonNode2;
        PConst pconstNode3;
        tcolonNode2 = (TColon)nodeArrayList1.get(0);
        pconstNode3 = (PConst)nodeArrayList2.get(0);

        pwidthNode1 = new AWidth(tcolonNode2, pconstNode3);
        }
	nodeList.add(pwidthNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new99() /* reduce AAsinglevarref1Varref */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PVarref pvarrefNode1;
        {
            // Block
        TName tnameNode2;
          Object nullNode3 = null;
        tnameNode2 = (TName)nodeArrayList1.get(0);

        pvarrefNode1 = new ASingleVarref(tnameNode2, null);
        }
	nodeList.add(pvarrefNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new100() /* reduce AAsinglevarref2Varref */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PVarref pvarrefNode1;
        {
            // Block
        TName tnameNode2;
        PArrayref parrayrefNode3;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        parrayrefNode3 = (PArrayref)nodeArrayList2.get(0);

        pvarrefNode1 = new ASingleVarref(tnameNode2, parrayrefNode3);
        }
	nodeList.add(pvarrefNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new101() /* reduce AArecordvarref1Varref */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PVarref pvarrefNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TDot tdotNode3;
        TName tnameNode4;
          Object nullNode5 = null;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tdotNode3 = (TDot)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);

        pvarrefNode1 = new ARecordVarref(pvarrefNode2, tdotNode3, tnameNode4, null);
        }
	nodeList.add(pvarrefNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new102() /* reduce AArecordvarref2Varref */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PVarref pvarrefNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TDot tdotNode3;
        TName tnameNode4;
        PArrayref parrayrefNode5;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tdotNode3 = (TDot)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        parrayrefNode5 = (PArrayref)nodeArrayList4.get(0);

        pvarrefNode1 = new ARecordVarref(pvarrefNode2, tdotNode3, tnameNode4, parrayrefNode5);
        }
	nodeList.add(pvarrefNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new103() /* reduce AAstringvarref1Varref */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PVarref pvarrefNode1;
        {
            // Block
        TApostrophe tapostropheNode2;
          Object nullNode3 = null;
        TName tnameNode4;
        TApostrophe tapostropheNode5;
        tapostropheNode2 = (TApostrophe)nodeArrayList1.get(0);
        tnameNode4 = (TName)nodeArrayList2.get(0);
        tapostropheNode5 = (TApostrophe)nodeArrayList3.get(0);

        pvarrefNode1 = new AStringVarref(tapostropheNode2, null, tnameNode4, tapostropheNode5);
        }
	nodeList.add(pvarrefNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new104() /* reduce AAstringvarref2Varref */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PVarref pvarrefNode1;
        {
            // Block
        TApostrophe tapostropheNode2;
        TBackslash tbackslashNode3;
        TName tnameNode4;
        TApostrophe tapostropheNode5;
        tapostropheNode2 = (TApostrophe)nodeArrayList1.get(0);
        tbackslashNode3 = (TBackslash)nodeArrayList2.get(0);
        tnameNode4 = (TName)nodeArrayList3.get(0);
        tapostropheNode5 = (TApostrophe)nodeArrayList4.get(0);

        pvarrefNode1 = new AStringVarref(tapostropheNode2, tbackslashNode3, tnameNode4, tapostropheNode5);
        }
	nodeList.add(pvarrefNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new105() /* reduce AArrayref */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PArrayref parrayrefNode1;
        {
            // Block
        TLBracket tlbracketNode2;
        PExpr pexprNode3;
        TRBracket trbracketNode4;
        tlbracketNode2 = (TLBracket)nodeArrayList1.get(0);
        pexprNode3 = (PExpr)nodeArrayList2.get(0);
        trbracketNode4 = (TRBracket)nodeArrayList3.get(0);

        parrayrefNode1 = new AArrayref(tlbracketNode2, pexprNode3, trbracketNode4);
        }
	nodeList.add(parrayrefNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new106() /* reduce ARecordref */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRecordref precordrefNode1;
        {
            // Block
        TDot tdotNode2;
        PVarref pvarrefNode3;
        tdotNode2 = (TDot)nodeArrayList1.get(0);
        pvarrefNode3 = (PVarref)nodeArrayList2.get(0);

        precordrefNode1 = new ARecordref(tdotNode2, pvarrefNode3);
        }
	nodeList.add(precordrefNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new107() /* reduce AFifoSend */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSend psendNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TBang tbangNode3;
        PSendArgs psendargsNode4;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tbangNode3 = (TBang)nodeArrayList2.get(0);
        psendargsNode4 = (PSendArgs)nodeArrayList3.get(0);

        psendNode1 = new AFifoSend(pvarrefNode2, tbangNode3, psendargsNode4);
        }
	nodeList.add(psendNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new108() /* reduce ASortedSend */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSend psendNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TBangBang tbangbangNode3;
        PSendArgs psendargsNode4;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tbangbangNode3 = (TBangBang)nodeArrayList2.get(0);
        psendargsNode4 = (PSendArgs)nodeArrayList3.get(0);

        psendNode1 = new ASortedSend(pvarrefNode2, tbangbangNode3, psendargsNode4);
        }
	nodeList.add(psendNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new109() /* reduce AFifoReceive */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PReceive preceiveNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TQuery tqueryNode3;
        PRecvArgs precvargsNode4;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tqueryNode3 = (TQuery)nodeArrayList2.get(0);
        precvargsNode4 = (PRecvArgs)nodeArrayList3.get(0);

        preceiveNode1 = new AFifoReceive(pvarrefNode2, tqueryNode3, precvargsNode4);
        }
	nodeList.add(preceiveNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new110() /* reduce ARandomReceive */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PReceive preceiveNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TQueryQuery tqueryqueryNode3;
        PRecvArgs precvargsNode4;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tqueryqueryNode3 = (TQueryQuery)nodeArrayList2.get(0);
        precvargsNode4 = (PRecvArgs)nodeArrayList3.get(0);

        preceiveNode1 = new ARandomReceive(pvarrefNode2, tqueryqueryNode3, precvargsNode4);
        }
	nodeList.add(preceiveNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new111() /* reduce AFifopollReceive */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PReceive preceiveNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TQuery tqueryNode3;
        TLt tltNode4;
        PRecvArgs precvargsNode5;
        TGt tgtNode6;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tqueryNode3 = (TQuery)nodeArrayList2.get(0);
        tltNode4 = (TLt)nodeArrayList3.get(0);
        precvargsNode5 = (PRecvArgs)nodeArrayList4.get(0);
        tgtNode6 = (TGt)nodeArrayList5.get(0);

        preceiveNode1 = new AFifopollReceive(pvarrefNode2, tqueryNode3, tltNode4, precvargsNode5, tgtNode6);
        }
	nodeList.add(preceiveNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new112() /* reduce ARandompollReceive */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PReceive preceiveNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TQueryQuery tqueryqueryNode3;
        TLt tltNode4;
        PRecvArgs precvargsNode5;
        TGt tgtNode6;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tqueryqueryNode3 = (TQueryQuery)nodeArrayList2.get(0);
        tltNode4 = (TLt)nodeArrayList3.get(0);
        precvargsNode5 = (PRecvArgs)nodeArrayList4.get(0);
        tgtNode6 = (TGt)nodeArrayList5.get(0);

        preceiveNode1 = new ARandompollReceive(pvarrefNode2, tqueryqueryNode3, tltNode4, precvargsNode5, tgtNode6);
        }
	nodeList.add(preceiveNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new113() /* reduce AFifoRecvPoll */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRecvPoll precvpollNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TQuery tqueryNode3;
        TLBracket tlbracketNode4;
        PRecvArgs precvargsNode5;
        TRBracket trbracketNode6;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tqueryNode3 = (TQuery)nodeArrayList2.get(0);
        tlbracketNode4 = (TLBracket)nodeArrayList3.get(0);
        precvargsNode5 = (PRecvArgs)nodeArrayList4.get(0);
        trbracketNode6 = (TRBracket)nodeArrayList5.get(0);

        precvpollNode1 = new AFifoRecvPoll(pvarrefNode2, tqueryNode3, tlbracketNode4, precvargsNode5, trbracketNode6);
        }
	nodeList.add(precvpollNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new114() /* reduce ARandomRecvPoll */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRecvPoll precvpollNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TQueryQuery tqueryqueryNode3;
        TLBracket tlbracketNode4;
        PRecvArgs precvargsNode5;
        TRBracket trbracketNode6;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tqueryqueryNode3 = (TQueryQuery)nodeArrayList2.get(0);
        tlbracketNode4 = (TLBracket)nodeArrayList3.get(0);
        precvargsNode5 = (PRecvArgs)nodeArrayList4.get(0);
        trbracketNode6 = (TRBracket)nodeArrayList5.get(0);

        precvpollNode1 = new ARandomRecvPoll(pvarrefNode2, tqueryqueryNode3, tlbracketNode4, precvargsNode5, trbracketNode6);
        }
	nodeList.add(precvpollNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new115() /* reduce AListSendArgs */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PSendArgs psendargsNode1;
        {
            // Block
        PArgLst parglstNode2;
        parglstNode2 = (PArgLst)nodeArrayList1.get(0);

        psendargsNode1 = new AListSendArgs(parglstNode2);
        }
	nodeList.add(psendargsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new116() /* reduce AHeadedlistSendArgs */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PSendArgs psendargsNode1;
        {
            // Block
        PExpr pexprNode2;
        TLParenthese tlparentheseNode3;
        PArgLst parglstNode4;
        TRParenthese trparentheseNode5;
        pexprNode2 = (PExpr)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        parglstNode4 = (PArgLst)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        psendargsNode1 = new AHeadedlistSendArgs(pexprNode2, tlparentheseNode3, parglstNode4, trparentheseNode5);
        }
	nodeList.add(psendargsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new117() /* reduce AOneArgLst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PArgLst parglstNode1;
        {
            // Block
        PExpr pexprNode2;
        pexprNode2 = (PExpr)nodeArrayList1.get(0);

        parglstNode1 = new AOneArgLst(pexprNode2);
        }
	nodeList.add(parglstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new118() /* reduce AManyArgLst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PArgLst parglstNode1;
        {
            // Block
        PExpr pexprNode2;
        TComma tcommaNode3;
        PArgLst parglstNode4;
        pexprNode2 = (PExpr)nodeArrayList1.get(0);
        tcommaNode3 = (TComma)nodeArrayList2.get(0);
        parglstNode4 = (PArgLst)nodeArrayList3.get(0);

        parglstNode1 = new AManyArgLst(pexprNode2, tcommaNode3, parglstNode4);
        }
	nodeList.add(parglstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new119() /* reduce AOneRecvArgs */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PRecvArgs precvargsNode1;
        {
            // Block
        PRecvArg precvargNode2;
        precvargNode2 = (PRecvArg)nodeArrayList1.get(0);

        precvargsNode1 = new AOneRecvArgs(precvargNode2);
        }
	nodeList.add(precvargsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new120() /* reduce AManyRecvArgs */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRecvArgs precvargsNode1;
        {
            // Block
        PRecvArg precvargNode2;
        TComma tcommaNode3;
        PRecvArgs precvargsNode4;
        precvargNode2 = (PRecvArg)nodeArrayList1.get(0);
        tcommaNode3 = (TComma)nodeArrayList2.get(0);
        precvargsNode4 = (PRecvArgs)nodeArrayList3.get(0);

        precvargsNode1 = new AManyRecvArgs(precvargNode2, tcommaNode3, precvargsNode4);
        }
	nodeList.add(precvargsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new121() /* reduce AManyheaded1RecvArgs */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRecvArgs precvargsNode1;
        {
            // Block
        PRecvArg precvargNode2;
        TLParenthese tlparentheseNode3;
        PRecvArgs precvargsNode4;
        TRParenthese trparentheseNode5;
        precvargNode2 = (PRecvArg)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        precvargsNode4 = (PRecvArgs)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        precvargsNode1 = new AManyheaded1RecvArgs(precvargNode2, tlparentheseNode3, precvargsNode4, trparentheseNode5);
        }
	nodeList.add(precvargsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new122() /* reduce AManyheaded2RecvArgs */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRecvArgs precvargsNode1;
        {
            // Block
        TLParenthese tlparentheseNode2;
        PRecvArgs precvargsNode3;
        TRParenthese trparentheseNode4;
        tlparentheseNode2 = (TLParenthese)nodeArrayList1.get(0);
        precvargsNode3 = (PRecvArgs)nodeArrayList2.get(0);
        trparentheseNode4 = (TRParenthese)nodeArrayList3.get(0);

        precvargsNode1 = new AManyheaded2RecvArgs(tlparentheseNode2, precvargsNode3, trparentheseNode4);
        }
	nodeList.add(precvargsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new123() /* reduce AVarRecvArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PRecvArg precvargNode1;
        {
            // Block
        PVarref pvarrefNode2;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);

        precvargNode1 = new AVarRecvArg(pvarrefNode2);
        }
	nodeList.add(precvargNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new124() /* reduce AEvalRecvArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRecvArg precvargNode1;
        {
            // Block
        TEval tevalNode2;
        TLParenthese tlparentheseNode3;
        PExpr pexprNode4;
        TRParenthese trparentheseNode5;
        tevalNode2 = (TEval)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        pexprNode4 = (PExpr)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        precvargNode1 = new AEvalRecvArg(tevalNode2, tlparentheseNode3, pexprNode4, trparentheseNode5);
        }
	nodeList.add(precvargNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new125() /* reduce AConstRecvArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PRecvArg precvargNode1;
        {
            // Block
        PConst pconstNode2;
        pconstNode2 = (PConst)nodeArrayList1.get(0);

        precvargNode1 = new AConstRecvArg(pconstNode2);
        }
	nodeList.add(precvargNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new126() /* reduce AUnderscoreRecvArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PRecvArg precvargNode1;
        {
            // Block
        TUnderscore tunderscoreNode2;
        tunderscoreNode2 = (TUnderscore)nodeArrayList1.get(0);

        precvargNode1 = new AUnderscoreRecvArg(tunderscoreNode2);
        }
	nodeList.add(precvargNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new127() /* reduce AAssignmentAssignment */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PAssignment passignmentNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TAssign tassignNode3;
        PExpr pexprNode4;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tassignNode3 = (TAssign)nodeArrayList2.get(0);
        pexprNode4 = (PExpr)nodeArrayList3.get(0);

        passignmentNode1 = new AAssignmentAssignment(pvarrefNode2, tassignNode3, pexprNode4);
        }
	nodeList.add(passignmentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new128() /* reduce AIncrementAssignment */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PAssignment passignmentNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TPlusPlus tplusplusNode3;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tplusplusNode3 = (TPlusPlus)nodeArrayList2.get(0);

        passignmentNode1 = new AIncrementAssignment(pvarrefNode2, tplusplusNode3);
        }
	nodeList.add(passignmentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new129() /* reduce ADecrementAssignment */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PAssignment passignmentNode1;
        {
            // Block
        PVarref pvarrefNode2;
        TMinusMinus tminusminusNode3;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);
        tminusminusNode3 = (TMinusMinus)nodeArrayList2.get(0);

        passignmentNode1 = new ADecrementAssignment(pvarrefNode2, tminusminusNode3);
        }
	nodeList.add(passignmentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new130() /* reduce AAruninlinestmnt1Stmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TName tnameNode2;
        TLParenthese tlparentheseNode3;
          Object nullNode4 = null;
        TRParenthese trparentheseNode5;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList3.get(0);

        pstmntNode1 = new ARunInlineStmnt(tnameNode2, tlparentheseNode3, null, trparentheseNode5);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new131() /* reduce AAruninlinestmnt2Stmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TName tnameNode2;
        TLParenthese tlparentheseNode3;
        PArgLst parglstNode4;
        TRParenthese trparentheseNode5;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        parglstNode4 = (PArgLst)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        pstmntNode1 = new ARunInlineStmnt(tnameNode2, tlparentheseNode3, parglstNode4, trparentheseNode5);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new132() /* reduce AIfStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TIf tifNode2;
        POptions poptionsNode3;
        TFi tfiNode4;
        tifNode2 = (TIf)nodeArrayList1.get(0);
        poptionsNode3 = (POptions)nodeArrayList2.get(0);
        tfiNode4 = (TFi)nodeArrayList3.get(0);

        pstmntNode1 = new AIfStmnt(tifNode2, poptionsNode3, tfiNode4);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new133() /* reduce ADoStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TDo tdoNode2;
        POptions poptionsNode3;
        TOd todNode4;
        tdoNode2 = (TDo)nodeArrayList1.get(0);
        poptionsNode3 = (POptions)nodeArrayList2.get(0);
        todNode4 = (TOd)nodeArrayList3.get(0);

        pstmntNode1 = new ADoStmnt(tdoNode2, poptionsNode3, todNode4);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new134() /* reduce ASendStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        PSend psendNode2;
        psendNode2 = (PSend)nodeArrayList1.get(0);

        pstmntNode1 = new ASendStmnt(psendNode2);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new135() /* reduce AReceiveStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        PReceive preceiveNode2;
        preceiveNode2 = (PReceive)nodeArrayList1.get(0);

        pstmntNode1 = new AReceiveStmnt(preceiveNode2);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new136() /* reduce AAssignStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        PAssignment passignmentNode2;
        passignmentNode2 = (PAssignment)nodeArrayList1.get(0);

        pstmntNode1 = new AAssignStmnt(passignmentNode2);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new137() /* reduce ABreakStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TBreak tbreakNode2;
        tbreakNode2 = (TBreak)nodeArrayList1.get(0);

        pstmntNode1 = new ABreakStmnt(tbreakNode2);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new138() /* reduce AGotoStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TGoto tgotoNode2;
        TName tnameNode3;
        tgotoNode2 = (TGoto)nodeArrayList1.get(0);
        tnameNode3 = (TName)nodeArrayList2.get(0);

        pstmntNode1 = new AGotoStmnt(tgotoNode2, tnameNode3);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new139() /* reduce APrintmStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TPrintm tprintmNode2;
        TLParenthese tlparentheseNode3;
        PExpr pexprNode4;
        TRParenthese trparentheseNode5;
        tprintmNode2 = (TPrintm)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        pexprNode4 = (PExpr)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        pstmntNode1 = new APrintmStmnt(tprintmNode2, tlparentheseNode3, pexprNode4, trparentheseNode5);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new140() /* reduce APrintfStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TPrintf tprintfNode2;
        TLParenthese tlparentheseNode3;
        TString tstringNode4;
        TRParenthese trparentheseNode5;
        tprintfNode2 = (TPrintf)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        tstringNode4 = (TString)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        pstmntNode1 = new APrintfStmnt(tprintfNode2, tlparentheseNode3, tstringNode4, trparentheseNode5);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new141() /* reduce APrintwithargsStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TPrintf tprintfNode2;
        TLParenthese tlparentheseNode3;
        TString tstringNode4;
        TComma tcommaNode5;
        PArgLst parglstNode6;
        TRParenthese trparentheseNode7;
        tprintfNode2 = (TPrintf)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        tstringNode4 = (TString)nodeArrayList3.get(0);
        tcommaNode5 = (TComma)nodeArrayList4.get(0);
        parglstNode6 = (PArgLst)nodeArrayList5.get(0);
        trparentheseNode7 = (TRParenthese)nodeArrayList6.get(0);

        pstmntNode1 = new APrintwithargsStmnt(tprintfNode2, tlparentheseNode3, tstringNode4, tcommaNode5, parglstNode6, trparentheseNode7);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new142() /* reduce AAssertStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        TAssert tassertNode2;
        PExpr pexprNode3;
        tassertNode2 = (TAssert)nodeArrayList1.get(0);
        pexprNode3 = (PExpr)nodeArrayList2.get(0);

        pstmntNode1 = new AAssertStmnt(tassertNode2, pexprNode3);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new143() /* reduce AExpressionStmnt */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PStmnt pstmntNode1;
        {
            // Block
        PExpr pexprNode2;
        pexprNode2 = (PExpr)nodeArrayList1.get(0);

        pstmntNode1 = new AExpressionStmnt(pexprNode2);
        }
	nodeList.add(pstmntNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new144() /* reduce AAoptions1Options */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        POptions poptionsNode1;
        {
            // Block
        TColonColon tcoloncolonNode2;
        PSequence psequenceNode3;
          Object nullNode4 = null;
        tcoloncolonNode2 = (TColonColon)nodeArrayList1.get(0);
        psequenceNode3 = (PSequence)nodeArrayList2.get(0);

        poptionsNode1 = new AOptions(tcoloncolonNode2, psequenceNode3, null);
        }
	nodeList.add(poptionsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new145() /* reduce AAoptions2Options */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        POptions poptionsNode1;
        {
            // Block
        TColonColon tcoloncolonNode2;
        PSequence psequenceNode3;
        POptions poptionsNode4;
        tcoloncolonNode2 = (TColonColon)nodeArrayList1.get(0);
        psequenceNode3 = (PSequence)nodeArrayList2.get(0);
        poptionsNode4 = (POptions)nodeArrayList3.get(0);

        poptionsNode1 = new AOptions(tcoloncolonNode2, psequenceNode3, poptionsNode4);
        }
	nodeList.add(poptionsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new146() /* reduce AParentheseFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TLParenthese tlparentheseNode2;
        PExpr pexprNode3;
        TRParenthese trparentheseNode4;
        tlparentheseNode2 = (TLParenthese)nodeArrayList1.get(0);
        pexprNode3 = (PExpr)nodeArrayList2.get(0);
        trparentheseNode4 = (TRParenthese)nodeArrayList3.get(0);

        pfactorNode1 = new AParentheseFactor(tlparentheseNode2, pexprNode3, trparentheseNode4);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new147() /* reduce ALengthFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TLen tlenNode2;
        TLParenthese tlparentheseNode3;
        PVarref pvarrefNode4;
        TRParenthese trparentheseNode5;
        tlenNode2 = (TLen)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        pvarrefNode4 = (PVarref)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        pfactorNode1 = new ALengthFactor(tlenNode2, tlparentheseNode3, pvarrefNode4, trparentheseNode5);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new148() /* reduce ARecvPollFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        PRecvPoll precvpollNode2;
        precvpollNode2 = (PRecvPoll)nodeArrayList1.get(0);

        pfactorNode1 = new ARecvPollFactor(precvpollNode2);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new149() /* reduce AVarrefFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        PVarref pvarrefNode2;
        pvarrefNode2 = (PVarref)nodeArrayList1.get(0);

        pfactorNode1 = new AVarrefFactor(pvarrefNode2);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new150() /* reduce AConstFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        PConst pconstNode2;
        pconstNode2 = (PConst)nodeArrayList1.get(0);

        pfactorNode1 = new AConstFactor(pconstNode2);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new151() /* reduce ATimeoutFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TTimeout ttimeoutNode2;
        ttimeoutNode2 = (TTimeout)nodeArrayList1.get(0);

        pfactorNode1 = new ATimeoutFactor(ttimeoutNode2);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new152() /* reduce ANonprogressFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TNp tnpNode2;
        tnpNode2 = (TNp)nodeArrayList1.get(0);

        pfactorNode1 = new ANonprogressFactor(tnpNode2);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new153() /* reduce AEnabledFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TEnabled tenabledNode2;
        TLParenthese tlparentheseNode3;
        PExpr pexprNode4;
        TRParenthese trparentheseNode5;
        tenabledNode2 = (TEnabled)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        pexprNode4 = (PExpr)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        pfactorNode1 = new AEnabledFactor(tenabledNode2, tlparentheseNode3, pexprNode4, trparentheseNode5);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new154() /* reduce APcValueFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TPcValue tpcvalueNode2;
        TLParenthese tlparentheseNode3;
        PExpr pexprNode4;
        TRParenthese trparentheseNode5;
        tpcvalueNode2 = (TPcValue)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        pexprNode4 = (PExpr)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        pfactorNode1 = new APcValueFactor(tpcvalueNode2, tlparentheseNode3, pexprNode4, trparentheseNode5);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new155() /* reduce ARemoterefFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TName tnameNode2;
        TLBracket tlbracketNode3;
        PExpr pexprNode4;
        TRBracket trbracketNode5;
        TAt tatNode6;
        TName tnameNode7;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        tlbracketNode3 = (TLBracket)nodeArrayList2.get(0);
        pexprNode4 = (PExpr)nodeArrayList3.get(0);
        trbracketNode5 = (TRBracket)nodeArrayList4.get(0);
        tatNode6 = (TAt)nodeArrayList5.get(0);
        tnameNode7 = (TName)nodeArrayList6.get(0);

        pfactorNode1 = new ARemoterefFactor(tnameNode2, tlbracketNode3, pexprNode4, trbracketNode5, tatNode6, tnameNode7);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new156() /* reduce AArunfactor1Factor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TRun trunNode2;
        TName tnameNode3;
        TLParenthese tlparentheseNode4;
          Object nullNode5 = null;
        TRParenthese trparentheseNode6;
          Object nullNode7 = null;
        trunNode2 = (TRun)nodeArrayList1.get(0);
        tnameNode3 = (TName)nodeArrayList2.get(0);
        tlparentheseNode4 = (TLParenthese)nodeArrayList3.get(0);
        trparentheseNode6 = (TRParenthese)nodeArrayList4.get(0);

        pfactorNode1 = new ARunFactor(trunNode2, tnameNode3, tlparentheseNode4, null, trparentheseNode6, null);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new157() /* reduce AArunfactor2Factor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TRun trunNode2;
        TName tnameNode3;
        TLParenthese tlparentheseNode4;
        PArgLst parglstNode5;
        TRParenthese trparentheseNode6;
          Object nullNode7 = null;
        trunNode2 = (TRun)nodeArrayList1.get(0);
        tnameNode3 = (TName)nodeArrayList2.get(0);
        tlparentheseNode4 = (TLParenthese)nodeArrayList3.get(0);
        parglstNode5 = (PArgLst)nodeArrayList4.get(0);
        trparentheseNode6 = (TRParenthese)nodeArrayList5.get(0);

        pfactorNode1 = new ARunFactor(trunNode2, tnameNode3, tlparentheseNode4, parglstNode5, trparentheseNode6, null);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new158() /* reduce AArunfactor3Factor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TRun trunNode2;
        TName tnameNode3;
        TLParenthese tlparentheseNode4;
          Object nullNode5 = null;
        TRParenthese trparentheseNode6;
        PPriority ppriorityNode7;
        trunNode2 = (TRun)nodeArrayList1.get(0);
        tnameNode3 = (TName)nodeArrayList2.get(0);
        tlparentheseNode4 = (TLParenthese)nodeArrayList3.get(0);
        trparentheseNode6 = (TRParenthese)nodeArrayList4.get(0);
        ppriorityNode7 = (PPriority)nodeArrayList5.get(0);

        pfactorNode1 = new ARunFactor(trunNode2, tnameNode3, tlparentheseNode4, null, trparentheseNode6, ppriorityNode7);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new159() /* reduce AArunfactor4Factor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TRun trunNode2;
        TName tnameNode3;
        TLParenthese tlparentheseNode4;
        PArgLst parglstNode5;
        TRParenthese trparentheseNode6;
        PPriority ppriorityNode7;
        trunNode2 = (TRun)nodeArrayList1.get(0);
        tnameNode3 = (TName)nodeArrayList2.get(0);
        tlparentheseNode4 = (TLParenthese)nodeArrayList3.get(0);
        parglstNode5 = (PArgLst)nodeArrayList4.get(0);
        trparentheseNode6 = (TRParenthese)nodeArrayList5.get(0);
        ppriorityNode7 = (PPriority)nodeArrayList6.get(0);

        pfactorNode1 = new ARunFactor(trunNode2, tnameNode3, tlparentheseNode4, parglstNode5, trparentheseNode6, ppriorityNode7);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new160() /* reduce AChanopFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TChanop tchanopNode2;
        TLParenthese tlparentheseNode3;
        PVarref pvarrefNode4;
        TRParenthese trparentheseNode5;
        tchanopNode2 = (TChanop)nodeArrayList1.get(0);
        tlparentheseNode3 = (TLParenthese)nodeArrayList2.get(0);
        pvarrefNode4 = (PVarref)nodeArrayList3.get(0);
        trparentheseNode5 = (TRParenthese)nodeArrayList4.get(0);

        pfactorNode1 = new AChanopFactor(tchanopNode2, tlparentheseNode3, pvarrefNode4, trparentheseNode5);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new161() /* reduce AConditionalFactor */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFactor pfactorNode1;
        {
            // Block
        TLParenthese tlparentheseNode2;
        PExpr pexprNode3;
        TRightarrow trightarrowNode4;
        PExpr pexprNode5;
        TColon tcolonNode6;
        PExpr pexprNode7;
        TRParenthese trparentheseNode8;
        tlparentheseNode2 = (TLParenthese)nodeArrayList1.get(0);
        pexprNode3 = (PExpr)nodeArrayList2.get(0);
        trightarrowNode4 = (TRightarrow)nodeArrayList3.get(0);
        pexprNode5 = (PExpr)nodeArrayList4.get(0);
        tcolonNode6 = (TColon)nodeArrayList5.get(0);
        pexprNode7 = (PExpr)nodeArrayList6.get(0);
        trparentheseNode8 = (TRParenthese)nodeArrayList7.get(0);

        pfactorNode1 = new AConditionalFactor(tlparentheseNode2, pexprNode3, trightarrowNode4, pexprNode5, tcolonNode6, pexprNode7, trparentheseNode8);
        }
	nodeList.add(pfactorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new162() /* reduce ASimpleUnExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PUnExpr punexprNode1;
        {
            // Block
        PFactor pfactorNode2;
        pfactorNode2 = (PFactor)nodeArrayList1.get(0);

        punexprNode1 = new ASimpleUnExpr(pfactorNode2);
        }
	nodeList.add(punexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new163() /* reduce ANotUnExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PUnExpr punexprNode1;
        {
            // Block
        TBang tbangNode2;
        PFactor pfactorNode3;
        tbangNode2 = (TBang)nodeArrayList1.get(0);
        pfactorNode3 = (PFactor)nodeArrayList2.get(0);

        punexprNode1 = new ANotUnExpr(tbangNode2, pfactorNode3);
        }
	nodeList.add(punexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new164() /* reduce AComplementUnExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PUnExpr punexprNode1;
        {
            // Block
        TComplement tcomplementNode2;
        PFactor pfactorNode3;
        tcomplementNode2 = (TComplement)nodeArrayList1.get(0);
        pfactorNode3 = (PFactor)nodeArrayList2.get(0);

        punexprNode1 = new AComplementUnExpr(tcomplementNode2, pfactorNode3);
        }
	nodeList.add(punexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new165() /* reduce ASimpleMultExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PMultExpr pmultexprNode1;
        {
            // Block
        PUnExpr punexprNode2;
        punexprNode2 = (PUnExpr)nodeArrayList1.get(0);

        pmultexprNode1 = new ASimpleMultExpr(punexprNode2);
        }
	nodeList.add(pmultexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new166() /* reduce ACompoundMultExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PMultExpr pmultexprNode1;
        {
            // Block
        PUnExpr punexprNode2;
        TMultop tmultopNode3;
        PMultExpr pmultexprNode4;
        punexprNode2 = (PUnExpr)nodeArrayList1.get(0);
        tmultopNode3 = (TMultop)nodeArrayList2.get(0);
        pmultexprNode4 = (PMultExpr)nodeArrayList3.get(0);

        pmultexprNode1 = new ACompoundMultExpr(punexprNode2, tmultopNode3, pmultexprNode4);
        }
	nodeList.add(pmultexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new167() /* reduce ASimpleAddExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PAddExpr paddexprNode1;
        {
            // Block
        PMultExpr pmultexprNode2;
        pmultexprNode2 = (PMultExpr)nodeArrayList1.get(0);

        paddexprNode1 = new ASimpleAddExpr(pmultexprNode2);
        }
	nodeList.add(paddexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new168() /* reduce ACompoundplusAddExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PAddExpr paddexprNode1;
        {
            // Block
        PMultExpr pmultexprNode2;
        TPlus tplusNode3;
        PAddExpr paddexprNode4;
        pmultexprNode2 = (PMultExpr)nodeArrayList1.get(0);
        tplusNode3 = (TPlus)nodeArrayList2.get(0);
        paddexprNode4 = (PAddExpr)nodeArrayList3.get(0);

        paddexprNode1 = new ACompoundplusAddExpr(pmultexprNode2, tplusNode3, paddexprNode4);
        }
	nodeList.add(paddexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new169() /* reduce ACompoundminusAddExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PAddExpr paddexprNode1;
        {
            // Block
        PMultExpr pmultexprNode2;
        TMinus tminusNode3;
        PAddExpr paddexprNode4;
        pmultexprNode2 = (PMultExpr)nodeArrayList1.get(0);
        tminusNode3 = (TMinus)nodeArrayList2.get(0);
        paddexprNode4 = (PAddExpr)nodeArrayList3.get(0);

        paddexprNode1 = new ACompoundminusAddExpr(pmultexprNode2, tminusNode3, paddexprNode4);
        }
	nodeList.add(paddexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new170() /* reduce ASimpleShiftExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PShiftExpr pshiftexprNode1;
        {
            // Block
        PAddExpr paddexprNode2;
        paddexprNode2 = (PAddExpr)nodeArrayList1.get(0);

        pshiftexprNode1 = new ASimpleShiftExpr(paddexprNode2);
        }
	nodeList.add(pshiftexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new171() /* reduce ACompoundShiftExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PShiftExpr pshiftexprNode1;
        {
            // Block
        PAddExpr paddexprNode2;
        TShiftop tshiftopNode3;
        PShiftExpr pshiftexprNode4;
        paddexprNode2 = (PAddExpr)nodeArrayList1.get(0);
        tshiftopNode3 = (TShiftop)nodeArrayList2.get(0);
        pshiftexprNode4 = (PShiftExpr)nodeArrayList3.get(0);

        pshiftexprNode1 = new ACompoundShiftExpr(paddexprNode2, tshiftopNode3, pshiftexprNode4);
        }
	nodeList.add(pshiftexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new172() /* reduce ASimpleRelExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PRelExpr prelexprNode1;
        {
            // Block
        PShiftExpr pshiftexprNode2;
        pshiftexprNode2 = (PShiftExpr)nodeArrayList1.get(0);

        prelexprNode1 = new ASimpleRelExpr(pshiftexprNode2);
        }
	nodeList.add(prelexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new173() /* reduce ACompoundrelopRelExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRelExpr prelexprNode1;
        {
            // Block
        PShiftExpr pshiftexprNode2;
        TRelop trelopNode3;
        PRelExpr prelexprNode4;
        pshiftexprNode2 = (PShiftExpr)nodeArrayList1.get(0);
        trelopNode3 = (TRelop)nodeArrayList2.get(0);
        prelexprNode4 = (PRelExpr)nodeArrayList3.get(0);

        prelexprNode1 = new ACompoundrelopRelExpr(pshiftexprNode2, trelopNode3, prelexprNode4);
        }
	nodeList.add(prelexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new174() /* reduce ACompoundgtRelExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRelExpr prelexprNode1;
        {
            // Block
        PShiftExpr pshiftexprNode2;
        TGt tgtNode3;
        PRelExpr prelexprNode4;
        pshiftexprNode2 = (PShiftExpr)nodeArrayList1.get(0);
        tgtNode3 = (TGt)nodeArrayList2.get(0);
        prelexprNode4 = (PRelExpr)nodeArrayList3.get(0);

        prelexprNode1 = new ACompoundgtRelExpr(pshiftexprNode2, tgtNode3, prelexprNode4);
        }
	nodeList.add(prelexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new175() /* reduce ACompoundltRelExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRelExpr prelexprNode1;
        {
            // Block
        PShiftExpr pshiftexprNode2;
        TLt tltNode3;
        PRelExpr prelexprNode4;
        pshiftexprNode2 = (PShiftExpr)nodeArrayList1.get(0);
        tltNode3 = (TLt)nodeArrayList2.get(0);
        prelexprNode4 = (PRelExpr)nodeArrayList3.get(0);

        prelexprNode1 = new ACompoundltRelExpr(pshiftexprNode2, tltNode3, prelexprNode4);
        }
	nodeList.add(prelexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new176() /* reduce ASimpleEqExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PEqExpr peqexprNode1;
        {
            // Block
        PRelExpr prelexprNode2;
        prelexprNode2 = (PRelExpr)nodeArrayList1.get(0);

        peqexprNode1 = new ASimpleEqExpr(prelexprNode2);
        }
	nodeList.add(peqexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new177() /* reduce ACompoundEqExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PEqExpr peqexprNode1;
        {
            // Block
        PRelExpr prelexprNode2;
        TEqop teqopNode3;
        PEqExpr peqexprNode4;
        prelexprNode2 = (PRelExpr)nodeArrayList1.get(0);
        teqopNode3 = (TEqop)nodeArrayList2.get(0);
        peqexprNode4 = (PEqExpr)nodeArrayList3.get(0);

        peqexprNode1 = new ACompoundEqExpr(prelexprNode2, teqopNode3, peqexprNode4);
        }
	nodeList.add(peqexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new178() /* reduce ASimpleBitandExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PBitandExpr pbitandexprNode1;
        {
            // Block
        PEqExpr peqexprNode2;
        peqexprNode2 = (PEqExpr)nodeArrayList1.get(0);

        pbitandexprNode1 = new ASimpleBitandExpr(peqexprNode2);
        }
	nodeList.add(pbitandexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new179() /* reduce ACompoundBitandExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PBitandExpr pbitandexprNode1;
        {
            // Block
        PEqExpr peqexprNode2;
        TBitand tbitandNode3;
        PBitandExpr pbitandexprNode4;
        peqexprNode2 = (PEqExpr)nodeArrayList1.get(0);
        tbitandNode3 = (TBitand)nodeArrayList2.get(0);
        pbitandexprNode4 = (PBitandExpr)nodeArrayList3.get(0);

        pbitandexprNode1 = new ACompoundBitandExpr(peqexprNode2, tbitandNode3, pbitandexprNode4);
        }
	nodeList.add(pbitandexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new180() /* reduce ASimpleBitxorExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PBitxorExpr pbitxorexprNode1;
        {
            // Block
        PBitandExpr pbitandexprNode2;
        pbitandexprNode2 = (PBitandExpr)nodeArrayList1.get(0);

        pbitxorexprNode1 = new ASimpleBitxorExpr(pbitandexprNode2);
        }
	nodeList.add(pbitxorexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new181() /* reduce ACompoundBitxorExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PBitxorExpr pbitxorexprNode1;
        {
            // Block
        PBitandExpr pbitandexprNode2;
        TBitxor tbitxorNode3;
        PBitxorExpr pbitxorexprNode4;
        pbitandexprNode2 = (PBitandExpr)nodeArrayList1.get(0);
        tbitxorNode3 = (TBitxor)nodeArrayList2.get(0);
        pbitxorexprNode4 = (PBitxorExpr)nodeArrayList3.get(0);

        pbitxorexprNode1 = new ACompoundBitxorExpr(pbitandexprNode2, tbitxorNode3, pbitxorexprNode4);
        }
	nodeList.add(pbitxorexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new182() /* reduce ASimpleBitorExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PBitorExpr pbitorexprNode1;
        {
            // Block
        PBitxorExpr pbitxorexprNode2;
        pbitxorexprNode2 = (PBitxorExpr)nodeArrayList1.get(0);

        pbitorexprNode1 = new ASimpleBitorExpr(pbitxorexprNode2);
        }
	nodeList.add(pbitorexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new183() /* reduce ACompoundBitorExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PBitorExpr pbitorexprNode1;
        {
            // Block
        PBitxorExpr pbitxorexprNode2;
        TBitor tbitorNode3;
        PBitorExpr pbitorexprNode4;
        pbitxorexprNode2 = (PBitxorExpr)nodeArrayList1.get(0);
        tbitorNode3 = (TBitor)nodeArrayList2.get(0);
        pbitorexprNode4 = (PBitorExpr)nodeArrayList3.get(0);

        pbitorexprNode1 = new ACompoundBitorExpr(pbitxorexprNode2, tbitorNode3, pbitorexprNode4);
        }
	nodeList.add(pbitorexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new184() /* reduce ASimpleAndExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PAndExpr pandexprNode1;
        {
            // Block
        PBitorExpr pbitorexprNode2;
        pbitorexprNode2 = (PBitorExpr)nodeArrayList1.get(0);

        pandexprNode1 = new ASimpleAndExpr(pbitorexprNode2);
        }
	nodeList.add(pandexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new185() /* reduce ACompoundAndExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PAndExpr pandexprNode1;
        {
            // Block
        PBitorExpr pbitorexprNode2;
        TAnd tandNode3;
        PAndExpr pandexprNode4;
        pbitorexprNode2 = (PBitorExpr)nodeArrayList1.get(0);
        tandNode3 = (TAnd)nodeArrayList2.get(0);
        pandexprNode4 = (PAndExpr)nodeArrayList3.get(0);

        pandexprNode1 = new ACompoundAndExpr(pbitorexprNode2, tandNode3, pandexprNode4);
        }
	nodeList.add(pandexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new186() /* reduce ASimpleOrExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        POrExpr porexprNode1;
        {
            // Block
        PAndExpr pandexprNode2;
        pandexprNode2 = (PAndExpr)nodeArrayList1.get(0);

        porexprNode1 = new ASimpleOrExpr(pandexprNode2);
        }
	nodeList.add(porexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new187() /* reduce ACompoundOrExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        POrExpr porexprNode1;
        {
            // Block
        PAndExpr pandexprNode2;
        TOr torNode3;
        POrExpr porexprNode4;
        pandexprNode2 = (PAndExpr)nodeArrayList1.get(0);
        torNode3 = (TOr)nodeArrayList2.get(0);
        porexprNode4 = (POrExpr)nodeArrayList3.get(0);

        porexprNode1 = new ACompoundOrExpr(pandexprNode2, torNode3, porexprNode4);
        }
	nodeList.add(porexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new188() /* reduce ASimpleExpr */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExpr pexprNode1;
        {
            // Block
        POrExpr porexprNode2;
        porexprNode2 = (POrExpr)nodeArrayList1.get(0);

        pexprNode1 = new ASimpleExpr(porexprNode2);
        }
	nodeList.add(pexprNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new189() /* reduce ATrueConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PConst pconstNode1;
        {
            // Block
        TTrue ttrueNode2;
        ttrueNode2 = (TTrue)nodeArrayList1.get(0);

        pconstNode1 = new ATrueConst(ttrueNode2);
        }
	nodeList.add(pconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new190() /* reduce AFalseConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PConst pconstNode1;
        {
            // Block
        TFalse tfalseNode2;
        tfalseNode2 = (TFalse)nodeArrayList1.get(0);

        pconstNode1 = new AFalseConst(tfalseNode2);
        }
	nodeList.add(pconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new191() /* reduce ASkipConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PConst pconstNode1;
        {
            // Block
        TSkip tskipNode2;
        tskipNode2 = (TSkip)nodeArrayList1.get(0);

        pconstNode1 = new ASkipConst(tskipNode2);
        }
	nodeList.add(pconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new192() /* reduce AAnumberconst1Const */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PConst pconstNode1;
        {
            // Block
          Object nullNode2 = null;
        TNumber tnumberNode3;
        tnumberNode3 = (TNumber)nodeArrayList1.get(0);

        pconstNode1 = new ANumberConst(null, tnumberNode3);
        }
	nodeList.add(pconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new193() /* reduce AAnumberconst2Const */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PConst pconstNode1;
        {
            // Block
        TMinus tminusNode2;
        TNumber tnumberNode3;
        tminusNode2 = (TMinus)nodeArrayList1.get(0);
        tnumberNode3 = (TNumber)nodeArrayList2.get(0);

        pconstNode1 = new ANumberConst(tminusNode2, tnumberNode3);
        }
	nodeList.add(pconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new194() /* reduce APidConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PConst pconstNode1;
        {
            // Block
        TProcessid tprocessidNode2;
        tprocessidNode2 = (TProcessid)nodeArrayList1.get(0);

        pconstNode1 = new APidConst(tprocessidNode2);
        }
	nodeList.add(pconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new195() /* reduce ANrPrConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PConst pconstNode1;
        {
            // Block
        TNrPr tnrprNode2;
        tnrprNode2 = (TNrPr)nodeArrayList1.get(0);

        pconstNode1 = new ANrPrConst(tnrprNode2);
        }
	nodeList.add(pconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new196() /* reduce ASemicolonSeparator */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PSeparator pseparatorNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList1.get(0);
	if(listNode2 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode2);
  	  //listNode3 = listNode2;
	}
        }

        pseparatorNode1 = new ASemicolonSeparator(listNode3);
        }
	nodeList.add(pseparatorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new197() /* reduce ARightarrowSeparator */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PSeparator pseparatorNode1;
        {
            // Block
        TRightarrow trightarrowNode2;
        trightarrowNode2 = (TRightarrow)nodeArrayList1.get(0);

        pseparatorNode1 = new ARightarrowSeparator(trightarrowNode2);
        }
	nodeList.add(pseparatorNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new198() /* reduce ATerminal$Module */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PModule pmoduleNode1;
        pmoduleNode1 = (PModule)nodeArrayList1.get(0);
	if(pmoduleNode1 != null)
	{
	  listNode2.add(pmoduleNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new199() /* reduce ANonTerminal$Module */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PModule pmoduleNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pmoduleNode2 = (PModule)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(pmoduleNode2 != null)
	{
	  listNode3.add(pmoduleNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new200() /* reduce ATerminal$Udecl */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PUdecl pudeclNode1;
        pudeclNode1 = (PUdecl)nodeArrayList1.get(0);
	if(pudeclNode1 != null)
	{
	  listNode2.add(pudeclNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new201() /* reduce ANonTerminal$Udecl */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PUdecl pudeclNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pudeclNode2 = (PUdecl)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(pudeclNode2 != null)
	{
	  listNode3.add(pudeclNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new202() /* reduce ATerminal$Semicolon */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        TSemicolon tsemicolonNode1;
        tsemicolonNode1 = (TSemicolon)nodeArrayList1.get(0);
	if(tsemicolonNode1 != null)
	{
	  listNode2.add(tsemicolonNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new203() /* reduce ANonTerminal$Semicolon */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        TSemicolon tsemicolonNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        tsemicolonNode2 = (TSemicolon)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(tsemicolonNode2 != null)
	{
	  listNode3.add(tsemicolonNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {23, SHIFT, 1}, {40, SHIFT, 2}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {57, SHIFT, 7}, {59, SHIFT, 8}, {60, SHIFT, 9}, {63, SHIFT, 10}, {64, SHIFT, 11}, {65, SHIFT, 12}, {70, SHIFT, 13}, {76, SHIFT, 14}, {77, SHIFT, 15}, {80, SHIFT, 16}, {81, SHIFT, 17}, {84, SHIFT, 18}, {86, SHIFT, 19}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, ERROR, 1}, {0, SHIFT, 38}, {62, SHIFT, 39}, },
			{{-1, REDUCE, 65}, {20, SHIFT, 40}, },
			{{-1, REDUCE, 53}, },
			{{-1, REDUCE, 54}, },
			{{-1, REDUCE, 55}, },
			{{-1, REDUCE, 60}, },
			{{-1, REDUCE, 69}, },
			{{-1, ERROR, 8}, {18, SHIFT, 41}, {73, SHIFT, 42}, },
			{{-1, REDUCE, 58}, },
			{{-1, REDUCE, 59}, {18, SHIFT, 44}, {26, SHIFT, 45}, },
			{{-1, ERROR, 11}, {18, SHIFT, 46}, },
			{{-1, ERROR, 12}, {18, SHIFT, 47}, },
			{{-1, REDUCE, 56}, },
			{{-1, ERROR, 14}, {91, SHIFT, 48}, },
			{{-1, ERROR, 15}, {91, SHIFT, 49}, },
			{{-1, REDUCE, 57}, },
			{{-1, REDUCE, 70}, },
			{{-1, ERROR, 18}, {18, SHIFT, 50}, },
			{{-1, ERROR, 19}, {91, SHIFT, 51}, },
			{{-1, REDUCE, 62}, },
			{{-1, REDUCE, 61}, },
			{{-1, ERROR, 22}, {94, ACCEPT, -1}, },
			{{-1, REDUCE, 198}, },
			{{-1, REDUCE, 1}, },
			{{-1, REDUCE, 2}, },
			{{-1, REDUCE, 9}, },
			{{-1, REDUCE, 10}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 12}, },
			{{-1, REDUCE, 13}, },
			{{-1, REDUCE, 3}, {22, SHIFT, 52}, {31, SHIFT, 53}, },
			{{-1, REDUCE, 5}, {22, SHIFT, 52}, {31, SHIFT, 53}, },
			{{-1, REDUCE, 7}, {22, SHIFT, 52}, {31, SHIFT, 53}, },
			{{-1, ERROR, 34}, {91, SHIFT, 58}, },
			{{-1, ERROR, 35}, {77, SHIFT, 61}, },
			{{-1, ERROR, 36}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {60, SHIFT, 9}, {63, SHIFT, 62}, {70, SHIFT, 13}, {80, SHIFT, 16}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, REDUCE, 0}, {23, SHIFT, 1}, {40, SHIFT, 2}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {57, SHIFT, 7}, {59, SHIFT, 8}, {60, SHIFT, 9}, {63, SHIFT, 10}, {64, SHIFT, 11}, {65, SHIFT, 12}, {70, SHIFT, 13}, {76, SHIFT, 14}, {77, SHIFT, 15}, {80, SHIFT, 16}, {81, SHIFT, 17}, {84, SHIFT, 18}, {86, SHIFT, 19}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, ERROR, 38}, {93, SHIFT, 65}, },
			{{-1, ERROR, 39}, {0, SHIFT, 66}, },
			{{-1, ERROR, 40}, {0, SHIFT, 67}, {5, SHIFT, 68}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 42}, {0, SHIFT, 67}, {5, SHIFT, 68}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, },
			{{-1, ERROR, 43}, {18, SHIFT, 124}, },
			{{-1, ERROR, 44}, {91, SHIFT, 125}, },
			{{-1, ERROR, 45}, {18, SHIFT, 127}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 48}, {16, SHIFT, 130}, },
			{{-1, ERROR, 49}, {16, SHIFT, 131}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 51}, {18, SHIFT, 133}, },
			{{-1, REDUCE, 202}, },
			{{-1, REDUCE, 197}, },
			{{-1, REDUCE, 4}, },
			{{-1, REDUCE, 196}, {22, SHIFT, 134}, },
			{{-1, REDUCE, 6}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 90}, {20, SHIFT, 135}, {26, SHIFT, 136}, {28, SHIFT, 137}, },
			{{-1, REDUCE, 49}, },
			{{-1, REDUCE, 51}, {24, SHIFT, 140}, },
			{{-1, ERROR, 61}, {91, SHIFT, 141}, },
			{{-1, REDUCE, 59}, },
			{{-1, ERROR, 63}, {91, SHIFT, 58}, },
			{{-1, REDUCE, 199}, },
			{{-1, REDUCE, 15}, {0, SHIFT, 143}, },
			{{-1, ERROR, 66}, {93, SHIFT, 144}, },
			{{-1, REDUCE, 192}, },
			{{-1, ERROR, 68}, {0, SHIFT, 145}, },
			{{-1, REDUCE, 190}, },
			{{-1, REDUCE, 194}, },
			{{-1, REDUCE, 195}, },
			{{-1, REDUCE, 191}, },
			{{-1, REDUCE, 189}, },
			{{-1, ERROR, 74}, {21, SHIFT, 146}, },
			{{-1, ERROR, 75}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 76}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 77}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 79}, {39, SHIFT, 153}, {91, SHIFT, 154}, },
			{{-1, ERROR, 80}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 81}, {18, SHIFT, 156}, },
			{{-1, REDUCE, 137}, },
			{{-1, ERROR, 83}, {16, SHIFT, 157}, },
			{{-1, ERROR, 84}, {18, SHIFT, 158}, },
			{{-1, ERROR, 85}, {27, SHIFT, 159}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {22, SHIFT, 52}, {31, SHIFT, 53}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 87}, {16, SHIFT, 163}, },
			{{-1, ERROR, 88}, {91, SHIFT, 164}, },
			{{-1, ERROR, 89}, {27, SHIFT, 159}, },
			{{-1, ERROR, 90}, {16, SHIFT, 166}, },
			{{-1, REDUCE, 152}, },
			{{-1, ERROR, 92}, {16, SHIFT, 167}, },
			{{-1, ERROR, 93}, {16, SHIFT, 168}, },
			{{-1, ERROR, 94}, {16, SHIFT, 169}, },
			{{-1, ERROR, 95}, {91, SHIFT, 170}, },
			{{-1, REDUCE, 151}, },
			{{-1, ERROR, 97}, {38, SHIFT, 79}, {91, SHIFT, 171}, },
			{{-1, ERROR, 98}, {38, SHIFT, 79}, {91, SHIFT, 171}, },
			{{-1, REDUCE, 99}, {16, SHIFT, 175}, {20, SHIFT, 176}, {28, SHIFT, 177}, {91, REDUCE, 61}, },
			{{-1, REDUCE, 83}, },
			{{-1, ERROR, 101}, {19, SHIFT, 179}, },
			{{-1, REDUCE, 72}, {22, SHIFT, 52}, {31, SHIFT, 53}, },
			{{-1, REDUCE, 149}, {1, SHIFT, 181}, {25, SHIFT, 182}, {26, SHIFT, 183}, {29, SHIFT, 184}, {30, SHIFT, 185}, {32, SHIFT, 186}, {33, SHIFT, 187}, {34, SHIFT, 188}, },
			{{-1, REDUCE, 134}, },
			{{-1, REDUCE, 135}, },
			{{-1, REDUCE, 148}, },
			{{-1, REDUCE, 136}, },
			{{-1, REDUCE, 84}, {87, SHIFT, 189}, },
			{{-1, REDUCE, 162}, },
			{{-1, REDUCE, 165}, {3, SHIFT, 190}, },
			{{-1, REDUCE, 167}, {4, SHIFT, 191}, {5, SHIFT, 192}, },
			{{-1, REDUCE, 170}, {6, SHIFT, 193}, },
			{{-1, REDUCE, 172}, {13, SHIFT, 194}, {14, SHIFT, 195}, {15, SHIFT, 196}, },
			{{-1, REDUCE, 176}, {7, SHIFT, 197}, },
			{{-1, REDUCE, 178}, {8, SHIFT, 198}, },
			{{-1, REDUCE, 180}, {10, SHIFT, 199}, },
			{{-1, REDUCE, 182}, {9, SHIFT, 200}, },
			{{-1, REDUCE, 184}, {11, SHIFT, 201}, },
			{{-1, REDUCE, 186}, {12, SHIFT, 202}, },
			{{-1, REDUCE, 188}, },
			{{-1, REDUCE, 143}, },
			{{-1, REDUCE, 150}, },
			{{-1, REDUCE, 67}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 45}, {24, SHIFT, 204}, },
			{{-1, ERROR, 126}, {19, SHIFT, 205}, },
			{{-1, ERROR, 127}, {91, SHIFT, 125}, },
			{{-1, ERROR, 128}, {19, SHIFT, 207}, },
			{{-1, ERROR, 129}, {19, SHIFT, 208}, },
			{{-1, ERROR, 130}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {17, SHIFT, 209}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 131}, {17, SHIFT, 212}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {57, SHIFT, 7}, {60, SHIFT, 9}, {63, SHIFT, 62}, {70, SHIFT, 13}, {80, SHIFT, 16}, {81, SHIFT, 17}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, ERROR, 132}, {19, SHIFT, 215}, },
			{{-1, ERROR, 133}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {57, SHIFT, 7}, {60, SHIFT, 9}, {63, SHIFT, 62}, {70, SHIFT, 13}, {80, SHIFT, 16}, {81, SHIFT, 17}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, REDUCE, 203}, },
			{{-1, ERROR, 135}, {0, SHIFT, 67}, {5, SHIFT, 68}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, },
			{{-1, ERROR, 136}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {20, SHIFT, 220}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 137}, {0, SHIFT, 67}, {5, SHIFT, 68}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, },
			{{-1, REDUCE, 92}, },
			{{-1, REDUCE, 91}, {26, SHIFT, 136}, },
			{{-1, ERROR, 140}, {91, SHIFT, 58}, },
			{{-1, ERROR, 141}, {16, SHIFT, 225}, },
			{{-1, REDUCE, 50}, },
			{{-1, REDUCE, 14}, },
			{{-1, ERROR, 144}, {0, SHIFT, 226}, },
			{{-1, REDUCE, 193}, },
			{{-1, REDUCE, 66}, },
			{{-1, REDUCE, 99}, {20, SHIFT, 176}, },
			{{-1, REDUCE, 149}, {25, SHIFT, 182}, {33, SHIFT, 227}, {34, SHIFT, 228}, },
			{{-1, REDUCE, 163}, },
			{{-1, REDUCE, 164}, },
			{{-1, ERROR, 151}, {17, SHIFT, 229}, {31, SHIFT, 230}, },
			{{-1, ERROR, 152}, {19, SHIFT, 231}, },
			{{-1, ERROR, 153}, {91, SHIFT, 232}, },
			{{-1, ERROR, 154}, {38, SHIFT, 233}, },
			{{-1, REDUCE, 142}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 157}, {38, SHIFT, 79}, {91, SHIFT, 171}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 160}, {67, SHIFT, 238}, },
			{{-1, REDUCE, 81}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 163}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 138}, },
			{{-1, ERROR, 165}, {55, SHIFT, 241}, },
			{{-1, ERROR, 166}, {38, SHIFT, 79}, {91, SHIFT, 171}, },
			{{-1, ERROR, 167}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 168}, {93, SHIFT, 244}, },
			{{-1, ERROR, 169}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 170}, {16, SHIFT, 246}, },
			{{-1, REDUCE, 99}, {20, SHIFT, 247}, },
			{{-1, REDUCE, 86}, },
			{{-1, REDUCE, 88}, {24, SHIFT, 248}, {25, SHIFT, 182}, },
			{{-1, REDUCE, 87}, },
			{{-1, ERROR, 175}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {17, SHIFT, 249}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 176}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 100}, },
			{{-1, REDUCE, 35}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 181}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 182}, {91, SHIFT, 257}, },
			{{-1, ERROR, 183}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 128}, },
			{{-1, REDUCE, 129}, },
			{{-1, ERROR, 186}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 187}, {0, SHIFT, 67}, {5, SHIFT, 68}, {13, SHIFT, 260}, {16, SHIFT, 261}, {20, SHIFT, 262}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, ERROR, 188}, {0, SHIFT, 67}, {5, SHIFT, 68}, {13, SHIFT, 269}, {16, SHIFT, 261}, {20, SHIFT, 270}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, ERROR, 189}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {41, SHIFT, 80}, {45, SHIFT, 82}, {47, SHIFT, 83}, {50, SHIFT, 85}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {58, SHIFT, 89}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 272}, },
			{{-1, ERROR, 190}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 191}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 192}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 193}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 194}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 195}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 196}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 197}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 198}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 199}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 200}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 201}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 202}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 203}, {19, SHIFT, 287}, },
			{{-1, ERROR, 204}, {91, SHIFT, 125}, },
			{{-1, REDUCE, 43}, },
			{{-1, ERROR, 206}, {19, SHIFT, 289}, },
			{{-1, REDUCE, 37}, },
			{{-1, REDUCE, 39}, },
			{{-1, ERROR, 209}, {18, SHIFT, 290}, },
			{{-1, ERROR, 210}, {17, SHIFT, 291}, },
			{{-1, REDUCE, 117}, {24, SHIFT, 292}, },
			{{-1, ERROR, 212}, {18, SHIFT, 293}, {73, SHIFT, 42}, {78, SHIFT, 294}, },
			{{-1, ERROR, 213}, {17, SHIFT, 297}, },
			{{-1, REDUCE, 47}, {22, SHIFT, 52}, {31, SHIFT, 53}, },
			{{-1, REDUCE, 38}, },
			{{-1, REDUCE, 200}, },
			{{-1, REDUCE, 41}, {22, SHIFT, 52}, {31, SHIFT, 53}, },
			{{-1, ERROR, 218}, {19, SHIFT, 300}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {57, SHIFT, 7}, {60, SHIFT, 9}, {63, SHIFT, 62}, {70, SHIFT, 13}, {80, SHIFT, 16}, {81, SHIFT, 17}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, ERROR, 219}, {21, SHIFT, 302}, },
			{{-1, ERROR, 220}, {0, SHIFT, 67}, {5, SHIFT, 68}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, },
			{{-1, REDUCE, 96}, },
			{{-1, REDUCE, 98}, },
			{{-1, REDUCE, 93}, },
			{{-1, REDUCE, 52}, },
			{{-1, ERROR, 225}, {17, SHIFT, 304}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {57, SHIFT, 7}, {60, SHIFT, 9}, {63, SHIFT, 62}, {70, SHIFT, 13}, {80, SHIFT, 16}, {81, SHIFT, 17}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, REDUCE, 16}, },
			{{-1, ERROR, 227}, {20, SHIFT, 262}, },
			{{-1, ERROR, 228}, {20, SHIFT, 270}, },
			{{-1, REDUCE, 146}, },
			{{-1, ERROR, 230}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {22, SHIFT, 52}, {31, SHIFT, 53}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 232}, {38, SHIFT, 309}, },
			{{-1, REDUCE, 103}, },
			{{-1, ERROR, 234}, {19, SHIFT, 310}, },
			{{-1, ERROR, 235}, {17, SHIFT, 311}, {25, SHIFT, 182}, },
			{{-1, ERROR, 236}, {19, SHIFT, 312}, },
			{{-1, REDUCE, 144}, {27, SHIFT, 159}, },
			{{-1, REDUCE, 133}, },
			{{-1, REDUCE, 82}, },
			{{-1, ERROR, 240}, {17, SHIFT, 314}, },
			{{-1, REDUCE, 132}, },
			{{-1, ERROR, 242}, {17, SHIFT, 315}, {25, SHIFT, 182}, },
			{{-1, ERROR, 243}, {17, SHIFT, 316}, },
			{{-1, ERROR, 244}, {17, SHIFT, 317}, {24, SHIFT, 318}, },
			{{-1, ERROR, 245}, {17, SHIFT, 319}, },
			{{-1, ERROR, 246}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {17, SHIFT, 320}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 247}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 248}, {38, SHIFT, 79}, {91, SHIFT, 171}, },
			{{-1, REDUCE, 130}, },
			{{-1, ERROR, 250}, {17, SHIFT, 324}, },
			{{-1, ERROR, 251}, {21, SHIFT, 325}, },
			{{-1, REDUCE, 80}, },
			{{-1, REDUCE, 73}, },
			{{-1, REDUCE, 107}, },
			{{-1, REDUCE, 115}, },
			{{-1, REDUCE, 117}, {16, SHIFT, 326}, {24, SHIFT, 292}, },
			{{-1, REDUCE, 101}, {20, SHIFT, 247}, },
			{{-1, REDUCE, 127}, },
			{{-1, REDUCE, 108}, },
			{{-1, ERROR, 260}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 261}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, ERROR, 261}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 261}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, ERROR, 262}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 261}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, REDUCE, 126}, },
			{{-1, ERROR, 264}, {16, SHIFT, 331}, },
			{{-1, REDUCE, 123}, {25, SHIFT, 182}, },
			{{-1, REDUCE, 110}, },
			{{-1, REDUCE, 119}, {16, SHIFT, 332}, {24, SHIFT, 333}, },
			{{-1, REDUCE, 125}, },
			{{-1, ERROR, 269}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 261}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, ERROR, 270}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 261}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, REDUCE, 109}, },
			{{-1, REDUCE, 99}, {16, SHIFT, 175}, {20, SHIFT, 176}, },
			{{-1, REDUCE, 85}, },
			{{-1, REDUCE, 166}, },
			{{-1, REDUCE, 168}, },
			{{-1, REDUCE, 169}, },
			{{-1, REDUCE, 171}, },
			{{-1, REDUCE, 175}, },
			{{-1, REDUCE, 174}, },
			{{-1, REDUCE, 173}, },
			{{-1, REDUCE, 177}, },
			{{-1, REDUCE, 179}, },
			{{-1, REDUCE, 181}, },
			{{-1, REDUCE, 183}, },
			{{-1, REDUCE, 185}, },
			{{-1, REDUCE, 187}, },
			{{-1, REDUCE, 36}, },
			{{-1, REDUCE, 46}, },
			{{-1, REDUCE, 44}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 291}, {18, SHIFT, 337}, },
			{{-1, ERROR, 292}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 294}, {16, SHIFT, 340}, },
			{{-1, ERROR, 295}, {18, SHIFT, 341}, {78, SHIFT, 294}, },
			{{-1, ERROR, 296}, {18, SHIFT, 343}, },
			{{-1, ERROR, 297}, {18, SHIFT, 344}, {73, SHIFT, 42}, {78, SHIFT, 294}, },
			{{-1, ERROR, 298}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {57, SHIFT, 7}, {60, SHIFT, 9}, {63, SHIFT, 62}, {70, SHIFT, 13}, {80, SHIFT, 16}, {81, SHIFT, 17}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, REDUCE, 42}, },
			{{-1, REDUCE, 40}, },
			{{-1, REDUCE, 201}, },
			{{-1, REDUCE, 94}, {26, SHIFT, 136}, },
			{{-1, ERROR, 303}, {21, SHIFT, 349}, },
			{{-1, ERROR, 304}, {18, SHIFT, 350}, {73, SHIFT, 42}, {78, SHIFT, 294}, },
			{{-1, ERROR, 305}, {17, SHIFT, 353}, },
			{{-1, ERROR, 306}, {28, SHIFT, 354}, },
			{{-1, REDUCE, 78}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 104}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {22, SHIFT, 52}, {31, SHIFT, 53}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 160}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {22, SHIFT, 52}, {31, SHIFT, 53}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 145}, },
			{{-1, REDUCE, 153}, },
			{{-1, REDUCE, 147}, },
			{{-1, REDUCE, 154}, },
			{{-1, REDUCE, 140}, },
			{{-1, ERROR, 318}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 139}, },
			{{-1, REDUCE, 156}, {73, SHIFT, 42}, },
			{{-1, ERROR, 321}, {17, SHIFT, 362}, },
			{{-1, ERROR, 322}, {21, SHIFT, 363}, },
			{{-1, REDUCE, 89}, },
			{{-1, REDUCE, 131}, },
			{{-1, REDUCE, 105}, {37, SHIFT, 364}, },
			{{-1, ERROR, 326}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 102}, },
			{{-1, ERROR, 328}, {14, SHIFT, 366}, },
			{{-1, ERROR, 329}, {17, SHIFT, 367}, },
			{{-1, ERROR, 330}, {21, SHIFT, 368}, },
			{{-1, ERROR, 331}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, ERROR, 332}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 261}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, ERROR, 333}, {0, SHIFT, 67}, {5, SHIFT, 68}, {16, SHIFT, 261}, {35, SHIFT, 263}, {38, SHIFT, 79}, {53, SHIFT, 264}, {54, SHIFT, 69}, {74, SHIFT, 70}, {75, SHIFT, 71}, {82, SHIFT, 72}, {85, SHIFT, 73}, {91, SHIFT, 171}, },
			{{-1, ERROR, 334}, {14, SHIFT, 372}, },
			{{-1, ERROR, 335}, {21, SHIFT, 373}, },
			{{-1, ERROR, 336}, {19, SHIFT, 374}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 118}, },
			{{-1, ERROR, 339}, {19, SHIFT, 376}, },
			{{-1, ERROR, 340}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 342}, {18, SHIFT, 379}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 345}, {18, SHIFT, 382}, {78, SHIFT, 294}, },
			{{-1, ERROR, 346}, {18, SHIFT, 384}, },
			{{-1, REDUCE, 48}, },
			{{-1, REDUCE, 95}, },
			{{-1, ERROR, 349}, {68, SHIFT, 385}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 351}, {18, SHIFT, 387}, {78, SHIFT, 294}, },
			{{-1, ERROR, 352}, {18, SHIFT, 389}, },
			{{-1, ERROR, 353}, {18, SHIFT, 390}, {73, SHIFT, 42}, {78, SHIFT, 294}, },
			{{-1, ERROR, 354}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {38, SHIFT, 79}, {47, SHIFT, 83}, {52, SHIFT, 87}, {54, SHIFT, 69}, {61, SHIFT, 90}, {66, SHIFT, 91}, {69, SHIFT, 92}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {91, SHIFT, 147}, },
			{{-1, REDUCE, 79}, },
			{{-1, REDUCE, 74}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 76}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 360}, {17, SHIFT, 396}, },
			{{-1, REDUCE, 158}, },
			{{-1, REDUCE, 157}, {73, SHIFT, 42}, },
			{{-1, REDUCE, 105}, },
			{{-1, ERROR, 364}, {91, SHIFT, 398}, },
			{{-1, ERROR, 365}, {17, SHIFT, 399}, },
			{{-1, REDUCE, 112}, },
			{{-1, REDUCE, 122}, },
			{{-1, REDUCE, 114}, },
			{{-1, ERROR, 369}, {17, SHIFT, 400}, },
			{{-1, ERROR, 370}, {17, SHIFT, 401}, },
			{{-1, REDUCE, 120}, },
			{{-1, REDUCE, 111}, },
			{{-1, REDUCE, 113}, },
			{{-1, REDUCE, 17}, },
			{{-1, ERROR, 375}, {19, SHIFT, 402}, },
			{{-1, REDUCE, 19}, },
			{{-1, ERROR, 377}, {17, SHIFT, 403}, },
			{{-1, ERROR, 378}, {19, SHIFT, 404}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 380}, {19, SHIFT, 406}, },
			{{-1, ERROR, 381}, {19, SHIFT, 407}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 383}, {18, SHIFT, 409}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 385}, {18, SHIFT, 411}, },
			{{-1, ERROR, 386}, {19, SHIFT, 412}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 388}, {18, SHIFT, 414}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 391}, {18, SHIFT, 417}, {78, SHIFT, 294}, },
			{{-1, ERROR, 392}, {18, SHIFT, 419}, },
			{{-1, ERROR, 393}, {17, SHIFT, 420}, },
			{{-1, REDUCE, 75}, },
			{{-1, REDUCE, 77}, },
			{{-1, REDUCE, 141}, },
			{{-1, REDUCE, 159}, },
			{{-1, REDUCE, 155}, },
			{{-1, REDUCE, 116}, },
			{{-1, REDUCE, 124}, },
			{{-1, REDUCE, 121}, },
			{{-1, REDUCE, 18}, },
			{{-1, REDUCE, 68}, },
			{{-1, REDUCE, 23}, },
			{{-1, ERROR, 405}, {19, SHIFT, 421}, },
			{{-1, REDUCE, 27}, },
			{{-1, REDUCE, 21}, },
			{{-1, ERROR, 408}, {19, SHIFT, 422}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 410}, {19, SHIFT, 424}, },
			{{-1, ERROR, 411}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {60, SHIFT, 9}, {63, SHIFT, 62}, {70, SHIFT, 13}, {80, SHIFT, 16}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, REDUCE, 20}, },
			{{-1, ERROR, 413}, {19, SHIFT, 427}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 415}, {19, SHIFT, 429}, },
			{{-1, ERROR, 416}, {19, SHIFT, 430}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 418}, {18, SHIFT, 432}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, REDUCE, 161}, },
			{{-1, REDUCE, 31}, },
			{{-1, REDUCE, 25}, },
			{{-1, ERROR, 423}, {19, SHIFT, 434}, },
			{{-1, REDUCE, 29}, },
			{{-1, REDUCE, 63}, {24, SHIFT, 435}, },
			{{-1, ERROR, 426}, {19, SHIFT, 436}, },
			{{-1, REDUCE, 24}, },
			{{-1, ERROR, 428}, {19, SHIFT, 437}, },
			{{-1, REDUCE, 28}, },
			{{-1, REDUCE, 22}, },
			{{-1, ERROR, 431}, {19, SHIFT, 438}, },
			{{-1, REDUCE, 71}, {0, SHIFT, 67}, {1, SHIFT, 75}, {2, SHIFT, 76}, {5, SHIFT, 68}, {16, SHIFT, 77}, {18, SHIFT, 78}, {38, SHIFT, 79}, {41, SHIFT, 80}, {42, SHIFT, 81}, {43, SHIFT, 3}, {44, SHIFT, 4}, {45, SHIFT, 82}, {46, SHIFT, 5}, {47, SHIFT, 83}, {48, SHIFT, 6}, {49, SHIFT, 84}, {50, SHIFT, 85}, {51, SHIFT, 86}, {52, SHIFT, 87}, {54, SHIFT, 69}, {56, SHIFT, 88}, {57, SHIFT, 7}, {58, SHIFT, 89}, {60, SHIFT, 9}, {61, SHIFT, 90}, {63, SHIFT, 62}, {66, SHIFT, 91}, {69, SHIFT, 92}, {70, SHIFT, 13}, {71, SHIFT, 93}, {72, SHIFT, 94}, {74, SHIFT, 70}, {75, SHIFT, 71}, {79, SHIFT, 95}, {80, SHIFT, 16}, {81, SHIFT, 17}, {82, SHIFT, 72}, {83, SHIFT, 96}, {85, SHIFT, 73}, {88, SHIFT, 20}, {89, SHIFT, 97}, {90, SHIFT, 98}, {91, SHIFT, 99}, },
			{{-1, ERROR, 433}, {19, SHIFT, 440}, },
			{{-1, REDUCE, 33}, },
			{{-1, ERROR, 435}, {43, SHIFT, 3}, {44, SHIFT, 4}, {46, SHIFT, 5}, {48, SHIFT, 6}, {60, SHIFT, 9}, {63, SHIFT, 62}, {70, SHIFT, 13}, {80, SHIFT, 16}, {88, SHIFT, 20}, {91, SHIFT, 21}, },
			{{-1, REDUCE, 97}, },
			{{-1, REDUCE, 32}, },
			{{-1, REDUCE, 26}, },
			{{-1, ERROR, 439}, {19, SHIFT, 442}, },
			{{-1, REDUCE, 30}, },
			{{-1, REDUCE, 64}, },
			{{-1, REDUCE, 34}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 22}, },
			{{-1, 23}, {37, 64}, },
			{{-1, 24}, },
			{{-1, 25}, },
			{{-1, 26}, },
			{{-1, 27}, },
			{{-1, 28}, },
			{{-1, 29}, },
			{{-1, 30}, },
			{{-1, 31}, },
			{{-1, 216}, {218, 301}, },
			{{-1, 32}, },
			{{-1, 126}, {127, 206}, {204, 288}, },
			{{-1, 213}, {225, 305}, {298, 347}, },
			{{-1, 100}, {0, 33}, {37, 33}, {131, 214}, {133, 217}, {218, 217}, {225, 214}, {298, 214}, },
			{{-1, 59}, {63, 142}, {140, 224}, },
			{{-1, 34}, {36, 63}, {411, 425}, {435, 425}, },
			{{-1, 426}, {435, 441}, },
			{{-1, 35}, },
			{{-1, 43}, {212, 295}, {297, 345}, {304, 351}, {320, 361}, {353, 391}, {362, 397}, },
			{{-1, 296}, {295, 342}, {297, 346}, {304, 352}, {345, 383}, {351, 388}, {353, 392}, {391, 418}, },
			{{-1, 36}, },
			{{-1, 101}, {46, 128}, {47, 129}, {50, 132}, {78, 152}, {86, 161}, {124, 203}, {156, 234}, {158, 236}, {159, 237}, {162, 239}, {177, 252}, {180, 253}, {231, 307}, {290, 336}, {293, 339}, {308, 355}, {310, 356}, {312, 358}, {337, 375}, {341, 378}, {343, 380}, {344, 381}, {350, 386}, {357, 394}, {359, 395}, {379, 405}, {382, 408}, {384, 410}, {387, 413}, {389, 415}, {390, 416}, {409, 423}, {414, 428}, {417, 431}, {419, 433}, {432, 439}, },
			{{-1, 102}, },
			{{-1, 172}, {98, 174}, {248, 323}, },
			{{-1, 60}, },
			{{-1, 138}, {139, 223}, {302, 348}, },
			{{-1, 139}, },
			{{-1, 103}, {75, 148}, {76, 148}, {77, 148}, {80, 148}, {97, 173}, {98, 173}, {130, 148}, {136, 148}, {157, 235}, {163, 148}, {166, 242}, {167, 148}, {169, 148}, {175, 148}, {176, 148}, {181, 148}, {183, 148}, {186, 148}, {187, 265}, {188, 265}, {190, 148}, {191, 148}, {192, 148}, {193, 148}, {194, 148}, {195, 148}, {196, 148}, {197, 148}, {198, 148}, {199, 148}, {200, 148}, {201, 148}, {202, 148}, {230, 148}, {246, 148}, {247, 148}, {248, 173}, {260, 265}, {261, 265}, {262, 265}, {269, 265}, {270, 265}, {292, 148}, {318, 148}, {326, 148}, {331, 148}, {332, 265}, {333, 265}, {340, 148}, {354, 148}, },
			{{-1, 178}, {257, 327}, },
			{{-1, -1}, },
			{{-1, 104}, },
			{{-1, 105}, },
			{{-1, 106}, },
			{{-1, 254}, {186, 259}, },
			{{-1, 255}, {130, 210}, {175, 250}, {246, 321}, {292, 338}, {318, 360}, {326, 365}, },
			{{-1, 266}, {188, 271}, {260, 328}, {261, 329}, {262, 330}, {269, 334}, {270, 335}, {332, 370}, {333, 371}, },
			{{-1, 267}, },
			{{-1, 107}, },
			{{-1, 108}, {189, 273}, },
			{{-1, 160}, {89, 165}, {237, 313}, },
			{{-1, 109}, {75, 149}, {76, 150}, },
			{{-1, 110}, },
			{{-1, 111}, {190, 274}, },
			{{-1, 112}, {191, 275}, {192, 276}, },
			{{-1, 113}, {193, 277}, },
			{{-1, 114}, {194, 278}, {195, 279}, {196, 280}, },
			{{-1, 115}, {197, 281}, },
			{{-1, 116}, {198, 282}, },
			{{-1, 117}, {199, 283}, },
			{{-1, 118}, {200, 284}, },
			{{-1, 119}, {201, 285}, },
			{{-1, 120}, {202, 286}, },
			{{-1, 121}, {77, 151}, {80, 155}, {130, 211}, {136, 221}, {163, 240}, {167, 243}, {169, 245}, {175, 211}, {176, 251}, {181, 256}, {183, 258}, {186, 256}, {230, 306}, {246, 211}, {247, 322}, {292, 211}, {318, 211}, {326, 211}, {331, 369}, {340, 377}, {354, 393}, },
			{{-1, 122}, {40, 74}, {42, 123}, {135, 219}, {137, 222}, {187, 268}, {188, 268}, {220, 303}, {260, 268}, {261, 268}, {262, 268}, {269, 268}, {270, 268}, {332, 268}, {333, 268}, },
			{{-1, 54}, {32, 56}, {33, 57}, {86, 162}, {102, 180}, {214, 298}, {217, 299}, {231, 308}, {310, 357}, {312, 359}, },
			{{-1, 37}, },
			{{-1, 218}, },
			{{-1, 55}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: '#', 'active', 'bit', 'bool', 'byte', 'chan', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unsigned', name",
			"expecting: number, 'line'",
			"expecting: '[', 'proctype'",
			"expecting: '}', ',', name",
			"expecting: 'bit', 'bool', 'byte', 'chan', 'int', 'mtype', 'pid', 'short', 'unsigned', name",
			"expecting: '{', 'priority'",
			"expecting: '{', '=', name",
			"expecting: '{'",
			"expecting: name",
			"expecting: EOF",
			"expecting: '#', 'active', 'bit', 'bool', 'byte', 'chan', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unsigned', name, EOF",
			"expecting: ';', '#', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unsigned', name, EOF",
			"expecting: 'proctype'",
			"expecting: string",
			"expecting: number",
			"expecting: number, '-', 'false', '_pid', '_nr_pr', 'skip', 'true'",
			"expecting: number, '!', '~', '-', '(', '{', '}', ''', 'assert', 'atomic', 'bit', 'bool', 'break', 'byte', chanop, 'chan', 'd_step', 'do', 'else', 'enabled', 'false', 'goto', 'hidden', 'if', 'int', 'len', 'mtype', 'np_', 'pc_value', 'pid', 'printf', 'printm', '_pid', '_nr_pr', 'run', 'short', 'show', 'skip', 'timeout', 'true', 'unsigned', 'xr', 'xs', name",
			"expecting: '('",
			"expecting: number, '!', '~', '-', '(', '{', '}', ';', '#', '::', ''', 'active', 'assert', 'atomic', 'bit', 'bool', 'break', 'byte', chanop, 'chan', 'd_step', 'do', 'else', 'enabled', 'false', 'fi', 'goto', 'hidden', 'if', 'init', 'int', 'len', 'mtype', 'never', 'notrace', 'np_', 'od', 'pc_value', 'pid', 'printf', 'printm', '_pid', '_nr_pr', 'inline', 'proctype', 'run', 'short', 'show', 'skip', 'timeout', 'trace', 'true', 'typedef', 'unsigned', 'xr', 'xs', name, EOF",
			"expecting: number, '!', '~', '-', '(', '{', '}', '#', '::', ''', 'active', 'assert', 'atomic', 'bit', 'bool', 'break', 'byte', chanop, 'chan', 'd_step', 'do', 'else', 'enabled', 'false', 'fi', 'goto', 'hidden', 'if', 'init', 'int', 'len', 'mtype', 'never', 'notrace', 'np_', 'od', 'pc_value', 'pid', 'printf', 'printm', '_pid', '_nr_pr', 'inline', 'proctype', 'run', 'short', 'show', 'skip', 'timeout', 'trace', 'true', 'typedef', 'unsigned', 'xr', 'xs', name, EOF",
			"expecting: ')', '}', '[', ';', '#', ',', '=', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unsigned', name, EOF",
			"expecting: ')', '}', ';', '#', '::', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unsigned', name, EOF",
			"expecting: ')', '}', ';', '#', ',', '::', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unsigned', name, EOF",
			"expecting: number, '#', 'active', 'bit', 'bool', 'byte', 'chan', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unsigned', name, EOF",
			"expecting: multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '{', '}', ']', ';', '#', ',', '=', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'provided', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: ']'",
			"expecting: number, '-', '(', ''', chanop, 'enabled', 'false', 'len', 'np_', 'pc_value', '_pid', '_nr_pr', 'run', 'skip', 'timeout', 'true', name",
			"expecting: number, '!', '~', '-', '(', ''', chanop, 'enabled', 'false', 'len', 'np_', 'pc_value', '_pid', '_nr_pr', 'run', 'skip', 'timeout', 'true', name",
			"expecting: '\', name",
			"expecting: '}', ';', '::', '->', 'fi', 'od', 'unless'",
			"expecting: '::'",
			"expecting: number, '!', '~', '-', '(', '{', '}', ';', '::', '->', ''', 'assert', 'atomic', 'bit', 'bool', 'break', 'byte', chanop, 'chan', 'd_step', 'do', 'else', 'enabled', 'false', 'fi', 'goto', 'hidden', 'if', 'int', 'len', 'mtype', 'np_', 'od', 'pc_value', 'pid', 'printf', 'printm', '_pid', '_nr_pr', 'run', 'short', 'show', 'skip', 'timeout', 'true', 'unsigned', 'xr', 'xs', name",
			"expecting: multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: ''', name",
			"expecting: '!', multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', '}', '[', ';', '.', '=', '::', ':', '++', '--', '->', '!!', '??', '?', 'fi', 'od', 'unless', name",
			"expecting: '}', ';', '::', '->', 'fi', 'od'",
			"expecting: '}'",
			"expecting: '!', multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '}', ';', '.', '=', '::', '++', '--', '->', '!!', '??', '?', 'fi', 'od', 'unless'",
			"expecting: '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: eqop, '&', '|', '^', '&&', '||', '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '&', '|', '^', '&&', '||', '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '|', '^', '&&', '||', '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '|', '&&', '||', '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '&&', '||', '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '||', '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '{', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'provided', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '}', ','",
			"expecting: number, '!', '~', '-', '(', ')', ''', chanop, 'enabled', 'false', 'len', 'np_', 'pc_value', '_pid', '_nr_pr', 'run', 'skip', 'timeout', 'true', name",
			"expecting: ')', 'bit', 'bool', 'byte', 'chan', 'hidden', 'int', 'mtype', 'pid', 'short', 'show', 'unsigned', name",
			"expecting: 'bit', 'bool', 'byte', 'chan', 'hidden', 'int', 'mtype', 'pid', 'short', 'show', 'unsigned', name",
			"expecting: number, '!', '~', '-', '(', '[', ''', chanop, 'enabled', 'false', 'len', 'np_', 'pc_value', '_pid', '_nr_pr', 'run', 'skip', 'timeout', 'true', name",
			"expecting: ')', '}', ';', '#', ',', '=', '::', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unsigned', name, EOF",
			"expecting: multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', '[', ']', ';', '#', ',', '.', '::', ':', '->', '??', '?', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', ']', ';', '#', ',', '.', '::', ':', '->', '??', '?', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: ')', '->'",
			"expecting: '''",
			"expecting: number, '!', '~', '-', '(', '{', '::', ''', 'assert', 'atomic', 'bit', 'bool', 'break', 'byte', chanop, 'chan', 'd_step', 'do', 'else', 'enabled', 'false', 'fi', 'goto', 'hidden', 'if', 'int', 'len', 'mtype', 'np_', 'od', 'pc_value', 'pid', 'printf', 'printm', '_pid', '_nr_pr', 'run', 'short', 'show', 'skip', 'timeout', 'true', 'unsigned', 'xr', 'xs', name",
			"expecting: 'od'",
			"expecting: '}', '::', 'fi', 'od'",
			"expecting: number, '!', '~', '-', '(', '{', '}', '::', ''', 'assert', 'atomic', 'bit', 'bool', 'break', 'byte', chanop, 'chan', 'd_step', 'do', 'else', 'enabled', 'false', 'fi', 'goto', 'hidden', 'if', 'int', 'len', 'mtype', 'np_', 'od', 'pc_value', 'pid', 'printf', 'printm', '_pid', '_nr_pr', 'run', 'short', 'show', 'skip', 'timeout', 'true', 'unsigned', 'xr', 'xs', name",
			"expecting: 'fi'",
			"expecting: '>', '(', ')', '}', '[', ']', ';', ',', '.', '::', '->', 'fi', 'od', 'unless'",
			"expecting: '}', ';', ',', '.', '::', '->', 'fi', 'od'",
			"expecting: '!', multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', ']', ';', '#', ',', '.', '=', '::', ':', '++', '--', '->', '!!', '??', '?', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: number, '-', '<', '(', '[', '_', ''', 'eval', 'false', '_pid', '_nr_pr', 'skip', 'true', name",
			"expecting: number, '!', '~', '-', '(', ''', 'assert', 'break', chanop, 'do', 'enabled', 'false', 'goto', 'if', 'len', 'np_', 'pc_value', 'printf', 'printm', '_pid', '_nr_pr', 'run', 'skip', 'timeout', 'true', name",
			"expecting: ')'",
			"expecting: ')', '}', ';', ',', '::', '->', 'fi', 'od', 'unless'",
			"expecting: '{', 'priority', 'provided'",
			"expecting: ')', ';', '->'",
			"expecting: '}', 'bit', 'bool', 'byte', 'chan', 'hidden', 'int', 'mtype', 'pid', 'short', 'show', 'unsigned', name",
			"expecting: '}', ';', '->', 'bit', 'bool', 'byte', 'chan', 'hidden', 'int', 'mtype', 'pid', 'short', 'show', 'unsigned', name",
			"expecting: '['",
			"expecting: ')', '.'",
			"expecting: '::', 'fi', 'od'",
			"expecting: ')', ','",
			"expecting: '(', '}', ';', ',', '::', '->', 'fi', 'od', 'unless'",
			"expecting: '!', multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', '[', ']', ';', '#', ',', '.', '=', '::', ':', '++', '--', '->', '!!', '??', '?', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: number, '-', '(', '_', ''', 'eval', 'false', '_pid', '_nr_pr', 'skip', 'true', name",
			"expecting: '>', '(', ')', '}', ']', ';', ',', '::', '->', 'fi', 'od', 'unless'",
			"expecting: '>', '(', ')', '}', ']', ';', ',', '.', '::', '->', 'fi', 'od', 'unless'",
			"expecting: '!', multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', '}', '[', ';', '.', '=', '::', '++', '--', '->', '!!', '??', '?', 'fi', 'od'",
			"expecting: '{', 'provided'",
			"expecting: ':'",
			"expecting: 'fi', 'od'",
			"expecting: multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', ']', ';', '#', ',', '::', ':', '->', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'priority', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '!', multop, '+', '-', shiftop, eqop, '&', '|', '^', '&&', '||', '<', '>', relop, '(', ')', '}', ']', ';', '#', ',', '.', '=', '::', ':', '++', '--', '->', '!!', '??', '?', '@', 'active', 'bit', 'bool', 'byte', 'chan', 'fi', 'hidden', 'init', 'int', 'mtype', 'never', 'notrace', 'od', 'pid', 'inline', 'proctype', 'short', 'show', 'trace', 'typedef', 'unless', 'unsigned', name, EOF",
			"expecting: '>'",
			"expecting: ')', '}', ';', '::', '->', 'fi', 'od', 'unless'",
			"expecting: 'of'",
			"expecting: '>', ')', '}', ']', ';', '::', '->', 'fi', 'od', 'unless'",
        };*/
    private static int[] errors;
/*      {
			0, 1, 2, 3, 3, 3, 3, 4, 5, 3, 6, 7, 7, 3, 8, 8, 3, 4, 7, 8, 3, 3, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 8, 12, 4, 10, 13, 14, 15, 16, 15, 7, 8, 7, 16, 16, 17, 17, 16, 7, 18, 19, 10, 18, 10, 10, 20, 21, 22, 8, 3, 8, 10, 23, 13, 24, 14, 24, 24, 24, 24, 24, 25, 26, 26, 27, 16, 28, 27, 7, 29, 17, 7, 30, 31, 17, 8, 30, 17, 32, 17, 17, 17, 8, 32, 33, 33, 34, 35, 36, 35, 37, 29, 29, 32, 29, 29, 32, 32, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 29, 32, 48, 16, 49, 36, 8, 36, 36, 50, 51, 36, 52, 18, 15, 53, 15, 22, 54, 8, 17, 21, 10, 14, 24, 12, 55, 56, 32, 32, 57, 36, 8, 58, 29, 16, 33, 16, 59, 60, 61, 62, 27, 29, 63, 33, 27, 13, 27, 17, 64, 35, 65, 35, 50, 27, 62, 66, 10, 62, 27, 8, 27, 29, 29, 27, 67, 67, 68, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 36, 8, 11, 36, 10, 10, 7, 69, 70, 71, 69, 72, 10, 73, 74, 73, 25, 15, 22, 54, 22, 21, 51, 10, 75, 75, 32, 27, 31, 58, 66, 36, 76, 36, 77, 29, 61, 69, 29, 76, 69, 78, 69, 50, 27, 33, 29, 69, 25, 61, 61, 29, 29, 79, 80, 29, 29, 81, 81, 81, 82, 17, 83, 29, 82, 82, 81, 81, 29, 84, 35, 38, 39, 39, 40, 41, 41, 41, 42, 43, 44, 45, 46, 47, 10, 36, 11, 16, 7, 27, 16, 17, 85, 7, 71, 52, 73, 11, 73, 54, 25, 71, 69, 86, 61, 62, 66, 31, 32, 31, 87, 32, 32, 32, 29, 27, 29, 88, 69, 25, 35, 29, 89, 27, 66, 90, 69, 25, 27, 81, 81, 90, 25, 36, 16, 91, 36, 27, 16, 7, 16, 16, 85, 7, 69, 22, 92, 16, 85, 7, 71, 27, 61, 61, 62, 61, 62, 69, 32, 88, 66, 8, 69, 29, 93, 32, 69, 69, 93, 29, 32, 10, 36, 10, 69, 36, 16, 36, 36, 16, 7, 16, 7, 36, 16, 7, 16, 16, 85, 7, 69, 61, 61, 29, 32, 32, 29, 82, 93, 10, 7, 10, 36, 10, 10, 36, 16, 36, 4, 10, 36, 16, 36, 36, 16, 7, 16, 32, 10, 10, 36, 10, 49, 36, 10, 36, 10, 10, 36, 16, 36, 10, 4, 22, 10, 10, 36, 10, 36, 10, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
