/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.worksheet;

import com.google.common.base.Preconditions;
import de.prob.web.WebUtils;
import de.prob.web.views.Worksheet;
import de.prob.web.worksheet.EChangeEffect;
import de.prob.web.worksheet.IBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;

public abstract class AbstractBox
implements IBox {
    protected String id;
    protected Worksheet owner;
    protected Bindings bindings = null;

    protected Map<String, String> makeHtml(String id, String html) {
        return WebUtils.wrap("cmd", "Worksheet.render", "box", id, "html", html);
    }

    protected List<Object> pack(Map<String, String> ... maps) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Map<String, String> map : maps) {
            res.add(map);
        }
        return res;
    }

    protected void freezeBindings() {
        this.owner.getGroovy().getBindings(100);
    }

    @Override
    public void setId(String id) {
        Preconditions.checkState((this.id == null ? 1 : 0) != 0);
        this.id = id;
    }

    @Override
    public void setOwner(Worksheet owner) {
        Preconditions.checkState((this.owner == null ? 1 : 0) != 0);
        this.owner = owner;
    }

    private Map<String, String> create(String cmd) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.putAll(this.getAdditionalEntries());
        m.putAll(WebUtils.wrap("number", this.id, "type", this.getClass().getSimpleName(), "content", this.getContentAsJson(), "renderedhtml", "", "template", this.getTemplate(), "codemirror", String.valueOf(this.useCodemirror())));
        m.put("cmd", "Worksheet." + cmd);
        return m;
    }

    protected abstract String getContentAsJson();

    protected Map<String, String> getAdditionalEntries() {
        return Collections.emptyMap();
    }

    protected boolean useCodemirror() {
        return true;
    }

    protected String getTemplate() {
        return "/ui/worksheet/boxes/codemirror.html";
    }

    @Override
    public Map<String, String> createMessage() {
        return this.create("render_box");
    }

    @Override
    public Map<String, String> replaceMessage() {
        return this.create("replace_box");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public EChangeEffect changeEffect() {
        return EChangeEffect.FULL_REEVALUATION;
    }

    @Override
    public boolean requiresReEvaluation() {
        return true;
    }
}

