/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import java.util.HashSet;
import java.util.Set;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.ast.wd.FormulaBuilder;
import org.eventb.internal.core.ast.wd.Lemma;
import org.eventb.internal.core.ast.wd.Node;

public class NodeLimp
extends Node {
    private Node left;
    private Node right;

    public NodeLimp(Node left, Node right) {
        this.left = left;
        this.right = right;
    }

    @Override
    protected int maxBindingDepth() {
        return Math.max(this.left.maxBindingDepth(), this.right.maxBindingDepth());
    }

    @Override
    protected void boundIdentifiersEqualizer(int offset) {
        this.left.boundIdentifiersEqualizer(offset);
        this.right.boundIdentifiersEqualizer(offset);
    }

    @Override
    protected Predicate internalAsPredicate(FormulaBuilder fb, boolean original) {
        return fb.limp(this.left.asPredicate(fb, original), this.right.asPredicate(fb, original));
    }

    @Override
    protected void collectAntecedents(Set<Predicate> antecedents, FormulaBuilder fb) {
        this.addPredicateToSet(antecedents, fb);
    }

    @Override
    protected void internalSimplify(Set<Lemma> knownLemmas, Set<Predicate> antecedents, FormulaBuilder fb) {
        HashSet<Predicate> leftAntes = new HashSet<Predicate>();
        HashSet<Lemma> leftLemmas = new HashSet<Lemma>(knownLemmas);
        this.left.simplify(leftLemmas, leftAntes, fb);
        HashSet<Predicate> rightAntes = new HashSet<Predicate>(antecedents);
        this.left.collectAntecedents(rightAntes, fb);
        this.right.simplify(knownLemmas, rightAntes, fb);
    }

    @Override
    protected void internalToString(StringBuilder sb, String indent) {
        sb.append("LIMP\n");
        String childIndent = indent + "  ";
        this.left.toString(sb, childIndent);
        this.right.toString(sb, childIndent);
    }
}

