/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.ArrayList;
import java.util.List;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.SourceLocation;
import org.eventb.internal.core.ast.datatype.DatatypeBuilder;
import org.eventb.internal.core.lexer.GenLexer;
import org.eventb.internal.core.lexer.ILexer;
import org.eventb.internal.core.lexer.Scanner;
import org.eventb.internal.core.lexer.Token;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.ParseResult;

public class DatatypeLexer
implements ILexer {
    private final GenLexer lexer;
    private final AbstractGrammar grammar;
    private final Token datatypeToken;
    private final List<Token> expectedTokens = new ArrayList<Token>();
    private final int identKind;

    public static Scanner makeDatatypeScanner(DatatypeBuilder dtBuilder, String str, ParseResult result, AbstractGrammar grammar) {
        DatatypeLexer lexer = new DatatypeLexer(dtBuilder, str, result, grammar);
        return new Scanner(lexer);
    }

    private DatatypeLexer(DatatypeBuilder dtBuilder, String toLex, ParseResult result, AbstractGrammar grammar) {
        this.lexer = new GenLexer(toLex, result, grammar);
        this.grammar = grammar;
        this.identKind = grammar.getKind(AbstractGrammar.DefaultToken.IDENT);
        this.datatypeToken = this.mIdentToken(dtBuilder.getName());
        this.makeExpectedTokens(dtBuilder);
    }

    private void makeExpectedTokens(DatatypeBuilder dtBuilder) {
        GivenType[] params = dtBuilder.getTypeParameters();
        assert (params.length != 0);
        Token comma = this.mToken(",");
        Token sep = this.mToken("(");
        for (GivenType param : params) {
            this.expectedTokens.add(sep);
            sep = comma;
            this.expectedTokens.add(this.mIdentToken(param.getName()));
        }
        this.expectedTokens.add(this.mToken(")"));
    }

    private Token mToken(String image) {
        return new Token(this.grammar.getKind(image), image, -1);
    }

    private Token mIdentToken(String image) {
        return new Token(this.identKind, image, -1);
    }

    @Override
    public Token nextToken() {
        Token tk = this.lexer.nextToken();
        if (tk.equals(this.datatypeToken) && !this.skipExpectedTokens()) {
            return this.lexer.makeEOF();
        }
        return tk;
    }

    private boolean skipExpectedTokens() {
        for (Token expTk : this.expectedTokens) {
            Token tk = this.lexer.nextToken();
            if (tk.equals(expTk)) continue;
            this.addProblem(tk, expTk);
            return false;
        }
        return true;
    }

    private void addProblem(Token tk, Token expected) {
        int end = tk.pos + tk.val.length();
        SourceLocation sloc = new SourceLocation(tk.pos, end);
        ASTProblem problem = new ASTProblem(sloc, ProblemKind.DatatypeParsingError, 1, expected.val);
        this.getResult().addProblem(problem);
    }

    @Override
    public GenLexer.LexState save() {
        return this.lexer.save();
    }

    @Override
    public void restore(GenLexer.LexState lexState) {
        this.lexer.restore(lexState);
    }

    @Override
    public int eofKind() {
        return this.lexer.eofKind();
    }

    @Override
    public ParseResult getResult() {
        return this.lexer.getResult();
    }

    @Override
    public Token makeEOF() {
        return this.lexer.makeEOF();
    }
}

