/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.PredicateVariable;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.TypeRewriter;

public class DefaultTypeCheckingRewriter
implements ITypeCheckingRewriter {
    protected final FormulaFactory ff;
    protected final TypeRewriter typeRewriter;
    private int bindingDepth;

    public static BoundIdentDecl checkReplacement(BoundIdentDecl src, BoundIdentDecl dst) {
        Type type;
        if (src != dst && (type = src.getType()) != null && !type.equals(dst.getType())) {
            throw new IllegalArgumentException("Incompatible types in rewrite");
        }
        return dst;
    }

    public static Expression checkReplacement(Expression src, Expression dst) {
        Type type;
        if (src != dst && (type = src.getType()) != null && !type.equals(dst.getType())) {
            throw new IllegalArgumentException("Incompatible types in rewrite");
        }
        return dst;
    }

    public static Predicate checkReplacement(Predicate src, Predicate dst) {
        if (src != dst && src.isTypeChecked() && !dst.isTypeChecked()) {
            throw new IllegalArgumentException("Incompatible types in rewrite");
        }
        return dst;
    }

    public DefaultTypeCheckingRewriter(FormulaFactory ff) {
        this.ff = ff;
        this.typeRewriter = new TypeRewriter(ff);
    }

    @Override
    public boolean autoFlatteningMode() {
        return false;
    }

    @Override
    public FormulaFactory getFactory() {
        return this.ff;
    }

    @Override
    public final void enteringQuantifier(int nbOfDeclarations) {
        this.bindingDepth += nbOfDeclarations;
    }

    protected final int getBindingDepth() {
        return this.bindingDepth;
    }

    @Override
    public final void leavingQuantifier(int nbOfDeclarations) {
        this.bindingDepth -= nbOfDeclarations;
    }

    @Override
    public BoundIdentDecl rewrite(BoundIdentDecl src) {
        if (this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makeBoundIdentDecl(src.getName(), src.getSourceLocation(), this.typeRewriter.rewrite(src.getType()));
    }

    @Override
    public Expression rewrite(AssociativeExpression src, AssociativeExpression expr) {
        return expr;
    }

    @Override
    public Predicate rewrite(AssociativePredicate src, AssociativePredicate pred) {
        return pred;
    }

    @Override
    public Expression rewrite(AtomicExpression src) {
        if (this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makeAtomicExpression(src.getTag(), src.getSourceLocation(), this.typeRewriter.rewrite(src.getType()));
    }

    @Override
    public Expression rewrite(BinaryExpression src, BinaryExpression expr) {
        return expr;
    }

    @Override
    public Predicate rewrite(BinaryPredicate src, BinaryPredicate pred) {
        return pred;
    }

    @Override
    public Expression rewrite(BoolExpression src, BoolExpression expr) {
        return expr;
    }

    @Override
    public Expression rewrite(BoundIdentifier src) {
        if (this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makeBoundIdentifier(src.getBoundIndex(), src.getSourceLocation(), this.typeRewriter.rewrite(src.getType()));
    }

    @Override
    public Expression rewrite(ExtendedExpression src, boolean changed, Expression[] newChildExprs, Predicate[] newChildPreds) {
        if (!changed && this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makeExtendedExpression(src.getExtension(), newChildExprs, newChildPreds, src.getSourceLocation(), this.typeRewriter.rewrite(src.getType()));
    }

    @Override
    public Predicate rewrite(ExtendedPredicate src, boolean changed, Expression[] newChildExprs, Predicate[] newChildPreds) {
        if (!changed && this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makeExtendedPredicate(src.getExtension(), newChildExprs, newChildPreds, src.getSourceLocation());
    }

    @Override
    public Expression rewrite(FreeIdentifier src) {
        if (this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makeFreeIdentifier(src.getName(), src.getSourceLocation(), this.typeRewriter.rewrite(src.getType()));
    }

    @Override
    public Expression rewrite(IntegerLiteral src) {
        if (this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makeIntegerLiteral(src.getValue(), src.getSourceLocation());
    }

    @Override
    public Predicate rewrite(LiteralPredicate src) {
        if (this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makeLiteralPredicate(src.getTag(), src.getSourceLocation());
    }

    @Override
    public Predicate rewrite(MultiplePredicate src, MultiplePredicate pred) {
        return pred;
    }

    @Override
    public Predicate rewrite(PredicateVariable src) {
        if (this.ff == src.getFactory()) {
            return src;
        }
        return this.ff.makePredicateVariable(src.getName(), src.getSourceLocation());
    }

    @Override
    public Expression rewrite(QuantifiedExpression src, QuantifiedExpression expr) {
        return expr;
    }

    @Override
    public Predicate rewrite(QuantifiedPredicate src, QuantifiedPredicate pred) {
        return pred;
    }

    @Override
    public Predicate rewrite(RelationalPredicate src, RelationalPredicate pred) {
        return pred;
    }

    @Override
    public Expression rewrite(SetExtension src, SetExtension expr) {
        if (this.ff == expr.getFactory()) {
            return expr;
        }
        if (expr.getMembers().length == 0) {
            return this.ff.makeEmptySetExtension(this.typeRewriter.rewrite(expr.getType()), expr.getSourceLocation());
        }
        return this.ff.makeSetExtension(expr.getMembers(), expr.getSourceLocation());
    }

    @Override
    public Expression rewriteToEmptySet(SetExtension src) {
        Type type = this.typeRewriter.rewrite(src.getType());
        return this.ff.makeEmptySet(type, src.getSourceLocation());
    }

    @Override
    public Predicate rewrite(SimplePredicate src, SimplePredicate pred) {
        return pred;
    }

    @Override
    public Expression rewrite(UnaryExpression src, boolean changed, Expression newChild) {
        if (!changed) {
            assert (this.ff == src.getFactory());
            return src;
        }
        return this.ff.makeUnaryExpression(src.getTag(), newChild, src.getSourceLocation());
    }

    @Override
    public Expression rewrite(UnaryExpression src, IntegerLiteral expr) {
        return expr;
    }

    @Override
    public Predicate rewrite(UnaryPredicate src, UnaryPredicate pred) {
        return pred;
    }
}

