/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ISealedTypeEnvironment;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;

public abstract class AbstractTranslation {
    protected final ISealedTypeEnvironment srcTypenv;

    public AbstractTranslation(ISealedTypeEnvironment srcTypenv) {
        this.srcTypenv = srcTypenv;
    }

    public final ISealedTypeEnvironment getSourceTypeEnvironment() {
        return this.srcTypenv;
    }

    public void ensurePreconditions(Formula<?> formula) {
        FormulaFactory fac = formula.getFactory();
        if (fac != this.srcTypenv.getFormulaFactory()) {
            throw new IllegalArgumentException("Formula factory " + fac + " incompatible with translation " + this);
        }
        for (FreeIdentifier ident : formula.getFreeIdentifiers()) {
            if (this.srcTypenv.contains(ident)) continue;
            throw new IllegalArgumentException("Free identifier " + ident + " is not part of the source type environment of " + this);
        }
    }

    public abstract ITypeCheckingRewriter getFormulaRewriter();
}

