/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class SetExtension
extends Expression {
    private static final String SETEXT_ID = "Set Extension";
    private final Expression[] members;

    public static void init(BMath grammar) {
        try {
            grammar.addOperator(Operators.OP_SETEXT);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected SetExtension(Expression[] expressions, SourceLocation location, FormulaFactory ff, Type type) {
        super(5, ff, location, SetExtension.combineHashCodes(expressions));
        this.members = expressions;
        this.ensureSameFactory(this.members);
        this.ensureSameFactory(type);
        this.setPredicateVariableCache(this.members);
        this.synthesizeType(type);
        FormulaChecks.ensureHasType(this, type);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        Type resultType;
        IdentListMerger freeIdentMerger = SetExtension.mergeFreeIdentifiers((Formula[])this.members);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = SetExtension.mergeBoundIdentifiers((Formula[])this.members);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        int length = this.members.length;
        if (length == 0) {
            if (!(givenType instanceof PowerSetType)) {
                return;
            }
            resultType = givenType;
            if (!this.mergeGivenTypes(resultType)) {
                return;
            }
        } else {
            Type memberType = this.members[0].getType();
            if (memberType == null) {
                return;
            }
            for (int i = 1; i < length; ++i) {
                if (memberType.equals(this.members[i].getType())) continue;
                return;
            }
            resultType = this.getFactory().makePowerSetType(memberType);
        }
        this.setFinalType(resultType, givenType);
    }

    public Expression[] getMembers() {
        return (Expression[])this.members.clone();
    }

    private Operators getOperator() {
        return Operators.OP_SETEXT;
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        StringBuffer str = new StringBuffer();
        String typeName = this.getType() != null ? " [type: " + this.getType().toString() + "]" : "";
        str.append(tabs + this.getClass().getSimpleName() + " [SETEXT]" + typeName + "\n");
        for (int i = 0; i < this.members.length; ++i) {
            str.append(this.members[i].getSyntaxTree(boundNames, tabs + "\t"));
        }
        return str.toString();
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i].isLegible(result);
        }
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        SetExtension other = (SetExtension)expr;
        return Arrays.equals(this.members, other.members);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        SourceLocation alphaLoc = this.members.length == 0 ? this.getSourceLocation() : null;
        TypeVariable alpha = result.newFreshVariable(alphaLoc);
        for (Expression member : this.members) {
            member.typeCheck(result, quantifiedIdentifiers);
            result.unify(member.getType(), alpha, this);
        }
        this.setTemporaryType(result.makePowerSetType(alpha), result);
        result.analyzeExpression(this);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        for (Expression member : this.members) {
            member.solveType(unifier);
        }
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        for (Expression child : this.members) {
            child.collectFreeIdentifiers(freeIdentSet);
        }
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        for (Expression member : this.members) {
            member.collectNamesAbove(names, boundNames, offset);
        }
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = visitor.enterSETEXT(this);
        for (int i = 0; goOn && i < this.members.length; ++i) {
            if (i != 0) {
                goOn = visitor.continueSETEXT(this);
            }
            if (!goOn) continue;
            goOn = this.members[i].accept(visitor);
        }
        return visitor.exitSETEXT(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitSetExtension(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        int length = this.members.length;
        FormulaFactory ff = rewriter.getFactory();
        SourceLocation sloc = this.getSourceLocation();
        if (length == 0 && rewriter.autoFlatteningMode()) {
            return rewriter.rewriteToEmptySet(this);
        }
        boolean changed = false;
        Expression[] newMembers = new Expression[length];
        for (int i = 0; i < length; ++i) {
            Expression newMember;
            Expression member = this.members[i];
            newMembers[i] = newMember = (Expression)member.rewrite(rewriter);
            changed |= newMember != member;
        }
        SetExtension before = !changed ? this : ff.makeSetExtension(newMembers, sloc);
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        for (Expression member : this.members) {
            member.inspect(acc);
            if (acc.allSkipped()) break;
            acc.nextChild();
        }
        acc.leaveChildren();
    }

    public Expression getChild(int index) {
        this.checkChildIndex(index);
        return this.members[index];
    }

    @Override
    public int getChildCount() {
        return this.members.length;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        for (Expression member : this.members) {
            IPosition pos = member.getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.incrementTop();
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        if (index < 0 || this.members.length <= index) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        Expression[] newMembers = (Expression[])this.members.clone();
        newMembers[index] = rewriter.rewrite(this.members[index]);
        return this.getFactory().makeSetExtension(newMembers, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<SetExtension>
    {
        OP_SETEXT(AbstractGrammar.DefaultToken.LBRACE.getImage(), "Set Extension", StandardGroup.BRACE_SETS);

        private final String image;
        private final String id;
        private final String groupId;

        private Operators(String image, String id, StandardGroup group) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<SetExtension> makeParser(int kind) {
            return new SubParsers.SetExtParser(kind);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

