/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Collection;
import java.util.Iterator;
import org.eventb.core.ast.ASTProblem;

public enum ProblemKind {
    FreeIdentifierHasBoundOccurences("%1$s appears bound"),
    BoundIdentifierHasFreeOccurences("%1$s appears free"),
    BoundIdentifierIsAlreadyBound("%1$s is bound twice"),
    LexerError("Lexer error, character '%1$s' has been ignored"),
    DatatypeParsingError("Invalid recursive datatype: expected '%1$s'"),
    TypeNameUsedForRegularIdentifier("Name %1$s is used both as a given type and as a free identifier with type %2$s"),
    TypesDoNotMatch("Type: %1$s does not match type: %2$s"),
    UnexpectedSubFormulaKind("Unexpected sub-formula, expected: %1$s but was: %2$s"),
    UnexpectedSymbol("Expected: %1$s but was: %2$s"),
    UnknownOperator("Unknown operator: %1$s"),
    UnmatchedTokens("Tokens have been ignored"),
    IncompatibleOperators("Operator: %1$s is not compatible with: %2$s, parentheses are required"),
    Circularity("Types do not match"),
    MisplacedNudOperator("Operator: %1$s should appear at the beginning of a sub-formula"),
    MisplacedLedOperator("Operator: %1$s should appear with a sub-formula on its left"),
    VariousPossibleErrors("Parse failed because either:\n%1$s"),
    InvalidAssignmentToImage("Assignment to function image applies to exactly one function"),
    IncompatibleIdentExprNumbers("Incompatible number of arguments: %1$s identifiers and %2$s expressions"),
    BECMOAppliesToOneIdent("'Becomes Member Of' applies to only one identifier"),
    FreeIdentifierExpected("Expected a free identifier"),
    IntegerLiteralExpected("Expected an integer literal"),
    InvalidGenericType("Invalid type for generic operator, expected %1$s"),
    UnexpectedOftype("Oftype is not expected here"),
    ExtensionPreconditionError("Preconditions for this extended operator are not fulfilled"),
    PrematureEOF("Premature End Of Formula"),
    DuplicateIdentifierInPattern("Duplicate identifier in pattern: %1$s"),
    TypeUnknown("Variable has an unknown type"),
    InvalidTypeExpression("Expression doesn't denote a type"),
    TypeCheckFailure("Couldn't infer some types"),
    MinusAppliedToSet("Arithmetic subtraction applied to a set expression"),
    MulAppliedToSet("Arithmetic multiplication applied to a set expression"),
    NotUpgradableError("Formula cannot be upgraded"),
    PredicateVariableNotAllowed("Predicate variable %1$s is not allowed here"),
    ExpressionNotBinding("Expression not binding any variable in quantified expression");

    private String message;

    public static String makeCompoundMessage(Collection<ASTProblem> problems) {
        if (problems.size() < 2) {
            throw new IllegalArgumentException("expected at least 2 error messages, but was " + problems);
        }
        String spaces = "  ";
        StringBuilder compound = new StringBuilder();
        Iterator<ASTProblem> problem = problems.iterator();
        compound.append("  ");
        compound.append(problem.next());
        while (problem.hasNext()) {
            compound.append("\n");
            compound.append("  ");
            compound.append(problem.next());
        }
        return compound.toString();
    }

    private ProblemKind(String message) {
        this.message = message;
    }

    public String toString() {
        return this.message;
    }
}

