/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.MainParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class BecomesMemberOf
extends Assignment {
    private static final String BECMO_ID = "Becomes Member Of";
    public static final IOperatorInfo<BecomesMemberOf> OP_BECMO = new IOperatorInfo<BecomesMemberOf>(){

        @Override
        public IParserPrinter<BecomesMemberOf> makeParser(int kind) {
            return new MainParsers.BecomesMemberOfParser(kind);
        }

        @Override
        public String getImage() {
            return ":\u2208";
        }

        @Override
        public String getId() {
            return BecomesMemberOf.BECMO_ID;
        }

        @Override
        public String getGroupId() {
            return StandardGroup.INFIX_SUBST.getId();
        }

        @Override
        public boolean isSpaced() {
            return true;
        }
    };
    private final Expression setExpr;

    public static void init(BMath grammar) {
        try {
            grammar.addOperator(OP_BECMO);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected BecomesMemberOf(FreeIdentifier assignedIdent, Expression setExpr, SourceLocation location, FormulaFactory ff) {
        super(7, ff, location, setExpr.hashCode(), new FreeIdentifier[]{assignedIdent});
        this.setExpr = setExpr;
        this.ensureSameFactory(this.setExpr);
        this.setPredicateVariableCache(this.setExpr);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        IdentListMerger freeIdentMerger = IdentListMerger.makeMerger((Identifier[])this.assignedIdents[0].freeIdents, (Identifier[])this.setExpr.freeIdents);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = IdentListMerger.makeMerger((Identifier[])this.assignedIdents[0].boundIdents, (Identifier[])this.setExpr.boundIdents);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        if (!this.setExpr.isTypeChecked()) {
            return;
        }
        Type type = this.assignedIdents[0].getType();
        if (type == null || !type.equals(this.setExpr.getType().getBaseType())) {
            return;
        }
        this.typeChecked = true;
    }

    public Expression getSet() {
        return this.setExpr;
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.collectFreeIdentifiers(freeIdentSet);
        }
        this.setExpr.collectFreeIdentifiers(freeIdentSet);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.collectNamesAbove(names, boundNames, offset);
        }
        this.setExpr.collectNamesAbove(names, boundNames, offset);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        int kind = mediator.getKind();
        OP_BECMO.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(OP_BECMO.getImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String childTabs = tabs + '\t';
        StringBuilder result = new StringBuilder();
        result.append(tabs);
        result.append(this.getClass().getSimpleName());
        result.append(" [:\u2208]\n");
        for (FreeIdentifier ident : this.assignedIdents) {
            result.append(ident.getSyntaxTree(boundNames, childTabs));
        }
        result.append(this.setExpr.getSyntaxTree(boundNames, childTabs));
        return result.toString();
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        BecomesMemberOf other = (BecomesMemberOf)formula;
        return this.hasSameAssignedIdentifiers(other) && this.setExpr.equals(other.setExpr);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] boundAbove) {
        FreeIdentifier lhs = this.assignedIdents[0];
        lhs.typeCheck(result, boundAbove);
        this.setExpr.typeCheck(result, boundAbove);
        result.unify(this.setExpr.getType(), result.makePowerSetType(lhs.getType()), this);
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.isLegible(result);
        }
        this.setExpr.isLegible(result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        this.setExpr.solveType(unifier);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = visitor.enterBECOMES_MEMBER_OF(this);
        if (goOn) {
            goOn = this.assignedIdents[0].accept(visitor);
        }
        if (goOn) {
            goOn = visitor.continueBECOMES_MEMBER_OF(this);
        }
        if (goOn) {
            goOn = this.setExpr.accept(visitor);
        }
        return visitor.exitBECOMES_MEMBER_OF(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitBecomesMemberOf(this);
    }

    @Override
    protected Predicate getFISPredicateRaw() {
        FormulaFactory ff = this.getFactory();
        SourceLocation loc = this.getSourceLocation();
        AtomicExpression emptySet = ff.makeEmptySet(this.setExpr.getType(), null);
        return ff.makeRelationalPredicate(102, this.setExpr, emptySet, loc);
    }

    @Override
    protected Predicate getBAPredicateRaw() {
        FormulaFactory ff = this.getFactory();
        SourceLocation loc = this.getSourceLocation();
        FreeIdentifier primedIdentifier = this.assignedIdents[0].withPrime();
        return ff.makeRelationalPredicate(107, primedIdentifier, this.setExpr, loc);
    }

    @Override
    public FreeIdentifier[] getUsedIdentifiers() {
        return this.setExpr.getFreeIdentifiers();
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }
}

