/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.EvaluationCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.animator.domainobjects.LTL;
import de.prob.check.IModelCheckingResult;
import de.prob.check.LTLCounterExample;
import de.prob.check.LTLError;
import de.prob.check.LTLNotYetFinished;
import de.prob.check.LTLOk;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.IntegerPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;

public final class LtlCheckingCommand
extends EvaluationCommand
implements IStateSpaceModifier {
    private static final String PROLOG_COMMAND_NAME = "prob2_do_ltl_modelcheck";
    private static final String VARIABLE_NAME_RESULT = "R";
    private static final String VARIABLE_NAME_ERRORS = "Errors";
    private final int max;
    private IModelCheckingResult result;
    private final LTL ltlFormula;
    private final StateSpace s;

    public LtlCheckingCommand(StateSpace s, LTL ltlFormula, int max) {
        super(ltlFormula, null);
        this.s = s;
        this.ltlFormula = ltlFormula;
        this.max = max;
    }

    public IModelCheckingResult getResult() {
        return this.result;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm term = (PrologTerm)bindings.get((Object)VARIABLE_NAME_RESULT);
        if (term.hasFunctor("ok", 0)) {
            LTLOk res = new LTLOk(this.ltlFormula);
            this.result = res;
            this.value = res;
        } else if (term.hasFunctor("nostart", 0)) {
            LTLError res = new LTLError(this.ltlFormula, "Could not find initialisation. Try to animating the model.");
            this.result = res;
            this.value = res;
        } else if (term.hasFunctor("typeerror", 0)) {
            LTLError res = new LTLError(this.ltlFormula, "Type error discovered in formula");
            this.result = res;
            this.value = res;
        } else if (term.hasFunctor("incomplete", 0)) {
            LTLNotYetFinished res = new LTLNotYetFinished(this.ltlFormula);
            this.result = res;
            this.value = res;
        } else if (term.hasFunctor("counterexample", 3)) {
            int loopEntry;
            PathType pathType;
            CompoundPrologTerm cpt = BindingGenerator.getCompoundTerm((PrologTerm)term, (int)3);
            ArrayList<Transition> counterExample = new ArrayList<Transition>();
            ArrayList<Transition> pathToCE = new ArrayList<Transition>();
            for (PrologTerm pt : BindingGenerator.getList((PrologTerm)cpt.getArgument(1))) {
                if (pt.hasFunctor("none", 0)) continue;
                counterExample.add(Transition.createTransitionFromCompoundPrologTerm(this.s, BindingGenerator.getCompoundTerm((PrologTerm)pt, (int)4)));
            }
            PrologTerm loopStatus = cpt.getArgument(2);
            if (loopStatus.hasFunctor("no_loop", 0)) {
                pathType = PathType.REDUCED;
                loopEntry = -1;
            } else if (loopStatus.hasFunctor("deadlock", 0)) {
                pathType = PathType.FINITE;
                loopEntry = -1;
            } else if (loopStatus.hasFunctor("loop", 1)) {
                pathType = PathType.INFINITE;
                loopEntry = ((IntegerPrologTerm)loopStatus.getArgument(1)).getValue().intValue();
            } else {
                throw new RuntimeException("LTL model check returned unexpected loop status: " + loopStatus);
            }
            for (PrologTerm pt : BindingGenerator.getList((PrologTerm)cpt.getArgument(3))) {
                pathToCE.add(Transition.createTransitionFromCompoundPrologTerm(this.s, BindingGenerator.getCompoundTerm((PrologTerm)pt, (int)4)));
            }
            LTLCounterExample res = new LTLCounterExample(this.ltlFormula, pathToCE, counterExample, loopEntry, pathType);
            this.result = res;
            this.value = res;
        } else {
            throw new RuntimeException("Unknown result from LTL checking: " + term.toString());
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        this.evalElement.printProlog(pto);
        pto.printNumber((long)this.max);
        pto.printVariable(VARIABLE_NAME_RESULT);
        pto.printVariable(VARIABLE_NAME_ERRORS);
        pto.closeTerm();
    }

    public static IModelCheckingResult modelCheck(StateSpace s, LTL formula, int max) {
        LtlCheckingCommand cmd = new LtlCheckingCommand(s, formula, max);
        s.execute((AbstractCommand)cmd);
        return cmd.getResult();
    }

    @Override
    public List<Transition> getNewTransitions() {
        ArrayList<Transition> newOps = new ArrayList<Transition>();
        if (this.result instanceof LTLCounterExample) {
            newOps.addAll(((LTLCounterExample)this.result).getOpList());
        }
        return newOps;
    }

    public static enum PathType {
        INFINITE,
        FINITE,
        REDUCED;

    }
}

