/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.List;

public class TLCRuntime {
    public static final long MinFpMemSize = 0xA00000L;
    private static TLCRuntime runtime;
    private long physicalSystemMemory = -1L;

    public static synchronized TLCRuntime getInstance() {
        if (runtime == null) {
            runtime = new TLCRuntime();
        }
        return runtime;
    }

    private long getPhysicalSystemMemory() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        for (Method method : operatingSystemMXBean.getClass().getDeclaredMethods()) {
            if (!method.getName().equals("getTotalPhysicalMemorySize")) continue;
            method.setAccessible(true);
            try {
                return (Long)method.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            catch (Exception e) {
                break;
            }
        }
        return Runtime.getRuntime().totalMemory();
    }

    public long getAbsolutePhysicalSystemMemory(double fraction) {
        if (this.physicalSystemMemory == -1L) {
            this.physicalSystemMemory = this.getPhysicalSystemMemory();
        }
        double d = (double)this.physicalSystemMemory * fraction;
        return (long)(d / 1024.0 / 1024.0);
    }

    public long getNonHeapPhysicalMemory() {
        long l = 0x4000000L;
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = RuntimemxBean.getInputArguments();
        for (String arg : arguments) {
            if (!arg.toLowerCase().startsWith("-xx:maxdirectmemorysize")) continue;
            String[] strings = arg.split("=");
            String mem = strings[1].toLowerCase();
            if (mem.endsWith("g")) {
                l = Long.parseLong(mem.substring(0, mem.length() - 1));
                l <<= 30;
                break;
            }
            if (mem.endsWith("m")) {
                l = Long.parseLong(mem.substring(0, mem.length() - 1));
                l <<= 20;
                break;
            }
            if (mem.endsWith("k")) {
                l = Long.parseLong(mem.substring(0, mem.length() - 1));
                l <<= 10;
                break;
            }
            l = Long.parseLong(mem.substring(0, mem.length()));
            break;
        }
        return l;
    }

    public long getFPMemSize(double fpMemSize) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (fpMemSize == -1.0) {
            fpMemSize = maxMemory >> 2;
        }
        if (0.0 <= fpMemSize && fpMemSize <= 1.0) {
            fpMemSize = (double)maxMemory * fpMemSize;
        }
        if (fpMemSize < 1.048576E7) {
            fpMemSize = 1.048576E7;
        }
        if (fpMemSize >= (double)maxMemory) {
            fpMemSize = maxMemory - (maxMemory >> 2);
        }
        return (long)fpMemSize;
    }
}

