/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.PrintWriter;
import java.util.Hashtable;
import util.WrongInvocationException;

public abstract class Sx {
    public static SxNil nil = new SxNil();
    private static Hashtable atomTbl = new Hashtable();
    private static int symCount = 0;

    public static Sx cons(Sx a, Sx b) {
        return new SxPair(a, b);
    }

    public static Sx car(Sx a) {
        if (!(a instanceof SxPair)) {
            throw new WrongInvocationException("Car must be applied to cons.");
        }
        return ((SxPair)a).car;
    }

    public static Sx cdr(Sx a) {
        if (!(a instanceof SxPair)) {
            throw new WrongInvocationException("Cdr must be applied to cons.");
        }
        return ((SxPair)a).cdr;
    }

    public static Sx List(Sx a) {
        return Sx.cons(a, nil);
    }

    public static Sx List(Sx a, Sx b) {
        return Sx.cons(a, Sx.cons(b, nil));
    }

    public static Sx List(Sx a, Sx b, Sx c) {
        return Sx.cons(a, Sx.cons(b, Sx.cons(c, nil)));
    }

    public static Sx List(Sx a, Sx b, Sx c, Sx d) {
        return Sx.cons(a, Sx.cons(b, Sx.cons(c, Sx.cons(d, nil))));
    }

    public static Sx Append(Sx a, Sx b) {
        if (a == nil) {
            return b;
        }
        return Sx.cons(Sx.car(a), Sx.Append(Sx.cdr(a), b));
    }

    public static SxAtom genSym() {
        return Sx.Atom("F__" + symCount++);
    }

    public static boolean memq(SxAtom a, Sx p) {
        while (p != nil) {
            if (a == Sx.car(p)) {
                return true;
            }
            p = Sx.cdr(p);
        }
        return false;
    }

    public static SxAtom Atom(String st) {
        SxAtom res = (SxAtom)atomTbl.get(st);
        if (res == null) {
            res = new SxAtom(st);
            atomTbl.put(st, res);
        }
        return res;
    }

    public static Sx FromInt(int k) {
        return new SxInt(k);
    }

    public abstract void print(PrintWriter var1);

    public static class SxPair
    extends Sx {
        public Sx car;
        public Sx cdr;

        public SxPair(Sx a, Sx b) {
            this.car = a;
            this.cdr = b;
        }

        @Override
        public void print(PrintWriter pw) {
            pw.print("(");
            this.car.print(pw);
            Sx next = this.cdr;
            while (next instanceof SxPair) {
                pw.print(" ");
                ((SxPair)next).car.print(pw);
                next = ((SxPair)next).cdr;
            }
            if (next != nil) {
                pw.print(" . ");
                next.print(pw);
            }
            pw.print(")");
        }
    }

    public static class SxNil
    extends Sx {
        private SxNil() {
        }

        @Override
        public void print(PrintWriter pw) {
            pw.print("nil");
        }
    }

    public static class SxInt
    extends Sx {
        public int val;

        public SxInt(int k) {
            this.val = k;
        }

        @Override
        public void print(PrintWriter pw) {
            pw.print(this.val);
        }
    }

    public static class SxAtom
    extends Sx {
        public String st;

        private SxAtom(String st) {
            this.st = st;
        }

        @Override
        public void print(PrintWriter pw) {
            pw.print(this.st);
        }
    }
}

