/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.st.TreeNode;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.tool.liveness.LNState;
import tlc2.util.Context;
import tlc2.value.BoolValue;
import tlc2.value.Value;
import util.Assert;

class LNStateAST
extends LNState {
    private final ExprNode body;

    public LNStateAST(ExprNode body, Context con) {
        super(con);
        this.body = body;
    }

    public final ExprNode getBody() {
        return this.body;
    }

    @Override
    public final boolean eval(Tool tool, TLCState s1, TLCState s2) {
        Value val = tool.eval(this.body, this.getContext(), s1);
        if (!(val instanceof BoolValue)) {
            Assert.fail(2250);
        }
        return ((BoolValue)val).val;
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        sb.append(this.body);
    }

    @Override
    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        if (this.body instanceof OpApplNode) {
            TreeNode[] zero;
            OpApplNode oan = (OpApplNode)this.body;
            sb.append("(");
            for (TreeNode treeNode : zero = oan.getTreeNode().zero()) {
                SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
                sb.append(stn.getHumanReadableImage());
            }
            TreeNode[] one = oan.getTreeNode().one();
            if (one != null) {
                for (TreeNode treeNode : one) {
                    SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
                    sb.append(stn.getHumanReadableImage());
                }
            }
            sb.append(")");
        } else {
            this.toString(sb, "");
        }
        return sb.toString();
    }
}

