/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ExprNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.DFIDWorker;
import tlc2.tool.EvalException;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateMutSource;
import tlc2.tool.fp.dfid.FPIntSet;
import tlc2.tool.fp.dfid.MemFPIntSet;
import tlc2.tool.liveness.LiveException;
import tlc2.util.IdThread;
import tlc2.util.LongVec;
import tlc2.util.ObjLongTable;
import util.FileUtil;
import util.FilenameToStream;
import util.UniqueString;

public class DFIDModelChecker
extends AbstractChecker {
    public TLCState[] theInitStates = null;
    public long[] theInitFPs = null;
    public FPIntSet theFPSet = new MemFPIntSet();
    protected DFIDWorker[] workers;

    public DFIDModelChecker(String specFile, String configFile, String dumpFile, boolean deadlock, String fromChkpt, boolean preprocess, FilenameToStream resolver, SpecObj specObj) throws EvalException, IOException {
        super(specFile, configFile, dumpFile, deadlock, fromChkpt, preprocess, resolver, specObj);
        this.theFPSet.init(TLCGlobals.getNumWorkers(), this.metadir, specFile);
        this.workers = new DFIDWorker[TLCGlobals.getNumWorkers()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelCheck() throws Exception {
        boolean recovered = this.recover();
        try {
            if (!this.checkAssumptions()) {
                return;
            }
            if (!this.doInit(false)) {
                return;
            }
        }
        catch (Throwable e) {
            if (this.errState != null) {
                MP.printError(2102, new String[]{e.getMessage(), this.errState.toString()});
            } else {
                MP.printError(1000, "computing initial states", e);
            }
            this.tool.setCallStack();
            try {
                this.numOfGenStates = new AtomicLong(0L);
                this.doInit(true);
            }
            catch (Throwable e1) {
                MP.printError(2103, this.tool.getCallStack().toString());
            }
            this.printSummary(false);
            this.cleanup(false);
            return;
        }
        if (recovered) {
            MP.printMessage(2207, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theInitStates.length)});
        } else {
            MP.printMessage(2208, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theInitStates.length)});
        }
        if (this.actions.length == 0) {
            this.reportSuccess();
            this.printSummary(true);
            this.cleanup(true);
            return;
        }
        boolean success = false;
        try {
            boolean terminated = false;
            for (int level = 2; level <= TLCGlobals.DFIDMax; ++level) {
                if (terminated) {
                    if (this.errState == null) {
                        if (this.checkLiveness) {
                            MP.printMessage(2192, new String[]{"complete", Long.toString(this.theFPSet.size())});
                            success = this.liveCheck.finalCheck();
                            if (!success) {
                                return;
                            }
                        }
                        success = true;
                        this.reportSuccess();
                    } else if (this.keepCallStack) {
                        this.tool.setCallStack();
                        try {
                            this.doNext(this.predErrState, this.predErrState.fingerPrint(), true, new ObjLongTable(10), new StateVec(1), new LongVec());
                        }
                        catch (Throwable e) {
                            MP.printError(2103, this.tool.getCallStack().toString());
                        }
                    }
                    break;
                }
                MP.printMessage(2206, new String[]{String.valueOf(level), String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size())});
                FPIntSet.incLevel();
                success = this.runTLC(level);
                if (!success) {
                    return;
                }
                for (int i = 0; i < this.workers.length; ++i) {
                    if (!this.workers[i].isTerminated()) continue;
                    terminated = true;
                    break;
                }
                boolean moreLevel = false;
                for (int i = 0; i < this.workers.length; ++i) {
                    if (!this.workers[i].hasMoreLevel()) continue;
                    moreLevel = true;
                    break;
                }
                terminated = terminated || !moreLevel;
            }
        }
        catch (Exception e) {
            success = false;
            if (!(e instanceof LiveException)) {
                MP.printError(1000, e);
            }
        }
        finally {
            this.printSummary(success);
            this.cleanup(success);
        }
    }

    public final boolean checkAssumptions() {
        ExprNode[] assumps = this.tool.getAssumptions();
        boolean[] isAxiom = this.tool.getAssumptionIsAxiom();
        for (int i = 0; i < assumps.length; ++i) {
            try {
                if (isAxiom[i] || this.tool.isValid(assumps[i])) continue;
                MP.printError(2104, assumps[i].toString());
                return false;
            }
            catch (Exception e) {
                MP.printError(2105, new String[]{assumps[i].toString(), e.getMessage()});
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean doInit(boolean ignoreCancel) throws Throwable {
        TLCState curState = null;
        try {
            StateVec states = this.tool.getInitStates();
            this.numOfGenStates.set(states.size());
            long l = this.numOfGenStates.get();
            this.theInitStates = new TLCState[(int)l];
            this.theInitFPs = new long[(int)l];
            int idx = 0;
            int i = 0;
            while ((long)i < l) {
                long fp;
                curState = states.elementAt(i);
                if (!this.tool.isGoodState(curState)) {
                    MP.printError(2106, curState.toString());
                    return false;
                }
                boolean inModel = this.tool.isInModel(curState);
                int status = 0;
                if (inModel && (status = this.theFPSet.setStatus(fp = curState.fingerPrint(), 0)) == 0) {
                    this.theInitStates[idx] = curState;
                    this.theInitFPs[idx++] = fp;
                    if (this.allStateWriter != null) {
                        this.allStateWriter.writeState(curState);
                    }
                    if (this.checkLiveness) {
                        this.liveCheck.addInitState(curState, fp);
                    }
                }
                if (status == 0) {
                    int j;
                    for (j = 0; j < this.invariants.length; ++j) {
                        if (this.tool.isValid(this.invariants[j], curState)) continue;
                        MP.printError(2107, new String[]{this.tool.getInvNames()[j], curState.toString()});
                        if (TLCGlobals.continuation) continue;
                        return false;
                    }
                    for (j = 0; j < this.impliedInits.length; ++j) {
                        if (this.tool.isValid(this.impliedInits[j], curState)) continue;
                        MP.printError(2108, new String[]{this.tool.getImpliedInitNames()[j], curState.toString()});
                        return false;
                    }
                }
                ++i;
            }
            if ((long)idx < this.numOfGenStates.get()) {
                TLCState[] stateTemp = new TLCState[idx];
                long[] fpTemp = new long[idx];
                System.arraycopy(this.theInitStates, 0, stateTemp, 0, idx);
                System.arraycopy(this.theInitFPs, 0, fpTemp, 0, idx);
                this.theInitStates = stateTemp;
                this.theInitFPs = fpTemp;
            }
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                MP.printError(1002);
                return false;
            }
            this.errState = curState;
            throw e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doNext(TLCState curState, long cfp, boolean isLeaf, ObjLongTable counts, StateVec states, LongVec fps) throws Throwable {
        boolean deadLocked = true;
        TLCState succState = null;
        StateVec liveNextStates = null;
        LongVec liveNextFPs = null;
        if (this.checkLiveness && isLeaf) {
            liveNextStates = new StateVec(2);
            liveNextFPs = new LongVec(2);
        }
        try {
            int k = 0;
            boolean allSuccDone = true;
            boolean allSuccNonLeaf = true;
            for (int i = 0; i < this.actions.length; ++i) {
                StateVec nextStates = this.tool.getNextStates(this.actions[i], curState);
                int sz = nextStates.size();
                this.incNumOfGenStates(sz);
                deadLocked = deadLocked && sz == 0;
                for (int j = 0; j < sz; ++j) {
                    DFIDModelChecker dFIDModelChecker;
                    int len;
                    succState = nextStates.elementAt(j);
                    if (!this.tool.isGoodState(succState)) {
                        if (this.setErrState(curState, succState, false)) {
                            this.printTrace(2109, null, curState, succState);
                            DFIDModelChecker dFIDModelChecker2 = this;
                            synchronized (dFIDModelChecker2) {
                                this.notify();
                            }
                        }
                        return allSuccNonLeaf;
                    }
                    if (TLCGlobals.coverageInterval >= 0) {
                        ((TLCStateMutSource)succState).addCounts(counts);
                    }
                    boolean inModel = this.tool.isInModel(succState) && this.tool.isInActions(curState, succState);
                    int status = 0;
                    if (inModel) {
                        long fp = succState.fingerPrint();
                        status = this.theFPSet.setStatus(fp, 0);
                        allSuccDone = allSuccDone && FPIntSet.isDone(status);
                        boolean bl = allSuccNonLeaf = allSuccNonLeaf && !FPIntSet.isLeaf(status);
                        if (status == 0 && this.allStateWriter != null) {
                            this.allStateWriter.writeState(succState);
                        }
                        if (!FPIntSet.isCompleted(status)) {
                            states.addElement(succState);
                            fps.addElement(fp);
                        }
                        if (this.checkLiveness && isLeaf) {
                            liveNextStates.addElement(succState);
                            liveNextFPs.addElement(fp);
                        }
                    }
                    if (status == 0) {
                        try {
                            len = this.invariants.length;
                            for (k = 0; k < len; ++k) {
                                if (this.tool.isValid(this.invariants[k], succState)) continue;
                                dFIDModelChecker = this;
                                synchronized (dFIDModelChecker) {
                                    if (TLCGlobals.continuation) {
                                        this.printTrace(2110, new String[]{this.tool.getInvNames()[k]}, curState, succState);
                                        break;
                                    }
                                    if (this.setErrState(curState, succState, false)) {
                                        this.printTrace(2110, new String[]{this.tool.getInvNames()[k]}, curState, succState);
                                        this.notify();
                                    }
                                    return allSuccNonLeaf;
                                }
                            }
                            if (k < len) {
                                continue;
                            }
                        }
                        catch (Exception e) {
                            if (this.setErrState(curState, succState, true)) {
                                this.printTrace(2111, new String[]{this.tool.getInvNames()[k]}, curState, succState);
                                this.notify();
                            }
                            return allSuccNonLeaf;
                        }
                    }
                    try {
                        len = this.impliedActions.length;
                        for (k = 0; k < len; ++k) {
                            if (this.tool.isValid(this.impliedActions[k], curState, succState)) continue;
                            dFIDModelChecker = this;
                            synchronized (dFIDModelChecker) {
                                if (TLCGlobals.continuation) {
                                    this.printTrace(2112, new String[]{this.tool.getImpliedActNames()[k]}, curState, succState);
                                    break;
                                }
                                if (this.setErrState(curState, succState, false)) {
                                    this.printTrace(2112, new String[]{this.tool.getImpliedActNames()[k]}, curState, succState);
                                    this.notify();
                                }
                                return allSuccNonLeaf;
                            }
                        }
                        if (k >= len) continue;
                    }
                    catch (Exception e) {
                        if (this.setErrState(curState, succState, true)) {
                            this.printTrace(2113, new String[]{this.tool.getImpliedActNames()[k]}, curState, succState);
                            this.notify();
                        }
                        return allSuccNonLeaf;
                    }
                }
                succState = null;
            }
            if (deadLocked && this.checkDeadlock) {
                DFIDModelChecker i = this;
                synchronized (i) {
                    if (this.setErrState(curState, null, false)) {
                        this.printTrace(2114, null, curState, null);
                        this.notify();
                    }
                }
                return allSuccNonLeaf;
            }
            if (this.checkLiveness && isLeaf) {
                long curStateFP = curState.fingerPrint();
                liveNextStates.addElement(curState);
                liveNextFPs.addElement(curStateFP);
                this.liveCheck.addNextState(curState, curStateFP, liveNextStates, liveNextFPs);
            }
            if (allSuccDone || isLeaf && allSuccNonLeaf) {
                this.theFPSet.setStatus(cfp, 1);
            }
            return allSuccNonLeaf;
        }
        catch (Throwable e) {
            boolean keep = e instanceof StackOverflowError || e instanceof OutOfMemoryError;
            DFIDModelChecker dFIDModelChecker = this;
            synchronized (dFIDModelChecker) {
                if (this.setErrState(curState, succState, !keep)) {
                    int errorCode;
                    String[] parameters = null;
                    if (e instanceof StackOverflowError) {
                        errorCode = 1005;
                    } else if (e instanceof OutOfMemoryError) {
                        errorCode = 1001;
                    } else {
                        errorCode = 1000;
                        parameters = new String[]{MP.ECGeneralMsg("computing the set of next states", e)};
                    }
                    this.printTrace(errorCode, parameters, curState, succState);
                    this.notifyAll();
                }
            }
            throw e;
        }
    }

    private final void printTrace(int errorCode, String[] parameters, TLCState s1, TLCState s2) {
        this.workers[IdThread.GetId()].printTrace(errorCode, parameters, s1, s2);
    }

    @Override
    public boolean setErrState(TLCState curState, TLCState succState, boolean keep) {
        boolean result = super.setErrState(curState, succState, keep);
        if (!result) {
            return false;
        }
        this.setStop(2);
        return true;
    }

    public final void setStop(int code) {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].setStop(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean doPeriodicWork() throws Exception {
        FPIntSet fPIntSet = this.theFPSet;
        synchronized (fPIntSet) {
            if (this.checkLiveness && !this.liveCheck.check(false)) {
                return false;
            }
            if (TLCGlobals.doCheckPoint()) {
                MP.printMessage(2195, this.metadir);
                this.theFPSet.beginChkpt();
                if (this.checkLiveness) {
                    this.liveCheck.beginChkpt();
                }
                UniqueString.internTbl.beginChkpt(this.metadir);
                this.theFPSet.commitChkpt();
                if (this.checkLiveness) {
                    this.liveCheck.commitChkpt();
                }
                UniqueString.internTbl.commitChkpt(this.metadir);
                MP.printMessage(2196);
            }
        }
        return true;
    }

    public final boolean recover() throws IOException {
        boolean recovered = false;
        if (this.fromChkpt != null) {
            MP.printMessage(2197, this.fromChkpt);
            this.theFPSet.recover();
            if (this.checkLiveness) {
                this.liveCheck.recover();
            }
            MP.printMessage(2203, String.valueOf(this.theFPSet.size()));
            recovered = true;
            this.numOfGenStates.set(this.theFPSet.size());
        }
        return recovered;
    }

    protected final void cleanup(boolean success) throws IOException {
        this.theFPSet.close();
        if (this.checkLiveness) {
            this.liveCheck.close();
        }
        if (this.allStateWriter != null) {
            this.allStateWriter.close();
        }
        FileUtil.deleteDir(this.metadir, success);
    }

    public final void printSummary(boolean success) throws IOException {
        this.reportCoverage(this.workers);
        if (TLCGlobals.tool) {
            MP.printMessage(2206, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size())});
        }
        MP.printMessage(2204, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size())});
    }

    public final void reportSuccess() throws IOException {
        long d = this.theFPSet.size();
        double prob1 = (double)(d * (this.numOfGenStates.get() - d)) / Math.pow(2.0, 64.0);
        double prob2 = this.theFPSet.checkFPs();
        MP.printMessage(2193, new String[]{String.valueOf(prob1), String.valueOf(prob2)});
    }

    @Override
    protected IdThread[] startWorkers(AbstractChecker checker, int checkIndex) {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new DFIDWorker(i, checkIndex, checker);
            this.workers[i].start();
        }
        return this.workers;
    }

    @Override
    protected void runTLCPreLoop() {
        this.done = false;
    }

    @Override
    protected void runTLCContinueDoing(int count, int depth) throws Exception {
        MP.printMessage(2206, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size())});
        if (count == 0) {
            this.reportCoverage(this.workers);
            count = TLCGlobals.coverageInterval / 60000;
        } else {
            --count;
        }
        this.wait(60000L);
    }
}

