/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.api;

import com.google.inject.Singleton;
import de.prob.ui.api.ITool;
import de.prob.ui.api.IToolListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class ToolRegistry {
    private final Map<String, ITool> tools = new HashMap<String, ITool>();
    List<WeakReference<IToolListener>> listeners = new ArrayList<WeakReference<IToolListener>>();

    public void registerListener(IToolListener listener) {
        this.listeners.add(new WeakReference<IToolListener>(listener));
    }

    public void register(String name, ITool stateprovider) {
        this.tools.put(name, stateprovider);
    }

    public void unregister(String name) {
        this.tools.remove(name);
    }

    public void notifyToolChange(String trigger, ITool tool) {
        for (WeakReference<IToolListener> listener : this.listeners) {
            ((IToolListener)listener.get()).animationChange(trigger, tool);
        }
    }

    public ITool getTool(String id) {
        return this.tools.get(id);
    }
}

