/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.ITraceDescription;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindTraceBetweenNodesCommand
extends AbstractCommand
implements ITraceDescription,
IStateSpaceModifier {
    private static final String PROLOG_COMMAND_NAME = "find_trace_from_node_to_node";
    Logger logger = LoggerFactory.getLogger(FindTraceBetweenNodesCommand.class);
    private static final String TRACE = "Trace";
    List<Transition> newTransitions = new ArrayList<Transition>();
    private final StateSpace stateSpace;
    private final String sourceId;
    private final String destId;

    public FindTraceBetweenNodesCommand(StateSpace stateSpace, String sourceId, String destId) {
        this.stateSpace = stateSpace;
        this.sourceId = sourceId;
        this.destId = destId;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtomOrNumber(this.sourceId);
        pto.printAtomOrNumber(this.destId);
        pto.printVariable(TRACE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm trace = (PrologTerm)bindings.get((Object)TRACE);
        if (trace instanceof ListPrologTerm) {
            for (PrologTerm term : (ListPrologTerm)trace) {
                this.newTransitions.add(Transition.createTransitionFromCompoundPrologTerm(this.stateSpace, (CompoundPrologTerm)term));
            }
        } else {
            String msg = "Trace was not found. Error was: " + trace.getFunctor();
            this.logger.error(msg);
            throw new RuntimeException(msg);
        }
    }

    @Override
    public List<Transition> getNewTransitions() {
        return this.newTransitions;
    }

    @Override
    public Trace getTrace(StateSpace s) throws RuntimeException {
        if (this.newTransitions.isEmpty()) {
            return new Trace(s.getState(this.sourceId));
        }
        return Trace.getTraceFromTransitions(s, this.newTransitions);
    }
}

