/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.AbstractEvalResult;
import de.prob.animator.domainobjects.ComputationNotCompletedResult;
import de.prob.animator.domainobjects.EvalResult;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.IntegerPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EvalstoreEvalCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "es_eval";
    private static final String RESULT_VAR = "Result";
    private final long evalstoreId;
    private final IEvalElement evalElement;
    private final Integer timeout;
    private EvalstoreResult result;

    public EvalstoreEvalCommand(long evalstoreId, IEvalElement evalElement, Integer timeout) {
        this.evalstoreId = evalstoreId;
        this.evalElement = evalElement;
        this.timeout = timeout;
    }

    public EvalstoreEvalCommand(long evalstoreId, IEvalElement evalElement) {
        this(evalstoreId, evalElement, null);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printNumber(this.evalstoreId);
        this.evalElement.printProlog(pto);
        if (this.timeout == null) {
            pto.printAtom("none");
        } else {
            pto.printNumber((long)this.timeout.intValue());
        }
        pto.printVariable(RESULT_VAR);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        EvalstoreResult result;
        CompoundPrologTerm term = (CompoundPrologTerm)bindings.get((Object)RESULT_VAR);
        if (term.hasFunctor("interrupted", 0)) {
            result = new EvalstoreResult(false, true, this.evalstoreId, null, Collections.<String>emptyList());
        } else if (term.hasFunctor("timeout", 0)) {
            result = new EvalstoreResult(true, false, this.evalstoreId, null, Collections.<String>emptyList());
        } else if (term.hasFunctor("errors", 1)) {
            ListPrologTerm args = (ListPrologTerm)term.getArgument(1);
            ArrayList<String> errors = new ArrayList<String>(args.size());
            for (PrologTerm arg : args) {
                errors.add(PrologTerm.atomicString((PrologTerm)((CompoundPrologTerm)arg).getArgument(1)));
            }
            String error = errors.isEmpty() ? "unspecified error" : (String)errors.get(0);
            ComputationNotCompletedResult er = new ComputationNotCompletedResult(this.evalElement.getCode(), error);
            result = new EvalstoreResult(false, false, this.evalstoreId, er, Collections.<String>emptyList());
        } else if (term.hasFunctor("ok", 4)) {
            String valueStr = PrologTerm.atomicString((PrologTerm)term.getArgument(2));
            ListPrologTerm ids = (ListPrologTerm)term.getArgument(3);
            List newIdentifiers = PrologTerm.atomicStrings((Iterable)ids);
            long storeId = ((IntegerPrologTerm)term.getArgument(4)).getValue().longValue();
            EvalResult er = new EvalResult(valueStr, Collections.<String, String>emptyMap());
            result = new EvalstoreResult(false, false, storeId, er, newIdentifiers);
        } else {
            throw new IllegalStateException("Unexpected es_eval result: " + term.getFunctor() + "/" + term.getArity());
        }
        this.result = result;
    }

    public EvalstoreResult getResult() {
        return this.result;
    }

    public static class EvalstoreResult {
        private final boolean hasTimeoutOccurred;
        private final boolean hasInterruptedOccurred;
        private final long resultingStoreId;
        private final AbstractEvalResult result;
        private final List<String> newIdentifiers;

        public EvalstoreResult(boolean hasTimeoutOccurred, boolean hasInterruptedOccurred, long resultingStoreId, AbstractEvalResult result, List<String> newIdentifiers) {
            this.hasTimeoutOccurred = hasTimeoutOccurred;
            this.hasInterruptedOccurred = hasInterruptedOccurred;
            this.resultingStoreId = resultingStoreId;
            this.result = result;
            this.newIdentifiers = newIdentifiers;
        }

        public boolean hasTimeoutOccurred() {
            return this.hasTimeoutOccurred;
        }

        public boolean hasInterruptedOccurred() {
            return this.hasInterruptedOccurred;
        }

        public boolean isSuccess() {
            return !this.hasTimeoutOccurred && !this.hasInterruptedOccurred && this.result instanceof EvalResult;
        }

        public long getResultingStoreId() {
            return this.resultingStoreId;
        }

        public AbstractEvalResult getResult() {
            return this.result;
        }

        public List<String> getNewIdentifiers() {
            return this.newIdentifiers;
        }

        public String toString() {
            String str = this.hasTimeoutOccurred ? "*timeout*" : (this.hasInterruptedOccurred ? "*interrupted*" : this.result.toString());
            return str;
        }
    }
}

