/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.OpDefNode;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.util.Context;
import tlc2.value.Applicable;
import tlc2.value.OpValue;
import tlc2.value.Value;
import tlc2.value.ValueExcept;
import util.Assert;
import util.WrongInvocationException;

public class OpLambdaValue
extends OpValue
implements Applicable {
    public OpDefNode opDef;
    public Tool tool;
    public Context con;
    public TLCState state;
    public TLCState pstate;

    public OpLambdaValue(OpDefNode op, Tool tool, Context con, TLCState state, TLCState pstate) {
        this.opDef = op;
        this.tool = tool;
        this.state = state;
        this.con = con;
        this.pstate = pstate;
    }

    @Override
    public final byte getKind() {
        return 10;
    }

    @Override
    public final int compareTo(Object obj) {
        Assert.fail("Attempted to compare operator " + OpLambdaValue.ppr(this.toString()) + " with value:\n" + OpLambdaValue.ppr(obj.toString()));
        return 0;
    }

    public final boolean equals(Object obj) {
        Assert.fail("Attempted to check equality of operator " + OpLambdaValue.ppr(this.toString()) + " with value:\n" + OpLambdaValue.ppr(obj.toString()));
        return false;
    }

    @Override
    public final boolean member(Value elem) {
        Assert.fail("Attempted to check if the value:\n" + OpLambdaValue.ppr(elem.toString()) + "\nis an element of operator " + OpLambdaValue.ppr(this.toString()));
        return false;
    }

    @Override
    public final boolean isFinite() {
        Assert.fail("Attempted to check if the operator " + OpLambdaValue.ppr(this.toString()) + " is a finite set.");
        return false;
    }

    @Override
    public final Value apply(Value arg, int control) {
        throw new WrongInvocationException("Should use the other apply method.");
    }

    @Override
    public final Value apply(Value[] args, int control) {
        int alen = this.opDef.getArity();
        if (alen != args.length) {
            Assert.fail("Applying the operator " + OpLambdaValue.ppr(this.toString()) + " with wrong number of arguments.");
        }
        Context c1 = this.con;
        FormalParamNode[] formals = this.opDef.getParams();
        for (int i = 0; i < alen; ++i) {
            c1 = c1.cons(formals[i], args[i]);
        }
        return this.tool.eval(this.opDef.getBody(), c1, this.state, this.pstate, control);
    }

    @Override
    public final Value select(Value arg) {
        throw new WrongInvocationException("Error(TLC): attempted to call OpLambdaValue.select().");
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        Assert.fail("Attempted to appy EXCEPT construct to the operator " + OpLambdaValue.ppr(this.toString()) + ".");
        return null;
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        Assert.fail("Attempted to apply EXCEPT construct to the operator " + OpLambdaValue.ppr(this.toString()) + ".");
        return null;
    }

    @Override
    public final Value getDomain() {
        Assert.fail("Attempted to compute the domain of the operator " + OpLambdaValue.ppr(this.toString()) + ".");
        return EmptySet;
    }

    @Override
    public final int size() {
        Assert.fail("Attempted to compute the number of elements in the operator " + OpLambdaValue.ppr(this.toString()) + ".");
        return 0;
    }

    @Override
    public final boolean isNormalized() {
        throw new WrongInvocationException("Should not normalize an operator.");
    }

    @Override
    public final void normalize() {
        throw new WrongInvocationException("Should not normalize an operator.");
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        throw new WrongInvocationException("Should not initialize an operator.");
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        String opName = this.opDef.getName().toString();
        return sb.append("<Operator ").append(opName).append(">");
    }
}

