/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import tlc2.output.MP;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;

public final class MemFPSet2
extends FPSet {
    private String metadir;
    private String filename;
    private byte[][] table;
    private long count;
    private int mask;
    private int LogSpineSize = 24;

    public MemFPSet2(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        int spineSize = 1 << this.LogSpineSize;
        this.count = 0L;
        this.table = new byte[spineSize][];
        this.mask = spineSize - 1;
    }

    @Override
    public void init(int numThreads, String metadir, String fname) {
        this.metadir = metadir;
        this.filename = metadir + FileUtil.separator + fname;
    }

    @Override
    public final synchronized long size() {
        return this.count;
    }

    @Override
    public final synchronized boolean put(long fp) {
        int index = (int)(fp & (long)this.mask);
        byte[] bucket = this.table[index];
        byte b1 = (byte)(fp >>> 24 & 0xFFL);
        byte b2 = (byte)(fp >>> 32 & 0xFFL);
        byte b3 = (byte)(fp >>> 40 & 0xFFL);
        byte b4 = (byte)(fp >>> 48 & 0xFFL);
        byte b5 = (byte)(fp >>> 56 & 0xFFL);
        int len = bucket == null ? 0 : bucket.length;
        for (int i = 0; i < len; i += 5) {
            if (bucket[i] != b1 || bucket[i + 1] != b2 || bucket[i + 2] != b3 || bucket[i + 3] != b4 || bucket[i + 4] != b5) continue;
            return true;
        }
        byte[] newBucket = new byte[len + 5];
        if (bucket != null) {
            System.arraycopy(bucket, 0, newBucket, 0, len);
        }
        this.table[index] = newBucket;
        newBucket[len] = b1;
        newBucket[len + 1] = b2;
        newBucket[len + 2] = b3;
        newBucket[len + 3] = b4;
        newBucket[len + 4] = b5;
        ++this.count;
        return false;
    }

    @Override
    public final synchronized boolean contains(long fp) {
        int index = (int)(fp & (long)this.mask);
        byte[] bucket = this.table[index];
        byte b1 = (byte)(fp >>> 24 & 0xFFL);
        byte b2 = (byte)(fp >>> 32 & 0xFFL);
        byte b3 = (byte)(fp >>> 40 & 0xFFL);
        byte b4 = (byte)(fp >>> 48 & 0xFFL);
        byte b5 = (byte)(fp >>> 56 & 0xFFL);
        int len = bucket == null ? 0 : bucket.length;
        for (int i = 0; i < len; i += 5) {
            if (bucket[i] != b1 || bucket[i + 1] != b2 || bucket[i + 2] != b3 || bucket[i + 3] != b4 || bucket[i + 4] != b5) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        if (cleanup) {
            FileUtil.deleteDir(this.metadir, true);
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        MP.printMessage(2211, hostname);
        System.exit(0);
    }

    @Override
    public final double checkFPs() {
        long dis = Long.MAX_VALUE;
        for (int i = 0; i < this.table.length; ++i) {
            long low = (long)i & 0xFFFFFFL;
            byte[] bucket = this.table[i];
            if (bucket == null) continue;
            int j = 0;
            while (j < bucket.length) {
                long b1 = ((long)bucket[j++] & 0xFFL) << 24;
                long b2 = ((long)bucket[j++] & 0xFFL) << 32;
                long b3 = ((long)bucket[j++] & 0xFFL) << 40;
                long b4 = ((long)bucket[j++] & 0xFFL) << 48;
                long b5 = ((long)bucket[j++] & 0xFFL) << 56;
                long fp = b5 | b4 | b3 | b2 | b1 | low;
                int k = j;
                while (k < bucket.length) {
                    long fp1;
                    long dis1;
                    b1 = ((long)bucket[k++] & 0xFFL) << 24;
                    b2 = ((long)bucket[k++] & 0xFFL) << 32;
                    b3 = ((long)bucket[k++] & 0xFFL) << 40;
                    if ((dis1 = fp > (fp1 = (b5 = ((long)bucket[k++] & 0xFFL) << 56) | (b4 = ((long)bucket[k++] & 0xFFL) << 48) | b3 | b2 | b1 | low) ? fp - fp1 : fp1 - fp) < 0L) continue;
                    dis = Math.min(dis, dis1);
                }
                for (k = i + 1; k < this.table.length; ++k) {
                    byte[] bucket1 = this.table[k];
                    if (bucket1 == null) continue;
                    long low1 = (long)k & 0xFFFFFFL;
                    int k1 = 0;
                    while (k1 < bucket.length) {
                        long fp1;
                        long dis1;
                        b1 = ((long)bucket[k1++] & 0xFFL) << 24;
                        b2 = ((long)bucket[k1++] & 0xFFL) << 32;
                        b3 = ((long)bucket[k1++] & 0xFFL) << 40;
                        if ((dis1 = fp > (fp1 = (b5 = ((long)bucket[k1++] & 0xFFL) << 56) | (b4 = ((long)bucket[k1++] & 0xFFL) << 48) | b3 | b2 | b1 | low1) ? fp - fp1 : fp1 - fp) < 0L) continue;
                        dis = Math.min(dis, dis1);
                    }
                }
            }
        }
        return 1.0 / (double)dis;
    }

    @Override
    public final void beginChkpt(String fname) throws IOException {
        BufferedDataOutputStream dos = new BufferedDataOutputStream(this.chkptName(fname, "tmp"));
        for (int i = 0; i < this.table.length; ++i) {
            long low = (long)i & 0xFFFFFFL;
            byte[] bucket = this.table[i];
            if (bucket == null) continue;
            int j = 0;
            while (j < bucket.length) {
                long b1 = ((long)bucket[j++] & 0xFFL) << 24;
                long b2 = ((long)bucket[j++] & 0xFFL) << 32;
                long b3 = ((long)bucket[j++] & 0xFFL) << 40;
                long b4 = ((long)bucket[j++] & 0xFFL) << 48;
                long b5 = ((long)bucket[j++] & 0xFFL) << 56;
                long fp = b5 | b4 | b3 | b2 | b1 | low;
                dos.writeLong(fp);
            }
        }
        dos.close();
    }

    @Override
    public final void commitChkpt(String fname) throws IOException {
        File oldChkpt = new File(this.chkptName(fname, "chkpt"));
        File newChkpt = new File(this.chkptName(fname, "tmp"));
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemFPSet2.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    @Override
    public final void recover(String fname) throws IOException {
        BufferedDataInputStream dis = new BufferedDataInputStream(this.chkptName(fname, "chkpt"));
        try {
            while (!dis.atEOF()) {
                Assert.check(!this.put(dis.readLong()), 2133);
            }
        }
        catch (EOFException e) {
            throw new IOException("MemFPSet2.recover: failed.");
        }
        dis.close();
    }

    @Override
    public final void beginChkpt() throws IOException {
        this.beginChkpt(this.filename);
    }

    @Override
    public final void commitChkpt() throws IOException {
        this.commitChkpt(this.filename);
    }

    @Override
    public final void recover() throws IOException {
        this.recover(this.filename);
    }

    @Override
    public final void prepareRecovery() throws IOException {
    }

    @Override
    public final void recoverFP(long fp) throws IOException {
        Assert.check(!this.put(fp), 2133);
    }

    @Override
    public final void completeRecovery() throws IOException {
    }

    private final String chkptName(String fname, String ext) {
        return this.metadir + FileUtil.separator + fname + ".fp." + ext;
    }
}

