/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;

public class AssumeNode
extends LevelNode {
    ModuleNode module;
    ExprNode assumeExpr;
    private ThmOrAssumpDefNode def;
    private boolean isAxiom = false;
    int levelChecked = 0;

    public boolean getIsAxiom() {
        return this.isAxiom;
    }

    public AssumeNode(TreeNode stn, ExprNode expr, ModuleNode mn, ThmOrAssumpDefNode opd) {
        super(20, stn);
        this.assumeExpr = expr;
        this.module = mn;
        this.def = opd;
        if (stn.heirs()[0].getImage().equals("AXIOM")) {
            this.isAxiom = true;
        }
        if (opd != null) {
            opd.thmOrAssump = this;
        }
    }

    public final ExprNode getAssume() {
        return this.assumeExpr;
    }

    public final ThmOrAssumpDefNode getDef() {
        return this.def;
    }

    @Override
    public final boolean levelCheck(int iter) {
        if (this.levelChecked >= iter) {
            return true;
        }
        this.levelChecked = iter;
        boolean res = this.assumeExpr.levelCheck(iter);
        if (this.def != null) {
            boolean bl = res = this.def.levelCheck(iter) && res;
        }
        if (this.assumeExpr.getLevel() != 0) {
            errors.addError(this.getTreeNode().getLocation(), "Level error: assumptions must be level 0 (Constant), \nbut this one has level " + this.getLevel() + ".");
        }
        if (res) {
            AssumeNode.addTemporalLevelConstraintToConstants(this.levelParams, this.levelConstraints);
        }
        return res;
    }

    @Override
    public final int getLevel() {
        return this.assumeExpr.getLevel();
    }

    @Override
    public final HashSet getLevelParams() {
        return this.assumeExpr.getLevelParams();
    }

    @Override
    public final HashSet getAllParams() {
        return this.assumeExpr.getAllParams();
    }

    @Override
    public final SetOfLevelConstraints getLevelConstraints() {
        return this.assumeExpr.getLevelConstraints();
    }

    @Override
    public final SetOfArgLevelConstraints getArgLevelConstraints() {
        return this.assumeExpr.getArgLevelConstraints();
    }

    @Override
    public final HashSet getArgLevelParams() {
        return this.assumeExpr.getArgLevelParams();
    }

    @Override
    public final String levelDataToString() {
        return "Level: " + this.getLevel() + "\n" + "LevelParameters: " + this.getLevelParams() + "\n" + "LevelConstraints: " + this.getLevelConstraints() + "\n" + "ArgLevelConstraints: " + this.getArgLevelConstraints() + "\n" + "ArgLevelParams: " + this.getArgLevelParams() + "\n";
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String res = Strings.indent(2, "\n*AssumeNode " + super.toString(depth) + (this.assumeExpr != null ? Strings.indent(2, this.assumeExpr.toString(depth - 1)) : ""));
        if (this.def != null) {
            res = res + Strings.indent(4, "\n def: " + Strings.indent(2, this.def.toString(depth - 1)));
        }
        return res;
    }

    @Override
    public SemanticNode[] getChildren() {
        return new SemanticNode[]{this.assumeExpr};
    }

    @Override
    public final void walkGraph(Hashtable semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        if (this.assumeExpr != null) {
            this.assumeExpr.walkGraph(semNodesTable);
        }
    }

    @Override
    public Element export(Document doc, SymbolContext context) {
        if (this.getDef() == null) {
            return super.export(doc, context);
        }
        return this.getDef().export(doc, context);
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        Element e = doc.createElement("AssumeNode");
        e.appendChild(this.getAssume().export(doc, context));
        return e;
    }
}

