/*
 * Decompiled with CFR 0.152.
 */
package de.prob.webconsole.servlets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import de.prob.webconsole.OutputBuffer;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroovyOutputServlet
extends HttpServlet {
    private final Logger logger = LoggerFactory.getLogger(GroovyOutputServlet.class);
    private final OutputBuffer sideeffects;

    @Inject
    public GroovyOutputServlet(OutputBuffer sideeffects) {
        this.sideeffects = sideeffects;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out = res.getWriter();
        String input = req.getParameter("since");
        int pos = 0;
        try {
            pos = Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            String msg = "Illegal parameter '" + input + "'. Was expecting an integer but received " + input;
            this.logger.error(msg);
        }
        String json = this.sideeffects.getTextAsJSon(pos);
        out.println(json);
        out.close();
    }
}

