/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BecomesEqualTo;
import org.eventb.core.ast.BecomesMemberOf;
import org.eventb.core.ast.BecomesSuchThat;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ISimpleVisitor2;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.PredicateVariable;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IPredicateExtension;
import org.eventb.internal.core.ast.extension.WDMediator;
import org.eventb.internal.core.ast.wd.FormulaBuilder;

public class WDComputer
implements ISimpleVisitor2 {
    private FormulaBuilder fb;
    private Predicate lemma;

    public WDComputer(FormulaFactory formulaFactory) {
        this.fb = new FormulaBuilder(formulaFactory);
    }

    public Predicate getWDLemma(Formula<?> formula) {
        assert (formula.isTypeChecked());
        return (Predicate)this.wd(formula).flatten();
    }

    public Predicate wd(Formula<?> formula) {
        formula.accept(this);
        return this.lemma;
    }

    public Predicate wd(Formula<?> left, Formula<?> right) {
        return this.fb.land(this.wd(left), this.wd(right));
    }

    public Predicate wd(Formula<?> ... children) {
        int length = children.length;
        Predicate[] wds = new Predicate[length];
        for (int i = 0; i < length; ++i) {
            wds[i] = this.wd(children[i]);
        }
        return this.fb.land(wds);
    }

    @Override
    public void visitAssociativeExpression(AssociativeExpression expression) {
        this.lemma = this.wd(expression.getChildren());
    }

    @Override
    public void visitAssociativePredicate(AssociativePredicate predicate) {
        Predicate[] children = predicate.getChildren();
        switch (predicate.getTag()) {
            case 351: {
                this.lemma = this.landWD(children);
                break;
            }
            case 352: {
                this.lemma = this.lorWD(children);
                break;
            }
            default: {
                assert (false);
                this.lemma = null;
            }
        }
    }

    public Predicate lorWD(Predicate[] children) {
        Predicate result = this.fb.btrue;
        for (int i = children.length - 1; i >= 0; --i) {
            Predicate child = children[i];
            result = this.fb.land(this.wd((Formula<?>)child), this.fb.lor(child, result));
        }
        return result;
    }

    public Predicate landWD(Predicate[] children) {
        Predicate result = this.fb.btrue;
        for (int i = children.length - 1; i >= 0; --i) {
            Predicate child = children[i];
            result = this.fb.land(this.wd((Formula<?>)child), this.fb.limp(child, result));
        }
        return result;
    }

    @Override
    public void visitAtomicExpression(AtomicExpression expression) {
        this.lemma = this.fb.btrue;
    }

    @Override
    public void visitBecomesEqualTo(BecomesEqualTo assignment) {
        this.lemma = this.wd(assignment.getExpressions());
    }

    @Override
    public void visitBecomesMemberOf(BecomesMemberOf assignment) {
        this.lemma = this.wd((Formula<?>)assignment.getSet());
    }

    @Override
    public void visitBecomesSuchThat(BecomesSuchThat assignment) {
        BoundIdentDecl[] primedIdents = assignment.getPrimedIdents();
        this.lemma = this.fb.forall(primedIdents, this.wd((Formula<?>)assignment.getCondition()));
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expr) {
        Expression left = expr.getLeft();
        Expression right = expr.getRight();
        this.lemma = this.fb.land(this.wd((Formula<?>)left), this.wd((Formula<?>)right), this.binExprWD(expr, left, right));
    }

    public Predicate binExprWD(BinaryExpression expr, Expression left, Expression right) {
        switch (expr.getTag()) {
            case 223: {
                return this.fb.notZero(right);
            }
            case 224: {
                return this.fb.land(this.fb.nonNegative(left), (Predicate)this.fb.positive(right));
            }
            case 225: {
                return this.fb.land(this.fb.nonNegative(left), this.fb.nonNegative(right));
            }
            case 226: {
                return this.fb.land(this.fb.inDomain(left, right), this.fb.partial(left));
            }
        }
        return this.fb.btrue;
    }

    @Override
    public void visitBinaryPredicate(BinaryPredicate predicate) {
        Predicate left = predicate.getLeft();
        Predicate right = predicate.getRight();
        switch (predicate.getTag()) {
            case 251: {
                this.lemma = this.fb.land(this.wd((Formula<?>)left), this.fb.limp(left, this.wd((Formula<?>)right)));
                break;
            }
            case 252: {
                this.lemma = this.fb.land(this.wd((Formula<?>)left), this.wd((Formula<?>)right));
                break;
            }
            default: {
                assert (false);
                this.lemma = null;
            }
        }
    }

    @Override
    public void visitBoolExpression(BoolExpression expression) {
        this.lemma = this.wd((Formula<?>)expression.getPredicate());
    }

    @Override
    public void visitBoundIdentDecl(BoundIdentDecl boundIdentDecl) {
        this.lemma = this.fb.btrue;
    }

    @Override
    public void visitBoundIdentifier(BoundIdentifier identifierExpression) {
        this.lemma = this.fb.btrue;
    }

    @Override
    public void visitFreeIdentifier(FreeIdentifier identifierExpression) {
        this.lemma = this.fb.btrue;
    }

    @Override
    public void visitIntegerLiteral(IntegerLiteral expression) {
        this.lemma = this.fb.btrue;
    }

    @Override
    public void visitLiteralPredicate(LiteralPredicate predicate) {
        this.lemma = this.fb.btrue;
    }

    @Override
    public void visitMultiplePredicate(MultiplePredicate predicate) {
        this.lemma = this.wd(predicate.getChildren());
    }

    @Override
    public void visitPredicateVariable(PredicateVariable predVar) {
        this.lemma = this.fb.btrue;
    }

    @Override
    public void visitQuantifiedExpression(QuantifiedExpression expression) {
        Predicate localWD;
        BoundIdentDecl[] decls = expression.getBoundIdentDecls();
        Predicate pred = expression.getPredicate();
        Expression expr = expression.getExpression();
        Predicate childrenWD = this.fb.forall(decls, this.fb.land(this.wd((Formula<?>)pred), this.fb.limp(pred, this.wd((Formula<?>)expr))));
        switch (expression.getTag()) {
            case 801: 
            case 803: {
                localWD = this.fb.btrue;
                break;
            }
            case 802: {
                localWD = this.fb.exists(decls, pred);
                break;
            }
            default: {
                assert (false);
                localWD = null;
            }
        }
        this.lemma = this.fb.land(childrenWD, localWD);
    }

    @Override
    public void visitQuantifiedPredicate(QuantifiedPredicate predicate) {
        BoundIdentDecl[] decls = predicate.getBoundIdentDecls();
        Predicate child = predicate.getPredicate();
        this.lemma = this.fb.forall(decls, this.wd((Formula<?>)child));
    }

    @Override
    public void visitRelationalPredicate(RelationalPredicate predicate) {
        this.lemma = this.wd((Formula<?>)predicate.getLeft(), (Formula<?>)predicate.getRight());
    }

    @Override
    public void visitSetExtension(SetExtension expression) {
        this.lemma = this.wd(expression.getMembers());
    }

    @Override
    public void visitSimplePredicate(SimplePredicate predicate) {
        this.lemma = this.wd((Formula<?>)predicate.getExpression());
    }

    @Override
    public void visitUnaryExpression(UnaryExpression expr) {
        Expression child = expr.getChild();
        this.lemma = this.fb.land(this.wd((Formula<?>)child), this.uExprWD(expr, child));
    }

    public Predicate uExprWD(UnaryExpression expr, Expression child) {
        switch (expr.getTag()) {
            case 751: {
                return this.fb.finite(child);
            }
            case 761: {
                return this.fb.land(this.fb.notEmpty(child), this.fb.bounded(child, true));
            }
            case 762: {
                return this.fb.land(this.fb.notEmpty(child), this.fb.bounded(child, false));
            }
            case 755: {
                return this.fb.notEmpty(child);
            }
        }
        return this.fb.btrue;
    }

    @Override
    public void visitUnaryPredicate(UnaryPredicate predicate) {
        this.lemma = this.wd((Formula<?>)predicate.getChild());
    }

    @Override
    public void visitExtendedPredicate(ExtendedPredicate predicate) {
        IPredicateExtension extension = predicate.getExtension();
        WDMediator wdMed = new WDMediator(this.fb);
        Predicate extensionWD = extension.getWDPredicate(predicate, wdMed);
        this.lemma = extension.conjoinChildrenWD() ? this.addChildrenWD(extensionWD, predicate) : extensionWD;
    }

    @Override
    public void visitExtendedExpression(ExtendedExpression expression) {
        IExpressionExtension extension = expression.getExtension();
        WDMediator wdMed = new WDMediator(this.fb);
        Predicate extensionWD = extension.getWDPredicate(expression, wdMed);
        this.lemma = extension.conjoinChildrenWD() ? this.addChildrenWD(extensionWD, expression) : extensionWD;
    }

    private Predicate addChildrenWD(Predicate initialWD, IExtendedFormula formula) {
        Predicate exprWD = this.wd(formula.getChildExpressions());
        Predicate predWD = this.wd(formula.getChildPredicates());
        Predicate childWD = this.fb.land(exprWD, predWD);
        return this.fb.land(initialWD, childWD);
    }
}

