/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import org.eventb.core.ast.BooleanType;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExpressionExtension;

public class TypeRewriter
implements ITypeVisitor {
    private final FormulaFactory ff;
    protected Type result;

    public TypeRewriter(FormulaFactory ff) {
        this.ff = ff;
    }

    public Type rewrite(Type type) {
        if (type == null) {
            return null;
        }
        this.result = null;
        type.accept(this);
        return this.result;
    }

    @Override
    public void visit(BooleanType type) {
        this.result = this.ff == type.getFactory() ? type : this.ff.makeBooleanType();
    }

    @Override
    public void visit(GivenType type) {
        this.result = this.ff == type.getFactory() ? type : this.ff.makeGivenType(type.getName());
    }

    @Override
    public void visit(IntegerType type) {
        this.result = this.ff == type.getFactory() ? type : this.ff.makeIntegerType();
    }

    @Override
    public void visit(ParametricType type) {
        boolean changed = this.ff != type.getFactory();
        Type[] typeParameters = type.getTypeParameters();
        Type[] newTypeParameters = new Type[typeParameters.length];
        for (int i = 0; i < typeParameters.length; ++i) {
            newTypeParameters[i] = this.rewrite(typeParameters[i]);
            changed |= newTypeParameters[i] != typeParameters[i];
        }
        IExpressionExtension constructor = type.getExprExtension();
        this.result = changed ? this.ff.makeParametricType(constructor, newTypeParameters) : type;
    }

    @Override
    public void visit(PowerSetType type) {
        Type base = type.getBaseType();
        Type newBase = this.rewrite(base);
        this.result = newBase == base ? type : this.ff.makePowerSetType(newBase);
    }

    @Override
    public void visit(ProductType type) {
        Type left = type.getLeft();
        Type right = type.getRight();
        Type newLeft = this.rewrite(left);
        Type newRight = this.rewrite(right);
        this.result = newLeft == left && newRight == right ? type : this.ff.makeProductType(newLeft, newRight);
    }
}

