/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IAccumulator;
import org.eventb.core.ast.IFormulaInspector;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.PredicateVariable;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.Position;

public class FindingAccumulator<F>
implements IAccumulator<F> {
    private final IFormulaInspector<F> inspector;
    private final IntStack indexes = new IntStack();
    private final List<F> findings = new ArrayList<F>();
    private boolean skipChildren = false;
    private boolean skipAll = false;

    public FindingAccumulator(IFormulaInspector<F> inspector) {
        this.inspector = inspector;
    }

    @Override
    public void add(F item) {
        this.findings.add(item);
    }

    @Override
    public void add(F ... items) {
        for (F item : items) {
            this.findings.add(item);
        }
    }

    @Override
    public void add(Collection<F> items) {
        this.findings.addAll(items);
    }

    @Override
    public IPosition getCurrentPosition() {
        return new Position(this.indexes);
    }

    public void inspect(UnaryPredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(UnaryExpression expression) {
        this.inspector.inspect(expression, this);
    }

    public void inspect(SimplePredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(SetExtension expression) {
        this.inspector.inspect(expression, this);
    }

    public void inspect(RelationalPredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(QuantifiedPredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(QuantifiedExpression expression) {
        this.inspector.inspect(expression, this);
    }

    public void inspect(PredicateVariable predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(MultiplePredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(LiteralPredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(IntegerLiteral literal) {
        this.inspector.inspect(literal, this);
    }

    public void inspect(ExtendedPredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(ExtendedExpression expression) {
        this.inspector.inspect(expression, this);
    }

    public void inspect(FreeIdentifier identifier) {
        this.inspector.inspect(identifier, this);
    }

    public void inspect(BoundIdentifier identifier) {
        this.inspector.inspect(identifier, this);
    }

    public void inspect(BoundIdentDecl decl) {
        this.inspector.inspect(decl, this);
    }

    public void inspect(BoolExpression expression) {
        this.inspector.inspect(expression, this);
    }

    public void inspect(BinaryPredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(BinaryExpression expression) {
        this.inspector.inspect(expression, this);
    }

    public void inspect(AtomicExpression expression) {
        this.inspector.inspect(expression, this);
    }

    public void inspect(AssociativePredicate predicate) {
        this.inspector.inspect(predicate, this);
    }

    public void inspect(AssociativeExpression expression) {
        this.inspector.inspect(expression, this);
    }

    public List<F> getFindings() {
        return this.findings;
    }

    public void enterChildren() {
        this.indexes.push(0);
    }

    public void nextChild() {
        this.indexes.incrementTop();
    }

    public void leaveChildren() {
        this.indexes.pop();
    }

    @Override
    public void skipChildren() {
        this.skipChildren = true;
    }

    @Override
    public void skipAll() {
        this.skipAll = true;
    }

    public boolean childrenSkipped() {
        boolean wasSkipChildren = this.skipChildren;
        this.skipChildren = false;
        return this.skipAll || wasSkipChildren;
    }

    public boolean allSkipped() {
        return this.skipAll;
    }
}

