/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Arrays;
import java.util.List;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.DefaultVisitor;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.internal.core.ast.DefaultTypeCheckingRewriter;
import org.eventb.internal.core.upgrade.UpgradeResult;
import org.eventb.internal.core.upgrade.VersionUpgrader;

class VersionUpgraderV1V2
extends VersionUpgrader {
    private static final List<String> RESERVED_NAMES = Arrays.asList("partition");

    public VersionUpgraderV1V2() {
        super(FormulaFactory.getV1Default());
    }

    @Override
    protected <T extends Formula<T>> void checkUpgrade(String formulaString, Formula<T> formula, UpgradeResult<T> result) {
        UpgradeVisitorV1V2<T> upgradeVisitor = new UpgradeVisitorV1V2<T>(formulaString, result, this.getReservedKeywords());
        formula.accept(upgradeVisitor);
    }

    @Override
    protected <T extends Formula<T>> void upgrade(T formula, UpgradeResult<T> result) {
        block3: {
            RewriterV1V2 rewriter = new RewriterV1V2(result.getFactory(), this.getReservedKeywords());
            try {
                T rewritten = formula.rewrite(rewriter);
                result.setUpgradedFormula(rewritten);
            }
            catch (Exception e) {
                if (!result.hasProblem()) {
                    result.addProblem(new ASTProblem(formula.getSourceLocation(), ProblemKind.NotUpgradableError, 1, new Object[0]));
                }
                if (!VersionUpgrader.DEBUG) break block3;
                System.out.println("Exception while rewriting formula " + formula);
                e.printStackTrace();
            }
        }
    }

    @Override
    protected List<String> getReservedKeywords() {
        return RESERVED_NAMES;
    }

    private static class UpgradeVisitorV1V2<T extends Formula<T>>
    extends DefaultVisitor {
        private final String formula;
        private final UpgradeResult<T> result;
        private final List<String> reservedNames;

        public UpgradeVisitorV1V2(String formula, UpgradeResult<T> result, List<String> reservedNames) {
            this.formula = formula;
            this.result = result;
            this.reservedNames = reservedNames;
        }

        @Override
        public boolean enterKID(UnaryExpression expr) {
            this.result.setUpgradeNeeded(true);
            return false;
        }

        @Override
        public boolean enterKPRJ1(UnaryExpression expr) {
            this.result.setUpgradeNeeded(true);
            return false;
        }

        @Override
        public boolean enterKPRJ2(UnaryExpression expr) {
            this.result.setUpgradeNeeded(true);
            return false;
        }

        private boolean lacksParentheses(Expression expression) {
            SourceLocation srcLoc = expression.getSourceLocation();
            return !UpgradeVisitorV1V2.findLeftParen(this.formula, srcLoc.getStart() - 1) || !UpgradeVisitorV1V2.findRightParen(this.formula, srcLoc.getEnd() + 1);
        }

        private static boolean findLeftParen(String form, int maxIndex) {
            for (int i = maxIndex; i >= 0; --i) {
                char ch = form.charAt(i);
                if (FormulaFactory.isEventBWhiteSpace(ch)) continue;
                return ch == '(';
            }
            return false;
        }

        private static boolean findRightParen(String form, int minIndex) {
            for (int i = minIndex; i < form.length(); ++i) {
                char ch = form.charAt(i);
                if (FormulaFactory.isEventBWhiteSpace(ch)) continue;
                return ch == ')';
            }
            return false;
        }

        private boolean processRelSetExpr(BinaryExpression expr) {
            Expression left = expr.getLeft();
            if (this.isRelationalSet(left)) {
                this.result.setUpgradeNeeded(this.lacksParentheses(left));
            }
            return !this.result.upgradeNeeded();
        }

        private boolean isRelationalSet(Expression expr) {
            switch (expr.getTag()) {
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean enterREL(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterTREL(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterSREL(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterSTREL(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterPFUN(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterTFUN(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterPINJ(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterTINJ(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterPSUR(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterTSUR(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean enterTBIJ(BinaryExpression expr) {
            return this.processRelSetExpr(expr);
        }

        @Override
        public boolean visitBOUND_IDENT_DECL(BoundIdentDecl ident) {
            if (this.reservedNames.contains(ident.getName())) {
                this.result.setUpgradeNeeded(true);
            }
            return true;
        }

        @Override
        public boolean visitFREE_IDENT(FreeIdentifier ident) {
            if (this.reservedNames.contains(ident.getName())) {
                this.result.setUpgradeNeeded(true);
                this.result.addProblem(new ASTProblem(ident.getSourceLocation(), ProblemKind.NotUpgradableError, 1, new Object[0]));
                return false;
            }
            return true;
        }
    }

    private static class RewriterV1V2
    extends DefaultTypeCheckingRewriter {
        private final List<String> reservedNames;

        public RewriterV1V2(FormulaFactory factory, List<String> reservedNames) {
            super(factory);
            this.reservedNames = reservedNames;
        }

        private static final int getGenericTag(int tag) {
            switch (tag) {
                case 758: {
                    return 410;
                }
                case 759: {
                    return 411;
                }
                case 760: {
                    return 412;
                }
            }
            return -1;
        }

        private String getNotReservedName(String name) {
            if (!this.reservedNames.contains(name)) {
                return name;
            }
            String newName = name + "1";
            assert (!this.reservedNames.contains(newName));
            return newName;
        }

        @Override
        public BoundIdentDecl rewrite(BoundIdentDecl src) {
            String name = this.getNotReservedName(src.getName());
            Type type = this.typeRewriter.rewrite(src.getType());
            return this.ff.makeBoundIdentDecl(name, null, type);
        }

        @Override
        public Expression rewrite(UnaryExpression src, boolean changed, Expression newChild) {
            int tag = src.getTag();
            int genericTag = RewriterV1V2.getGenericTag(tag);
            if (genericTag < 0) {
                return super.rewrite(src, changed, newChild);
            }
            Type type = this.typeRewriter.rewrite(src.getType());
            if (newChild.isATypeExpression()) {
                return this.ff.makeAtomicExpression(genericTag, null, type);
            }
            return this.makeDomRes(newChild, genericTag, type);
        }

        private Expression makeDomRes(Expression left, int genTag, Type type) {
            return this.ff.makeBinaryExpression(217, left, this.ff.makeAtomicExpression(genTag, null, type), null);
        }
    }
}

