/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.MainParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class BecomesEqualTo
extends Assignment {
    private static final String BECEQ_ID = "Becomes Equal To";
    public static final IOperatorInfo<BecomesEqualTo> OP_BECEQ = new IOperatorInfo<BecomesEqualTo>(){

        @Override
        public IParserPrinter<BecomesEqualTo> makeParser(int kind) {
            return new MainParsers.BecomesEqualToParser(kind);
        }

        @Override
        public String getImage() {
            return "\u2254";
        }

        @Override
        public String getId() {
            return BecomesEqualTo.BECEQ_ID;
        }

        @Override
        public String getGroupId() {
            return StandardGroup.INFIX_SUBST.getId();
        }

        @Override
        public boolean isSpaced() {
            return true;
        }
    };
    private final Expression[] values;

    public static void init(BMath grammar) {
        try {
            grammar.addOperator(OP_BECEQ);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected BecomesEqualTo(FreeIdentifier[] assignedIdents, Expression[] values, SourceLocation location, FormulaFactory ff) {
        super(6, ff, location, BecomesEqualTo.combineHashCodes(values), assignedIdents);
        this.values = values;
        FormulaChecks.ensureSameLength(assignedIdents, values);
        this.ensureSameFactory(this.values);
        this.setPredicateVariableCache(this.values);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        int length = this.assignedIdents.length;
        Formula[] children = new Expression[length * 2];
        System.arraycopy(this.assignedIdents, 0, children, 0, length);
        System.arraycopy(this.values, 0, children, length, length);
        IdentListMerger freeIdentMerger = BecomesEqualTo.mergeFreeIdentifiers((Formula[])children);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = BecomesEqualTo.mergeBoundIdentifiers((Formula[])children);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Type type = this.assignedIdents[i].getType();
            if (type != null && type.equals(this.values[i].getType())) continue;
            return;
        }
        this.typeChecked = true;
    }

    public Expression[] getExpressions() {
        return (Expression[])this.values.clone();
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.collectFreeIdentifiers(freeIdentSet);
        }
        for (Expression value : this.values) {
            value.collectFreeIdentifiers(freeIdentSet);
        }
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.collectNamesAbove(names, boundNames, offset);
        }
        for (Expression value : this.values) {
            value.collectNamesAbove(names, boundNames, offset);
        }
    }

    private String getOperatorImage() {
        return OP_BECEQ.getImage();
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        int kind = mediator.getKind();
        OP_BECEQ.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String childTabs = tabs + '\t';
        StringBuilder result = new StringBuilder();
        result.append(tabs);
        result.append(this.getClass().getSimpleName());
        result.append(" [:=]\n");
        for (FreeIdentifier ident : this.assignedIdents) {
            result.append(ident.getSyntaxTree(boundNames, childTabs));
        }
        for (Expression value : this.values) {
            result.append(value.getSyntaxTree(boundNames, childTabs));
        }
        return result.toString();
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        BecomesEqualTo other = (BecomesEqualTo)formula;
        return this.hasSameAssignedIdentifiers(other) && Arrays.equals(this.values, other.values);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] boundAbove) {
        for (int i = 0; i < this.values.length; ++i) {
            this.assignedIdents[i].typeCheck(result, boundAbove);
            this.values[i].typeCheck(result, boundAbove);
            result.unify(this.assignedIdents[i].getType(), this.values[i].getType(), this);
        }
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.isLegible(result);
        }
        for (Expression value : this.values) {
            value.isLegible(result);
        }
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        for (Expression value : this.values) {
            value.solveType(unifier);
        }
    }

    @Override
    public boolean accept(IVisitor visitor) {
        int i;
        boolean goOn = visitor.enterBECOMES_EQUAL_TO(this);
        for (i = 0; goOn && i < this.assignedIdents.length; ++i) {
            goOn = this.assignedIdents[i].accept(visitor);
            if (!goOn) continue;
            goOn = visitor.continueBECOMES_EQUAL_TO(this);
        }
        for (i = 0; goOn && i < this.values.length; ++i) {
            if (i != 0) {
                goOn = visitor.continueBECOMES_EQUAL_TO(this);
            }
            if (!goOn) continue;
            goOn = this.values[i].accept(visitor);
        }
        return visitor.exitBECOMES_EQUAL_TO(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitBecomesEqualTo(this);
    }

    @Override
    protected Predicate getFISPredicateRaw() {
        return this.getFactory().makeLiteralPredicate(610, this.getSourceLocation());
    }

    @Override
    protected Predicate getBAPredicateRaw() {
        FormulaFactory ff = this.getFactory();
        SourceLocation loc = this.getSourceLocation();
        int length = this.assignedIdents.length;
        Predicate[] predicates = new Predicate[length];
        for (int i = 0; i < length; ++i) {
            predicates[i] = ff.makeRelationalPredicate(101, this.assignedIdents[i].withPrime(), this.values[i], loc);
        }
        if (predicates.length > 1) {
            return ff.makeAssociativePredicate(351, predicates, loc);
        }
        return predicates[0];
    }

    @Override
    public FreeIdentifier[] getUsedIdentifiers() {
        if (this.values.length == 1) {
            return this.values[0].getFreeIdentifiers();
        }
        IdentListMerger freeIdentMerger = BecomesEqualTo.mergeFreeIdentifiers((Formula[])this.values);
        FreeIdentifier[] idents = freeIdentMerger.getFreeMergedArray();
        return (FreeIdentifier[])idents.clone();
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }
}

