/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_ds.PersistentSortedSet;
import com.github.krukow.clj_ds.TransientCollection;
import com.github.krukow.clj_lang.APersistentMap;
import com.github.krukow.clj_lang.APersistentSet;
import com.github.krukow.clj_lang.IObj;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.PersistentTreeMap;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.Reversible;
import com.github.krukow.clj_lang.Sorted;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentTreeSet<T>
extends APersistentSet<T>
implements IObj,
Reversible<T>,
Sorted<T>,
PersistentSortedSet<T> {
    public static final PersistentTreeSet EMPTY = new PersistentTreeSet(null, PersistentTreeMap.EMPTY);
    final IPersistentMap _meta;

    public static <T> PersistentTreeSet<T> create(ISeq<? extends T> items) {
        IPersistentCollection<T> ret = EMPTY;
        while (items != null) {
            ret = ret.cons((Object)items.first());
            items = items.next();
        }
        return ret;
    }

    public static <T> PersistentTreeSet<T> create(Comparator<T> comp, ISeq<? extends T> items) {
        IPersistentCollection<T> ret = new PersistentTreeSet<T>(null, new PersistentTreeMap(null, comp));
        while (items != null) {
            ret = ret.cons((Object)items.first());
            items = items.next();
        }
        return ret;
    }

    PersistentTreeSet(IPersistentMap meta, IPersistentMap impl) {
        super(impl);
        this._meta = meta;
    }

    @Override
    public PersistentTreeSet<T> disjoin(T key) {
        if (this.contains((Object)key)) {
            return new PersistentTreeSet<T>(this.meta(), this.impl.without(key));
        }
        return this;
    }

    @Override
    public PersistentTreeSet<T> cons(T o) {
        if (this.contains((Object)o)) {
            return this;
        }
        return new PersistentTreeSet<T>(this.meta(), this.impl.assoc(o, o));
    }

    @Override
    public PersistentTreeSet<T> empty() {
        return new PersistentTreeSet<T>(this.meta(), (PersistentTreeMap)this.impl.empty());
    }

    @Override
    public ISeq<T> rseq() {
        return APersistentMap.KeySeq.create(((Reversible)((Object)this.impl)).rseq());
    }

    @Override
    public PersistentTreeSet<T> withMeta(IPersistentMap meta) {
        return new PersistentTreeSet<T>(meta, this.impl);
    }

    @Override
    public Comparator<T> comparator() {
        return ((Sorted)((Object)this.impl)).comparator();
    }

    @Override
    public Object entryKey(Object entry) {
        return entry;
    }

    @Override
    public ISeq<T> seq(boolean ascending) {
        PersistentTreeMap m = (PersistentTreeMap)this.impl;
        return RT.keys(m.seq(ascending));
    }

    @Override
    public ISeq<T> seqFrom(T key, boolean ascending) {
        PersistentTreeMap m = (PersistentTreeMap)this.impl;
        return RT.keys(m.seqFrom(key, ascending));
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    @Override
    public PersistentSortedSet<T> zero() {
        return this.empty();
    }

    @Override
    public PersistentSortedSet<T> plus(T o) {
        return this.cons((Object)o);
    }

    @Override
    public PersistentSortedSet<T> minus(T key) {
        return this.disjoin((Object)key);
    }

    @Override
    public TransientCollection<T> asTransient() {
        throw new UnsupportedOperationException();
    }
}

