/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.stups.probkodkod.parser.lexer;

import java.io.*;
import java.util.*;
import de.stups.probkodkod.parser.node.*;
import de.hhu.stups.sablecc.patch.*;


@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;

	private IToken tok;

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = this.token;
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                              Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                              Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                              Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                              Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                              Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                              Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                              Token token = new20(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                              Token token = new21(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                              Token token = new22(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                              Token token = new23(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                              Token token = new24(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                              Token token = new25(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                              Token token = new26(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                              Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                              Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                              Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                              Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                              Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                              Token token = new32(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                              Token token = new33(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                              Token token = new34(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                              Token token = new35(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                              Token token = new36(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                              Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                              Token token = new38(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                              Token token = new39(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                              Token token = new40(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                              Token token = new41(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                              Token token = new42(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                              Token token = new43(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                              Token token = new44(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                              Token token = new45(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                              Token token = new46(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                              Token token = new47(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                              Token token = new48(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                              Token token = new49(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                              Token token = new50(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                              Token token = new51(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                              Token token = new52(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                              Token token = new53(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                              Token token = new54(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                              Token token = new55(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                              Token token = new56(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                              Token token = new57(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                              Token token = new58(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                              Token token = new59(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                              Token token = new60(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                              Token token = new61(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 62:
                        {
                              Token token = new62(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 63:
                        {
                              Token token = new63(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 64:
                        {
                              Token token = new64(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 65:
                        {
                              Token token = new65(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 66:
                        {
                              Token token = new66(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 67:
                        {
                              Token token = new67(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 68:
                        {
                              Token token = new68(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 69:
                        {
                              Token token = new69(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 70:
                        {
                              Token token = new70(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  String text,   int line,   int pos) { return new TBlanks(text, line, pos); }
    Token new1(  String text,   int line,   int pos) { return new TNumber(text, line, pos); }
    Token new2(  int line,   int pos) { return new TParenl(line, pos); }
    Token new3(  int line,   int pos) { return new TParenr(line, pos); }
    Token new4(  int line,   int pos) { return new TAnglel(line, pos); }
    Token new5(  int line,   int pos) { return new TAngler(line, pos); }
    Token new6(  int line,   int pos) { return new TBracketl(line, pos); }
    Token new7(  int line,   int pos) { return new TBracketr(line, pos); }
    Token new8(  int line,   int pos) { return new TKeywordProblem(line, pos); }
    Token new9(  int line,   int pos) { return new TKeywordExact(line, pos); }
    Token new10(  int line,   int pos) { return new TKeywordSubset(line, pos); }
    Token new11(  int line,   int pos) { return new TKeywordInts(line, pos); }
    Token new12(  int line,   int pos) { return new TKeywordSingleton(line, pos); }
    Token new13(  int line,   int pos) { return new TKeywordTrue(line, pos); }
    Token new14(  int line,   int pos) { return new TKeywordFalse(line, pos); }
    Token new15(  int line,   int pos) { return new TKeywordIn(line, pos); }
    Token new16(  int line,   int pos) { return new TKeywordEquals(line, pos); }
    Token new17(  int line,   int pos) { return new TKeywordSome(line, pos); }
    Token new18(  int line,   int pos) { return new TKeywordOne(line, pos); }
    Token new19(  int line,   int pos) { return new TKeywordNo(line, pos); }
    Token new20(  int line,   int pos) { return new TKeywordLone(line, pos); }
    Token new21(  int line,   int pos) { return new TKeywordSet(line, pos); }
    Token new22(  int line,   int pos) { return new TKeywordNot(line, pos); }
    Token new23(  int line,   int pos) { return new TKeywordAnd(line, pos); }
    Token new24(  int line,   int pos) { return new TKeywordOr(line, pos); }
    Token new25(  int line,   int pos) { return new TKeywordImplies(line, pos); }
    Token new26(  int line,   int pos) { return new TKeywordIff(line, pos); }
    Token new27(  int line,   int pos) { return new TKeywordIf(line, pos); }
    Token new28(  int line,   int pos) { return new TKeywordAll(line, pos); }
    Token new29(  int line,   int pos) { return new TKeywordExists(line, pos); }
    Token new30(  int line,   int pos) { return new TKeywordUnion(line, pos); }
    Token new31(  int line,   int pos) { return new TKeywordIntersection(line, pos); }
    Token new32(  int line,   int pos) { return new TKeywordDiff(line, pos); }
    Token new33(  int line,   int pos) { return new TKeywordJoin(line, pos); }
    Token new34(  int line,   int pos) { return new TKeywordProduct(line, pos); }
    Token new35(  int line,   int pos) { return new TKeywordOverwrite(line, pos); }
    Token new36(  int line,   int pos) { return new TKeywordTranspose(line, pos); }
    Token new37(  int line,   int pos) { return new TKeywordClosure(line, pos); }
    Token new38(  int line,   int pos) { return new TKeywordComprehension(line, pos); }
    Token new39(  int line,   int pos) { return new TKeywordEmpty(line, pos); }
    Token new40(  int line,   int pos) { return new TKeywordIden(line, pos); }
    Token new41(  int line,   int pos) { return new TKeywordUniv(line, pos); }
    Token new42(  int line,   int pos) { return new TKeywordRanges(line, pos); }
    Token new43(  int line,   int pos) { return new TKeywordExt(line, pos); }
    Token new44(  int line,   int pos) { return new TKeywordRelref(line, pos); }
    Token new45(  int line,   int pos) { return new TKeywordVarref(line, pos); }
    Token new46(  int line,   int pos) { return new TKeywordRequest(line, pos); }
    Token new47(  int line,   int pos) { return new TKeywordStop(line, pos); }
    Token new48(  int line,   int pos) { return new TKeywordReset(line, pos); }
    Token new49(  int line,   int pos) { return new TKeywordList(line, pos); }
    Token new50(  int line,   int pos) { return new TKeywordPositive(line, pos); }
    Token new51(  int line,   int pos) { return new TKeywordNegative(line, pos); }
    Token new52(  int line,   int pos) { return new TKeywordCardinality(line, pos); }
    Token new53(  int line,   int pos) { return new TKeywordAddition(line, pos); }
    Token new54(  int line,   int pos) { return new TKeywordSubtraction(line, pos); }
    Token new55(  int line,   int pos) { return new TKeywordMultiplication(line, pos); }
    Token new56(  int line,   int pos) { return new TKeywordDivision(line, pos); }
    Token new57(  int line,   int pos) { return new TKeywordModulo(line, pos); }
    Token new58(  int line,   int pos) { return new TKeywordGreater(line, pos); }
    Token new59(  int line,   int pos) { return new TKeywordGreaterEqual(line, pos); }
    Token new60(  int line,   int pos) { return new TKeywordLesser(line, pos); }
    Token new61(  int line,   int pos) { return new TKeywordLesserEqual(line, pos); }
    Token new62(  int line,   int pos) { return new TKeywordProjection(line, pos); }
    Token new63(  int line,   int pos) { return new TKeywordPartialFunction(line, pos); }
    Token new64(  int line,   int pos) { return new TKeywordTotalFunction(line, pos); }
    Token new65(  int line,   int pos) { return new TKeywordInt2pow2(line, pos); }
    Token new66(  int line,   int pos) { return new TKeywordInt2intset(line, pos); }
    Token new67(  int line,   int pos) { return new TKeywordExpr2int(line, pos); }
    Token new68(  int line,   int pos) { return new TMinus(line, pos); }
    Token new69(  String text,   int line,   int pos) { return new TIdentifier(text, line, pos); }
    Token new70(  int line,   int pos) { return new TFullstop(line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {40, 40, 5}, {41, 41, 6}, {45, 45, 7}, {46, 46, 8}, {48, 57, 9}, {60, 60, 10}, {62, 62, 11}, {65, 90, 12}, {91, 91, 13}, {93, 93, 14}, {95, 95, 15}, {97, 97, 16}, {98, 98, 17}, {99, 99, 18}, {100, 100, 19}, {101, 101, 20}, {102, 102, 21}, {103, 103, 22}, {104, 104, 17}, {105, 105, 23}, {106, 106, 24}, {107, 107, 17}, {108, 108, 25}, {109, 109, 26}, {110, 110, 27}, {111, 111, 28}, {112, 112, 29}, {113, 113, 17}, {114, 114, 30}, {115, 115, 31}, {116, 116, 32}, {117, 117, 33}, {118, 118, 34}, {119, 122, 17}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {},
            {},
            {},
            {},
            {{48, 57, 9}, {65, 90, 12}, {95, 95, 15}, {97, 122, 17}, },
            {},
            {},
            {{48, 57, 35}, {65, 122, -11}, },
            {},
            {},
            {{48, 122, -14}, },
            {{48, 95, -14}, {97, 99, 17}, {100, 100, 36}, {101, 107, 17}, {108, 108, 37}, {109, 109, 17}, {110, 110, 38}, {111, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 95, -14}, {97, 97, 39}, {98, 107, 17}, {108, 108, 40}, {109, 110, 17}, {111, 111, 41}, {112, 122, 17}, },
            {{48, 95, -14}, {97, 104, 17}, {105, 105, 42}, {106, 122, 17}, },
            {{48, 95, -14}, {97, 108, 17}, {109, 109, 43}, {110, 112, 17}, {113, 113, 44}, {114, 119, 17}, {120, 120, 45}, {121, 122, 17}, },
            {{48, 95, -14}, {97, 97, 46}, {98, 116, 17}, {117, 117, 47}, {118, 122, 17}, },
            {{48, 95, -14}, {97, 115, 17}, {116, 116, 48}, {117, 122, 17}, },
            {{48, 99, -18}, {100, 100, 49}, {101, 101, 17}, {102, 102, 50}, {103, 108, 17}, {109, 109, 51}, {110, 110, 52}, {111, 122, 17}, },
            {{48, 95, -14}, {97, 110, 17}, {111, 111, 53}, {112, 122, 17}, },
            {{48, 104, -21}, {105, 105, 54}, {106, 110, 17}, {111, 111, 55}, {112, 115, 17}, {116, 116, 56}, {117, 122, 17}, },
            {{48, 110, -26}, {111, 111, 57}, {112, 116, 17}, {117, 117, 58}, {118, 122, 17}, },
            {{48, 95, -14}, {97, 100, 17}, {101, 101, 59}, {102, 110, 17}, {111, 111, 60}, {112, 122, 17}, },
            {{48, 95, -14}, {97, 109, 17}, {110, 110, 61}, {111, 113, 17}, {114, 114, 62}, {115, 117, 17}, {118, 118, 63}, {119, 122, 17}, },
            {{48, 95, -14}, {97, 101, 17}, {102, 102, 64}, {103, 110, 17}, {111, 111, 65}, {112, 113, 17}, {114, 114, 66}, {115, 122, 17}, },
            {{48, 95, -14}, {97, 97, 67}, {98, 100, 17}, {101, 101, 68}, {102, 122, 17}, },
            {{48, 100, -29}, {101, 101, 69}, {102, 104, 17}, {105, 105, 70}, {106, 110, 17}, {111, 111, 71}, {112, 115, 17}, {116, 116, 72}, {117, 117, 73}, {118, 122, 17}, },
            {{48, 95, -14}, {97, 113, 17}, {114, 114, 74}, {115, 122, 17}, },
            {{48, 109, -30}, {110, 110, 75}, {111, 122, 17}, },
            {{48, 95, -14}, {97, 97, 76}, {98, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 99, -18}, {100, 100, 77}, {101, 122, 17}, },
            {{48, 95, -14}, {97, 107, 17}, {108, 108, 78}, {109, 122, 17}, },
            {{48, 99, -18}, {100, 100, 79}, {101, 122, 17}, },
            {{48, 113, -34}, {114, 114, 80}, {115, 122, 17}, },
            {{48, 110, -26}, {111, 111, 81}, {112, 122, 17}, },
            {{48, 108, -22}, {109, 109, 82}, {110, 122, 17}, },
            {{48, 101, -31}, {102, 102, 83}, {103, 117, 17}, {118, 118, 84}, {119, 122, 17}, },
            {{48, 95, -14}, {97, 111, 17}, {112, 112, 85}, {113, 122, 17}, },
            {{48, 95, -14}, {97, 116, 17}, {117, 117, 86}, {118, 122, 17}, },
            {{48, 95, -14}, {97, 97, 87}, {98, 104, 17}, {105, 105, 88}, {106, 111, 17}, {112, 112, 89}, {113, 115, 17}, {116, 116, 90}, {117, 122, 17}, },
            {{48, 107, -39}, {108, 108, 91}, {109, 122, 17}, },
            {{48, 109, -30}, {110, 110, 92}, {111, 122, 17}, },
            {{48, 100, -29}, {101, 101, 93}, {102, 122, 17}, },
            {{48, 100, -29}, {101, 101, 94}, {102, 122, 17}, },
            {{48, 101, -31}, {102, 102, 95}, {103, 122, 17}, },
            {{48, 111, -45}, {112, 112, 96}, {113, 122, 17}, },
            {{48, 115, -24}, {116, 116, 97}, {117, 122, 17}, },
            {{48, 104, -21}, {105, 105, 98}, {106, 122, 17}, },
            {{48, 95, -14}, {97, 114, 17}, {115, 115, 99}, {116, 122, 17}, },
            {{48, 109, -30}, {110, 110, 100}, {111, 122, 17}, },
            {{48, 100, -29}, {101, 101, 101}, {102, 122, 17}, },
            {{48, 99, -18}, {100, 100, 102}, {101, 122, 17}, },
            {{48, 107, -39}, {108, 108, 103}, {109, 122, 17}, },
            {{48, 95, -14}, {97, 102, 17}, {103, 103, 104}, {104, 122, 17}, },
            {{48, 115, -24}, {116, 116, 105}, {117, 122, 17}, },
            {{48, 100, -29}, {101, 101, 106}, {102, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 100, -29}, {101, 101, 107}, {102, 122, 17}, },
            {{48, 116, -46}, {117, 117, 108}, {118, 122, 17}, },
            {{48, 114, -56}, {115, 115, 109}, {116, 122, 17}, },
            {{48, 95, -14}, {97, 105, 17}, {106, 106, 110}, {107, 110, 17}, {111, 111, 111}, {112, 122, 17}, },
            {{48, 109, -30}, {110, 110, 112}, {111, 122, 17}, },
            {{48, 107, -39}, {108, 108, 113}, {109, 112, 17}, {113, 113, 114}, {114, 114, 17}, {115, 115, 115}, {116, 122, 17}, },
            {{48, 115, -24}, {116, 116, 116}, {117, 122, 17}, },
            {{48, 109, -30}, {110, 110, 117}, {111, 122, 17}, },
            {{48, 108, -22}, {109, 109, 118}, {110, 122, 17}, },
            {{48, 110, -26}, {111, 111, 119}, {112, 122, 17}, },
            {{48, 95, -14}, {97, 97, 17}, {98, 98, 120}, {99, 122, 17}, },
            {{48, 95, -14}, {97, 97, 121}, {98, 116, 17}, {117, 117, 122}, {118, 122, 17}, },
            {{48, 104, -21}, {105, 105, 123}, {106, 122, 17}, },
            {{48, 113, -34}, {114, 114, 124}, {115, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 99, -18}, {100, 100, 125}, {101, 122, 17}, },
            {{48, 114, -56}, {115, 115, 126}, {116, 122, 17}, },
            {{48, 111, -45}, {112, 112, 127}, {113, 122, 17}, },
            {{48, 101, -31}, {102, 102, 128}, {103, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 115, -24}, {116, 116, 129}, {117, 122, 17}, },
            {{48, 95, -14}, {97, 97, 130}, {98, 122, 17}, },
            {{48, 95, -14}, {97, 98, 17}, {99, 99, 131}, {100, 122, 17}, },
            {{48, 114, -56}, {115, 115, 132}, {116, 122, 17}, },
            {{48, 113, -34}, {114, 114, 133}, {115, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 114, -56}, {115, 115, 134}, {116, 122, 17}, },
            {{48, 98, -89}, {99, 99, 135}, {100, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 109, -30}, {110, 110, 136}, {111, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 107, -39}, {108, 108, 137}, {109, 122, 17}, },
            {{48, 49, 35}, {50, 50, 138}, {51, 57, 35}, {65, 100, -29}, {101, 101, 139}, {102, 115, 17}, {116, 116, 140}, {117, 122, 17}, },
            {{48, 109, -30}, {110, 110, 141}, {111, 122, 17}, },
            {{48, 115, -24}, {116, 116, 142}, {117, 122, 17}, },
            {{48, 100, -29}, {101, 101, 143}, {102, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 113, -34}, {114, 114, 144}, {115, 122, 17}, },
            {{48, 109, -30}, {110, 110, 145}, {111, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 97, -75}, {98, 98, 146}, {99, 99, 17}, {100, 100, 147}, {101, 122, 17}, },
            {{48, 102, -61}, {103, 103, 148}, {104, 122, 17}, },
            {{48, 113, -34}, {114, 114, 149}, {115, 122, 17}, },
            {{48, 116, -46}, {117, 117, 150}, {118, 122, 17}, },
            {{48, 100, -29}, {101, 101, 151}, {102, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 102, -61}, {103, 103, 152}, {104, 122, 17}, },
            {{48, 100, -29}, {101, 101, 153}, {102, 122, 17}, },
            {{48, 111, -45}, {112, 112, 154}, {113, 122, 17}, },
            {{48, 114, -56}, {115, 115, 155}, {116, 122, 17}, },
            {{48, 109, -30}, {110, 110, 156}, {111, 122, 17}, },
            {{48, 100, -29}, {101, 101, 157}, {102, 122, 17}, },
            {{48, 110, -26}, {111, 111, 158}, {112, 117, 17}, {118, 118, 159}, {119, 122, 17}, },
            {{48, 113, -34}, {114, 114, 160}, {115, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 116, -46}, {117, 117, 161}, {118, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 100, -29}, {101, 101, 162}, {102, 122, 17}, },
            {{48, 95, -14}, {97, 120, 17}, {121, 121, 163}, {122, 122, 17}, },
            {{48, 107, -39}, {108, 108, 164}, {109, 122, 17}, },
            {{48, 115, -24}, {116, 116, 165}, {117, 122, 17}, },
            {{48, 115, -24}, {116, 116, 166}, {117, 122, 17}, },
            {{48, 49, 35}, {50, 50, 167}, {51, 95, -99}, {97, 122, 17}, },
            {{48, 100, -29}, {101, 101, 168}, {102, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 104, -21}, {105, 105, 169}, {106, 122, 17}, },
            {{48, 104, -21}, {105, 105, 170}, {106, 111, 17}, {112, 112, 171}, {113, 122, 17}, },
            {{48, 113, -34}, {114, 114, 172}, {115, 122, 17}, },
            {{48, 120, -131}, {121, 121, 173}, {122, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 95, -14}, {97, 118, 17}, {119, 119, 174}, {120, 122, 17}, },
            {{48, 98, -89}, {99, 99, 175}, {100, 122, 17}, },
            {{48, 107, -39}, {108, 108, 176}, {109, 122, 17}, },
            {{48, 116, -46}, {117, 117, 177}, {118, 122, 17}, },
            {{48, 100, -29}, {101, 101, 178}, {102, 122, 17}, },
            {{48, 100, -29}, {101, 101, 179}, {102, 122, 17}, },
            {{48, 100, -29}, {101, 101, 180}, {102, 122, 17}, },
            {{48, 115, -24}, {116, 116, 181}, {117, 122, 17}, },
            {{48, 107, -39}, {108, 108, 182}, {109, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 100, -29}, {101, 101, 183}, {102, 122, 17}, },
            {{48, 114, -56}, {115, 115, 184}, {116, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 109, -30}, {110, 110, 185}, {111, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 100, -29}, {101, 101, 186}, {102, 122, 17}, },
            {{48, 113, -34}, {114, 114, 187}, {115, 122, 17}, },
            {{48, 113, -34}, {114, 114, 188}, {115, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 114, -56}, {115, 115, 189}, {116, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 114, -56}, {115, 115, 190}, {116, 122, 17}, },
            {{48, 104, -21}, {105, 105, 191}, {106, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 100, -29}, {101, 101, 192}, {102, 122, 17}, },
            {{48, 109, -30}, {110, 110, 193}, {111, 122, 17}, },
            {{48, 110, -26}, {111, 111, 194}, {112, 122, 17}, },
            {{48, 114, -56}, {115, 115, 195}, {116, 122, 17}, },
            {{48, 111, -45}, {112, 112, 196}, {113, 122, 17}, },
            {{48, 113, -34}, {114, 114, 197}, {115, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 100, -29}, {101, 101, 198}, {102, 122, 17}, },
            {{48, 98, -89}, {99, 99, 199}, {100, 122, 17}, },
            {{48, 114, -56}, {115, 115, 200}, {116, 122, 17}, },
            {{48, 101, -31}, {102, 102, 201}, {103, 122, 17}, },
            {{48, 114, -56}, {115, 115, 202}, {116, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 100, -29}, {101, 101, 203}, {102, 122, 17}, },
            {{48, 115, -24}, {116, 116, 204}, {117, 122, 17}, },
            {{48, 111, -45}, {112, 112, 205}, {113, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 101, -31}, {102, 102, 206}, {103, 122, 17}, },
            {{48, 100, -29}, {101, 101, 207}, {102, 122, 17}, },
            {{48, 100, -29}, {101, 101, 208}, {102, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 109, -30}, {110, 110, 209}, {111, 122, 17}, },
            {{48, 114, -56}, {115, 115, 210}, {116, 122, 17}, },
            {{48, 115, -24}, {116, 116, 211}, {117, 122, 17}, },
            {{48, 118, -146}, {119, 119, 212}, {120, 122, 17}, },
            {{48, 100, -29}, {101, 101, 213}, {102, 122, 17}, },
            {{48, 100, -29}, {101, 101, 214}, {102, 122, 17}, },
            {{48, 104, -21}, {105, 105, 215}, {106, 122, 17}, },
            {{48, 108, -22}, {109, 109, 216}, {110, 122, 17}, },
            {{48, 115, -24}, {116, 116, 217}, {117, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 115, -24}, {116, 116, 218}, {117, 122, 17}, },
            {{48, 115, -24}, {116, 116, 219}, {117, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 110, -26}, {111, 111, 220}, {112, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 109, -30}, {110, 110, 221}, {111, 122, 17}, },
            {{48, 115, -24}, {116, 116, 222}, {117, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 114, -56}, {115, 115, 223}, {116, 122, 17}, },
            {{48, 49, 35}, {50, 50, 224}, {51, 122, -135}, },
            {{48, 98, -89}, {99, 99, 225}, {100, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 115, -24}, {116, 116, 226}, {117, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 110, -26}, {111, 111, 227}, {112, 122, 17}, },
            {{48, 114, -56}, {115, 115, 228}, {116, 122, 17}, },
            {{48, 98, -89}, {99, 99, 229}, {100, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 100, -29}, {101, 101, 230}, {102, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 115, -24}, {116, 116, 231}, {117, 122, 17}, },
            {{48, 100, -29}, {101, 101, 232}, {102, 122, 17}, },
            {{48, 109, -30}, {110, 110, 233}, {111, 122, 17}, },
            {{48, 100, -29}, {101, 101, 234}, {102, 122, 17}, },
            {{48, 100, -29}, {101, 101, 235}, {102, 122, 17}, },
            {{48, 115, -24}, {116, 116, 236}, {117, 122, 17}, },
            {{48, 104, -21}, {105, 105, 237}, {106, 122, 17}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 122, -14}, },
            {{48, 110, -26}, {111, 111, 238}, {112, 122, 17}, },
            {{48, 109, -30}, {110, 110, 239}, {111, 122, 17}, },
            {{48, 122, -14}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {-1, 0, 0, 0, 0, 2, 3, 68, 70, 1, 4, 5, 69, 6, 7, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 58, 69, 27, 69, 15, 69, 69, 69, 60, 69, 69, 69, 19, 69, 24, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 53, 28, 23, 69, 69, 69, 69, 56, 69, 69, 69, 69, 69, 43, 69, 69, 59, 69, 26, 69, 69, 69, 69, 69, 61, 57, 55, 51, 22, 18, 69, 69, 50, 62, 69, 69, 69, 69, 69, 21, 69, 69, 69, 54, 69, 69, 69, 69, 52, 69, 38, 69, 69, 69, 69, 69, 69, 69, 64, 40, 69, 69, 69, 69, 33, 49, 20, 69, 69, 69, 69, 69, 69, 69, 69, 69, 17, 47, 69, 69, 13, 69, 41, 69, 69, 69, 39, 69, 9, 69, 69, 14, 69, 69, 69, 69, 69, 69, 63, 69, 69, 69, 69, 69, 48, 69, 69, 69, 30, 69, 69, 69, 16, 29, 69, 69, 69, 69, 69, 69, 69, 69, 69, 42, 44, 69, 69, 10, 69, 45, 37, 69, 69, 25, 69, 69, 69, 11, 69, 8, 34, 46, 69, 69, 69, 67, 69, 65, 69, 69, 69, 69, 69, 69, 69, 35, 12, 36, 32, 66, 69, 69, 31, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
