/*
 * Decompiled with CFR 0.152.
 */
package de.prob.statespace;

import com.google.inject.Singleton;
import de.prob.model.representation.AbstractElement;
import de.prob.statespace.ITraceChangesListener;
import de.prob.statespace.Trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Animations {
    Logger logger = LoggerFactory.getLogger(Animations.class);
    List<ITraceChangesListener> traceListeners = new CopyOnWriteArrayList<ITraceChangesListener>();
    Map<UUID, Trace> traces = new LinkedHashMap<UUID, Trace>();

    public void registerAnimationChangeListener(ITraceChangesListener listener) {
        this.traceListeners.add(listener);
        listener.changed(this.getTraces());
    }

    public void deregisterAnimationChangeListener(ITraceChangesListener listener) {
        this.traceListeners.remove(listener);
    }

    public void addNewAnimation(Trace trace) {
        Trace t = trace;
        if (this.traces.containsKey(trace.getUUID())) {
            t = trace.copy();
        }
        this.traces.put(t.getUUID(), t);
        this.notifyTraceChange(t);
    }

    private void notifyTraceChange(Trace trace) {
        for (ITraceChangesListener listener : this.traceListeners) {
            try {
                listener.changed(Collections.singletonList(trace));
            }
            catch (Exception e) {
                this.logger.error("An exception of type " + e.getClass() + " was thrown while executing IAnimationChangeListener of class " + listener.getClass() + " with message " + e.getMessage());
            }
        }
    }

    private void notifyTraceRemove(Trace trace) {
        for (ITraceChangesListener listener : this.traceListeners) {
            try {
                listener.removed(Collections.singletonList(trace.getUUID()));
            }
            catch (Exception e) {
                this.logger.error("An exception of type " + e.getClass() + " was thrown while executing IAnimationChangeListener of class " + listener.getClass() + " with message " + e.getMessage());
            }
        }
    }

    public void notifyBusy() {
        HashSet<UUID> busy = new HashSet<UUID>();
        for (Trace t : this.traces.values()) {
            if (!t.getStateSpace().isBusy()) continue;
            busy.add(t.getUUID());
        }
        for (ITraceChangesListener listener : this.traceListeners) {
            try {
                listener.animatorStatus(busy);
            }
            catch (Exception e) {
                this.logger.error("An exception of type " + e.getClass() + " was thrown while executing IAnimationChangeListener of class " + listener.getClass() + " with message " + e.getMessage());
            }
        }
    }

    public List<Trace> getTraces() {
        return Collections.unmodifiableList(new ArrayList<Trace>(this.traces.values()));
    }

    public Trace getTrace(UUID uuid) {
        return this.traces.get(uuid);
    }

    public AbstractElement getModel(Trace trace) {
        return trace.getModel();
    }

    public String toString() {
        return "Animations Registry. (" + this.traces.size() + " traces)";
    }

    public void traceChange(Trace trace) {
        UUID uuid = trace.getUUID();
        this.traces.put(uuid, trace);
        this.notifyTraceChange(trace);
    }

    public void removeTrace(Trace trace) {
        this.traces.remove(trace.getUUID());
        this.notifyTraceRemove(trace);
    }
}

