/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.theory;

import com.github.krukow.clj_lang.PersistentHashMap;
import com.google.common.base.Objects;
import de.prob.model.eventb.EventBAxiom;
import de.prob.model.eventb.theory.AxiomaticDefinitionBlock;
import de.prob.model.eventb.theory.DataType;
import de.prob.model.eventb.theory.Operator;
import de.prob.model.eventb.theory.ProofRulesBlock;
import de.prob.model.eventb.theory.Type;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.ModelElementList;
import de.prob.tmparser.OperatorMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eventb.core.ast.extension.IFormulaExtension;

public class Theory
extends AbstractElement {
    private final String name;
    private final String parentDirectory;
    private final Collection<OperatorMapping> proBMappings;
    private Set<IFormulaExtension> typeEnvironment;

    public Theory(String name, String parentDirectory, Collection<OperatorMapping> mappings) {
        this(name, parentDirectory, mappings, Collections.emptySet(), (PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>>)PersistentHashMap.emptyMap());
    }

    private Theory(String name, String parentDirectory, Collection<OperatorMapping> proBMappings, Set<IFormulaExtension> typeEnvironment, PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>> children) {
        super(children);
        this.name = name;
        this.parentDirectory = parentDirectory;
        this.proBMappings = proBMappings;
        this.typeEnvironment = typeEnvironment;
    }

    public Theory set(Class<? extends AbstractElement> clazz, ModelElementList<? extends AbstractElement> elements) {
        return new Theory(this.name, this.parentDirectory, this.proBMappings, this.typeEnvironment, this.assoc(clazz, elements));
    }

    public ModelElementList<DataType> getDataTypes() {
        return this.getChildrenOfType(DataType.class);
    }

    public ModelElementList<Theory> getImported() {
        return this.getChildrenOfType(Theory.class);
    }

    public ModelElementList<Operator> getOperators() {
        return this.getChildrenOfType(Operator.class);
    }

    public ModelElementList<AxiomaticDefinitionBlock> getAxiomaticDefinitionBlocks() {
        return this.getChildrenOfType(AxiomaticDefinitionBlock.class);
    }

    public ModelElementList<ProofRulesBlock> getProofRules() {
        return this.getChildrenOfType(ProofRulesBlock.class);
    }

    public ModelElementList<EventBAxiom> getTheorems() {
        return this.getChildrenOfType(EventBAxiom.class);
    }

    public ModelElementList<Type> getTypeParameters() {
        return this.getChildrenOfType(Type.class);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getParentDirectoryName() {
        return this.parentDirectory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Theory other = (Theory)obj;
        return Objects.equal((Object)this.parentDirectory, (Object)other.parentDirectory) && Objects.equal((Object)this.name, (Object)other.name);
    }

    public Collection<OperatorMapping> getProBMappings() {
        return this.proBMappings;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parentDirectory, this.name});
    }

    public Theory setTypeEnvironment(Set<IFormulaExtension> typeEnvironment) {
        return new Theory(this.name, this.parentDirectory, this.proBMappings, typeEnvironment, (PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>>)this.children);
    }

    public Set<IFormulaExtension> getTypeEnvironment() {
        return this.typeEnvironment;
    }
}

